/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.util.PsiUtils;

public class LocationInfo {
    private final String filePath;
    private final int startOffset;
    private final int endOffset;
    private final int length;
    private final int startLine;
    private final int endLine;
    private final CodeElementType codeElementType;
    private final int startColumn;
    private final int endColumn;

    public LocationInfo(@NotNull KtFile ktFile, @NotNull String filePath, @NotNull KtElement node, @NotNull CodeElementType codeElementType) {
        if (ktFile == null) {
            LocationInfo.$$$reportNull$$$0(0);
        }
        if (filePath == null) {
            LocationInfo.$$$reportNull$$$0(1);
        }
        if (node == null) {
            LocationInfo.$$$reportNull$$$0(2);
        }
        if (codeElementType == null) {
            LocationInfo.$$$reportNull$$$0(3);
        }
        this.filePath = filePath;
        this.codeElementType = codeElementType;
        TextRange range = node.getTextRange();
        this.startOffset = range.getStartOffset();
        this.length = range.getLength();
        this.endOffset = range.getEndOffset();
        Document document = ktFile.getViewProvider().getDocument();
        if (document != null) {
            this.startLine = document.getLineNumber(this.startOffset) + 1;
            this.endLine = document.getLineNumber(this.endOffset) + 1;
            this.startColumn = PsiUtils.countColumn(this.startLine - 1, document) + 1;
            this.endColumn = PsiUtils.countColumn(this.endLine - 1, document) + 1;
        } else {
            this.startLine = 0;
            this.endLine = 0;
            this.startColumn = 0;
            this.endColumn = 0;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartLine() {
        return this.startLine;
    }

    public int getStartColumn() {
        return this.startColumn;
    }

    public int getEndLine() {
        return this.endLine;
    }

    public int getEndColumn() {
        return this.endColumn;
    }

    public CodeElementType getCodeElementType() {
        return this.codeElementType;
    }

    public CodeRange codeRange() {
        return new CodeRange(this.getFilePath(), this.getStartLine(), this.getEndLine(), this.getStartColumn(), this.getEndColumn(), this.getCodeElementType());
    }

    public boolean subsumes(LocationInfo other) {
        return this.filePath.equals(other.filePath) && this.startOffset <= other.startOffset && this.endOffset >= other.endOffset;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endOffset;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LocationInfo other = (LocationInfo)obj;
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "ktFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "node";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "codeElementType";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/research/kotlinrminer/ide/decomposition/LocationInfo";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

