/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCatchClause;
import org.jetbrains.kotlin.psi.KtConstructorCalleeExpression;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFinallySection;
import org.jetbrains.kotlin.psi.KtForExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperExpression;
import org.jetbrains.kotlin.psi.KtThrowExpression;
import org.jetbrains.kotlin.psi.KtTryExpression;
import org.jetbrains.kotlin.psi.KtWhenConditionWithExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.jetbrains.kotlin.psi.KtWhileExpression;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractExpression;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.TryStatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;

public class OperationBody {
    private final CompositeStatementObject compositeStatement;

    public OperationBody(KtFile cu, String filePath, KtBlockExpression methodBody) {
        this.compositeStatement = new CompositeStatementObject(cu, filePath, (KtElement)methodBody, 0, CodeElementType.BLOCK);
        List statements = methodBody.getStatements();
        for (KtExpression statement : statements) {
            this.processStatement(cu, filePath, this.compositeStatement, statement);
        }
    }

    public int statementCount() {
        return this.compositeStatement.statementCount();
    }

    public CompositeStatementObject getCompositeStatement() {
        return this.compositeStatement;
    }

    public List<String> getAllVariables() {
        return new ArrayList<String>(this.compositeStatement.getAllVariables());
    }

    public List<VariableDeclaration> getAllVariableDeclarations() {
        return new ArrayList<VariableDeclaration>(this.compositeStatement.getAllVariableDeclarations());
    }

    public List<VariableDeclaration> getVariableDeclarationsInScope(LocationInfo location) {
        return new ArrayList<VariableDeclaration>(this.compositeStatement.getVariableDeclarationsInScope(location));
    }

    public VariableDeclaration getVariableDeclaration(String variableName) {
        return this.compositeStatement.getVariableDeclaration(variableName);
    }

    private void processStatement(KtFile ktFile, String filePath, CompositeStatementObject parent, KtExpression statement) {
        if (statement instanceof KtBlockExpression) {
            KtBlockExpression block = (KtBlockExpression)statement;
            List blockStatements = block.getStatements();
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)block, parent.getDepth() + 1, CodeElementType.BLOCK);
            parent.addStatement(child);
            for (KtExpression blockStatement : blockStatements) {
                this.processStatement(ktFile, filePath, child, blockStatement);
            }
        } else if (statement instanceof KtIfExpression) {
            KtIfExpression ifStatement = (KtIfExpression)statement;
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)ifStatement, parent.getDepth() + 1, CodeElementType.IF_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, ifStatement.getCondition(), CodeElementType.IF_STATEMENT_CONDITION);
            child.addExpression(abstractExpression);
            this.processStatement(ktFile, filePath, child, ifStatement.getThen());
            if (ifStatement.getElse() != null) {
                this.processStatement(ktFile, filePath, child, ifStatement.getElse());
            }
        } else if (statement instanceof KtForExpression) {
            KtForExpression forStatement = (KtForExpression)statement;
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)forStatement, parent.getDepth() + 1, CodeElementType.ENHANCED_FOR_STATEMENT);
            parent.addStatement(child);
            VariableDeclaration variableDeclaration = new VariableDeclaration(ktFile, filePath, (KtElement)forStatement.getLoopParameter());
            child.addVariableDeclaration(variableDeclaration);
            AbstractExpression abstractEx = new AbstractExpression(ktFile, filePath, (KtExpression)forStatement.getLoopParameter(), CodeElementType.ENHANCED_FOR_STATEMENT_PARAMETER_NAME);
            child.addExpression(abstractEx);
            KtDestructuringDeclaration ktDeclaration = forStatement.getDestructuringDeclaration();
            if (ktDeclaration != null && ktDeclaration.getInitializer() != null) {
                KtExpression initializer = ktDeclaration.getInitializer();
                AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, initializer, CodeElementType.FOR_STATEMENT_INITIALIZER);
                child.addExpression(abstractExpression);
            }
            KtExpression rangeExpr = forStatement.getLoopRange();
            AbstractExpression range = new AbstractExpression(ktFile, filePath, rangeExpr, CodeElementType.ENHANCED_FOR_STATEMENT_RANGE);
            child.addExpression(range);
            if (ktDeclaration != null) {
                AbstractExpression abstractExpr = new AbstractExpression(ktFile, filePath, (KtExpression)ktDeclaration, CodeElementType.ENHANCED_FOR_STATEMENT_EXPRESSION);
                child.addExpression(abstractExpr);
            }
            this.processStatement(ktFile, filePath, child, forStatement.getBody());
        } else if (statement instanceof KtWhileExpression) {
            KtWhileExpression whileStatement = (KtWhileExpression)statement;
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)whileStatement, parent.getDepth() + 1, CodeElementType.WHILE_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, whileStatement.getCondition(), CodeElementType.WHILE_STATEMENT_CONDITION);
            child.addExpression(abstractExpression);
            this.processStatement(ktFile, filePath, child, whileStatement.getBody());
        } else if (statement instanceof KtDoWhileExpression) {
            KtDoWhileExpression doStatement = (KtDoWhileExpression)statement;
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)doStatement, parent.getDepth() + 1, CodeElementType.DO_STATEMENT);
            parent.addStatement(child);
            AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, doStatement.getCondition(), CodeElementType.DO_STATEMENT_CONDITION);
            child.addExpression(abstractExpression);
            this.processStatement(ktFile, filePath, child, doStatement.getBody());
        } else if (statement instanceof KtLabeledExpression) {
            KtLabeledExpression labeledStatement = (KtLabeledExpression)statement;
            KtSimpleNameExpression label = labeledStatement.getTargetLabel();
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)labeledStatement, parent.getDepth() + 1, CodeElementType.LABELED_STATEMENT.setName(label.getName()));
            parent.addStatement(child);
            this.processStatement(ktFile, filePath, child, labeledStatement.getBaseExpression());
        } else if (statement instanceof KtReturnExpression) {
            KtReturnExpression returnStatement = (KtReturnExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)returnStatement, parent.getDepth() + 1, CodeElementType.RETURN_STATEMENT);
            parent.addStatement(child);
        } else if (statement instanceof KtThrowExpression) {
            KtThrowExpression throwStatement = (KtThrowExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)throwStatement, parent.getDepth() + 1, CodeElementType.THROW_STATEMENT);
            parent.addStatement(child);
        } else if (statement instanceof KtTryExpression) {
            KtTryExpression tryStatement = (KtTryExpression)statement;
            TryStatementObject child = new TryStatementObject(ktFile, filePath, tryStatement, parent.getDepth() + 1);
            parent.addStatement(child);
            List catchClauses = tryStatement.getCatchClauses();
            for (KtCatchClause catchClause : catchClauses) {
                KtExpression catchClauseBody = catchClause.getCatchBody();
                CompositeStatementObject catchClauseStatementObject = new CompositeStatementObject(ktFile, filePath, (KtElement)catchClauseBody, parent.getDepth() + 1, CodeElementType.CATCH_CLAUSE);
                child.addCatchClause(catchClauseStatementObject);
                parent.addStatement(catchClauseStatementObject);
                KtParameter variableDeclaration = catchClause.getCatchParameter();
                VariableDeclaration vd = new VariableDeclaration(ktFile, filePath, (KtElement)variableDeclaration);
                catchClauseStatementObject.addVariableDeclaration(vd);
                AbstractExpression variableDeclarationName = new AbstractExpression(ktFile, filePath, (KtExpression)variableDeclaration, CodeElementType.CATCH_CLAUSE_EXCEPTION_NAME);
                catchClauseStatementObject.addExpression(variableDeclarationName);
                if (!(catchClauseBody instanceof KtBlockExpression)) continue;
                KtBlockExpression block = (KtBlockExpression)catchClauseBody;
                List blockStatements = block.getStatements();
                for (KtExpression expression : blockStatements) {
                    this.processStatement(ktFile, filePath, catchClauseStatementObject, expression);
                }
            }
            KtFinallySection finallyBlock = tryStatement.getFinallyBlock();
            if (finallyBlock != null) {
                CompositeStatementObject finallyClauseStatementObject = new CompositeStatementObject(ktFile, filePath, (KtElement)finallyBlock, parent.getDepth() + 1, CodeElementType.FINALLY_BLOCK);
                child.setFinallyClause(finallyClauseStatementObject);
                parent.addStatement(finallyClauseStatementObject);
                List blockStatements = finallyBlock.getFinalExpression().getStatements();
                for (KtExpression blockStatement : blockStatements) {
                    this.processStatement(ktFile, filePath, finallyClauseStatementObject, blockStatement);
                }
            }
        } else if (statement instanceof KtConstructorCalleeExpression) {
            KtConstructorCalleeExpression constructorInvocation = (KtConstructorCalleeExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)constructorInvocation, parent.getDepth() + 1, CodeElementType.CONSTRUCTOR_INVOCATION);
            parent.addStatement(child);
        } else if (statement instanceof KtSuperExpression) {
            KtSuperExpression superConstructorInvocation = (KtSuperExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)superConstructorInvocation, parent.getDepth() + 1, CodeElementType.SUPER_CONSTRUCTOR_INVOCATION);
            parent.addStatement(child);
        } else if (statement instanceof KtBreakExpression) {
            KtBreakExpression breakStatement = (KtBreakExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)breakStatement, parent.getDepth() + 1, CodeElementType.BREAK_STATEMENT);
            parent.addStatement(child);
        } else if (statement instanceof KtContinueExpression) {
            KtContinueExpression continueStatement = (KtContinueExpression)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)continueStatement, parent.getDepth() + 1, CodeElementType.CONTINUE_STATEMENT);
            parent.addStatement(child);
        } else if (statement instanceof KtWhenExpression) {
            KtWhenExpression whenExpression = (KtWhenExpression)statement;
            CompositeStatementObject child = new CompositeStatementObject(ktFile, filePath, (KtElement)whenExpression, parent.getDepth() + 1, CodeElementType.WHEN_EXPRESSION);
            parent.addStatement(child);
            if (whenExpression.getSubjectExpression() != null) {
                AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, whenExpression.getSubjectExpression(), CodeElementType.WHEN_EXPRESSION);
                child.addExpression(abstractExpression);
                this.processStatement(ktFile, filePath, child, whenExpression.getSubjectExpression());
            }
            if (whenExpression.getElseExpression() != null) {
                this.processStatement(ktFile, filePath, child, whenExpression.getElseExpression());
            }
            List entries = whenExpression.getEntries();
            for (KtWhenEntry entry : entries) {
                if (entry.getConditions().length > 0 && entry.getConditions()[0] != null && entry.getConditions()[0] instanceof KtWhenConditionWithExpression) {
                    AbstractExpression abstractExpression = new AbstractExpression(ktFile, filePath, ((KtWhenConditionWithExpression)entry.getConditions()[0]).getExpression(), CodeElementType.WHEN_EXPRESSION_CONDITION);
                    child.addExpression(abstractExpression);
                }
                this.processStatement(ktFile, filePath, child, entry.getExpression());
            }
        } else if (statement instanceof KtProperty) {
            KtProperty variableDeclarationStatement = (KtProperty)statement;
            StatementObject child = new StatementObject(ktFile, filePath, (KtExpression)variableDeclarationStatement, parent.getDepth() + 1, CodeElementType.VARIABLE_DECLARATION_STATEMENT);
            parent.addStatement(child);
        } else {
            StatementObject child = new StatementObject(ktFile, filePath, statement, parent.getDepth() + 1, CodeElementType.EXPRESSION_STATEMENT);
            parent.addStatement(child);
        }
    }

    public Map<String, Set<String>> aliasedAttributes() {
        return this.compositeStatement.aliasedAttributes();
    }

    public CompositeStatementObject loopWithVariables(String currentElementName, String collectionName) {
        return this.compositeStatement.loopWithVariables(currentElementName, collectionName);
    }

    public List<String> stringRepresentation() {
        return this.compositeStatement.stringRepresentation();
    }

    public List<OperationInvocation> getAllOperationInvocations() {
        ArrayList<OperationInvocation> invocations = new ArrayList<OperationInvocation>();
        Map<String, List<OperationInvocation>> invocationMap = this.compositeStatement.getAllMethodInvocations();
        for (String key : invocationMap.keySet()) {
            invocations.addAll((Collection<OperationInvocation>)invocationMap.get(key));
        }
        return invocations;
    }

    public List<LambdaExpressionObject> getAllLambdas() {
        return new ArrayList<LambdaExpressionObject>(this.compositeStatement.getAllLambdas());
    }
}

