/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtPrimaryConstructor;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.common.util.PrefixSuffixUtils;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCall;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;
import org.jetbrains.research.kotlinrminer.ide.util.ReplacementUtil;

public class OperationInvocation
extends AbstractCall {
    private String methodName;
    private List<String> subExpressions = new ArrayList<String>();
    private volatile int hashCode = 0;

    public OperationInvocation(KtFile ktFile, String filePath, KtCallExpression invocation) {
        this.locationInfo = new LocationInfo(ktFile, filePath, (KtElement)invocation, CodeElementType.METHOD_INVOCATION);
        this.methodName = invocation.getCalleeExpression().getText();
        this.typeArguments = invocation.getValueArguments().size();
        this.arguments = new ArrayList();
        List args = invocation.getValueArguments();
        for (KtValueArgument argument : args) {
            if (argument.getText() == null) continue;
            this.arguments.add(argument.getText());
        }
        if (invocation.getCalleeExpression() != null) {
            String methodCallExpression = invocation.getPrevSibling() != null && invocation.getPrevSibling().getParent() != null ? (invocation.getPrevSibling().getParent() instanceof KtDotQualifiedExpression ? invocation.getPrevSibling().getParent().getText() : invocation.getCalleeExpression().getContext().getText()) : invocation.getCalleeExpression().getContext().getText();
            this.expression = methodCallExpression;
            this.processExpression(invocation.getCalleeExpression(), this.subExpressions);
        }
    }

    public OperationInvocation(KtFile ktFile, String filePath, KtPrimaryConstructor invocation) {
        this.locationInfo = new LocationInfo(ktFile, filePath, (KtElement)invocation, CodeElementType.CONSTRUCTOR_INVOCATION);
        this.methodName = "this";
        this.typeArguments = invocation.getTypeParameters().size();
        this.arguments = new ArrayList();
        List args = invocation.getValueParameters();
        for (KtParameter argument : args) {
            if (argument.getName() == null) continue;
            this.arguments.add(argument.getText());
        }
    }

    private OperationInvocation() {
    }

    private static boolean differInThisDot(String subExpression1, String subExpression2) {
        block5: {
            String commonPrefix;
            block4: {
                String commonPrefix2;
                if (subExpression1.length() >= subExpression2.length()) break block4;
                Object modified = subExpression1;
                String previousCommonPrefix = "";
                while ((commonPrefix2 = PrefixSuffixUtils.longestCommonPrefix((String)modified, subExpression2)).length() > previousCommonPrefix.length()) {
                    if (((String)(modified = commonPrefix2 + "this." + ((String)modified).substring(commonPrefix2.length()))).equals(subExpression2)) {
                        return true;
                    }
                    previousCommonPrefix = commonPrefix2;
                }
                break block5;
            }
            if (subExpression1.length() <= subExpression2.length()) break block5;
            Object modified = subExpression2;
            String previousCommonPrefix = "";
            while ((commonPrefix = PrefixSuffixUtils.longestCommonPrefix((String)modified, subExpression1)).length() > previousCommonPrefix.length()) {
                if (((String)(modified = commonPrefix + "this." + ((String)modified).substring(commonPrefix.length()))).equals(subExpression1)) {
                    return true;
                }
                previousCommonPrefix = commonPrefix;
            }
        }
        return false;
    }

    public List<String> getSubExpressions() {
        return this.subExpressions;
    }

    private static boolean dotInsideArguments(int indexOfDot, String thisExpression) {
        boolean openingParenthesisFound = false;
        for (int i = indexOfDot; i >= 0; --i) {
            if (thisExpression.charAt(i) != '(') continue;
            openingParenthesisFound = true;
            break;
        }
        boolean closingParenthesisFound = false;
        for (int i = indexOfDot; i < thisExpression.length(); ++i) {
            if (thisExpression.charAt(i) != ')') continue;
            closingParenthesisFound = true;
            break;
        }
        return openingParenthesisFound && closingParenthesisFound;
    }

    private void processExpression(KtExpression expression, List<String> subExpressions) {
        if (expression instanceof KtNamedFunction) {
            KtNamedFunction invocation = (KtNamedFunction)expression;
            if (invocation.getBodyExpression() != null) {
                String expressionAsString = invocation.getBodyExpression().toString();
                String invocationAsString = invocation.toString();
                String suffix = invocationAsString.substring(expressionAsString.length() + 1);
                subExpressions.add(0, suffix);
                this.processExpression(invocation.getBodyExpression(), subExpressions);
            } else {
                subExpressions.add(0, invocation.toString());
            }
        } else if (expression instanceof KtClassInitializer) {
            KtClassInitializer creation = (KtClassInitializer)expression;
            if (creation.getBody() != null) {
                String expressionAsString = creation.getBody().toString();
                String invocationAsString = creation.toString();
                String suffix = invocationAsString.substring(expressionAsString.length() + 1);
                subExpressions.add(0, suffix);
                this.processExpression(creation.getBody(), subExpressions);
            } else {
                subExpressions.add(0, creation.toString());
            }
        }
    }

    @Override
    public OperationInvocation update(String oldExpression, String newExpression) {
        OperationInvocation newOperationInvocation = new OperationInvocation();
        newOperationInvocation.methodName = this.methodName;
        newOperationInvocation.locationInfo = this.locationInfo;
        this.update(newOperationInvocation, oldExpression, newExpression);
        newOperationInvocation.subExpressions = new ArrayList<String>();
        for (String argument : this.subExpressions) {
            newOperationInvocation.subExpressions.add(ReplacementUtil.performReplacement(argument, oldExpression, newExpression));
        }
        return newOperationInvocation;
    }

    @Override
    public String getName() {
        return this.getMethodName();
    }

    public String getMethodName() {
        return this.methodName;
    }

    public int numberOfSubExpressions() {
        return this.subExpressions.size();
    }

    public boolean matchesOperation(UMLOperation operation) {
        return this.matchesOperation(operation, new HashMap<String, UMLType>(), null);
    }

    public boolean matchesOperation(UMLOperation operation, Map<String, UMLType> variableTypeMap, UMLModelDiff modelDiff) {
        ArrayList<UMLType> inferredArgumentTypes = new ArrayList<UMLType>();
        for (String arg : this.arguments) {
            CharSequence type;
            int indexOfOpeningParenthesis = arg.indexOf("(");
            int indexOfOpeningSquareBracket = arg.indexOf("[");
            boolean openingParenthesisBeforeSquareBracket = false;
            boolean openingSquareBracketBeforeParenthesis = false;
            if (indexOfOpeningParenthesis != -1 && indexOfOpeningSquareBracket != -1) {
                if (indexOfOpeningParenthesis < indexOfOpeningSquareBracket) {
                    openingParenthesisBeforeSquareBracket = true;
                } else if (indexOfOpeningSquareBracket < indexOfOpeningParenthesis) {
                    openingSquareBracketBeforeParenthesis = true;
                }
            } else if (indexOfOpeningParenthesis != -1 && indexOfOpeningSquareBracket == -1) {
                openingParenthesisBeforeSquareBracket = true;
            } else if (indexOfOpeningParenthesis == -1 && indexOfOpeningSquareBracket != -1) {
                openingSquareBracketBeforeParenthesis = true;
            }
            if (variableTypeMap.containsKey(arg)) {
                inferredArgumentTypes.add(variableTypeMap.get(arg));
                continue;
            }
            if (arg.startsWith("\"") && arg.endsWith("\"")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("String"));
                continue;
            }
            if (arg.startsWith("'") && arg.endsWith("'")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("Char"));
                continue;
            }
            if (arg.endsWith(".class")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("Class"));
                continue;
            }
            if (arg.equals("True")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("Boolean"));
                continue;
            }
            if (arg.equals("False")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("Boolean"));
                continue;
            }
            if (arg.contains("(") && openingParenthesisBeforeSquareBracket) {
                type = arg.substring(0, arg.indexOf("("));
                inferredArgumentTypes.add(UMLType.extractTypeObject((String)type));
                continue;
            }
            if (arg.contains("[") && openingSquareBracketBeforeParenthesis) {
                type = new StringBuilder(arg.substring(0, arg.indexOf("[")));
                for (int i = 0; i < arg.length(); ++i) {
                    if (arg.charAt(i) == '[') {
                        ((StringBuilder)type).append("[]");
                        continue;
                    }
                    if (arg.charAt(i) == '\n' || arg.charAt(i) == '{') break;
                }
                inferredArgumentTypes.add(UMLType.extractTypeObject(((StringBuilder)type).toString()));
                continue;
            }
            if (arg.endsWith(".getClassLoader()")) {
                inferredArgumentTypes.add(UMLType.extractTypeObject("ClassLoader"));
                continue;
            }
            if (arg.contains("+") && !arg.contains("++") && !UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(arg)) {
                String[] tokens = arg.split("(\\s)*(\\+)(\\s)*");
                if (tokens[0].startsWith("\"") && tokens[0].endsWith("\"")) {
                    inferredArgumentTypes.add(UMLType.extractTypeObject("String"));
                    continue;
                }
                inferredArgumentTypes.add(null);
                continue;
            }
            inferredArgumentTypes.add(null);
        }
        boolean i = false;
        return this.methodName.equals(operation.getName()) && (this.typeArguments == operation.getParameterTypeList().size() || this.varArgsMatch(operation));
    }

    private boolean compatibleTypes(UMLParameter parameter, UMLType type, UMLModelDiff modelDiff) {
        String type1 = parameter.getType().toString();
        String type2 = type.toString();
        if (type1.equals("Throwable") && type2.endsWith("Exception")) {
            return true;
        }
        if (type1.equals("Exception") && type2.endsWith("Exception")) {
            return true;
        }
        if (type1.equals("int") && type2.equals("long")) {
            return true;
        }
        if (type1.equals("long") && type2.equals("int")) {
            return true;
        }
        if (!parameter.isVarargs() && type1.endsWith("Object") && !type2.endsWith("Object")) {
            return true;
        }
        if (!parameter.isVarargs() && type1.endsWith("Base") && type2.endsWith("Impl")) {
            return true;
        }
        if (parameter.isVarargs() && type1.endsWith("Object[]") && (type2.equals("Throwable") || type2.endsWith("Exception"))) {
            return true;
        }
        if (parameter.getType().equalsWithSubType(type)) {
            return true;
        }
        return parameter.getType().isParameterized() && type.isParameterized() && parameter.getType().getClassType().equals(type.getClassType());
    }

    private boolean varArgsMatch(UMLOperation operation) {
        return this.typeArguments == operation.getNumberOfNonVarargsParameters() || operation.hasVarargsParameter() && this.typeArguments > operation.getNumberOfNonVarargsParameters();
    }

    public boolean compatibleExpression(OperationInvocation other) {
        if (this.subExpressions.size() > 1 || other.subExpressions.size() > 1) {
            Set<String> intersection = this.subExpressionIntersection(other);
            int thisUnmatchedSubExpressions = this.subExpressions().size() - intersection.size();
            int otherUnmatchedSubExpressions = other.subExpressions().size() - intersection.size();
            return thisUnmatchedSubExpressions <= intersection.size() && otherUnmatchedSubExpressions <= intersection.size();
        }
        return true;
    }

    public boolean containsVeryLongSubExpression() {
        for (String expression : this.subExpressions) {
            if (expression.length() <= 100 || UMLOperationBodyMapper.containsMethodSignatureOfAnonymousClass(expression)) continue;
            return true;
        }
        return false;
    }

    public Set<String> callChainIntersection(OperationInvocation other) {
        LinkedHashSet<String> s1 = new LinkedHashSet<String>(this.subExpressions);
        s1.add(this.actualString());
        LinkedHashSet<String> s2 = new LinkedHashSet<String>(other.subExpressions);
        s2.add(other.actualString());
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(s1);
        intersection.retainAll(s2);
        return intersection;
    }

    private Set<String> subExpressionIntersection(OperationInvocation other) {
        Set<String> subExpressions1 = this.subExpressions();
        Set<String> subExpressions2 = other.subExpressions();
        LinkedHashSet<String> intersection = new LinkedHashSet<String>(subExpressions1);
        intersection.retainAll(subExpressions2);
        if (subExpressions1.size() == subExpressions2.size()) {
            Iterator<String> it1 = subExpressions1.iterator();
            Iterator<String> it2 = subExpressions2.iterator();
            while (it1.hasNext()) {
                String subExpression1 = it1.next();
                String subExpression2 = it2.next();
                if (intersection.contains(subExpression1) || !OperationInvocation.differInThisDot(subExpression1, subExpression2)) continue;
                intersection.add(subExpression1);
            }
        }
        return intersection;
    }

    private Set<String> subExpressions() {
        LinkedHashSet<String> subExpressions = new LinkedHashSet<String>(this.subExpressions);
        String thisExpression = this.expression;
        if (thisExpression != null) {
            if (thisExpression.contains(".")) {
                int indexOfDot = thisExpression.indexOf(".");
                String subString = thisExpression.substring(0, indexOfDot);
                if (!subExpressions.contains(subString) && !OperationInvocation.dotInsideArguments(indexOfDot, thisExpression)) {
                    subExpressions.add(subString);
                }
            } else {
                subExpressions.add(thisExpression);
            }
        }
        return subExpressions;
    }

    @Override
    public double normalizedNameDistance(AbstractCall call) {
        String s1 = this.getMethodName().toLowerCase();
        String s2 = ((OperationInvocation)call).getMethodName().toLowerCase();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof OperationInvocation) {
            OperationInvocation invocation = (OperationInvocation)o;
            return this.methodName.equals(invocation.methodName) && this.typeArguments == invocation.typeArguments;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.methodName);
        sb.append("(");
        if (this.typeArguments > 0) {
            for (int i = 0; i < this.typeArguments - 1; ++i) {
                sb.append("arg").append(i).append(", ");
            }
            sb.append("arg").append(this.typeArguments - 1);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            int result = 17;
            result = 37 * result + this.methodName.hashCode();
            this.hashCode = result = 37 * result + this.typeArguments;
        }
        return this.hashCode;
    }

    @Override
    public boolean identicalName(AbstractCall call) {
        return this.getMethodName().equals(((OperationInvocation)call).getMethodName());
    }

    public boolean typeInferenceMatch(UMLOperation operationToBeMatched, Map<String, UMLType> typeInferenceMapFromContext) {
        List<UMLParameter> parameters = operationToBeMatched.getParametersWithoutReturnType();
        if (operationToBeMatched.hasVarargsParameter()) {
            if (this.getArguments().size() < parameters.size()) {
                int i = 0;
                for (String argument : this.getArguments()) {
                    UMLType paremeterType;
                    UMLType argumentType;
                    if (typeInferenceMapFromContext.containsKey(argument) && !(argumentType = typeInferenceMapFromContext.get(argument)).equals(paremeterType = parameters.get(i).getType())) {
                        return false;
                    }
                    ++i;
                }
            } else {
                int i = 0;
                for (UMLParameter parameter : parameters) {
                    String argument = this.getArguments().get(i);
                    if (typeInferenceMapFromContext.containsKey(argument)) {
                        UMLType paremeterType;
                        UMLType argumentType = typeInferenceMapFromContext.get(argument);
                        UMLType uMLType = paremeterType = parameter.isVarargs() ? UMLType.extractTypeObject(parameter.getType().getClassType()) : parameter.getType();
                        if (!argumentType.equals(paremeterType)) {
                            return false;
                        }
                    }
                    ++i;
                }
            }
        } else {
            int i = 0;
            for (String argument : this.getArguments()) {
                UMLType paremeterType;
                UMLType argumentType;
                if (typeInferenceMapFromContext.containsKey(argument) && !(argumentType = typeInferenceMapFromContext.get(argument)).equals(paremeterType = parameters.get(i).getType())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public boolean differentExpressionNameAndArguments(OperationInvocation other) {
        boolean differentExpression;
        boolean bl = differentExpression = this.expression == null && other.expression != null;
        if (this.expression != null && other.expression == null) {
            differentExpression = true;
        }
        if (this.expression != null && other.expression != null) {
            differentExpression = !this.expression.equals(other.expression) && !this.expression.startsWith(other.expression) && !other.expression.startsWith(this.expression);
        }
        boolean differentName = !this.methodName.equals(other.methodName);
        LinkedHashSet argumentIntersection = new LinkedHashSet(this.arguments);
        argumentIntersection.retainAll(other.arguments);
        boolean argumentFoundInExpression = false;
        if (this.expression != null) {
            for (String argument : other.arguments) {
                if (!this.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
                break;
            }
        }
        if (other.expression != null) {
            for (String argument : this.arguments) {
                if (!other.expression.contains(argument)) continue;
                argumentFoundInExpression = true;
                break;
            }
        }
        boolean differentArguments = !this.arguments.equals(other.arguments) && argumentIntersection.isEmpty() && !argumentFoundInExpression;
        return differentExpression && differentName && differentArguments;
    }

    public boolean identicalWithExpressionCallChainDifference(OperationInvocation other) {
        Set<String> subExpressionIntersection = this.subExpressionIntersection(other);
        return this.identicalName(other) && this.equalArguments(other) && subExpressionIntersection.size() > 0 && (subExpressionIntersection.size() == this.subExpressions().size() || subExpressionIntersection.size() == other.subExpressions().size());
    }
}

