/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import com.intellij.psi.PsiElementVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractStatement;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AnonymousClassDeclarationObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LambdaExpressionObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.ObjectCreation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.decomposition.Visitor;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;

public class StatementObject
extends AbstractStatement {
    private final String statement;
    private final LocationInfo locationInfo;
    private final List<String> variables;
    private final List<String> types;
    private final List<VariableDeclaration> variableDeclarations;
    private final Map<String, List<OperationInvocation>> methodInvocationMap;
    private final List<String> stringLiterals;
    private final List<String> numberLiterals;
    private final List<String> nullLiterals;
    private final List<String> booleanLiterals;
    private final List<String> typeLiterals;
    private final List<String> arrayAccesses;
    private final List<String> prefixExpressions;
    private final List<String> postfixExpressions;
    private final List<String> infixOperators;
    private final List<String> arguments;
    private final List<LambdaExpressionObject> lambdas;

    public StatementObject(KtFile cu, String filePath, KtExpression statement, int depth, CodeElementType codeElementType) {
        this.locationInfo = new LocationInfo(cu, filePath, (KtElement)statement, codeElementType);
        Visitor visitor = new Visitor(cu, filePath);
        statement.accept((PsiElementVisitor)visitor);
        this.variables = visitor.getVariables();
        this.types = visitor.getTypes();
        this.variableDeclarations = visitor.getVariableDeclarations();
        this.methodInvocationMap = visitor.getMethodInvocationMap();
        this.stringLiterals = visitor.getStringLiterals();
        this.numberLiterals = visitor.getNumberLiterals();
        this.nullLiterals = visitor.getNullLiterals();
        this.booleanLiterals = visitor.getBooleanLiterals();
        this.typeLiterals = visitor.getTypeLiterals();
        this.arrayAccesses = visitor.getArrayAccesses();
        this.prefixExpressions = visitor.getPrefixExpressions();
        this.postfixExpressions = visitor.getPostfixExpressions();
        this.infixOperators = visitor.getInfixOperators();
        this.arguments = visitor.getArguments();
        this.lambdas = visitor.getLambdas();
        this.setDepth(depth);
        this.statement = statement.getText();
    }

    @Override
    public List<String> stringRepresentation() {
        ArrayList<String> stringRepresentation = new ArrayList<String>();
        stringRepresentation.add(this.toString());
        return stringRepresentation;
    }

    @Override
    public List<StatementObject> getLeaves() {
        ArrayList<StatementObject> leaves = new ArrayList<StatementObject>();
        leaves.add(this);
        return leaves;
    }

    public String toString() {
        return this.statement;
    }

    @Override
    public List<String> getVariables() {
        return this.variables;
    }

    @Override
    public List<String> getTypes() {
        return this.types;
    }

    @Override
    public List<VariableDeclaration> getVariableDeclarations() {
        return this.variableDeclarations;
    }

    @Override
    public List<String> getInfixExpressions() {
        return new ArrayList<String>();
    }

    @Override
    public Map<String, List<OperationInvocation>> getMethodInvocationMap() {
        return this.methodInvocationMap;
    }

    @Override
    public List<AnonymousClassDeclarationObject> getAnonymousClassDeclarations() {
        return new ArrayList<AnonymousClassDeclarationObject>();
    }

    @Override
    public List<String> getStringLiterals() {
        return this.stringLiterals;
    }

    @Override
    public List<String> getNumberLiterals() {
        return this.numberLiterals;
    }

    @Override
    public List<String> getNullLiterals() {
        return this.nullLiterals;
    }

    @Override
    public List<String> getBooleanLiterals() {
        return this.booleanLiterals;
    }

    @Override
    public List<String> getTypeLiterals() {
        return this.typeLiterals;
    }

    @Override
    public Map<String, List<ObjectCreation>> getCreationMap() {
        return new HashMap<String, List<ObjectCreation>>();
    }

    @Override
    public List<String> getArrayAccesses() {
        return this.arrayAccesses;
    }

    @Override
    public List<String> getPrefixExpressions() {
        return this.prefixExpressions;
    }

    @Override
    public List<String> getPostfixExpressions() {
        return this.postfixExpressions;
    }

    @Override
    public List<String> getInfixOperators() {
        return this.infixOperators;
    }

    @Override
    public List<String> getArguments() {
        return this.arguments;
    }

    @Override
    public int statementCount() {
        return 1;
    }

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    @Override
    public VariableDeclaration getVariableDeclaration(String variableName) {
        List<VariableDeclaration> variableDeclarations = this.getVariableDeclarations();
        for (VariableDeclaration declaration : variableDeclarations) {
            if (!declaration.getVariableName().equals(variableName)) continue;
            return declaration;
        }
        return null;
    }

    @Override
    public List<LambdaExpressionObject> getLambdas() {
        return this.lambdas;
    }
}

