/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.decomposition;

import com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.util.PsiUtils;

public class VariableScope {
    private final String filePath;
    private final int startOffset;
    private final int endOffset;
    private final int startLine;
    private int startColumn;
    private final int endLine;
    private int endColumn;

    public VariableScope(KtFile ktFile, String filePath, int startOffset, int endOffset) {
        this.filePath = filePath;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        Document document = ktFile.getViewProvider().getDocument();
        this.startLine = document != null ? document.getLineNumber(startOffset) : 0;
        this.endLine = document.getLineNumber(endOffset);
        this.startColumn = PsiUtils.countColumn(this.startLine, document);
        if (this.startColumn > 0) {
            ++this.startColumn;
        }
        this.endColumn = PsiUtils.countColumn(this.endLine, document);
        if (this.endColumn > 0) {
            ++this.endColumn;
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.endColumn;
        result = 31 * result + this.endLine;
        result = 31 * result + this.endOffset;
        result = 31 * result + (this.filePath == null ? 0 : this.filePath.hashCode());
        result = 31 * result + this.startColumn;
        result = 31 * result + this.startLine;
        result = 31 * result + this.startOffset;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VariableScope other = (VariableScope)obj;
        if (this.endColumn != other.endColumn) {
            return false;
        }
        if (this.endLine != other.endLine) {
            return false;
        }
        if (this.endOffset != other.endOffset) {
            return false;
        }
        if (this.filePath == null ? other.filePath != null : !this.filePath.equals(other.filePath)) {
            return false;
        }
        if (this.startColumn != other.startColumn) {
            return false;
        }
        if (this.startLine != other.startLine) {
            return false;
        }
        return this.startOffset == other.startOffset;
    }

    public String toString() {
        return this.startLine + ":" + this.startColumn + "-" + this.endLine + ":" + this.endColumn;
    }

    public boolean subsumes(LocationInfo other) {
        return this.filePath.equals(other.getFilePath()) && this.startOffset <= other.getStartOffset() && this.endOffset >= other.getEndOffset();
    }
}

