/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.diff.CallTreeNode;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;

public class CallTree {
    private final CallTreeNode root;

    public CallTree(CallTreeNode root) {
        this.root = root;
    }

    public List<CallTreeNode> getNodesInBreadthFirstOrder() {
        ArrayList<CallTreeNode> nodes = new ArrayList<CallTreeNode>();
        LinkedList<CallTreeNode> queue = new LinkedList<CallTreeNode>();
        nodes.add(this.root);
        queue.add(this.root);
        while (!queue.isEmpty()) {
            CallTreeNode node = (CallTreeNode)queue.remove(0);
            nodes.addAll(node.getChildren());
            queue.addAll(node.getChildren());
        }
        return nodes;
    }

    public boolean contains(UMLOperation invokedOperation) {
        for (CallTreeNode node : this.getNodesInBreadthFirstOrder()) {
            if (!node.getInvokedOperation().equals(invokedOperation)) continue;
            return true;
        }
        return false;
    }
}

