/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.research.kotlinrminer.ide.RefactoringMinerTimedOutException;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.decomposition.OperationInvocation;
import org.jetbrains.research.kotlinrminer.ide.decomposition.StatementObject;
import org.jetbrains.research.kotlinrminer.ide.decomposition.UMLOperationBodyMapper;
import org.jetbrains.research.kotlinrminer.ide.diff.CallTree;
import org.jetbrains.research.kotlinrminer.ide.diff.CallTreeNode;
import org.jetbrains.research.kotlinrminer.ide.diff.ExtractOperationDetection;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLClassBaseDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLModelDiff;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.InlineOperationRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLType;

public class InlineOperationDetection {
    private final UMLOperationBodyMapper mapper;
    private final List<UMLOperation> removedOperations;
    private final UMLClassBaseDiff classDiff;
    private final UMLModelDiff modelDiff;
    private final List<OperationInvocation> operationInvocations;
    private final Map<CallTreeNode, CallTree> callTreeMap = new LinkedHashMap<CallTreeNode, CallTree>();

    public InlineOperationDetection(UMLOperationBodyMapper mapper, List<UMLOperation> removedOperations, UMLClassBaseDiff classDiff, UMLModelDiff modelDiff) {
        this.mapper = mapper;
        this.removedOperations = removedOperations;
        this.classDiff = classDiff;
        this.modelDiff = modelDiff;
        this.operationInvocations = this.getInvocationsInTargetOperationBeforeInline(mapper);
    }

    public List<InlineOperationRefactoring> check(UMLOperation removedOperation) throws RefactoringMinerTimedOutException {
        List<OperationInvocation> removedOperationInvocations;
        ArrayList<InlineOperationRefactoring> refactorings = new ArrayList<InlineOperationRefactoring>();
        if (!(this.mapper.getNonMappedLeavesT2().isEmpty() && this.mapper.getNonMappedInnerNodesT2().isEmpty() && this.mapper.getReplacementsInvolvingMethodInvocation().isEmpty() || (removedOperationInvocations = this.matchingInvocations(removedOperation, this.operationInvocations, this.mapper.getOperation1().variableTypeMap())).size() <= 0 || this.invocationMatchesWithAddedOperation(removedOperationInvocations.get(0), this.mapper.getOperation1().variableTypeMap(), this.mapper.getOperation2().getAllOperationInvocations()))) {
            CallTree callTree;
            OperationInvocation removedOperationInvocation = removedOperationInvocations.get(0);
            CallTreeNode root = new CallTreeNode(this.mapper.getOperation1(), removedOperation, removedOperationInvocation);
            if (this.callTreeMap.containsKey(root)) {
                callTree = this.callTreeMap.get(root);
            } else {
                callTree = new CallTree(root);
                this.generateCallTree(removedOperation, root, callTree);
                this.callTreeMap.put(root, callTree);
            }
            UMLOperationBodyMapper operationBodyMapper = this.createMapperForInlinedMethod(this.mapper, removedOperation, removedOperationInvocation);
            ArrayList<AbstractCodeMapping> additionalExactMatches = new ArrayList<AbstractCodeMapping>();
            List<CallTreeNode> nodesInBreadthFirstOrder = callTree.getNodesInBreadthFirstOrder();
            for (int i = 1; i < nodesInBreadthFirstOrder.size(); ++i) {
                CallTreeNode node = nodesInBreadthFirstOrder.get(i);
                if (this.matchingInvocations(node.getInvokedOperation(), this.operationInvocations, this.mapper.getOperation1().variableTypeMap()).size() != 0) continue;
                UMLOperationBodyMapper nestedMapper = this.createMapperForInlinedMethod(this.mapper, node.getInvokedOperation(), node.getInvocation());
                additionalExactMatches.addAll(nestedMapper.getExactMatches());
                if (!this.inlineMatchCondition(nestedMapper)) continue;
                List<OperationInvocation> nestedMatchingInvocations = this.matchingInvocations(node.getInvokedOperation(), node.getOriginalOperation().getAllOperationInvocations(), node.getOriginalOperation().variableTypeMap());
                InlineOperationRefactoring nestedRefactoring = new InlineOperationRefactoring(nestedMapper, this.mapper.getOperation1(), nestedMatchingInvocations);
                refactorings.add(nestedRefactoring);
                operationBodyMapper.addChildMapper(nestedMapper);
            }
            if (this.inlineMatchCondition(operationBodyMapper)) {
                InlineOperationRefactoring inlineOperationRefactoring = new InlineOperationRefactoring(operationBodyMapper, this.mapper.getOperation1(), removedOperationInvocations);
                refactorings.add(inlineOperationRefactoring);
            }
        }
        return refactorings;
    }

    private List<OperationInvocation> getInvocationsInTargetOperationBeforeInline(UMLOperationBodyMapper mapper) {
        List<OperationInvocation> operationInvocations = mapper.getOperation1().getAllOperationInvocations();
        for (StatementObject statement : mapper.getNonMappedLeavesT1()) {
            ExtractOperationDetection.addStatementInvocations(operationInvocations, statement);
        }
        return operationInvocations;
    }

    private List<OperationInvocation> matchingInvocations(UMLOperation removedOperation, List<OperationInvocation> operationInvocations, Map<String, UMLType> variableTypeMap) {
        ArrayList<OperationInvocation> removedOperationInvocations = new ArrayList<OperationInvocation>();
        for (OperationInvocation invocation : operationInvocations) {
            if (!invocation.matchesOperation(removedOperation, variableTypeMap, this.modelDiff)) continue;
            removedOperationInvocations.add(invocation);
        }
        return removedOperationInvocations;
    }

    private UMLOperationBodyMapper createMapperForInlinedMethod(UMLOperationBodyMapper mapper, UMLOperation removedOperation, OperationInvocation removedOperationInvocation) throws RefactoringMinerTimedOutException {
        List<String> arguments = removedOperationInvocation.getArguments();
        List<String> parameters = removedOperation.getParameterNameList();
        LinkedHashMap<String, String> parameterToArgumentMap = new LinkedHashMap<String, String>();
        int size = Math.min(arguments.size(), parameters.size());
        for (int i = 0; i < size; ++i) {
            parameterToArgumentMap.put(parameters.get(i), arguments.get(i));
        }
        return new UMLOperationBodyMapper(removedOperation, mapper, parameterToArgumentMap, this.classDiff);
    }

    private void generateCallTree(UMLOperation operation, CallTreeNode parent, CallTree callTree) {
        List<OperationInvocation> invocations = operation.getAllOperationInvocations();
        for (UMLOperation removedOperation : this.removedOperations) {
            for (OperationInvocation invocation : invocations) {
                if (!invocation.matchesOperation(removedOperation, operation.variableTypeMap(), this.modelDiff) || callTree.contains(removedOperation)) continue;
                CallTreeNode node = new CallTreeNode(operation, removedOperation, invocation);
                parent.addChild(node);
                this.generateCallTree(removedOperation, node, callTree);
            }
        }
    }

    private boolean inlineMatchCondition(UMLOperationBodyMapper operationBodyMapper) {
        int delegateStatements = 0;
        for (StatementObject statement : operationBodyMapper.getNonMappedLeavesT1()) {
            OperationInvocation invocation = statement.invocationCoveringEntireFragment();
            if (invocation == null || !invocation.matchesOperation(operationBodyMapper.getOperation1())) continue;
            ++delegateStatements;
        }
        int mappings = operationBodyMapper.mappingsWithoutBlocks();
        int nonMappedElementsT1 = operationBodyMapper.nonMappedElementsT1() - delegateStatements;
        List<AbstractCodeMapping> exactMatchList = operationBodyMapper.getExactMatches();
        int exactMatches = exactMatchList.size();
        return mappings > 0 && (mappings > nonMappedElementsT1 || exactMatches == 1 && !exactMatchList.get(0).getFragment1().throwsNewException() && nonMappedElementsT1 - exactMatches < 10 || exactMatches > 1 && nonMappedElementsT1 - exactMatches < 20);
    }

    private boolean invocationMatchesWithAddedOperation(OperationInvocation removedOperationInvocation, Map<String, UMLType> variableTypeMap, List<OperationInvocation> operationInvocationsInNewMethod) {
        if (operationInvocationsInNewMethod.contains(removedOperationInvocation)) {
            for (UMLOperation addedOperation : this.classDiff.getAddedOperations()) {
                if (!removedOperationInvocation.matchesOperation(addedOperation, variableTypeMap, this.modelDiff)) continue;
                return true;
            }
        }
        return false;
    }
}

