/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.ide.diff.UMLAnnotationDiff;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;

public class UMLAnnotationListDiff {
    private final List<UMLAnnotation> removedAnnotations = new ArrayList<UMLAnnotation>();
    private final List<UMLAnnotation> addedAnnotations = new ArrayList<UMLAnnotation>();
    private final List<UMLAnnotationDiff> annotationDiffList = new ArrayList<UMLAnnotationDiff>();

    public UMLAnnotationListDiff(List<UMLAnnotation> annotations1, List<UMLAnnotation> annotations2) {
        boolean found;
        ArrayList<AbstractMap.SimpleEntry<UMLAnnotation, UMLAnnotation>> matchedAnnotations = new ArrayList<AbstractMap.SimpleEntry<UMLAnnotation, UMLAnnotation>>();
        for (UMLAnnotation uMLAnnotation : annotations1) {
            found = false;
            for (UMLAnnotation annotation2 : annotations2) {
                if (!uMLAnnotation.getTypeName().equals(annotation2.getTypeName())) continue;
                matchedAnnotations.add(new AbstractMap.SimpleEntry<UMLAnnotation, UMLAnnotation>(uMLAnnotation, annotation2));
                found = true;
                break;
            }
            if (found) continue;
            this.removedAnnotations.add(uMLAnnotation);
        }
        for (UMLAnnotation uMLAnnotation : annotations2) {
            found = false;
            for (UMLAnnotation annotation1 : annotations1) {
                if (!annotation1.getTypeName().equals(uMLAnnotation.getTypeName())) continue;
                matchedAnnotations.add(new AbstractMap.SimpleEntry<UMLAnnotation, UMLAnnotation>(annotation1, uMLAnnotation));
                found = true;
                break;
            }
            if (found) continue;
            this.addedAnnotations.add(uMLAnnotation);
        }
        for (AbstractMap.SimpleEntry simpleEntry : matchedAnnotations) {
            UMLAnnotationDiff annotationDiff = new UMLAnnotationDiff((UMLAnnotation)simpleEntry.getKey(), (UMLAnnotation)simpleEntry.getValue());
            if (annotationDiff.isEmpty()) continue;
            this.annotationDiffList.add(annotationDiff);
        }
    }

    public List<UMLAnnotation> getRemovedAnnotations() {
        return this.removedAnnotations;
    }

    public List<UMLAnnotation> getAddedAnnotations() {
        return this.addedAnnotations;
    }

    public List<UMLAnnotationDiff> getAnnotationDiffList() {
        return this.annotationDiffList;
    }

    public boolean isEmpty() {
        return this.removedAnnotations.isEmpty() && this.addedAnnotations.isEmpty() && this.annotationDiffList.isEmpty();
    }
}

