/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.AbstractCodeMapping;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLClass;

public class ExtractAttributeRefactoring
implements Refactoring {
    private final UMLAttribute attributeDeclaration;
    private final UMLClass originalClass;
    private final UMLClass nextClass;
    private final Set<AbstractCodeMapping> references;

    public ExtractAttributeRefactoring(UMLAttribute variableDeclaration, UMLClass originalClass, UMLClass nextClass) {
        this.attributeDeclaration = variableDeclaration;
        this.originalClass = originalClass;
        this.nextClass = nextClass;
        this.references = new LinkedHashSet<AbstractCodeMapping>();
    }

    public void addReference(AbstractCodeMapping mapping) {
        this.references.add(mapping);
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.EXTRACT_ATTRIBUTE;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    public UMLAttribute getVariableDeclaration() {
        return this.attributeDeclaration;
    }

    public Set<AbstractCodeMapping> getReferences() {
        return this.references;
    }

    @Override
    public String toString() {
        return this.getName() + "\t" + this.attributeDeclaration + " in class " + this.attributeDeclaration.getClassName();
    }

    public CodeRange getExtractedVariableDeclarationCodeRange() {
        return this.attributeDeclaration.codeRange();
    }

    public UMLClass getOriginalClass() {
        return this.originalClass;
    }

    public UMLClass getNextClass() {
        return this.nextClass;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeDeclaration == null ? 0 : this.attributeDeclaration.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtractAttributeRefactoring other = (ExtractAttributeRefactoring)obj;
        if (this.attributeDeclaration == null) {
            return other.attributeDeclaration == null;
        }
        return this.attributeDeclaration.equals(other.attributeDeclaration);
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOriginalClass().getLocationInfo().getFilePath(), (Object)this.getOriginalClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getNextClass().getLocationInfo().getFilePath(), (Object)this.getNextClass().getQualifiedName()));
        return pairs;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment1().codeRange().setDescription("statement with the initializer of the extracted attribute"));
        }
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.attributeDeclaration.codeRange().setDescription("extracted attribute declaration").setCodeElement(this.attributeDeclaration.toString()));
        for (AbstractCodeMapping mapping : this.references) {
            ranges.add(mapping.getFragment2().codeRange().setDescription("statement with the name of the extracted attribute"));
        }
        return ranges;
    }
}

