/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.MoveAttributeRefactoring;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAttribute;

public class PushDownAttributeRefactoring
extends MoveAttributeRefactoring {
    public PushDownAttributeRefactoring(UMLAttribute originalAttribute, UMLAttribute movedAttribute) {
        super(originalAttribute, movedAttribute);
    }

    @Override
    public String toString() {
        return this.getName() + "\t" + this.getOriginalAttribute().toQualifiedString() + " from class " + this.getSourceClassName() + " to " + this.getMovedAttribute().toQualifiedString() + " from class " + this.getTargetClassName();
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.PUSH_DOWN_ATTRIBUTE;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        ranges.add(this.movedAttribute.codeRange().setDescription("pushed down attribute declaration").setCodeElement(this.movedAttribute.toString()));
        return ranges;
    }
}

