/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.diff.refactoring;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jetbrains.research.kotlinrminer.common.RefactoringType;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLOperation;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLParameter;

public class ReorderParameterRefactoring
implements Refactoring {
    private final List<VariableDeclaration> parametersBefore;
    private final List<VariableDeclaration> parametersAfter;
    private final UMLOperation operationBefore;
    private final UMLOperation operationAfter;

    public ReorderParameterRefactoring(UMLOperation operationBefore, UMLOperation operationAfter) {
        this.operationBefore = operationBefore;
        this.operationAfter = operationAfter;
        this.parametersBefore = new ArrayList<VariableDeclaration>();
        for (UMLParameter parameter : operationBefore.getParametersWithoutReturnType()) {
            this.parametersBefore.add(parameter.getVariableDeclaration());
        }
        this.parametersAfter = new ArrayList<VariableDeclaration>();
        for (UMLParameter parameter : operationAfter.getParametersWithoutReturnType()) {
            this.parametersAfter.add(parameter.getVariableDeclaration());
        }
    }

    public List<VariableDeclaration> getParametersBefore() {
        return this.parametersBefore;
    }

    public List<VariableDeclaration> getParametersAfter() {
        return this.parametersAfter;
    }

    public UMLOperation getOperationBefore() {
        return this.operationBefore;
    }

    public UMLOperation getOperationAfter() {
        return this.operationAfter;
    }

    @Override
    public List<CodeRange> leftSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration parameter : this.parametersBefore) {
            ranges.add(parameter.codeRange().setDescription("original parameter declaration").setCodeElement(parameter.toString()));
        }
        ranges.add(this.operationBefore.codeRange().setDescription("original method declaration").setCodeElement(this.operationBefore.toString()));
        return ranges;
    }

    @Override
    public List<CodeRange> rightSide() {
        ArrayList<CodeRange> ranges = new ArrayList<CodeRange>();
        for (VariableDeclaration parameter : this.parametersAfter) {
            ranges.add(parameter.codeRange().setDescription("reordered parameter declaration").setCodeElement(parameter.toString()));
        }
        ranges.add(this.operationAfter.codeRange().setDescription("method declaration with reordered parameters").setCodeElement(this.operationAfter.toString()));
        return ranges;
    }

    @Override
    public RefactoringType getRefactoringType() {
        return RefactoringType.REORDER_PARAMETER;
    }

    @Override
    public String getName() {
        return this.getRefactoringType().getDisplayName();
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesBeforeRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationBefore().getLocationInfo().getFilePath(), (Object)this.getOperationBefore().getClassName()));
        return pairs;
    }

    @Override
    public Set<ImmutablePair<String, String>> getInvolvedClassesAfterRefactoring() {
        LinkedHashSet<ImmutablePair<String, String>> pairs = new LinkedHashSet<ImmutablePair<String, String>>();
        pairs.add(new ImmutablePair((Object)this.getOperationAfter().getLocationInfo().getFilePath(), (Object)this.getOperationAfter().getClassName()));
        return pairs;
    }

    @Override
    public String toString() {
        return this.getName() + " " + this.parametersBefore + " to " + this.parametersAfter + " in method " + this.operationAfter + " in class " + this.operationAfter.getClassName();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.operationAfter == null ? 0 : this.operationAfter.hashCode());
        result = 31 * result + (this.operationBefore == null ? 0 : this.operationBefore.hashCode());
        result = 31 * result + (this.parametersAfter == null ? 0 : this.parametersAfter.hashCode());
        result = 31 * result + (this.parametersBefore == null ? 0 : this.parametersBefore.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReorderParameterRefactoring other = (ReorderParameterRefactoring)obj;
        if (this.operationAfter == null ? other.operationAfter != null : !this.operationAfter.equals(other.operationAfter)) {
            return false;
        }
        if (this.operationBefore == null ? other.operationBefore != null : !this.operationBefore.equals(other.operationBefore)) {
            return false;
        }
        if (this.parametersAfter == null ? other.parametersAfter != null : !this.parametersAfter.equals(other.parametersAfter)) {
            return false;
        }
        if (this.parametersBefore == null) {
            return other.parametersBefore == null;
        }
        return this.parametersBefore.equals(other.parametersBefore);
    }
}

