/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.kotlinrminer.ide.uml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.kotlin.psi.KtAnnotation;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunctionType;
import org.jetbrains.kotlin.psi.KtNullableType;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtUserType;
import org.jetbrains.research.kotlinrminer.common.decomposition.CodeElementType;
import org.jetbrains.research.kotlinrminer.common.util.StringDistance;
import org.jetbrains.research.kotlinrminer.ide.decomposition.CompositeType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.FunctionType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LeafType;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfo;
import org.jetbrains.research.kotlinrminer.ide.decomposition.LocationInfoProvider;
import org.jetbrains.research.kotlinrminer.ide.decomposition.Untyped;
import org.jetbrains.research.kotlinrminer.ide.diff.CodeRange;
import org.jetbrains.research.kotlinrminer.ide.uml.UMLAnnotation;

public abstract class UMLType
implements Serializable,
LocationInfoProvider {
    private LocationInfo locationInfo;
    private int arrayDimension;
    private List<UMLType> typeArguments = new ArrayList<UMLType>();
    protected List<UMLAnnotation> annotations = new ArrayList<UMLAnnotation>();
    private boolean isNullable;

    @Override
    public LocationInfo getLocationInfo() {
        return this.locationInfo;
    }

    public int getArrayDimension() {
        return this.arrayDimension;
    }

    public List<UMLAnnotation> getAnnotations() {
        return this.annotations;
    }

    @Override
    public CodeRange codeRange() {
        return this.locationInfo.codeRange();
    }

    public void setVarargs() {
        ++this.arrayDimension;
    }

    protected String typeArgumentsToString() {
        StringBuilder sb = new StringBuilder();
        if (!this.typeArguments.isEmpty()) {
            sb.append("<");
            for (int i = 0; i < this.typeArguments.size(); ++i) {
                sb.append(this.typeArguments.get(i).toQualifiedString());
                if (i >= this.typeArguments.size() - 1) continue;
                sb.append(",");
            }
            sb.append(">");
        }
        return sb.toString();
    }

    private boolean equalTypeArguments(UMLType type) {
        String thisTypeArguments = this.typeArgumentsToString();
        String otherTypeArguments = type.typeArgumentsToString();
        if (thisTypeArguments.equals("<?>") && otherTypeArguments.startsWith("<? ") || thisTypeArguments.startsWith("<? ") && otherTypeArguments.equals("<?>")) {
            return true;
        }
        if (thisTypeArguments.equals("<Object>") && otherTypeArguments.contains("<Object>") || otherTypeArguments.equals("<Object>") && thisTypeArguments.contains("<Object>")) {
            return true;
        }
        if (this.typeArguments.size() != type.typeArguments.size()) {
            return false;
        }
        for (int i = 0; i < this.typeArguments.size(); ++i) {
            UMLType otherComponent;
            UMLType thisComponent = this.typeArguments.get(i);
            if (thisComponent.equals(otherComponent = type.typeArguments.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean equalTypeArgumentsAndArrayDimension(UMLType typeObject) {
        if (!this.isParameterized() && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && typeObject.isParameterized()) {
            return this.equalTypeArguments(typeObject) && this.arrayDimension == typeObject.arrayDimension;
        }
        return false;
    }

    protected boolean equalTypeArgumentsAndArrayDimensionForSubType(UMLType typeObject) {
        if (!this.isParameterized() && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && typeObject.isParameterized()) {
            return this.equalTypeArguments(typeObject) && this.arrayDimension == typeObject.arrayDimension;
        }
        if (this.isParameterized() && this.typeArgumentsToString().equals("<?>") && !typeObject.isParameterized()) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        if (!this.isParameterized() && typeObject.isParameterized() && typeObject.typeArgumentsToString().equals("<?>")) {
            return this.arrayDimension == typeObject.arrayDimension;
        }
        return false;
    }

    public boolean containsTypeArgument(String type) {
        for (UMLType typeArgument : this.typeArguments) {
            if (!typeArgument.toString().equals(type)) continue;
            return true;
        }
        return false;
    }

    public boolean isParameterized() {
        return this.typeArguments.size() > 0;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    public abstract String toQualifiedString();

    public abstract String getClassType();

    public boolean equalsQualified(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean equalsWithSubType(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean equalClassType(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public boolean compatibleTypes(UMLType type) {
        if (this.getClass() == type.getClass()) {
            return this.equals(type);
        }
        return false;
    }

    public static LeafType extractTypeObject(String qualifiedName) {
        int arrayDimension = 0;
        ArrayList<UMLType> typeArgumentDecomposition = new ArrayList<UMLType>();
        if (qualifiedName.contains("<") && qualifiedName.contains(">")) {
            String typeArguments = qualifiedName.substring(qualifiedName.indexOf("<") + 1, qualifiedName.lastIndexOf(">"));
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < typeArguments.length(); ++i) {
                char charAt = typeArguments.charAt(i);
                if (charAt != ',') {
                    sb.append(charAt);
                    continue;
                }
                if (sb.length() > 0 && UMLType.equalOpeningClosingTags(sb.toString())) {
                    typeArgumentDecomposition.add(UMLType.extractTypeObject(sb.toString()));
                    sb = new StringBuilder();
                    continue;
                }
                sb.append(charAt);
            }
            if (sb.length() > 0) {
                typeArgumentDecomposition.add(UMLType.extractTypeObject(sb.toString()));
            }
            qualifiedName = qualifiedName.substring(0, qualifiedName.indexOf("<"));
        }
        LeafType typeObject = new LeafType(qualifiedName);
        typeObject.arrayDimension = arrayDimension;
        typeObject.typeArguments = typeArgumentDecomposition;
        return typeObject;
    }

    private static boolean equalOpeningClosingTags(String typeArguments) {
        int openingTags = 0;
        int closingTags = 0;
        for (int i = 0; i < typeArguments.length(); ++i) {
            if (typeArguments.charAt(i) == '>') {
                ++openingTags;
                continue;
            }
            if (typeArguments.charAt(i) != '<') continue;
            ++closingTags;
        }
        return openingTags == closingTags;
    }

    public static UMLType extractTypeObject(KtFile ktFile, String filePath, KtElement type, int extraDimensions) {
        UMLType umlType = UMLType.extractTypeObject(ktFile, filePath, type);
        if (!(umlType instanceof Untyped)) {
            umlType.locationInfo = new LocationInfo(ktFile, filePath, type, CodeElementType.TYPE);
            umlType.arrayDimension += extraDimensions;
        }
        return umlType;
    }

    private static UMLType extractTypeObject(KtFile ktFile, String filePath, KtElement type) {
        if (type == null) {
            return new Untyped();
        }
        if (type instanceof KtUserType) {
            KtUserType userType = (KtUserType)type;
            KtUserType qualifier = userType.getQualifier();
            if (qualifier != null) {
                UMLType left = UMLType.extractTypeObject(ktFile, filePath, (KtElement)qualifier);
                LeafType rightType = UMLType.extractTypeObject(userType.getReferencedName());
                return new CompositeType(left, rightType);
            }
            return UMLType.extractTypeObject(type.getText());
        }
        if (type instanceof KtTypeReference) {
            KtUserType userType;
            KtTypeReference typeReference = (KtTypeReference)type;
            KtTypeElement element = typeReference.getTypeElement();
            if (element instanceof KtFunctionType) {
                LeafType receiver;
                LeafType returnType;
                KtFunctionType functionType = (KtFunctionType)element;
                LeafType leafType = returnType = functionType.getReturnTypeReference() == null ? null : UMLType.extractTypeObject(functionType.getReturnTypeReference().getText());
                if (returnType != null) {
                    returnType.isNullable = functionType.getReturnTypeReference().getTypeElement() instanceof KtNullableType;
                }
                LeafType leafType2 = receiver = functionType.getReceiverTypeReference() == null ? null : UMLType.extractTypeObject(functionType.getReceiverTypeReference().getText());
                if (receiver != null) {
                    receiver.isNullable = functionType.getReceiverTypeReference().getTypeElement() instanceof KtNullableType;
                }
                ArrayList<UMLType> umlTypeList = new ArrayList<UMLType>();
                if (functionType.getParameterList() != null) {
                    List parameterList = functionType.getParameterList().getParameters();
                    for (KtParameter ktParameter : parameterList) {
                        LeafType umlType = UMLType.extractTypeObject(ktParameter.getText());
                        if (ktParameter.getTypeReference() != null) {
                            umlType.isNullable = ktParameter.getTypeReference().getTypeElement() instanceof KtNullableType;
                        }
                        umlTypeList.add(umlType);
                    }
                }
                return new FunctionType(receiver, returnType, umlTypeList);
            }
            LeafType umlType = UMLType.extractTypeObject(element.getText());
            if (element instanceof KtNullableType) {
                umlType.isNullable = true;
            }
            List annotations = typeReference.getAnnotations();
            for (KtAnnotation annotation : annotations) {
                umlType.annotations.add(new UMLAnnotation(ktFile, filePath, annotation));
            }
            if (element instanceof KtUserType && (userType = (KtUserType)element).getQualifier() != null) {
                LeafType rightType = UMLType.extractTypeObject(userType.getReferencedName());
                UMLType left = UMLType.extractTypeObject(ktFile, filePath, (KtElement)userType.getQualifier());
                return new CompositeType(left, rightType);
            }
            return umlType;
        }
        if (type instanceof KtProperty) {
            KtProperty property = (KtProperty)type;
            return UMLType.extractTypeObject(ktFile, filePath, (KtElement)property.getTypeReference());
        }
        return null;
    }

    public double normalizedNameDistance(UMLType type) {
        String s1 = this.toString();
        String s2 = type.toString();
        int distance = StringDistance.editDistance(s1, s2);
        return (double)distance / (double)Math.max(s1.length(), s2.length());
    }

    public boolean isNullable() {
        return this.isNullable;
    }
}

