/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.diff;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.SimpleDiffRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.jetbrains.research.refactorinsight.common.adapters.CodeRange;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringLine;
import org.jetbrains.research.refactorinsight.common.diff.VisualizationType;

public abstract class DiffRequestGenerator {
    transient List<RefactoringLine> lineMarkings = new ArrayList<RefactoringLine>();

    public abstract SimpleDiffRequest generate(DiffContent[] var1, RefactoringInfo var2);

    public abstract void prepareRanges(List<RefactoringLine> var1);

    public void addMarking(CodeRange left, CodeRange mid, CodeRange right, VisualizationType type, Consumer<RefactoringLine> offsetFunction, RefactoringLine.MarkingOption option, boolean hasColumns) {
        RefactoringLine line = new RefactoringLine(left, mid, right, type, option, hasColumns);
        if (offsetFunction != null) {
            offsetFunction.accept(line);
        }
        this.lineMarkings.add(line);
    }

    public List<RefactoringLine> getMarkings() {
        return this.lineMarkings;
    }

    public void correct(String before, String mid, String after, boolean skipAnnotationsLeft, boolean skipAnnotationsMid, boolean skipAnnotationsRight) {
        this.lineMarkings.forEach(l -> l.correctLines(before, mid, after, skipAnnotationsLeft, skipAnnotationsMid, skipAnnotationsRight));
        this.prepareRanges(this.lineMarkings);
    }
}

