/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.utils;

import java.util.List;

public class StringUtils {
    public static final String ESC = "#";
    public static final String ESC_REGEX = "(?<!#)";
    public static final int ENTRY = 2;
    public static final int LIST = 4;
    public static final int FRAG = 5;
    public static final int RANGE = 6;
    public static final String[] delimiters = new String[]{"_", "=", "`", "-", "!", ",", ";"};

    public static String delimiter(int option, boolean escaped) {
        return (escaped ? ESC_REGEX : "") + delimiters[option];
    }

    public static String delimiter(int option) {
        return StringUtils.delimiter(option, false);
    }

    public static String calculateSignatureWithoutClassName(String operationName, List<String> parameterTypeList) {
        StringBuilder builder = new StringBuilder();
        builder.append(operationName).append("(");
        parameterTypeList.forEach(x -> builder.append((String)x).append(", "));
        if (parameterTypeList.size() > 0) {
            builder.deleteCharAt(builder.length() - 1);
            builder.deleteCharAt(builder.length() - 1);
        }
        builder.append(")");
        return builder.toString();
    }

    public static String sanitize(String s) {
        s = s.replaceAll(ESC, "##");
        for (String d : delimiters) {
            s = s.replaceAll(d, ESC + d);
        }
        return s;
    }

    public static String deSanitize(String s) {
        for (String d : delimiters) {
            s = s.replaceAll(ESC + d, d);
        }
        return s.replaceAll("##", ESC);
    }

    public static String pathToClassName(String name) {
        return name.substring(name.indexOf(47) + 1, name.lastIndexOf(46)).replace('/', '.');
    }
}

