/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.common.utils;

import com.intellij.openapi.Disposable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.common.data.RefactoringType;

public class Utils {
    private static final ArrayList<Disposable> logs = new ArrayList();

    public static void add(Disposable log) {
        logs.add(log);
    }

    public static int[] findColumns(String text, String word, int line) {
        String[] lines = text.split("\r\n|\r|\n");
        int startColumn = lines[line].indexOf(word) + 1;
        int endColumn = startColumn + word.length();
        return new int[]{startColumn, endColumn};
    }

    public static int[] findColumnsBackwards(String text, String word, int line) {
        String[] lines = text.split("\r\n|\r|\n");
        int startColumn = lines[line].lastIndexOf(word) + 1;
        int endColumn = startColumn + word.length();
        return new int[]{startColumn, endColumn};
    }

    public static int skipJavadoc(String text, int line, boolean skipAnnotations) {
        String[] lines = text.split("\r\n|\r|\n");
        if (line >= lines.length) {
            System.out.println(text);
            System.out.println(line);
        }
        if (lines[line].contains("/**")) {
            for (int i = line + 1; i < lines.length; ++i) {
                if (!lines[i].contains("*/")) continue;
                return skipAnnotations ? Utils.skipAnnotations(lines, i + 1) : i + 1;
            }
        }
        return skipAnnotations ? Utils.skipAnnotations(lines, line) : line;
    }

    private static int skipAnnotations(String[] lines, int line) {
        for (int i = line; i < lines.length; ++i) {
            if (lines[i].matches("((\\s|\\t)*@(\\w)*([(](.)*[)])*(\\s|\\t)*)+") || lines[i].matches("(\\s|\\t)*")) continue;
            return i;
        }
        return line;
    }

    public static int getOffset(String text, int line, int column) {
        int offset = 0;
        String[] lines = text.split("\r\n|\r|\n");
        if (lines.length <= line - 2) {
            line = lines.length;
        }
        for (int i = 0; i < line - 1; ++i) {
            offset += lines[i].length() + 1;
        }
        return offset + column - 1;
    }

    public static int getMaxLine(String text) {
        return text.split("\r\n|\r|\n").length;
    }

    public static RefactoringInfo getMainRefactoringInfo(List<RefactoringInfo> infos) {
        RefactoringInfo info = null;
        if (infos.stream().anyMatch(Utils.ofType(RefactoringType.RENAME_ATTRIBUTE)) && infos.stream().anyMatch(Utils.ofType(RefactoringType.CHANGE_ATTRIBUTE_TYPE))) {
            info = infos.stream().filter(Utils.ofType(RefactoringType.RENAME_ATTRIBUTE)).findFirst().get();
            info.setType(RefactoringType.RENAME_AND_CHANGE_ATTRIBUTE_TYPE);
        } else if (infos.stream().anyMatch(Utils.ofType(RefactoringType.RENAME_ATTRIBUTE))) {
            info = infos.stream().filter(Utils.ofType(RefactoringType.RENAME_ATTRIBUTE)).findFirst().get();
        } else if (infos.stream().anyMatch(Utils.ofType(RefactoringType.CHANGE_ATTRIBUTE_TYPE))) {
            info = infos.stream().filter(Utils.ofType(RefactoringType.CHANGE_ATTRIBUTE_TYPE)).findFirst().get();
        } else if (infos.stream().anyMatch(Utils.ofType(RefactoringType.CHANGE_VARIABLE_TYPE))) {
            info = infos.stream().filter(Utils.ofType(RefactoringType.CHANGE_VARIABLE_TYPE)).findFirst().get();
            info.setType(RefactoringType.RENAME_AND_CHANGE_VARIABLE_TYPE);
        } else if (infos.stream().anyMatch(Utils.ofType(RefactoringType.RENAME_PARAMETER)) && infos.stream().anyMatch(Utils.ofType(RefactoringType.CHANGE_PARAMETER_TYPE))) {
            info = infos.stream().filter(Utils.ofType(RefactoringType.RENAME_PARAMETER)).findFirst().get();
            info.setType(RefactoringType.RENAME_AND_CHANGE_PARAMETER_TYPE);
        }
        return info;
    }

    private static Predicate<RefactoringInfo> ofType(RefactoringType type) {
        return r -> r.getType().name().equals(type.name());
    }

    public static String fixPath(String path) {
        if (path != null && path.contains(".gradle/caches/")) {
            return path.substring(path.lastIndexOf("/bin/") + 5);
        }
        return path;
    }

    public static int findPackageLine(String text) {
        String[] lines = text.split("\r\n|\r|\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].contains("package ")) {
                return i;
            }
            if (!lines[i].matches("^[a-zA-Z0-9]*$")) continue;
            return -1;
        }
        return 0;
    }
}

