/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.research.refactorinsight.kotlin.impl.data.methods;

import java.util.List;
import java.util.stream.IntStream;
import org.jetbrains.research.kotlinrminer.ide.Refactoring;
import org.jetbrains.research.kotlinrminer.ide.decomposition.VariableDeclaration;
import org.jetbrains.research.kotlinrminer.ide.diff.refactoring.ReorderParameterRefactoring;
import org.jetbrains.research.refactorinsight.common.data.Group;
import org.jetbrains.research.refactorinsight.common.data.RefactoringInfo;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.KotlinRefactoringHandler;
import org.jetbrains.research.refactorinsight.kotlin.impl.data.util.KotlinUtils;

public class ReorderParameterKotlinHandler
extends KotlinRefactoringHandler {
    @Override
    public RefactoringInfo specify(Refactoring refactoring, RefactoringInfo info) {
        ReorderParameterRefactoring ref = (ReorderParameterRefactoring)refactoring;
        String classNameBefore = ref.getOperationBefore().getClassName();
        String classNameAfter = ref.getOperationAfter().getClassName();
        List<VariableDeclaration> befores = ref.getParametersBefore();
        List<VariableDeclaration> afters = ref.getParametersAfter();
        IntStream.range(0, Math.min(befores.size(), afters.size())).mapToObj(i -> new Pair((VariableDeclaration)befores.get(i), (VariableDeclaration)afters.get(i))).forEach(x -> {
            if (!x.first.getVariableDeclaration().getType().equals(x.second.getVariableDeclaration().getType()) || !x.first.getVariableName().equals(x.second.getVariableName())) {
                info.addMarking(KotlinUtils.createCodeRangeFromKotlin(x.first.codeRange()), KotlinUtils.createCodeRangeFromKotlin(x.second.codeRange()), true);
            }
        });
        return info.setGroup(Group.METHOD).setDetailsBefore(classNameBefore).setDetailsAfter(classNameAfter).setNameBefore(KotlinUtils.calculateSignatureForKotlinMethod(ref.getOperationBefore())).setNameAfter(KotlinUtils.calculateSignatureForKotlinMethod(ref.getOperationAfter()));
    }

    private class Pair {
        private final VariableDeclaration first;
        private final VariableDeclaration second;

        Pair(VariableDeclaration first, VariableDeclaration second) {
            this.first = first;
            this.second = second;
        }
    }
}

