/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.segments;

import com.intellij.lang.ant.segments.DeferredActionsQueue;
import com.intellij.lang.ant.segments.DispatchListener;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;

public class DeferredActionsQueueImpl
implements DeferredActionsQueue {
    private static final Logger LOG = Logger.getInstance(DeferredActionsQueueImpl.class);
    private DispatchListener myListener = DispatchListener.DEAF;
    private int myCounter = 0;

    @Override
    public void addLast(Runnable runnable) {
        this.checkIsDispatchThread();
        this.myListener.onStarted();
        try {
            runnable.run();
        }
        finally {
            this.myListener.onFinished();
        }
    }

    private void checkIsDispatchThread() {
        ++this.myCounter;
        if (this.myCounter > 127) {
            this.myCounter = 0;
            LOG.assertTrue(EventQueue.isDispatchThread());
        }
    }

    @Override
    public void setDispactchListener(DispatchListener listener) {
        this.myListener = listener;
    }
}

