/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import java.time.Instant;

public final class LogCatMessage {
    private final LogCatHeader mHeader;
    private final String mMessage;

    public LogCatMessage(LogCatHeader header, String msg) {
        this.mHeader = header;
        this.mMessage = msg;
    }

    public LogCatMessage(Log.LogLevel logLevel, String message2) {
        this(new LogCatHeader(logLevel, -1, -1, "", "", Instant.EPOCH), message2);
    }

    public LogCatHeader getHeader() {
        return this.mHeader;
    }

    public String getMessage() {
        return this.mMessage;
    }

    public Log.LogLevel getLogLevel() {
        return this.mHeader.getLogLevel();
    }

    public int getPid() {
        return this.mHeader.getPid();
    }

    public int getTid() {
        return this.mHeader.getTid();
    }

    public String getAppName() {
        return this.mHeader.getAppName();
    }

    public String getTag() {
        return this.mHeader.getTag();
    }

    public Instant getTimestamp() {
        return this.mHeader.getTimestamp();
    }

    public String toString() {
        return this.mHeader.toString() + ": " + this.mMessage;
    }
}

