/*
 * Decompiled with CFR 0.152.
 */
package com.android.draw9patch.ui;

import com.android.draw9patch.ui.CorruptPatch;
import com.android.draw9patch.ui.Pair;
import com.android.draw9patch.ui.PatchInfo;
import java.awt.AWTEvent;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Area;
import java.awt.geom.Line2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class ImageViewer
extends JComponent {
    private final Color CORRUPTED_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.7f);
    private final Color LOCK_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.7f);
    private final Color STRIPES_COLOR = new Color(1.0f, 0.0f, 0.0f, 0.5f);
    private final Color BACK_COLOR = UIManager.getColor("Panel.background").darker();
    private final Color PATCH_COLOR = new Color(1.0f, 0.37f, 0.99f, 0.5f);
    private final Color PATCH_ONEWAY_COLOR = new Color(0.37f, 1.0f, 0.37f, 0.5f);
    private final Color HIGHLIGHT_REGION_COLOR = new Color(0.5f, 0.5f, 0.5f, 0.5f);
    private final Color FOCUS_COLOR = Color.BLUE;
    private static final float STRIPES_WIDTH = 4.0f;
    private static final double STRIPES_SPACING = 6.0;
    private static final int STRIPES_ANGLE = 45;
    private static final float IDEAL_IMAGE_FRACTION_OF_WINDOW = 0.7f;
    public static final int DEFAULT_ZOOM = 8;
    public static final int MIN_ZOOM = 1;
    public static final int MAX_ZOOM = 16;
    private final AWTEventListener mAwtKeyEventListener;
    private int zoom = 8;
    private boolean showPatches;
    private boolean showLock = false;
    private final TexturePaint texture;
    private final Container container;
    private final StatusBar statusBar;
    private final Dimension size;
    private boolean locked;
    private int lastPositionX;
    private int lastPositionY;
    private boolean showCursor;
    private boolean eraseMode;
    private List<Rectangle> corruptedPatches;
    private boolean showBadPatches;
    private boolean drawingLine;
    private int lineFromX;
    private int lineFromY;
    private int lineToX;
    private int lineToY;
    private boolean showDrawingLine;
    private int focusX = 0;
    private int focusY = 0;
    private final List<Rectangle> hoverHighlightRegions = new ArrayList<Rectangle>();
    private String toolTipText;
    private boolean isEditMode;
    private UpdateRegion editRegion;
    private final Pair<Integer> editSegment = new Pair<Integer>(0, 0);
    private final List<Rectangle> editHighlightRegions = new ArrayList<Rectangle>();
    private Rectangle editPatchRegion = new Rectangle();
    private BufferedImage image;
    private PatchInfo patchInfo;
    private DrawMode currentMode = DrawMode.PATCH;
    private static final int EDGE_DELTA = 1;
    private final Set<PatchUpdateListener> listeners = new HashSet<PatchUpdateListener>();

    ImageViewer(Container container, TexturePaint texture, BufferedImage image, StatusBar statusBar) {
        this.container = container;
        this.texture = texture;
        this.image = image;
        this.statusBar = statusBar;
        this.setLayout(new GridBagLayout());
        this.setOpaque(true);
        this.setFocusable(true);
        this.size = new Dimension(0, 0);
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorRemoved(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
                ImageViewer.this.removeAncestorListener(this);
                ImageViewer.this.setDefaultZoom();
            }

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }
        });
        this.updatePatchInfo();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                ImageViewer.this.updateDrawMode(event);
                int x10 = ImageViewer.this.imageXCoordinate(event.getX());
                int y10 = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.startDrawingLine(x10, y10);
                if (ImageViewer.this.currentMode == DrawMode.PATCH) {
                    ImageViewer.this.startEditingRegion(x10, y10);
                } else {
                    ImageViewer.this.hoverHighlightRegions.clear();
                    ImageViewer.this.setCursor(Cursor.getDefaultCursor());
                    ImageViewer.this.repaint();
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                int x10 = ImageViewer.this.imageXCoordinate(event.getX());
                int y10 = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.endDrawingLine();
                ImageViewer.this.endEditingRegion(x10, y10);
                ImageViewer.this.resetDrawMode();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                int y10;
                int x10 = ImageViewer.this.imageXCoordinate(event.getX());
                if (!ImageViewer.this.checkLockedRegion(x10, y10 = ImageViewer.this.imageYCoordinate(event.getY()))) {
                    ImageViewer.this.moveLine(x10, y10);
                }
                ImageViewer.this.updateEditRegion(x10, y10);
            }

            @Override
            public void mouseMoved(MouseEvent event) {
                int x10 = ImageViewer.this.imageXCoordinate(event.getX());
                int y10 = ImageViewer.this.imageYCoordinate(event.getY());
                ImageViewer.this.checkLockedRegion(x10, y10);
                ImageViewer.this.updateHoverRegion(x10, y10);
                ImageViewer.this.repaint();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e10) {
                ImageViewer.this.hoverHighlightRegions.clear();
                ImageViewer.this.updateSize();
                ImageViewer.this.repaint();
            }
        });
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e10) {
            }

            @Override
            public void keyPressed(KeyEvent e10) {
                int increment;
                int n10 = increment = e10.isControlDown() ? 10 : 1;
                if (e10.getKeyCode() == 39) {
                    ImageViewer.this.focusX = (ImageViewer.this.focusX + increment) % ImageViewer.this.image.getWidth();
                } else if (e10.getKeyCode() == 37) {
                    ImageViewer.this.focusX = Math.max(ImageViewer.this.focusX - increment, 0);
                } else if (e10.getKeyCode() == 40) {
                    ImageViewer.this.focusY = (ImageViewer.this.focusY + increment) % ImageViewer.this.image.getHeight();
                } else if (e10.getKeyCode() == 38) {
                    ImageViewer.this.focusY = Math.max(ImageViewer.this.focusY - increment, 0);
                } else if (e10.getKeyCode() == 32) {
                    int rgb = ImageViewer.this.image.getRGB(ImageViewer.this.focusX, ImageViewer.this.focusY);
                    if (rgb == -16777216) {
                        rgb = -65536;
                    } else if (rgb == -65536) {
                        rgb = 0;
                    } else if (rgb == 0) {
                        rgb = -16777216;
                    }
                    ImageViewer.this.image.setRGB(ImageViewer.this.focusX, ImageViewer.this.focusY, rgb);
                    ImageViewer.this.patchesChanged();
                }
                ImageViewer.this.repaint();
            }

            @Override
            public void keyReleased(KeyEvent e10) {
            }
        });
        this.mAwtKeyEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                ImageViewer.this.enableEraseMode((KeyEvent)event);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.mAwtKeyEventListener, 8L);
    }

    public void setShowBadPatches(boolean en2) {
        this.showBadPatches = en2;
        this.corruptedPatches = en2 ? CorruptPatch.findBadPatches(this.image, this.patchInfo) : null;
        this.repaint();
    }

    private void updateDrawMode(MouseEvent event) {
        this.currentMode = event.isShiftDown() ? DrawMode.ERASE : (event.isControlDown() ? DrawMode.LAYOUT_BOUND : DrawMode.PATCH);
    }

    private void resetDrawMode() {
        this.currentMode = DrawMode.PATCH;
    }

    private UpdateRegionInfo findVerticalPatch(int x10, int y10) {
        UpdateRegion region;
        List<Pair<Integer>> markers;
        if (x10 < this.image.getWidth() / 2) {
            markers = this.patchInfo.verticalPatchMarkers;
            region = UpdateRegion.LEFT_PATCH;
        } else {
            markers = this.patchInfo.verticalPaddingMarkers;
            region = UpdateRegion.RIGHT_PADDING;
        }
        return this.getContainingPatch(markers, y10, region);
    }

    private UpdateRegionInfo findHorizontalPatch(int x10, int y10) {
        UpdateRegion region;
        List<Pair<Integer>> markers;
        if (y10 < this.image.getHeight() / 2) {
            markers = this.patchInfo.horizontalPatchMarkers;
            region = UpdateRegion.TOP_PATCH;
        } else {
            markers = this.patchInfo.horizontalPaddingMarkers;
            region = UpdateRegion.BOTTOM_PADDING;
        }
        return this.getContainingPatch(markers, x10, region);
    }

    private UpdateRegionInfo getContainingPatch(List<Pair<Integer>> patches, int a10, UpdateRegion region) {
        for (Pair<Integer> p10 : patches) {
            if ((Integer)p10.first <= a10 && (Integer)p10.second > a10) {
                return new UpdateRegionInfo(region, p10);
            }
            if ((Integer)p10.first <= a10) continue;
            break;
        }
        return new UpdateRegionInfo(region, null);
    }

    private void updateHoverRegion(int x10, int y10) {
        UpdateRegionInfo vertical = this.findVerticalPatch(x10, y10);
        UpdateRegionInfo horizontal = this.findHorizontalPatch(x10, y10);
        this.computeHoverHighlightRegions(vertical, horizontal);
        this.computeHoverRegionTooltip(vertical, horizontal);
        UpdateRegionInfo updateRegion = this.pickUpdateRegion(x10, y10, vertical, horizontal);
        this.setCursorForRegion(x10, y10, updateRegion);
    }

    private void startEditingRegion(int x10, int y10) {
        this.hoverHighlightRegions.clear();
        this.isEditMode = false;
        this.editRegion = null;
        UpdateRegionInfo vertical = this.findVerticalPatch(x10, y10);
        UpdateRegionInfo horizontal = this.findHorizontalPatch(x10, y10);
        UpdateRegionInfo updateRegion = this.pickUpdateRegion(x10, y10, vertical, horizontal);
        this.setCursorForRegion(x10, y10, updateRegion);
        if (updateRegion != null) {
            this.editRegion = updateRegion.region;
            this.isEditMode = true;
            Edge e10 = null;
            switch (this.editRegion) {
                case LEFT_PATCH: 
                case RIGHT_PADDING: {
                    e10 = this.getClosestEdge(y10, updateRegion.segment);
                    break;
                }
                case TOP_PATCH: 
                case BOTTOM_PADDING: {
                    e10 = this.getClosestEdge(x10, updateRegion.segment);
                    break;
                }
                default: {
                    assert (false) : this.editRegion;
                    break;
                }
            }
            int first = (Integer)updateRegion.segment.first;
            int second = (Integer)updateRegion.segment.second;
            boolean start = e10 == Edge.START;
            this.editSegment.first = start ? second : first;
            this.editSegment.second = start ? first : second;
            this.flushEditPatchData(0);
        } else {
            this.editRegion = this.findNewPatchRegion(x10, y10);
            if (this.editRegion != null) {
                this.isEditMode = true;
                boolean verticalPatch = this.editRegion == UpdateRegion.LEFT_PATCH || this.editRegion == UpdateRegion.RIGHT_PADDING;
                x10 = this.clamp(x10, 1, this.image.getWidth() - 1);
                y10 = this.clamp(y10, 1, this.image.getHeight() - 1);
                this.editSegment.second = verticalPatch ? y10 : x10;
                this.editSegment.first = this.editSegment.second;
            }
        }
        if (this.isEditMode) {
            this.computeEditHighlightRegions();
        }
        this.repaint();
    }

    private void endEditingRegion(int x10, int y10) {
        if (!this.isEditMode) {
            return;
        }
        x10 = this.clamp(x10, 1, this.image.getWidth() - 1);
        y10 = this.clamp(y10, 1, this.image.getHeight() - 1);
        switch (this.editRegion) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                this.editSegment.second = y10;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                this.editSegment.second = x10;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        this.flushEditPatchData(-16777216);
        this.hoverHighlightRegions.clear();
        this.setCursor(Cursor.getDefaultCursor());
        this.patchesChanged();
        this.repaint();
        this.isEditMode = false;
        this.editRegion = null;
    }

    private void updateEditRegion(int x10, int y10) {
        if (!this.isEditMode) {
            return;
        }
        x10 = this.clamp(x10, 1, this.image.getWidth() - 1);
        y10 = this.clamp(y10, 1, this.image.getHeight() - 1);
        switch (this.editRegion) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                this.editSegment.second = y10;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                this.editSegment.second = x10;
            }
        }
        this.computeEditHighlightRegions();
        this.repaint();
    }

    private int clamp(int i10, int min, int max) {
        if (i10 < min) {
            return min;
        }
        if (i10 > max) {
            return max;
        }
        return i10;
    }

    private UpdateRegion findNewPatchRegion(int x10, int y10) {
        boolean horizontalPatch;
        boolean verticalPatch = y10 >= 0 && y10 <= this.image.getHeight();
        boolean bl2 = horizontalPatch = x10 >= 0 && x10 <= this.image.getWidth();
        if (verticalPatch) {
            if (x10 < 0) {
                return UpdateRegion.LEFT_PATCH;
            }
            if (x10 > this.image.getWidth()) {
                return UpdateRegion.RIGHT_PADDING;
            }
        }
        if (horizontalPatch) {
            if (y10 < 0) {
                return UpdateRegion.TOP_PATCH;
            }
            if (y10 > this.image.getHeight()) {
                return UpdateRegion.BOTTOM_PADDING;
            }
        }
        return null;
    }

    private void computeHoverHighlightRegions(UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        this.hoverHighlightRegions.clear();
        if (vertical != null && vertical.segment != null) {
            this.hoverHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, (Integer)vertical.segment.first, this.image.getWidth(), (Integer)vertical.segment.second - (Integer)vertical.segment.first));
        }
        if (horizontal != null && horizontal.segment != null) {
            this.hoverHighlightRegions.addAll(this.getVerticalHighlightRegions((Integer)horizontal.segment.first, 0, (Integer)horizontal.segment.second - (Integer)horizontal.segment.first, this.image.getHeight()));
        }
    }

    private void computeHoverRegionTooltip(UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        StringBuilder sb2 = new StringBuilder(50);
        if (vertical != null && vertical.segment != null) {
            if (vertical.region == UpdateRegion.LEFT_PATCH) {
                sb2.append("Vertical Patch: ");
            } else {
                sb2.append("Vertical Padding: ");
            }
            sb2.append(String.format("%d - %d px", vertical.segment.first, vertical.segment.second));
        }
        if (horizontal != null && horizontal.segment != null) {
            if (sb2.length() > 0) {
                sb2.append(", ");
            }
            if (horizontal.region == UpdateRegion.TOP_PATCH) {
                sb2.append("Horizontal Patch: ");
            } else {
                sb2.append("Horizontal Padding: ");
            }
            sb2.append(String.format("%d - %d px", horizontal.segment.first, horizontal.segment.second));
        }
        this.toolTipText = sb2.length() > 0 ? sb2.toString() : null;
    }

    private void computeEditHighlightRegions() {
        this.editHighlightRegions.clear();
        int f10 = (Integer)this.editSegment.first;
        int s10 = (Integer)this.editSegment.second;
        int min = Math.min(f10, s10);
        int diff = Math.abs(f10 - s10);
        int imageWidth = this.image.getWidth();
        int imageHeight = this.image.getHeight();
        switch (this.editRegion) {
            case LEFT_PATCH: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(0, min, 1, diff));
                this.editHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, min, imageWidth, diff));
                break;
            }
            case RIGHT_PADDING: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(imageWidth - 1, min, 1, diff));
                this.editHighlightRegions.addAll(this.getHorizontalHighlightRegions(0, min, imageWidth, diff));
                break;
            }
            case TOP_PATCH: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(min, 0, diff, 1));
                this.editHighlightRegions.addAll(this.getVerticalHighlightRegions(min, 0, diff, imageHeight));
                break;
            }
            case BOTTOM_PADDING: {
                this.editPatchRegion = this.displayCoordinates(new Rectangle(min, imageHeight - 1, diff, 1));
                this.editHighlightRegions.addAll(this.getVerticalHighlightRegions(min, 0, diff, imageHeight));
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
    }

    private List<Rectangle> getHorizontalHighlightRegions(int x10, int y10, int w10, int h10) {
        ArrayList<Rectangle> l10 = new ArrayList<Rectangle>(3);
        Rectangle r10 = this.displayCoordinates(new Rectangle(x10, y10, w10, h10));
        l10.add(r10);
        l10.add(new Rectangle(0, r10.y, this.getWidth(), 1));
        l10.add(new Rectangle(0, r10.y + r10.height, this.getWidth(), 1));
        return l10;
    }

    private List<Rectangle> getVerticalHighlightRegions(int x10, int y10, int w10, int h10) {
        ArrayList<Rectangle> l10 = new ArrayList<Rectangle>(3);
        Rectangle r10 = this.displayCoordinates(new Rectangle(x10, y10, w10, h10));
        l10.add(r10);
        l10.add(new Rectangle(r10.x, 0, 1, this.getHeight()));
        l10.add(new Rectangle(r10.x + r10.width, 0, 1, this.getHeight()));
        return l10;
    }

    private void setCursorForRegion(int x10, int y10, UpdateRegionInfo region) {
        if (region != null) {
            Cursor c10 = this.getCursor(x10, y10, region);
            this.setCursor(c10);
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private Cursor getCursor(int x10, int y10, UpdateRegionInfo editRegion) {
        int cursor = 0;
        switch (editRegion.region) {
            case LEFT_PATCH: 
            case RIGHT_PADDING: {
                Edge e10 = this.getClosestEdge(y10, editRegion.segment);
                cursor = e10 == Edge.START ? 8 : 9;
                break;
            }
            case TOP_PATCH: 
            case BOTTOM_PADDING: {
                Edge e11 = this.getClosestEdge(x10, editRegion.segment);
                cursor = e11 == Edge.START ? 10 : 11;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        return Cursor.getPredefinedCursor(cursor);
    }

    private UpdateRegionInfo pickUpdateRegion(int x10, int y10, UpdateRegionInfo vertical, UpdateRegionInfo horizontal) {
        Edge e10;
        if (vertical != null && vertical.segment != null && (e10 = this.getClosestEdge(y10, vertical.segment)) != Edge.NONE) {
            return vertical;
        }
        if (horizontal != null && horizontal.segment != null && (e10 = this.getClosestEdge(x10, horizontal.segment)) != Edge.NONE) {
            return horizontal;
        }
        return null;
    }

    private Edge getClosestEdge(int x10, Pair<Integer> range) {
        if (Math.abs(x10 - (Integer)range.first) <= 1) {
            return Edge.START;
        }
        if (Math.abs((Integer)range.second - x10) <= 1) {
            return Edge.END;
        }
        return Edge.NONE;
    }

    private int imageYCoordinate(int y10) {
        int top = (this.getHeight() - this.size.height) / 2;
        return (y10 - top) / this.zoom;
    }

    private int imageXCoordinate(int x10) {
        int left = (this.getWidth() - this.size.width) / 2;
        return (x10 - left) / this.zoom;
    }

    private Point getImageOrigin() {
        int left = (this.getWidth() - this.size.width) / 2;
        int top = (this.getHeight() - this.size.height) / 2;
        return new Point(left, top);
    }

    private Rectangle displayCoordinates(Rectangle r10) {
        Point imageOrigin = this.getImageOrigin();
        int x10 = r10.x * this.zoom + imageOrigin.x;
        int y10 = r10.y * this.zoom + imageOrigin.y;
        int w10 = r10.width * this.zoom;
        int h10 = r10.height * this.zoom;
        return new Rectangle(x10, y10, w10, h10);
    }

    private void updatePatchInfo() {
        this.patchInfo = new PatchInfo(this.image);
    }

    private void enableEraseMode(KeyEvent event) {
        this.eraseMode = event.isShiftDown();
    }

    private void startDrawingLine(int x10, int y10) {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        if ((x10 == 0 || x10 == width - 1) && y10 > 0 && y10 < height - 1 || x10 > 0 && x10 < width - 1 && (y10 == 0 || y10 == height - 1)) {
            this.drawingLine = true;
            this.lineFromX = x10;
            this.lineFromY = y10;
            this.lineToX = x10;
            this.lineToY = y10;
            this.showDrawingLine = true;
            this.showCursor = false;
            this.repaint();
        }
    }

    private void moveLine(int x10, int y10) {
        if (!this.drawingLine) {
            return;
        }
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        this.showDrawingLine = false;
        if (x10 == this.lineFromX && y10 > 0 && y10 < height - 1 || x10 > 0 && x10 < width - 1 && y10 == this.lineFromY) {
            this.lineToX = x10;
            this.lineToY = y10;
            this.showDrawingLine = true;
        }
        this.repaint();
    }

    private void endDrawingLine() {
        int color;
        if (!this.drawingLine) {
            return;
        }
        this.drawingLine = false;
        if (!this.showDrawingLine) {
            return;
        }
        switch (this.currentMode) {
            case PATCH: {
                color = -16777216;
                break;
            }
            case LAYOUT_BOUND: {
                color = -65536;
                break;
            }
            case ERASE: {
                color = 0;
                break;
            }
            default: {
                return;
            }
        }
        this.setPatchData(color, this.lineFromX, this.lineFromY, this.lineToX, this.lineToY, true);
        this.patchesChanged();
        this.repaint();
    }

    private void setPatchData(int color, int x12, int y12, int x22, int y22, boolean inclusive) {
        int x10 = x12;
        int y10 = y12;
        int dx2 = 0;
        int dy2 = 0;
        if (x22 != x12) {
            dx2 = x22 > x12 ? 1 : -1;
        } else if (y22 != y12) {
            int n10 = dy2 = y22 > y12 ? 1 : -1;
        }
        while (x10 != x22 || y10 != y22) {
            this.image.setRGB(x10, y10, color);
            x10 += dx2;
            y10 += dy2;
        }
        if (inclusive) {
            this.image.setRGB(x10, y10, color);
        }
    }

    private void flushEditPatchData(int color) {
        int y22 = 0;
        int y12 = 0;
        int x22 = 0;
        int x12 = 0;
        int min = Math.min((Integer)this.editSegment.first, (Integer)this.editSegment.second);
        int max = Math.max((Integer)this.editSegment.first, (Integer)this.editSegment.second);
        switch (this.editRegion) {
            case LEFT_PATCH: {
                x22 = 0;
                x12 = 0;
                y12 = min;
                y22 = max;
                break;
            }
            case RIGHT_PADDING: {
                x12 = x22 = this.image.getWidth() - 1;
                y12 = min;
                y22 = max;
                break;
            }
            case TOP_PATCH: {
                x12 = min;
                x22 = max;
                y22 = 0;
                y12 = 0;
                break;
            }
            case BOTTOM_PADDING: {
                x12 = min;
                x22 = max;
                y12 = y22 = this.image.getHeight() - 1;
                break;
            }
            default: {
                assert (false) : this.editRegion;
                break;
            }
        }
        this.setPatchData(color, x12, y12, x22, y22, false);
    }

    private void patchesChanged() {
        this.updatePatchInfo();
        this.notifyPatchesUpdated();
        if (this.showBadPatches) {
            this.corruptedPatches = CorruptPatch.findBadPatches(this.image, this.patchInfo);
        }
    }

    private boolean checkLockedRegion(int x10, int y10) {
        int oldX = this.lastPositionX;
        int oldY = this.lastPositionY;
        this.lastPositionX = x10;
        this.lastPositionY = y10;
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        this.statusBar.setPointerLocation(Math.max(0, Math.min(x10, width - 1)), Math.max(0, Math.min(y10, height - 1)));
        boolean previousLock = this.locked;
        this.locked = x10 > 0 && x10 < width - 1 && y10 > 0 && y10 < height - 1;
        boolean previousCursor = this.showCursor;
        boolean bl2 = this.showCursor = !this.drawingLine && ((x10 == 0 || x10 == width - 1) && y10 > 0 && y10 < height - 1 || x10 > 0 && x10 < width - 1 && (y10 == 0 || y10 == height - 1));
        if (this.locked != previousLock) {
            this.repaint();
        } else if (this.showCursor || this.showCursor != previousCursor) {
            Rectangle clip = new Rectangle(this.lastPositionX - 1 - this.zoom / 2, this.lastPositionY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2);
            clip = clip.union(new Rectangle(oldX - 1 - this.zoom / 2, oldY - 1 - this.zoom / 2, this.zoom + 2, this.zoom + 2));
            this.repaint(clip);
        }
        return this.locked;
    }

    @Override
    protected void paintComponent(Graphics g10) {
        int x10 = (this.getWidth() - this.size.width) / 2;
        int y10 = (this.getHeight() - this.size.height) / 2;
        Graphics2D g22 = (Graphics2D)g10.create();
        g22.setColor(this.BACK_COLOR);
        g22.fillRect(0, 0, this.getWidth(), this.getHeight());
        g22.translate(x10, y10);
        g22.setPaint(this.texture);
        g22.fillRect(0, 0, this.size.width, this.size.height);
        g22.scale(this.zoom, this.zoom);
        g22.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g22.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g22.drawImage((Image)this.image, 0, 0, null);
        if (this.isFocusOwner()) {
            g22.setColor(this.FOCUS_COLOR);
            g22.drawRect(this.focusX, this.focusY, 1, 1);
        }
        if (this.showPatches) {
            g22.setColor(this.PATCH_COLOR);
            for (Rectangle patch : this.patchInfo.patches) {
                g22.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
            g22.setColor(this.PATCH_ONEWAY_COLOR);
            for (Rectangle patch : this.patchInfo.horizontalPatches) {
                g22.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
            for (Rectangle patch : this.patchInfo.verticalPatches) {
                g22.fillRect(patch.x, patch.y, patch.width, patch.height);
            }
        }
        if (this.corruptedPatches != null) {
            g22.setColor(this.CORRUPTED_COLOR);
            g22.setStroke(new BasicStroke(3.0f / (float)this.zoom));
            for (Rectangle patch : this.corruptedPatches) {
                g22.draw(new RoundRectangle2D.Float((float)patch.x - 2.0f / (float)this.zoom, (float)patch.y - 2.0f / (float)this.zoom, (float)patch.width + 2.0f / (float)this.zoom, (float)patch.height + 2.0f / (float)this.zoom, 6.0f / (float)this.zoom, 6.0f / (float)this.zoom));
            }
        }
        if (this.showLock && this.locked) {
            int width = this.image.getWidth();
            int height = this.image.getHeight();
            g22.setColor(this.LOCK_COLOR);
            g22.fillRect(1, 1, width - 2, height - 2);
            g22.setColor(this.STRIPES_COLOR);
            g22.translate(1, 1);
            this.paintStripes(g22, width - 2, height - 2);
            g22.translate(-1, -1);
        }
        g22.dispose();
        if (this.drawingLine && this.showDrawingLine) {
            Graphics cursor = g10.create();
            cursor.setXORMode(Color.WHITE);
            cursor.setColor(Color.BLACK);
            x10 = Math.min(this.lineFromX, this.lineToX);
            y10 = Math.min(this.lineFromY, this.lineToY);
            int w10 = Math.abs(this.lineFromX - this.lineToX) + 1;
            int h10 = Math.abs(this.lineFromY - this.lineToY) + 1;
            x10 *= this.zoom;
            y10 *= this.zoom;
            int left = (this.getWidth() - this.size.width) / 2;
            int top = (this.getHeight() - this.size.height) / 2;
            cursor.drawRect(x10 += left, y10 += top, w10 *= this.zoom, h10 *= this.zoom);
            cursor.dispose();
        }
        if (this.showCursor) {
            Graphics cursor = g10.create();
            cursor.setXORMode(Color.WHITE);
            cursor.setColor(Color.BLACK);
            cursor.drawRect(this.lastPositionX - this.zoom / 2, this.lastPositionY - this.zoom / 2, this.zoom, this.zoom);
            cursor.dispose();
        }
        g22 = (Graphics2D)g10.create();
        g22.setColor(this.HIGHLIGHT_REGION_COLOR);
        for (Rectangle r10 : this.hoverHighlightRegions) {
            g22.fillRect(r10.x, r10.y, r10.width, r10.height);
        }
        if (!this.hoverHighlightRegions.isEmpty()) {
            this.setToolTipText(this.toolTipText);
        } else {
            this.setToolTipText(null);
        }
        if (this.isEditMode && this.editRegion != null) {
            g22.setColor(this.HIGHLIGHT_REGION_COLOR);
            for (Rectangle r11 : this.editHighlightRegions) {
                g22.fillRect(r11.x, r11.y, r11.width, r11.height);
            }
            g22.setColor(Color.BLACK);
            g22.fillRect(this.editPatchRegion.x, this.editPatchRegion.y, this.editPatchRegion.width, this.editPatchRegion.height);
        }
        g22.dispose();
    }

    private void paintStripes(Graphics2D g10, int width, int height) {
        Shape oldClip = g10.getClip();
        Area area = new Area(new Rectangle(0, 0, width, height));
        if (oldClip != null) {
            area = new Area(oldClip);
        }
        area.intersect(new Area(new Rectangle(0, 0, width, height)));
        g10.setClip(area);
        g10.setStroke(new BasicStroke(4.0f));
        double hypLength = Math.sqrt(width * width + height * height);
        double radians = Math.toRadians(45.0);
        g10.rotate(radians);
        double spacing = 6.0;
        int numLines = (int)(hypLength / (spacing += 4.0));
        for (int i10 = 0; i10 < numLines; ++i10) {
            double x10 = (double)i10 * spacing;
            Line2D.Double line = new Line2D.Double(x10, -hypLength, x10, hypLength);
            g10.draw(line);
        }
        g10.setClip(oldClip);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.size;
    }

    private void setDefaultZoom() {
        int frameWidth = this.getWidth();
        int frameHeight = this.getHeight();
        int z10 = 8;
        if (frameWidth > 0 && frameHeight > 0) {
            float w10 = (float)this.image.getWidth() / (float)frameWidth;
            float h10 = (float)this.image.getHeight() / (float)frameHeight;
            float current = Math.max(w10, h10);
            float ideal = 0.7f;
            z10 = this.clamp(Math.round(ideal / current), 1, 16);
        }
        this.setZoom(z10);
    }

    void setZoom(int value) {
        this.zoom = value;
        this.updateSize();
        if (!this.size.equals(this.getSize())) {
            this.setSize(this.size);
            this.container.validate();
            this.repaint();
        }
    }

    int getZoom() {
        return this.zoom;
    }

    private void updateSize() {
        int width = this.image.getWidth();
        int height = this.image.getHeight();
        if (this.size.height == 0 || this.getHeight() - this.size.height == 0) {
            this.size.setSize(width * this.zoom, height * this.zoom);
        } else {
            this.size.setSize(width * this.zoom, height * this.zoom);
        }
    }

    void setPatchesVisible(boolean visible) {
        this.showPatches = visible;
        this.updatePatchInfo();
        this.repaint();
    }

    void setLockVisible(boolean visible) {
        this.showLock = visible;
        this.repaint();
    }

    public void setImage(BufferedImage image) {
        this.image = image;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public PatchInfo getPatchInfo() {
        return this.patchInfo;
    }

    public void addPatchUpdateListener(PatchUpdateListener p10) {
        this.listeners.add(p10);
    }

    public void removePatchUpdateListener(PatchUpdateListener p10) {
        this.listeners.remove(p10);
    }

    private void notifyPatchesUpdated() {
        for (PatchUpdateListener p10 : this.listeners) {
            p10.patchesUpdated();
        }
    }

    public void dispose() {
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.mAwtKeyEventListener);
    }

    public static interface PatchUpdateListener {
        public void patchesUpdated();
    }

    public static interface StatusBar {
        public void setPointerLocation(int var1, int var2);
    }

    private static enum Edge {
        START,
        END,
        NONE;

    }

    private static class UpdateRegionInfo {
        public final UpdateRegion region;
        public final Pair<Integer> segment;

        private UpdateRegionInfo(UpdateRegion region, Pair<Integer> segment) {
            this.region = region;
            this.segment = segment;
        }
    }

    private static enum UpdateRegion {
        LEFT_PATCH,
        TOP_PATCH,
        RIGHT_PADDING,
        BOTTOM_PADDING;

    }

    private static enum DrawMode {
        PATCH,
        LAYOUT_BOUND,
        ERASE;

    }
}

