/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutinspector.model;

import com.android.layoutinspector.model.DisplayInfo;
import com.android.layoutinspector.model.ViewProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\t\b\u0086\b\u0018\u0000 Q2\u00020\u0001:\u0002QRB!\b\u0000\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u000e\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u0019J\u0010\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000109H\u0016J\u000b\u0010:\u001a\u0004\u0018\u00010\u0000H\u00c2\u0003J\t\u0010;\u001a\u00020\u0004H\u00c6\u0003J\t\u0010<\u001a\u00020\u0004H\u00c6\u0003J)\u0010=\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010>\u001a\u00020)2\b\u0010?\u001a\u0004\u0018\u00010@H\u00d6\u0003J\b\u0010A\u001a\u00020)H\u0016J\u0010\u0010B\u001a\u00020\u00002\u0006\u0010C\u001a\u00020#H\u0016J\b\u0010D\u001a\u00020#H\u0016J\u0010\u0010$\u001a\u00020#2\u0006\u0010E\u001a\u00020\u0001H\u0016J\u0010\u0010F\u001a\u00020\u00042\u0006\u00108\u001a\u00020\u0019H\u0002J\n\u0010G\u001a\u0004\u0018\u00010\u0000H\u0016J)\u0010H\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0003\u001a\u00020\u00042\u0012\u0010I\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040J\"\u00020\u0004\u00a2\u0006\u0002\u0010KJ\t\u0010L\u001a\u00020#H\u00d6\u0001J\b\u0010M\u001a\u00020)H\u0016J\b\u0010N\u001a\u00020\u0004H\u0016J\u0006\u0010O\u001a\u000207J\u000e\u0010O\u001a\u0002072\u0006\u0010P\u001a\u00020)R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R#\u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\b0\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u001c\u0010\u001e\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u001d\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001e\u0010*\u001a\u00020)2\u0006\u0010(\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u001e\u0010,\u001a\u00020)2\u0006\u0010(\u001a\u00020)@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010+R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010\u001dR\u001d\u0010.\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u0010\u001bR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00100\u001a\u000201\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0017\u00104\u001a\b\u0012\u0004\u0012\u00020\u00190\b\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u0010\n\u00a8\u0006S"}, d2={"Lcom/android/layoutinspector/model/ViewNode;", "Ljavax/swing/tree/TreeNode;", "parent", "name", "", "hash", "(Lcom/android/layoutinspector/model/ViewNode;Ljava/lang/String;Ljava/lang/String;)V", "children", "", "getChildren", "()Ljava/util/List;", "displayInfo", "Lcom/android/layoutinspector/model/DisplayInfo;", "getDisplayInfo", "()Lcom/android/layoutinspector/model/DisplayInfo;", "setDisplayInfo", "(Lcom/android/layoutinspector/model/DisplayInfo;)V", "forcedState", "Lcom/android/layoutinspector/model/ViewNode$ForcedState;", "getForcedState", "()Lcom/android/layoutinspector/model/ViewNode$ForcedState;", "setForcedState", "(Lcom/android/layoutinspector/model/ViewNode$ForcedState;)V", "groupedProperties", "", "Lcom/android/layoutinspector/model/ViewProperty;", "getGroupedProperties", "()Ljava/util/Map;", "getHash", "()Ljava/lang/String;", "id", "getId", "setId", "(Ljava/lang/String;)V", "index", "", "getIndex", "()I", "setIndex", "(I)V", "<set-?>", "", "isDrawn", "()Z", "isParentVisible", "getName", "namedProperties", "getNamedProperties", "previewBox", "Ljava/awt/Rectangle;", "getPreviewBox", "()Ljava/awt/Rectangle;", "properties", "getProperties", "addPropertyToGroup", "", "property", "Ljava/util/Enumeration;", "component1", "component2", "component3", "copy", "equals", "other", "", "getAllowsChildren", "getChildAt", "childIndex", "getChildCount", "node", "getKey", "getParent", "getProperty", "altNames", "", "(Ljava/lang/String;[Ljava/lang/String;)Lcom/android/layoutinspector/model/ViewProperty;", "hashCode", "isLeaf", "toString", "updateNodeDrawn", "parentVisible", "Companion", "ForcedState", "android.sdktools.layoutinspector"})
public final class ViewNode
implements TreeNode {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ViewNode parent;
    @NotNull
    private final String name;
    @NotNull
    private final String hash;
    @NotNull
    private final Map<String, List<ViewProperty>> groupedProperties;
    @NotNull
    private final Map<String, ViewProperty> namedProperties;
    @NotNull
    private final List<ViewProperty> properties;
    @NotNull
    private final List<ViewNode> children;
    @NotNull
    private final Rectangle previewBox;
    private int index;
    @Nullable
    private String id;
    public DisplayInfo displayInfo;
    private boolean isParentVisible;
    private boolean isDrawn;
    @NotNull
    private ForcedState forcedState;

    public ViewNode(@Nullable ViewNode parent, @NotNull String name, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        this.parent = parent;
        this.name = name;
        this.hash = hash;
        Cloneable cloneable = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)cloneable, (String)"newHashMap()");
        this.groupedProperties = cloneable;
        cloneable = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)cloneable, (String)"newHashMap()");
        this.namedProperties = cloneable;
        cloneable = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)cloneable, (String)"newArrayList()");
        this.properties = (List)((Object)cloneable);
        cloneable = Lists.newArrayList();
        Intrinsics.checkExpressionValueIsNotNull((Object)cloneable, (String)"newArrayList()");
        this.children = (List)((Object)cloneable);
        this.previewBox = new Rectangle();
        this.forcedState = ForcedState.NONE;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final String getHash() {
        return this.hash;
    }

    @NotNull
    public final Map<String, List<ViewProperty>> getGroupedProperties() {
        return this.groupedProperties;
    }

    @NotNull
    public final Map<String, ViewProperty> getNamedProperties() {
        return this.namedProperties;
    }

    @NotNull
    public final List<ViewProperty> getProperties() {
        return this.properties;
    }

    @NotNull
    public final List<ViewNode> getChildren() {
        return this.children;
    }

    @NotNull
    public final Rectangle getPreviewBox() {
        return this.previewBox;
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n10) {
        this.index = n10;
    }

    @Nullable
    public final String getId() {
        return this.id;
    }

    public final void setId(@Nullable String string) {
        this.id = string;
    }

    @NotNull
    public final DisplayInfo getDisplayInfo() {
        DisplayInfo displayInfo = this.displayInfo;
        if (displayInfo != null) {
            return displayInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"displayInfo");
        return null;
    }

    public final void setDisplayInfo(@NotNull DisplayInfo displayInfo) {
        Intrinsics.checkParameterIsNotNull((Object)displayInfo, (String)"<set-?>");
        this.displayInfo = displayInfo;
    }

    public final boolean isParentVisible() {
        return this.isParentVisible;
    }

    public final boolean isDrawn() {
        return this.isDrawn;
    }

    @NotNull
    public final ForcedState getForcedState() {
        return this.forcedState;
    }

    public final void setForcedState(@NotNull ForcedState forcedState) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)forcedState), (String)"<set-?>");
        this.forcedState = forcedState;
    }

    public final void addPropertyToGroup(@NotNull ViewProperty property) {
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        String key = this.getKey(property);
        List propertiesList = this.groupedProperties.getOrDefault(key, new LinkedList());
        propertiesList.add(property);
        Map<String, List<ViewProperty>> map = this.groupedProperties;
        boolean bl2 = false;
        map.put(key, propertiesList);
    }

    private final String getKey(ViewProperty property) {
        String string = property.getCategory();
        return string == null ? (StringsKt.endsWith$default((String)property.getFullName(), (String)"()", (boolean)false, (int)2, null) ? "methods" : "properties") : string;
    }

    @Nullable
    public final ViewProperty getProperty(@NotNull String name, String ... altNames) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)altNames, (String)"altNames");
        ViewProperty property = this.namedProperties.get(name);
        int i10 = 0;
        while (property == null && i10 < altNames.length) {
            property = this.namedProperties.get(altNames[i10]);
            int n10 = i10;
            i10 = n10 + 1;
        }
        return property;
    }

    public final void updateNodeDrawn() {
        this.updateNodeDrawn(this.isParentVisible);
    }

    public final void updateNodeDrawn(boolean parentVisible) {
        boolean parentVisible2;
        this.isParentVisible = parentVisible2 = parentVisible;
        if (this.forcedState == ForcedState.NONE) {
            this.isDrawn = !this.getDisplayInfo().getWillNotDraw() && parentVisible2 && this.getDisplayInfo().isVisible();
            parentVisible2 &= this.getDisplayInfo().isVisible();
        } else {
            parentVisible2 = this.isDrawn = this.forcedState == ForcedState.VISIBLE && parentVisible2;
        }
        for (ViewNode child : this.children) {
            child.updateNodeDrawn(parentVisible2);
            this.isDrawn |= child.isDrawn && child.getDisplayInfo().isVisible();
        }
    }

    @NotNull
    public String toString() {
        return this.name + '@' + this.hash;
    }

    @Override
    @NotNull
    public ViewNode getChildAt(int childIndex) {
        return this.children.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.children.size();
    }

    @Override
    @Nullable
    public ViewNode getParent() {
        return this.parent;
    }

    @Override
    public int getIndex(@NotNull TreeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        return this.children.indexOf((ViewNode)node);
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    @Override
    @NotNull
    public Enumeration<? extends TreeNode> children() {
        Enumeration enumeration = Collections.enumeration((Collection)this.children);
        Intrinsics.checkExpressionValueIsNotNull(enumeration, (String)"enumeration(children)");
        return enumeration;
    }

    private final ViewNode component1() {
        return this.parent;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final String component3() {
        return this.hash;
    }

    @NotNull
    public final ViewNode copy(@Nullable ViewNode parent, @NotNull String name, @NotNull String hash) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)hash, (String)"hash");
        return new ViewNode(parent, name, hash);
    }

    public static /* synthetic */ ViewNode copy$default(ViewNode viewNode, ViewNode viewNode2, String string, String string2, int n10, Object object) {
        if ((n10 & 1) != 0) {
            viewNode2 = viewNode.parent;
        }
        if ((n10 & 2) != 0) {
            string = viewNode.name;
        }
        if ((n10 & 4) != 0) {
            string2 = viewNode.hash;
        }
        return viewNode.copy(viewNode2, string, string2);
    }

    public int hashCode() {
        int result2 = this.parent == null ? 0 : this.parent.hashCode();
        result2 = result2 * 31 + this.name.hashCode();
        result2 = result2 * 31 + this.hash.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ViewNode)) {
            return false;
        }
        ViewNode viewNode = (ViewNode)other;
        if (!Intrinsics.areEqual((Object)this.parent, (Object)viewNode.parent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)viewNode.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.hash, (Object)viewNode.hash);
    }

    @JvmStatic
    @NotNull
    public static final TreePath getPath(@NotNull ViewNode node) {
        return Companion.getPath(node);
    }

    @JvmStatic
    @NotNull
    public static final TreePath getPathFromParent(@NotNull ViewNode node, @NotNull ViewNode root) {
        return Companion.getPathFromParent(node, root);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/layoutinspector/model/ViewNode$ForcedState;", "", "(Ljava/lang/String;I)V", "NONE", "VISIBLE", "INVISIBLE", "android.sdktools.layoutinspector"})
    public static final class ForcedState
    extends Enum<ForcedState> {
        public static final /* enum */ ForcedState NONE = new ForcedState();
        public static final /* enum */ ForcedState VISIBLE = new ForcedState();
        public static final /* enum */ ForcedState INVISIBLE = new ForcedState();
        private static final /* synthetic */ ForcedState[] $VALUES;

        public static ForcedState[] values() {
            return (ForcedState[])$VALUES.clone();
        }

        public static ForcedState valueOf(String value) {
            return Enum.valueOf(ForcedState.class, value);
        }

        static {
            $VALUES = forcedStateArray = new ForcedState[]{ForcedState.NONE, ForcedState.VISIBLE, ForcedState.INVISIBLE};
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0018\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0007J\u001a\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\b\u001a\u0004\u0018\u00010\u0006H\u0002\u00a8\u0006\n"}, d2={"Lcom/android/layoutinspector/model/ViewNode$Companion;", "", "()V", "getPath", "Ljavax/swing/tree/TreePath;", "node", "Lcom/android/layoutinspector/model/ViewNode;", "getPathFromParent", "root", "getPathImpl", "android.sdktools.layoutinspector"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final TreePath getPath(@NotNull ViewNode node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            return this.getPathImpl(node, null);
        }

        @JvmStatic
        @NotNull
        public final TreePath getPathFromParent(@NotNull ViewNode node, @NotNull ViewNode root) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
            return this.getPathImpl(node, root);
        }

        private final TreePath getPathImpl(ViewNode node, ViewNode root) {
            ViewNode node2 = node;
            ArrayList nodes = Lists.newArrayList();
            do {
                nodes.add(0, node2);
                ViewNode viewNode = node2;
                ViewNode viewNode2 = node2 = viewNode == null ? null : viewNode.parent;
            } while (node2 != null && node2 != root);
            if (root != null && node2 == root) {
                nodes.add(0, root);
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)nodes, (String)"nodes");
            Collection $this$toTypedArray$iv = nodes;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
            if (objectArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            return new TreePath(objectArray);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

