/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

public abstract class SigUtils {
    public static String getSimpleName(String fqn) {
        return fqn.substring(fqn.lastIndexOf(46) + 1);
    }

    public static String methodName(final String className, final String methodName, String signature) {
        try {
            return new SigReader(signature){

                @Override
                String getMethodName() {
                    return methodName;
                }

                @Override
                String getClassName() {
                    return className;
                }
            }.getSignature();
        }
        catch (Exception ignored) {
            return className + "." + methodName;
        }
    }

    public static String signatureToName(String s10) {
        return new SigReader(s10).getSignature();
    }

    public static String typeToSignature(String fqcn) {
        StringBuilder sb2 = new StringBuilder(fqcn.length() + 2);
        while (fqcn.endsWith("[]")) {
            fqcn = fqcn.substring(0, fqcn.length() - "[]".length());
            sb2.append('[');
        }
        if ("boolean".equals(fqcn)) {
            sb2.append('Z');
        } else if ("byte".equals(fqcn)) {
            sb2.append('B');
        } else if ("char".equals(fqcn)) {
            sb2.append('C');
        } else if ("short".equals(fqcn)) {
            sb2.append('S');
        } else if ("int".equals(fqcn)) {
            sb2.append('I');
        } else if ("long".equals(fqcn)) {
            sb2.append('J');
        } else if ("float".equals(fqcn)) {
            sb2.append('F');
        } else if ("double".equals(fqcn)) {
            sb2.append('D');
        } else if ("void".equals(fqcn)) {
            sb2.append('V');
        } else {
            sb2.append('L');
            sb2.append(fqcn.replace('.', '/'));
            sb2.append(';');
        }
        return sb2.toString();
    }

    private static class SigReader {
        final String buffer;
        int pos = 0;

        SigReader(String s10) {
            this.buffer = s10;
        }

        int get() {
            return this.buffer.charAt(this.pos++);
        }

        int peek() {
            return this.buffer.charAt(this.pos);
        }

        boolean eof() {
            return this.buffer.length() <= this.pos;
        }

        String getSignature() {
            if (this.eof()) {
                return "";
            }
            switch (this.get()) {
                case 90: {
                    return "boolean";
                }
                case 66: {
                    return "byte";
                }
                case 67: {
                    return "char";
                }
                case 83: {
                    return "short";
                }
                case 73: {
                    return "int";
                }
                case 74: {
                    return "long";
                }
                case 70: {
                    return "float";
                }
                case 68: {
                    return "double";
                }
                case 86: {
                    return "void";
                }
                case 76: {
                    int start = this.pos;
                    this.pos = this.buffer.indexOf(59, start) + 1;
                    return this.buffer.substring(start, this.pos - 1).replace('/', '.');
                }
                case 91: {
                    return this.getSignature() + "[]";
                }
                case 40: {
                    StringBuilder result2 = new StringBuilder("(");
                    String separator = "";
                    while (this.peek() != 41) {
                        result2.append(separator);
                        result2.append(this.getSignature());
                        separator = ", ";
                    }
                    this.get();
                    result2.append(")");
                    return this.getSignature() + " " + this.getClassName() + "." + this.getMethodName() + " " + result2;
                }
            }
            return null;
        }

        String getMethodName() {
            return "";
        }

        String getClassName() {
            return "";
        }
    }
}

