/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantLock;

class AdbInstallerChannel
implements AutoCloseable {
    private final SocketChannel channel;
    private final Selector readSelector;
    private final SelectionKey readKey;
    private final Selector writeSelector;
    private final SelectionKey writeKey;
    private final ReentrantLock lock = new ReentrantLock(true);

    AdbInstallerChannel(SocketChannel c10) throws IOException {
        this.channel = c10;
        this.channel.configureBlocking(false);
        this.readSelector = Selector.open();
        this.readKey = this.channel.register(this.readSelector, 1);
        this.writeSelector = Selector.open();
        this.writeKey = this.channel.register(this.writeSelector, 4);
    }

    void read(ByteBuffer buffer, long timeOutMs) throws IOException {
        this.checkLock();
        while (buffer.remaining() != 0) {
            this.readSelector.select(timeOutMs);
            if (!this.readKey.isReadable()) {
                String template = "InstallerChannel: Read %d bytes failed (%d ms)";
                String msg = String.format(Locale.US, template, buffer.remaining(), timeOutMs);
                throw new IOException(msg);
            }
            int read = this.channel.read(buffer);
            if (read != -1) continue;
            break;
        }
        if (buffer.remaining() != 0) {
            String template = "Unable to read %d bytes (read %d)";
            String msg = String.format(Locale.US, template, buffer.capacity(), buffer.limit());
            throw new IOException(msg);
        }
        buffer.rewind();
    }

    void write(ByteBuffer buffer, long timeOutMs) throws IOException {
        this.checkLock();
        while (buffer.remaining() != 0) {
            this.writeSelector.select(timeOutMs);
            if (!this.writeKey.isWritable()) {
                String template = "InstallerChannel: Write %d bytes failed (%d ms)";
                String msg = String.format(Locale.US, template, buffer.remaining(), timeOutMs);
                throw new IOException(msg);
            }
            this.channel.write(buffer);
        }
    }

    @Override
    public void close() throws IOException {
        try (SocketChannel c10 = this.channel;
             Selector r10 = this.readSelector;){
            Selector w10 = this.writeSelector;
            if (w10 != null) {
                w10.close();
            }
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public void checkLock() {
        if (!this.lock.isHeldByCurrentThread()) {
            throw new IllegalStateException("Channel lock must be acquired before read/write");
        }
    }
}

