/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.DexSplitter;
import com.android.tools.deployer.SqlApkFileDatabase;
import com.android.tools.deployer.model.ApkEntry;
import com.android.tools.deployer.model.DexClass;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.function.Predicate;

public class CachedDexSplitter
implements DexSplitter {
    private final SqlApkFileDatabase db;
    private final DexSplitter splitter;

    public CachedDexSplitter(SqlApkFileDatabase db2, DexSplitter splitter) {
        this.db = db2;
        this.splitter = splitter;
    }

    @Override
    public Collection<DexClass> split(ApkEntry dex, Predicate<DexClass> keepCode) throws DeployerException {
        Collection<DexClass> classes = this.db.getClasses(dex);
        if (classes.isEmpty() || keepCode != null) {
            if (dex.getApk().path == null || Files.notExists(Paths.get(dex.getApk().path, new String[0]), new LinkOption[0])) {
                throw DeployerException.remoteApkNotFound();
            }
            classes = this.splitter.split(dex, keepCode);
            this.db.addClasses(classes);
        }
        return classes;
    }
}

