/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer;

import java.util.ArrayList;
import java.util.List;

public class DeployRunnerParameters {
    private Command command = Command.UNKNOWN;
    private boolean forceFullInstall = false;
    private boolean optimisticInstall = false;
    private String installersPath = null;
    private List<String> parameters = new ArrayList<String>();

    private DeployRunnerParameters() {
    }

    private void parseFlag(String arg) {
        if ("--force-full-install".equals(arg)) {
            this.forceFullInstall = true;
        } else if (arg.startsWith("--installers-path=")) {
            this.installersPath = arg.substring(18);
        } else if (arg.startsWith("--optimistic-install")) {
            this.optimisticInstall = true;
        } else {
            throw new RuntimeException("Unknown flag: '" + arg + "'");
        }
    }

    private Command parseCommand(String arg) {
        try {
            this.command = Command.valueOf(arg.toUpperCase());
        }
        catch (Exception e10) {
            throw new RuntimeException("Unknown command: '" + arg + "'");
        }
        return Command.UNKNOWN;
    }

    public static DeployRunnerParameters parse(String[] args) {
        DeployRunnerParameters drp = new DeployRunnerParameters();
        for (int i10 = 0; i10 < args.length; ++i10) {
            String arg = args[i10];
            if (arg.startsWith("--")) {
                drp.parseFlag(arg);
                continue;
            }
            if (drp.command == Command.UNKNOWN) {
                drp.parseCommand(arg);
                continue;
            }
            drp.add(arg);
        }
        return drp;
    }

    public int size() {
        return this.parameters.size();
    }

    public void add(String parameter) {
        this.parameters.add(parameter);
    }

    public String get(int index) {
        return this.parameters.get(index);
    }

    public Command getCommand() {
        return this.command;
    }

    public boolean isForceFullInstall() {
        return this.forceFullInstall;
    }

    public String getInstallersPath() {
        return this.installersPath;
    }

    public boolean isOptimisticInstall() {
        return this.optimisticInstall;
    }

    public static enum Command {
        INSTALL,
        CODESWAP,
        FULLSWAP,
        UNKNOWN;

    }
}

