/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import java.nio.ByteBuffer;
import java.util.List;

public abstract class ApiClassBase
implements Comparable<ApiClassBase> {
    private final String name;
    List<String> members;
    int index;
    int indexOffset;
    int memberOffsetBegin;
    int memberOffsetEnd;
    int memberIndexStart;
    int memberIndexLength;

    public ApiClassBase(String name) {
        this.name = name;
    }

    String getName() {
        return this.name;
    }

    abstract int computeExtraStorageNeeded(Api<? extends ApiClassBase> var1);

    abstract void writeSuperInterfaces(Api<? extends ApiClassBase> var1, ByteBuffer var2);

    abstract void writeMemberData(Api<? extends ApiClassBase> var1, String var2, ByteBuffer var3);

    public String getContainerName() {
        int index = ApiClassBase.lastIndexOfSlashOrDollar(this.name);
        if (index >= 0) {
            return this.name.substring(0, index);
        }
        return "";
    }

    private static int lastIndexOfSlashOrDollar(String className) {
        int i10 = className.length();
        while (--i10 >= 0) {
            char c10 = className.charAt(i10);
            if (c10 != '/' && c10 != '$') continue;
            return i10;
        }
        return -1;
    }

    public String getSimpleName() {
        int index = this.name.lastIndexOf(47);
        if (index != -1) {
            return this.name.substring(index + 1);
        }
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(ApiClassBase other) {
        return this.name.compareTo(other.name);
    }
}

