/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.CharSequences;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UComment;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UFile;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CommentDetector
extends ResourceXmlDetector
implements SourceCodeScanner,
GradleScanner {
    private static final String STOPSHIP_COMMENT = "STOPSHIP";
    private static final Implementation IMPLEMENTATION = new Implementation(CommentDetector.class, EnumSet.of(Scope.RESOURCE_FILE, Scope.JAVA_FILE, Scope.GRADLE_FILE, Scope.MANIFEST, Scope.PROPERTY_FILE), Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE, Scope.GRADLE_SCOPE, Scope.MANIFEST_SCOPE, Scope.PROPERTY_SCOPE);
    public static final Issue EASTER_EGG = Issue.create("EasterEgg", "Code contains easter egg", "An \"easter egg\" is code deliberately hidden in the code, both from potential users and even from other developers. This lint check looks for code which looks like it may be hidden from sight.", Category.SECURITY, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(false).setEnabledByDefault(false);
    public static final Issue STOP_SHIP = Issue.create("StopShip", "Code contains `STOPSHIP` marker", "Using the comment `// STOPSHIP` can be used to flag code that is incomplete but checked in. This comment marker can be used to indicate that the code should not be shipped until the issue is addressed, and lint will look for these. In Gradle projects, this is only checked for non-debug (release) builds.\n\nIn Kotlin, the `TODO()` method is also treated as a stop ship marker; you can use it to make incomplete code compile, but it will throw an exception at runtime and therefore should be fixed before shipping releases.", Category.CORRECTNESS, 10, Severity.FATAL, IMPLEMENTATION).setAndroidSpecific(false).setEnabledByDefault(false);
    private static final String ESCAPE_STRING = "\\u002a\\u002f";

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return Collections.singletonList(UFile.class);
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new CommentChecker(context2);
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        CommentDetector.checkXml(context2, document);
    }

    private static void checkXml(XmlContext context2, Node node) {
        if (node.getNodeType() == 8) {
            String source = node.getNodeValue();
            CommentDetector.checkComment(context2, node, source, 0, 0, source.length());
        }
        NodeList children = node.getChildNodes();
        int n10 = children.getLength();
        for (int i10 = 0; i10 < n10; ++i10) {
            CommentDetector.checkXml(context2, children.item(i10));
        }
    }

    private static void checkComment(Context context2, Object node, CharSequence source, int offset, int start, int end) {
        int prev = 0;
        for (int i10 = start; i10 < end - 2; ++i10) {
            String message2;
            char c10 = source.charAt(i10);
            if (prev == 92) {
                if (c10 == 'u' || c10 == 'U') {
                    if (CharSequences.regionMatches((CharSequence)source, (boolean)true, (int)(i10 - 1), (CharSequence)ESCAPE_STRING, (int)0, (int)ESCAPE_STRING.length())) {
                        Location location;
                        message2 = "Code might be hidden here; found unicode escape sequence which is interpreted as comment end, compiled code follows";
                        if (context2 instanceof JavaContext && node instanceof UElement) {
                            JavaContext javaContext = (JavaContext)context2;
                            UElement javaNode = (UElement)node;
                            if (!Lint.isKotlin(javaNode.getSourcePsi())) {
                                location = javaContext.getRangeLocation(javaNode, offset + i10 - 1, ESCAPE_STRING.length());
                                javaContext.report(EASTER_EGG, javaNode, location, message2);
                            }
                        } else if (context2 instanceof XmlContext && node instanceof Node) {
                            XmlContext xmlContext = (XmlContext)context2;
                            Node xmlNode = (Node)node;
                            location = xmlContext.getLocation(xmlNode, i10, i10 + ESCAPE_STRING.length());
                            xmlContext.report(EASTER_EGG, xmlNode, location, message2);
                        } else {
                            Location location2 = Location.create(context2.file, source, i10 - 1, i10 - 1 + ESCAPE_STRING.length());
                            context2.report(STOP_SHIP, location2, message2);
                        }
                    }
                } else {
                    ++i10;
                }
            } else if (prev == 83 && c10 == 'T' && CharSequences.regionMatches((CharSequence)source, (int)(i10 - 1), (CharSequence)STOPSHIP_COMMENT, (int)0, (int)STOPSHIP_COMMENT.length())) {
                Incident incident;
                LintFix fix;
                Location location;
                message2 = "`STOPSHIP` comment found; points to code which must be fixed prior to release";
                if (context2 instanceof JavaContext && node instanceof UElement) {
                    JavaContext javaContext = (JavaContext)context2;
                    UElement javaNode = (UElement)node;
                    location = javaContext.getRangeLocation(javaNode, offset + i10 - 1, STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, javaNode, location, message2, fix);
                } else if (context2 instanceof XmlContext && node instanceof Node) {
                    XmlContext xmlContext = (XmlContext)context2;
                    Node xmlNode = (Node)node;
                    location = xmlContext.getLocation(xmlNode, i10, i10 + STOPSHIP_COMMENT.length());
                    fix = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, xmlNode, location, message2, fix);
                } else {
                    Location location3 = Location.create(context2.file, source, i10 - 1, i10 + -1 + STOPSHIP_COMMENT.length());
                    LintFix fix2 = CommentDetector.createRemoveStopShipFix();
                    incident = new Incident(STOP_SHIP, location3, message2, fix2);
                }
                context2.report(incident, new LintMap());
            }
            prev = c10;
        }
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        if (!context2.getDriver().isIsolated()) {
            Boolean releaseMode = CommentDetector.getReleaseMode(context2);
            return releaseMode != Boolean.FALSE;
        }
        return true;
    }

    private static LintFix createRemoveStopShipFix() {
        return LintFix.create().name("Remove STOPSHIP").replace().pattern("(\\s*STOPSHIP)").with("").build();
    }

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("TODO");
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression node, PsiMethod method) {
        String message2 = "`TODO` call found; points to code which must be fixed prior to release";
        PsiClass containingClass = method.getContainingClass();
        if (containingClass == null || !"kotlin.StandardKt__StandardKt".equals(containingClass.getQualifiedName())) {
            return;
        }
        Location location = context2.getLocation((UElement)node);
        LintFix fix = this.fix().name("Remove TODO").replace().all().with("").reformat(true).build();
        context2.report(STOP_SHIP, (UElement)node, location, message2, fix);
    }

    private static Boolean getReleaseMode(Context context2) {
        Project project = context2.getMainProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            return !variant.getDebuggable();
        }
        return null;
    }

    @Override
    public boolean getCustomVisitor() {
        return true;
    }

    @Override
    public void visitBuildScript(Context context2) {
        if (context2 instanceof JavaContext) {
            JavaContext javaContext = (JavaContext)context2;
            UFile file = javaContext.getUastFile();
            if (file != null) {
                new CommentChecker(javaContext).visitFile(file);
            }
        } else {
            CharSequence contents = context2.getContents();
            if (contents == null) {
                return;
            }
            int length = contents.length();
            boolean STATE_INITIAL = true;
            int STATE_SLASH = 2;
            int STATE_LINE_COMMENT = 3;
            int STATE_BLOCK_COMMENT = 4;
            int state = 1;
            int offset = 0;
            int startComment = 0;
            block6: while (offset < length) {
                char c10 = contents.charAt(offset);
                switch (state) {
                    case 1: {
                        if (c10 == '/') {
                            state = 2;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 2: {
                        if (c10 == '/') {
                            startComment = offset + 1;
                            state = 3;
                        } else if (c10 == '*') {
                            startComment = offset + 1;
                            state = 4;
                        } else {
                            state = 1;
                            continue block6;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 3: {
                        if (c10 == '\n') {
                            CommentDetector.checkComment(context2, null, contents, 0, startComment, offset);
                            state = 1;
                        }
                        ++offset;
                        continue block6;
                    }
                    case 4: {
                        if (c10 == '*' && offset < contents.length() - 1 && contents.charAt(offset + 1) == '/') {
                            CommentDetector.checkComment(context2, null, contents, 0, startComment, offset);
                            state = 1;
                            offset += 2;
                            continue block6;
                        }
                        ++offset;
                        continue block6;
                    }
                }
                assert (false) : state;
            }
            if (state == 3) {
                CommentDetector.checkComment(context2, null, contents, 0, startComment, length);
            }
        }
    }

    private static class CommentChecker
    extends UElementHandler {
        private final JavaContext mContext;

        CommentChecker(JavaContext context2) {
            this.mContext = context2;
        }

        @Override
        public void visitFile(UFile node) {
            for (UComment comment : node.getAllCommentsInFile()) {
                String contents = comment.getText();
                CommentDetector.checkComment(this.mContext, comment, contents, 0, 0, contents.length());
            }
        }
    }
}

