/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DuplicateResourceDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("DuplicateDefinition", "Duplicate definitions of resources", "You can define a resource multiple times in different resource folders; that's how string translations are done, for example. However, defining the same resource more than once in the same resource folder is likely an error, for example attempting to add a new resource without realizing that the name is already used, and so on.", Category.CORRECTNESS, 6, Severity.ERROR, new Implementation(DuplicateResourceDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE));
    public static final Implementation IMPLEMENTATION_XML = new Implementation(DuplicateResourceDetector.class, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue TYPE_MISMATCH = Issue.create("ReferenceType", "Incorrect reference types", "When you generate a resource alias, the resource you are pointing to must be of the same type as the alias", Category.CORRECTNESS, 8, Severity.FATAL, IMPLEMENTATION_XML);
    public static final Issue STRING_ESCAPING = Issue.create("StringEscaping", "Invalid string escapes", "Apostrophes (') must always be escaped (with a \\\\), unless they appear in a string which is itself escaped in double quotes (\").", Category.MESSAGES, 9, Severity.ERROR, IMPLEMENTATION_XML);
    private static final String PRODUCT = "product";
    private Map<ResourceType, Set<String>> mTypeMap;
    private Map<ResourceType, List<Pair<String, Location.Handle>>> mLocations;
    private File mParent;

    @Override
    public Collection<String> getApplicableAttributes() {
        return Collections.singletonList("name");
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void beforeCheckFile(Context context2) {
        File parent = context2.file.getParentFile();
        if (!parent.equals(this.mParent)) {
            this.mParent = parent;
            this.mTypeMap = Maps.newEnumMap(ResourceType.class);
            this.mLocations = Maps.newEnumMap(ResourceType.class);
        }
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String name;
        String tag;
        Element element = attribute.getOwnerElement();
        if (element.hasAttribute(PRODUCT)) {
            return;
        }
        String typeString = tag = element.getTagName();
        if (tag.equals("item") && ((typeString = element.getAttribute("type")) == null || typeString.isEmpty())) {
            if (element.getParentNode().getNodeName().equals(ResourceType.STYLE.getName()) && DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context2, (Element)element.getParentNode());
            }
            return;
        }
        ResourceType type = ResourceType.fromXmlTag((Node)element);
        if (type == null) {
            return;
        }
        if (type == ResourceType.PUBLIC) {
            return;
        }
        if (type == ResourceType.ATTR && element.getParentNode().getNodeName().equals("declare-styleable")) {
            if (DuplicateResourceDetector.isFirstElementChild(element)) {
                DuplicateResourceDetector.checkUniqueNames(context2, (Element)element.getParentNode());
            }
            return;
        }
        NodeList children = element.getChildNodes();
        int childCount = children.getLength();
        block0: for (int i10 = 0; i10 < childCount; ++i10) {
            Node child = children.item(i10);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            this.checkXmlEscapes(context2, child, element, text);
            int length = text.length();
            for (int j10 = 0; j10 < length; ++j10) {
                char c10 = text.charAt(j10);
                if (c10 == '@') {
                    ResourceUrl url;
                    if (text.regionMatches(false, j10 + 1, typeString, 0, typeString.length()) || !context2.isEnabled(TYPE_MISMATCH) || (url = ResourceUrl.parse((String)text.trim())) == null || url.type == type || type == ResourceType.DRAWABLE && (url.type == ResourceType.COLOR || url.type == ResourceType.MIPMAP)) break block0;
                    LintFix fix = this.fix().replace().pattern("(@.*/)").with("@" + type + "/").build();
                    String message2 = "Unexpected resource reference type; expected value of type `@" + type + "/`";
                    context2.report(TYPE_MISMATCH, element, context2.getLocation(child), message2, fix);
                    break block0;
                }
                if (!Character.isWhitespace(c10)) break block0;
            }
            break;
        }
        Set names = this.mTypeMap.computeIfAbsent(type, k10 -> Sets.newHashSetWithExpectedSize((int)40));
        String originalName = name = attribute.getValue();
        if (names.contains(name = ResourcesUtil.resourceNameToFieldName((String)name))) {
            String message3 = String.format("`%1$s` has already been defined in this folder", name);
            if (!name.equals(originalName)) {
                message3 = message3 + " (`" + name + "` is equivalent to `" + originalName + "`)";
            }
            Location location = context2.getLocation(attribute);
            List<Pair<String, Location.Handle>> list2 = this.mLocations.get(type);
            for (Pair<String, Location.Handle> pair : list2) {
                if (!name.equals(pair.getFirst())) continue;
                Location secondary = ((Location.Handle)pair.getSecond()).resolve();
                secondary.setMessage("Previously defined here");
                location.setSecondary(secondary);
            }
            context2.report(ISSUE, attribute, location, message3);
        } else {
            names.add(name);
            List list3 = this.mLocations.computeIfAbsent(type, k10 -> Lists.newArrayList());
            Location.Handle handle = context2.createLocationHandle(attribute);
            list3.add(Pair.of((Object)name, (Object)handle));
        }
    }

    private static void checkUniqueNames(XmlContext context2, Element parent) {
        List<Element> items = Lint.getChildren(parent);
        if (items.size() > 1) {
            HashSet names = Sets.newHashSet();
            for (Element item : items) {
                Attr nameNode = item.getAttributeNode("name");
                if (nameNode == null) continue;
                String name = nameNode.getValue();
                if (names.contains(name) && context2.isEnabled(ISSUE)) {
                    Location location = context2.getLocation(nameNode);
                    for (Element prevItem : items) {
                        Attr attribute = item.getAttributeNode("name");
                        if (attribute == null || !name.equals(attribute.getValue())) continue;
                        assert (prevItem != item);
                        Location prev = context2.getLocation(prevItem);
                        prev.setMessage("Previously defined here");
                        location.setSecondary(prev);
                        break;
                    }
                    String message2 = String.format("`%1$s` has already been defined in this `<%2$s>`", name, parent.getTagName());
                    context2.report(ISSUE, nameNode, location, message2);
                }
                names.add(name);
            }
        }
    }

    private static boolean isFirstElementChild(Node node) {
        for (node = node.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return false;
        }
        return true;
    }

    private void checkXmlEscapes(XmlContext context2, Node textNode, Element element, String string) {
        int len;
        int s10 = 0;
        for (len = string.length(); len > 0 && Character.isWhitespace(string.charAt(s10)); --len) {
            ++s10;
        }
        while (len > 0 && Character.isWhitespace(string.charAt(s10 + len - 1))) {
            --len;
        }
        if (len > 0 && string.charAt(s10 + len - 1) == '\\' && s10 + len < string.length()) {
            ++len;
        }
        char quoted = '\u0000';
        int p10 = s10;
        while (p10 < s10 + len) {
            char c10;
            while (p10 < s10 + len && (c10 = string.charAt(p10)) != '\\' && (quoted != '\u0000' || !Character.isWhitespace(c10) || c10 == ' ' && !Character.isWhitespace(string.charAt(p10 + 1))) && (c10 != '\"' || quoted != '\u0000' && quoted != '\"')) {
                if (c10 == '\'' && (quoted == '\u0000' || quoted == '\'')) {
                    Location location = context2.getLocation(textNode, p10, len);
                    LintFix fix = this.fix().name("Escape Apostrophe").replace().pattern("[^\\\\]?(')").with("\\'").build();
                    context2.report(STRING_ESCAPING, element, location, "Apostrophe not preceded by \\\\", fix);
                    return;
                }
                ++p10;
            }
            if (p10 >= s10 + len) continue;
            char cp2 = string.charAt(p10);
            if (cp2 == '\"' || cp2 == '\'') {
                quoted = quoted == '\u0000' ? cp2 : (char)'\u0000';
                ++p10;
            } else if (Character.isWhitespace(cp2)) {
                ++p10;
                while (p10 < s10 + len && Character.isWhitespace(string.charAt(p10))) {
                    ++p10;
                }
            } else if (cp2 == '\\' && ++p10 < s10 + len) {
                switch (string.charAt(p10)) {
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '?': 
                    case '@': 
                    case '\\': 
                    case 'n': 
                    case 't': {
                        break;
                    }
                    case 'u': {
                        for (int i10 = 0; i10 < 4 && p10 + 1 < len; ++i10) {
                            char h10;
                            if ((h10 = string.charAt(++p10)) >= '0' && h10 <= '9' || h10 >= 'a' && h10 <= 'f' || h10 >= 'A' && h10 <= 'F') continue;
                            Location location = context2.getLocation(textNode, p10, p10 + 1);
                            context2.report(STRING_ESCAPING, element, location, "Bad character in \\\\u unicode escape sequence");
                            return;
                        }
                        break;
                    }
                }
                ++p10;
            }
            len -= p10 - s10;
            s10 = p10;
        }
    }
}

