/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiTypeElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;

public class ExifInterfaceDetector
extends Detector
implements SourceCodeScanner {
    public static final String EXIF_INTERFACE = "ExifInterface";
    public static final String OLD_EXIF_INTERFACE = "android.media.ExifInterface";
    private static final Implementation IMPLEMENTATION = new Implementation(ExifInterfaceDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("ExifInterface", "Using `android.media.ExifInterface`", "The `android.media.ExifInterface` implementation has some known security bugs in older versions of Android. There is a new implementation available of this library in the support library, which is preferable.", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);

    private static void fix(JavaContext context2, UElement reference, PsiElement referenced) {
        String qualifiedName;
        if (referenced instanceof PsiMethod || referenced instanceof PsiField) {
            referenced = ((PsiMember)referenced).getContainingClass();
        }
        if (referenced instanceof PsiClass && (qualifiedName = ((PsiClass)referenced).getQualifiedName()) != null && OLD_EXIF_INTERFACE.equals(qualifiedName)) {
            ExifInterfaceDetector.replace(context2, reference);
        }
    }

    private static void replace(JavaContext context2, UElement reference) {
        UElement locationNode = reference;
        while (locationNode.getUastParent() instanceof UReferenceExpression) {
            locationNode = locationNode.getUastParent();
        }
        Location location = context2.getLocation(locationNode);
        String message2 = ExifInterfaceDetector.getErrorMessage();
        context2.report(ISSUE, reference, location, message2);
    }

    private static void replace(JavaContext context2, PsiElement reference) {
        Location location = context2.getLocation(reference);
        String message2 = ExifInterfaceDetector.getErrorMessage();
        context2.report(ISSUE, reference, location, message2);
    }

    private static String getErrorMessage() {
        return "Avoid using `android.media.ExifInterface`; use `android.support.media.ExifInterface` from the support library instead";
    }

    @Override
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        ArrayList<Class<? extends UElement>> types = new ArrayList<Class<? extends UElement>>(3);
        types.add(UQualifiedReferenceExpression.class);
        types.add(UImportStatement.class);
        types.add(UVariable.class);
        return types;
    }

    @Override
    public UElementHandler createUastHandler(JavaContext context2) {
        return new MyVisitor(context2);
    }

    private static final class MyVisitor
    extends UElementHandler {
        private final JavaContext context;

        private MyVisitor(JavaContext context2) {
            this.context = context2;
        }

        @Override
        public void visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
            PsiElement resolved;
            USimpleNameReferenceExpression name;
            UExpression selector = node.getSelector();
            if (selector instanceof USimpleNameReferenceExpression && ExifInterfaceDetector.EXIF_INTERFACE.equals((name = (USimpleNameReferenceExpression)selector).getIdentifier()) && (resolved = node.resolve()) != null) {
                ExifInterfaceDetector.fix(this.context, (UElement)node, resolved);
            }
        }

        @Override
        public void visitImportStatement(UImportStatement node) {
            UElement importReference = node.getImportReference();
            if (importReference != null) {
                PsiClass cls;
                PsiElement resolved = node.resolve();
                if (resolved instanceof PsiField) {
                    resolved = ((PsiField)resolved).getContainingClass();
                } else if (resolved instanceof PsiMethod) {
                    resolved = ((PsiMethod)resolved).getContainingClass();
                }
                if (resolved instanceof PsiClass && ExifInterfaceDetector.EXIF_INTERFACE.equals((cls = (PsiClass)resolved).getName()) && ExifInterfaceDetector.OLD_EXIF_INTERFACE.equals(cls.getQualifiedName())) {
                    ExifInterfaceDetector.fix(this.context, importReference, resolved);
                }
            }
        }

        @Override
        public void visitVariable(UVariable node) {
            PsiJavaCodeReferenceElement referenceElement;
            PsiTypeElement typeElement = node.getTypeElement();
            if (typeElement != null && (referenceElement = typeElement.getInnermostComponentReferenceElement()) != null && ExifInterfaceDetector.EXIF_INTERFACE.equals(referenceElement.getReferenceName()) && ExifInterfaceDetector.OLD_EXIF_INTERFACE.equals(referenceElement.getText())) {
                ExifInterfaceDetector.replace(this.context, (PsiElement)referenceElement);
            }
        }
    }
}

