/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00142\u00020\u00012\u00020\u0002:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/lint/checks/ExportedReceiverDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "()V", "filterIncident", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getApplicableElements", "", "", "visitElement", "", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
public final class ExportedReceiverDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE = Issue.Companion.create("IntentFilterExportedReceiver", "Unspecified `android:exported` in manifest", "\n                Apps targeting Android 12 and higher are required to specify an explicit value \\\n                for `android:exported` when the corresponding component has an intent filter defined. \\\n                Otherwise, installation will fail.\n\n                Previously, `android:exported` for components without any intent filters present \\\n                used to default to `false`, and when intent filters were present, the default was \\\n                `true`. Defaults which change value based on other values are confusing and lead to \\\n                apps accidentally exporting components as a side-effect of adding intent filters. \\\n                This is a security risk, and we have made this change to avoid introducing \\\n                accidental vulnerabilities.\n\n                While the default without intent filters remains unchanged, it is now required to \\\n                explicitly specify a value when intent filters are present. Any app failing to meet \\\n                this requirement will fail to install on any Android version after Android 11.\n\n                We recommend setting `android:exported` to false (even on previous versions of Android \\\n                prior to this requirement) unless you have a good reason to export a particular \\\n                component.\n            ", Category.SECURITY, 5, Severity.WARNING, new Implementation(ExportedReceiverDetector.class, Scope.MANIFEST_SCOPE));

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"activity", "activity-alias", "service", "receiver", "provider"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        Element intentFilter = DomExtensions.subtag((Element)element, (String)"intent-filter");
        Attr exported = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "exported");
        if (intentFilter != null && exported == null) {
            LintFix fix = LintFix.SetAttributeBuilder.todo$default(LintFix.Companion.create().set(), "http://schemas.android.com/apk/res/android", "exported", null, null, 12, null).build();
            Incident incident = new Incident(ISSUE, element, context2.getNameLocation(element), "When using intent filters, please specify `android:exported` as well", fix);
            context2.report(incident, this.map());
        }
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        if (context2.getMainProject().getTargetSdk() >= 31) {
            incident.overrideSeverity(Severity.ERROR);
        }
        return true;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/lint/checks/ExportedReceiverDetector$Companion;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

