/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.base.Joiner;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FullBackupContentDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("FullBackupContent", "Valid Full Backup Content File", "Ensures that a `<full-backup-content>` file, which is pointed to by a `android:fullBackupContent attribute` in the manifest file, is valid", Category.CORRECTNESS, 5, Severity.FATAL, new Implementation(FullBackupContentDetector.class, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://android-developers.googleblog.com/2015/07/auto-backup-for-apps-made-simple.html");
    private static final String DOMAIN_SHARED_PREF = "sharedpref";
    private static final String DOMAIN_ROOT = "root";
    private static final String DOMAIN_FILE = "file";
    private static final String DOMAIN_DATABASE = "database";
    private static final String DOMAIN_EXTERNAL = "external";
    private static final String TAG_EXCLUDE = "exclude";
    private static final String TAG_INCLUDE = "include";
    private static final String TAG_FULL_BACKUP_CONTENT = "full-backup-content";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_DOMAIN = "domain";
    private static final String[] VALID_DOMAINS = new String[]{"root", "file", "database", "sharedpref", "external"};

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.XML;
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        if (!TAG_FULL_BACKUP_CONTENT.equals(root.getTagName())) {
            return;
        }
        ArrayList includes = Lists.newArrayList();
        ArrayList excludes = Lists.newArrayList();
        NodeList children = root.getChildNodes();
        int n10 = children.getLength();
        for (int i10 = 0; i10 < n10; ++i10) {
            Node child = children.item(i10);
            if (child.getNodeType() != 1) continue;
            Element element = (Element)child;
            String tag = element.getTagName();
            if (TAG_INCLUDE.equals(tag)) {
                includes.add(element);
                continue;
            }
            if (TAG_EXCLUDE.equals(tag)) {
                excludes.add(element);
                continue;
            }
            context2.report(ISSUE, element, context2.getNameLocation(element), String.format("Unexpected element `<%1$s>`", tag));
        }
        ArrayListMultimap includePaths = ArrayListMultimap.create((int)includes.size(), (int)4);
        for (Element include : includes) {
            String domain = FullBackupContentDetector.validateDomain(context2, include);
            String path2 = FullBackupContentDetector.validatePath(context2, include);
            if (domain == null) continue;
            includePaths.put((Object)domain, (Object)path2);
        }
        for (Element exclude : excludes) {
            String domain;
            String excludePath = FullBackupContentDetector.validatePath(context2, exclude);
            if (excludePath.isEmpty() || (domain = FullBackupContentDetector.validateDomain(context2, exclude)) == null || includePaths.isEmpty()) continue;
            boolean hasPrefix = false;
            Collection included = includePaths.get((Object)domain);
            if (included == null) continue;
            for (String includePath : included) {
                if (!excludePath.startsWith(includePath) && !includePath.equals(".")) continue;
                if (excludePath.equals(includePath)) {
                    Attr pathNode = exclude.getAttributeNode(ATTR_PATH);
                    assert (pathNode != null);
                    Location location = context2.getValueLocation(pathNode);
                    for (Element include : includes) {
                        Attr includePathNode = include.getAttributeNode(ATTR_PATH);
                        String includeDomain = include.getAttribute(ATTR_DOMAIN);
                        if (includePathNode == null || !excludePath.equals(includePathNode.getValue()) || !domain.equals(includeDomain)) continue;
                        Location earlier = context2.getLocation(includePathNode);
                        earlier.setMessage("Unnecessary/conflicting <include>");
                        location.setSecondary(earlier);
                    }
                    context2.report(ISSUE, exclude, location, String.format("Include `%1$s` is also excluded", excludePath));
                }
                hasPrefix = true;
                break;
            }
            if (hasPrefix) continue;
            Attr pathNode = exclude.getAttributeNode(ATTR_PATH);
            assert (pathNode != null);
            context2.report(ISSUE, exclude, context2.getValueLocation(pathNode), String.format("`%1$s` is not in an included path", excludePath));
        }
    }

    private static String validatePath(XmlContext context2, Element element) {
        String domain;
        Attr pathNode = element.getAttributeNode(ATTR_PATH);
        if (pathNode == null) {
            return "";
        }
        String value = pathNode.getValue();
        if (value.contains("//")) {
            context2.report(ISSUE, element, context2.getValueLocation(pathNode), "Paths are not allowed to contain `//`");
        } else if (value.contains("..")) {
            context2.report(ISSUE, element, context2.getValueLocation(pathNode), "Paths are not allowed to contain `..`");
        } else if (value.contains("/") && (DOMAIN_SHARED_PREF.equals(domain = element.getAttribute(ATTR_DOMAIN)) || DOMAIN_DATABASE.equals(domain))) {
            context2.report(ISSUE, element, context2.getValueLocation(pathNode), String.format("Subdirectories are not allowed for domain `%1$s`", domain));
        }
        return value;
    }

    private static String validateDomain(XmlContext context2, Element element) {
        Attr domainNode = element.getAttributeNode(ATTR_DOMAIN);
        if (domainNode == null) {
            context2.report(ISSUE, element, context2.getElementLocation(element), String.format("Missing domain attribute, expected one of %1$s", Joiner.on((String)", ").join((Object[])VALID_DOMAINS)));
            return null;
        }
        String domain = domainNode.getValue();
        for (String availableDomain : VALID_DOMAINS) {
            if (!availableDomain.equals(domain)) continue;
            return domain;
        }
        context2.report(ISSUE, element, context2.getValueLocation(domainNode), String.format("Unexpected domain `%1$s`, expected one of %2$s", domain, Joiner.on((String)", ").join((Object[])VALID_DOMAINS)));
        return domain;
    }
}

