/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GoogleMavenRepository;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.repository.MavenRepositories;
import com.android.io.CancellableFileIo;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.android.sdklib.SdkVersionInfo;
import com.android.tools.lint.checks.BlockedDependencies;
import com.android.tools.lint.checks.DeprecatedSdkRegistry;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.DomExtensions;
import com.android.utils.StringHelper;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.ArrayListMultimap;
import com.intellij.pom.java.LanguageLevel;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u00de\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b\u0016\u0018\u0000 \u0096\u00012\u00020\u00012\u00020\u0002:\b\u0095\u0001\u0096\u0001\u0097\u0001\u0098\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010*\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016J(\u0010+\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010'\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002J\u0018\u00101\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00102\u001a\u00020\nH\u0002J,\u00103\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000f2\u0006\u00105\u001a\u00020-2\b\u00106\u001a\u0004\u0018\u00010-H\u0002J\u001a\u00107\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J\u001a\u00108\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000fH\u0002J$\u00109\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u00104\u001a\u0004\u0018\u00010\u000f2\b\u0010:\u001a\u0004\u0018\u00010\u000fH\u0002J0\u0010;\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010=\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002J \u0010>\u001a\u00020&2\u0006\u0010,\u001a\u00020-2\u0006\u0010'\u001a\u00020/2\u0006\u00100\u001a\u00020\u000fH\u0002JJ\u0010?\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010@\u001a\u00020-2\u0006\u0010A\u001a\u00020-2\u0006\u0010B\u001a\u00020-2\b\u0010C\u001a\u0004\u0018\u00010-2\u0006\u00100\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0016J0\u0010E\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-2\u0006\u0010G\u001a\u00020H2\u0006\u00104\u001a\u00020\u000fH\u0002J \u0010I\u001a\u00020\u00182\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u00104\u001a\u00020\u000fH\u0002J \u0010J\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010A\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0002J\u0010\u0010K\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010L\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0016JV\u0010M\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010N\u001a\u00020-2\b\u0010B\u001a\u0004\u0018\u00010-2\b\u0010C\u001a\u0004\u0018\u00010-2\u0012\u0010O\u001a\u000e\u0012\u0004\u0012\u00020-\u0012\u0004\u0012\u00020-0P2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00020-0R2\u0006\u00104\u001a\u00020\u000fH\u0016J \u0010S\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010G\u001a\u00020\r2\u0006\u0010D\u001a\u00020\u000fH\u0002J \u0010T\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010A\u001a\u00020-2\u0006\u00104\u001a\u00020\u000fH\u0002J8\u0010U\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\u0006\u0010V\u001a\u00020-2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010:\u001a\u00020\u000fH\u0002J2\u0010W\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020H2\b\u0010X\u001a\u0004\u0018\u00010H2\u0006\u00104\u001a\u00020\u000fH\u0002J\u0010\u0010Y\u001a\u00020&2\u0006\u0010'\u001a\u00020/H\u0002J:\u0010Z\u001a\u00020&2\u0006\u0010'\u001a\u00020/2\b\u0010G\u001a\u0004\u0018\u00010H2\u0006\u00104\u001a\u00020\u000f2\u0006\u0010[\u001a\u00020\r2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\rH\u0002J \u0010^\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(2\u0006\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bH\u0016J\"\u0010c\u001a\u0004\u0018\u00010H2\u0006\u0010.\u001a\u00020<2\u000e\u0010d\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010eH\u0002J\u0016\u0010f\u001a\u00020g2\f\u0010h\u001a\b\u0012\u0004\u0012\u00020g0iH\u0002J\u0016\u0010j\u001a\b\u0012\u0004\u0012\u00020k0R2\u0006\u00102\u001a\u00020\nH\u0002J\b\u0010l\u001a\u00020\u0007H\u0004J\u0016\u0010m\u001a\u00020-2\f\u0010n\u001a\b\u0012\u0004\u0012\u00020o0RH\u0002J\u0010\u0010p\u001a\u00020\u00112\u0006\u0010q\u001a\u00020rH\u0002J*\u0010s\u001a\u0004\u0018\u00010H2\u0006\u0010'\u001a\u00020/2\u0006\u0010.\u001a\u00020<2\u000e\u0010d\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010eH\u0002J\u0010\u0010t\u001a\u00020\u00132\u0006\u0010q\u001a\u00020rH\u0002J\u001a\u0010u\u001a\u0004\u0018\u00010H2\u0006\u0010v\u001a\u00020H2\u0006\u0010w\u001a\u00020HH\u0002J\"\u0010u\u001a\u0004\u0018\u00010H2\u0006\u0010v\u001a\u00020H2\u0006\u0010[\u001a\u00020\r2\u0006\u0010\\\u001a\u00020\rH\u0002J*\u0010u\u001a\u0004\u0018\u00010H2\u0006\u0010v\u001a\u00020H2\u0006\u0010[\u001a\u00020\r2\u0006\u0010\\\u001a\u00020\r2\u0006\u0010]\u001a\u00020\rH\u0002J\"\u0010x\u001a\u00020-2\u0006\u0010.\u001a\u00020<2\u0006\u0010G\u001a\u00020-2\b\u0010y\u001a\u0004\u0018\u00010HH\u0002J\u0010\u0010z\u001a\u00020\r2\u0006\u0010A\u001a\u00020-H\u0002J/\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020-2\u0006\u0010~\u001a\u00020-2\b\b\u0002\u0010\u007f\u001a\u00020\u00182\u000b\b\u0002\u0010\u0080\u0001\u001a\u0004\u0018\u00010HH\u0002J1\u0010\u0081\u0001\u001a\n\u0012\u0004\u0012\u00020H\u0018\u00010e2\u0006\u0010'\u001a\u00020/2\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-2\u0006\u0010V\u001a\u00020-H\u0002J\u0019\u0010\u0082\u0001\u001a\u00020\u00182\u0006\u00105\u001a\u00020-2\u0006\u0010F\u001a\u00020-H\u0002J\u0011\u0010\u0083\u0001\u001a\u00020\u00182\u0006\u0010'\u001a\u00020(H\u0002J\u0011\u0010\u0084\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002JD\u0010\u0085\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\u0007\u0010\u0088\u0001\u001a\u00020-2\u000b\b\u0002\u0010\u0089\u0001\u001a\u0004\u0018\u00010|2\t\b\u0002\u0010\u008a\u0001\u001a\u00020\u0018H\u0002J$\u0010\u008b\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u0088\u0001\u001a\u00020-H\u0002J\"\u0010\u008b\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020-H\u0002J-\u0010\u008b\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020-2\t\u0010\u0089\u0001\u001a\u0004\u0018\u00010|H\u0002J$\u0010\u008e\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\b\u0010\u008c\u0001\u001a\u00030\u008d\u00012\u0007\u0010\u0088\u0001\u001a\u00020-H\u0002J/\u0010\u008e\u0001\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u00104\u001a\u00020\u000f2\u0007\u0010\u0088\u0001\u001a\u00020-2\u000b\b\u0002\u0010\u008f\u0001\u001a\u0004\u0018\u00010|H\u0002J$\u0010\u0090\u0001\u001a\u0004\u0018\u00010<2\u0006\u0010'\u001a\u00020/2\u0006\u0010@\u001a\u00020-2\u0007\u0010\u0091\u0001\u001a\u00020<H\u0002J\u0011\u0010\u0092\u0001\u001a\u00020\u00182\u0006\u00102\u001a\u00020\nH\u0002J\r\u0010\u0093\u0001\u001a\u00020\u0018*\u00020gH\u0002J\r\u0010\u0094\u0001\u001a\u00020\u0018*\u00020gH\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00078TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010#\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0099\u0001"}, d2={"Lcom/android/tools/lint/checks/GradleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "agpVersionCheckInfo", "Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "artifactCacheHome", "Ljava/io/File;", "blockedDependencies", "Ljava/util/HashMap;", "Lcom/android/tools/lint/detector/api/Project;", "Lcom/android/tools/lint/checks/BlockedDependencies;", "compileSdkVersion", "", "compileSdkVersionCookie", "", "deprecatedSdkRegistry", "Lcom/android/tools/lint/checks/DeprecatedSdkRegistry;", "googleMavenRepository", "Lcom/android/ide/common/repository/GoogleMavenRepository;", "gradleUserHome", "getGradleUserHome", "()Ljava/io/File;", "mAppliedJavaPlugin", "", "mAppliedKotlinAndroidPlugin", "mAppliedKotlinKaptPlugin", "mCheckedGms", "mCheckedSupportLibs", "mCheckedWearableLibs", "mDeclaredGoogleMavenRepository", "mDeclaredSourceCompatibility", "mDeclaredTargetCompatibility", "mJavaPluginInfo", "Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "minSdkVersion", "targetSdkVersion", "afterCheckFile", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckRootProject", "beforeCheckRootProject", "checkAnnotationProcessorOnCompilePath", "configuration", "", "dependency", "Lcom/android/tools/lint/detector/api/GradleContext;", "propertyCookie", "checkBlockedDependencies", "project", "checkConsistentLibraries", "cookie", "groupId", "groupId2", "checkConsistentPlayServices", "checkConsistentSupportLibraries", "checkConsistentWearableLibraries", "statementCookie", "checkDependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "checkDeprecatedConfigurations", "checkDslPropertyAssignment", "property", "value", "parent", "parentParent", "valueCookie", "checkForKtxExtension", "artifactId", "version", "Lcom/android/ide/common/repository/GradleVersion;", "checkGradlePluginDependency", "checkIntegerAsString", "checkLibraryConsistency", "checkMergedProject", "checkMethodCall", "statement", "namedArguments", "", "unnamedArguments", "", "checkMinSdkVersion", "checkOctal", "checkPlayServices", "revision", "checkSupportLibraries", "newerVersion", "checkTargetCompatibility", "ensureTargetCompatibleWithO", "major", "minor", "micro", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "findCachedNewerVersion", "filter", "Ljava/util/function/Predicate;", "findFirst", "Lcom/android/tools/lint/model/LintModelMavenName;", "coordinates", "", "getAllLibraries", "Lcom/android/tools/lint/model/LintModelLibrary;", "getArtifactCacheHome", "getBlockedDependencyMessage", "path", "Lcom/android/tools/lint/model/LintModelDependency;", "getDeprecatedLibraryLookup", "client", "Lcom/android/tools/lint/client/api/LintClient;", "getGoogleMavenRepoVersion", "getGoogleMavenRepository", "getNewerVersion", "version1", "version2", "getNewerVersionAvailableMessage", "stable", "getSdkVersion", "getUpdateDependencyFix", "Lcom/android/tools/lint/detector/api/LintFix;", "currentVersion", "suggestedVersion", "suggestedVersionIsSafe", "safeReplacement", "getUpgradeVersionFilter", "isSupportLibraryDependentOnCompileSdk", "isWearApp", "maybeReportAgpVersionIssue", "report", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "fix", "partial", "reportFatalCompatibilityIssue", "location", "Lcom/android/tools/lint/detector/api/Location;", "reportNonFatalCompatibilityIssue", "lintFix", "resolveCoordinate", "gc", "usesLegacyHttpLibrary", "isAndroidxArtifact", "isSupportLibArtifact", "AgpVersionCheckInfo", "Companion", "DeprecatedConfiguration", "JavaPluginInfo", "android.sdktools.lint-checks"})
public class GradleDetector
extends Detector
implements GradleScanner {
    @NotNull
    public static final Companion Companion;
    private int minSdkVersion;
    private int compileSdkVersion;
    @Nullable
    private Object compileSdkVersionCookie;
    private int targetSdkVersion;
    @Nullable
    private File artifactCacheHome;
    private boolean mCheckedGms;
    private boolean mCheckedSupportLibs;
    private boolean mCheckedWearableLibs;
    private boolean mAppliedKotlinAndroidPlugin;
    private boolean mAppliedKotlinKaptPlugin;
    private boolean mAppliedJavaPlugin;
    @Nullable
    private JavaPluginInfo mJavaPluginInfo;
    private boolean mDeclaredSourceCompatibility;
    private boolean mDeclaredTargetCompatibility;
    private boolean mDeclaredGoogleMavenRepository;
    @Nullable
    private AgpVersionCheckInfo agpVersionCheckInfo;
    @NotNull
    private final HashMap<Project, BlockedDependencies> blockedDependencies = new HashMap();
    @Nullable
    private GoogleMavenRepository googleMavenRepository;
    @Nullable
    private DeprecatedSdkRegistry deprecatedSdkRegistry;
    @Nullable
    private static Calendar calendar;
    @NotNull
    public static final String KEY_COORDINATE = "coordinate";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @JvmField
    @NotNull
    public static final Issue DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue AGP_DEPENDENCY;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_CONFIGURATION;
    @JvmField
    @NotNull
    public static final Issue GRADLE_PLUGIN_COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue PATH;
    @JvmField
    @NotNull
    public static final Issue IDE_SUPPORT;
    @JvmField
    @NotNull
    public static final Issue PLUS;
    @JvmField
    @NotNull
    public static final Issue GRADLE_GETTER;
    @JvmField
    @NotNull
    public static final Issue COMPATIBILITY;
    @JvmField
    @NotNull
    public static final Issue STRING_INTEGER;
    @JvmField
    @NotNull
    public static final Issue NOT_INTERPOLATED;
    @JvmField
    @NotNull
    public static final Issue REMOTE_VERSION;
    @JvmField
    @NotNull
    public static final Issue MIN_SDK_TOO_LOW;
    @JvmField
    @NotNull
    public static final Issue ACCIDENTAL_OCTAL;
    @JvmField
    @NotNull
    public static final Issue BUNDLED_GMS;
    @JvmField
    @NotNull
    public static final Issue HIGH_APP_VERSION_CODE;
    @JvmField
    @NotNull
    public static final Issue DEV_MODE_OBSOLETE;
    @JvmField
    @NotNull
    public static final Issue DUPLICATE_CLASSES;
    @JvmField
    @NotNull
    public static final Issue EXPIRING_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue EXPIRED_TARGET_SDK_VERSION;
    @JvmField
    @NotNull
    public static final Issue DEPRECATED_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue DATA_BINDING_WITHOUT_KAPT;
    @JvmField
    @NotNull
    public static final Issue LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8;
    @JvmField
    @NotNull
    public static final Issue RISKY_LIBRARY;
    @JvmField
    @NotNull
    public static final Issue ANNOTATION_PROCESSOR_ON_COMPILE_PATH;
    @JvmField
    @NotNull
    public static final Issue KTX_EXTENSION_AVAILABLE;
    @JvmField
    @NotNull
    public static final Issue JAVA_PLUGIN_LANGUAGE_LEVEL;
    @JvmField
    @NotNull
    public static final Issue JCENTER_REPOSITORY_OBSOLETE;
    @NotNull
    private static final List<String> JAVA_PLUGIN_IDS;
    @NotNull
    public static final String APP_PLUGIN_ID = "com.android.application";
    @NotNull
    public static final String LIB_PLUGIN_ID = "com.android.library";
    @NotNull
    public static final String OLD_APP_PLUGIN_ID = "android";
    @NotNull
    public static final String OLD_LIB_PLUGIN_ID = "android-library";
    @NotNull
    public static final String GMS_GROUP_ID = "com.google.android.gms";
    @NotNull
    public static final String FIREBASE_GROUP_ID = "com.google.firebase";
    @NotNull
    public static final String GOOGLE_SUPPORT_GROUP_ID = "com.google.android.support";
    @NotNull
    public static final String ANDROID_WEAR_GROUP_ID = "com.google.android.wearable";
    @NotNull
    private static final String WEARABLE_ARTIFACT_ID = "wearable";
    @NotNull
    private static final GradleCoordinate PLAY_SERVICES_V650;
    private static final int VERSION_CODE_HIGH_THRESHOLD = 2000000000;
    private static int majorBuildTools;
    @Nullable
    private static GradleVersion latestBuildTools;
    @NotNull
    private static final Set<String> commonAnnotationProcessors;

    @NotNull
    protected File getGradleUserHome() {
        String gradleUserHome = System.getProperty("gradle.user.home");
        if (gradleUserHome == null && (gradleUserHome = System.getenv("GRADLE_USER_HOME")) == null) {
            gradleUserHome = System.getProperty("user.home") + File.separator + ".gradle";
        }
        return new File(gradleUserHome);
    }

    private final void checkOctal(GradleContext context2, String value, Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || Intrinsics.compare((int)value.charAt(1), (int)56) >= 0 && GradleContext.Companion.isNonNegativeInteger(value)) && context2.isEnabled(ACCIDENTAL_OCTAL)) {
            String string;
            String string2;
            String message2;
            String string3 = message2 = "The leading 0 turns this number into octal which is probably not what was intended";
            try {
                string2 = string3;
                Long numericValue = Long.decode(value);
                string = " (interpreted as " + numericValue + ')';
            }
            catch (NumberFormatException numberFormatException) {
                string2 = string3;
                string = " (and it is not a valid octal number)";
            }
            message2 = Intrinsics.stringPlus((String)string2, (Object)string);
            GradleDetector.report$default(this, context2, cookie, ACCIDENTAL_OCTAL, message2, null, false, 48, null);
        }
    }

    @Override
    public void checkDslPropertyAssignment(@NotNull GradleContext context2, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object propertyCookie, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)property, (String)"property");
        Intrinsics.checkParameterIsNotNull((Object)value, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)parent, (String)"parent");
        Intrinsics.checkParameterIsNotNull((Object)propertyCookie, (String)"propertyCookie");
        Intrinsics.checkParameterIsNotNull((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkParameterIsNotNull((Object)statementCookie, (String)"statementCookie");
        if (Intrinsics.areEqual((Object)parent, (Object)"defaultConfig")) {
            int version;
            int version2;
            if (Intrinsics.areEqual((Object)property, (Object)"targetSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0 && version2 < context2.getClient().getHighestKnownApiLevel()) {
                    boolean warned = false;
                    if (version2 < 29) {
                        Calendar calendar = GradleDetector.calendar;
                        Calendar now = calendar == null ? Calendar.getInstance() : calendar;
                        int year = now.get(1);
                        int month = now.get(2);
                        int required = 0;
                        Issue issue = null;
                        if (year > 2020 || month >= 10) {
                            required = 29;
                            issue = EXPIRED_TARGET_SDK_VERSION;
                        } else if (version2 < 28 && year > 2018) {
                            required = 28;
                            issue = EXPIRED_TARGET_SDK_VERSION;
                        } else if (year == 2020) {
                            required = 29;
                            issue = EXPIRING_TARGET_SDK_VERSION;
                        } else {
                            required = -1;
                            issue = IssueRegistry.LINT_ERROR;
                        }
                        if (required != -1) {
                            boolean alreadySuppressed;
                            String message2 = Intrinsics.areEqual((Object)issue, (Object)EXPIRED_TARGET_SDK_VERSION) ? "Google Play requires that apps target API level " + required + " or higher.\n" : "Google Play will soon require that apps target API level 29 or higher. This will be required for new apps in August 2020, and for updates to existing apps in November 2020.";
                            int highest = context2.getClient().getHighestKnownApiLevel();
                            String label = Intrinsics.stringPlus((String)"Update targetSdkVersion to ", (Object)highest);
                            LintFix fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                            boolean bl2 = alreadySuppressed = !Intrinsics.areEqual((Object)issue, (Object)EXPIRING_TARGET_SDK_VERSION) && context2.containsCommentSuppress() && context2.isSuppressedWithComment(statementCookie, issue);
                            if (!alreadySuppressed) {
                                this.report(context2, statementCookie, issue, message2, fix, true);
                            }
                            warned = true;
                        }
                    }
                    if (!warned) {
                        String message3 = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                        int highest = context2.getClient().getHighestKnownApiLevel();
                        String label = Intrinsics.stringPlus((String)"Update targetSdkVersion to ", (Object)highest);
                        LintFix fix = this.fix().name(label).replace().text(value).with(String.valueOf(highest)).build();
                        GradleDetector.report$default(this, context2, statementCookie, ManifestDetector.TARGET_NEWER, message3, fix, false, 32, null);
                    }
                }
                if (version2 > 0) {
                    this.targetSdkVersion = version2;
                    this.checkTargetCompatibility(context2);
                } else {
                    this.checkIntegerAsString(context2, value, statementCookie);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion")) {
                version2 = this.getSdkVersion(value);
                if (version2 > 0) {
                    this.minSdkVersion = version2;
                    this.checkMinSdkVersion(context2, version2, statementCookie);
                } else {
                    this.checkIntegerAsString(context2, value, statementCookie);
                }
            }
            if (StringsKt.startsWith$default((String)value, (String)"0", (boolean)false, (int)2, null)) {
                this.checkOctal(context2, value, valueCookie);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionName") || Intrinsics.areEqual((Object)property, (Object)"versionCode") && !GradleContext.Companion.isNonNegativeInteger(value) || !GradleContext.Companion.isStringLiteral(value)) {
                if (Intrinsics.areEqual((Object)value, (Object)"getVersionCode") || Intrinsics.areEqual((Object)value, (Object)"getVersionName")) {
                    String message4 = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                    GradleDetector.report$default(this, context2, statementCookie, GRADLE_GETTER, message4, null, false, 48, null);
                }
            } else if (Intrinsics.areEqual((Object)property, (Object)"packageName")) {
                String message5 = "Deprecated: Replace 'packageName' with 'applicationId'";
                LintFix fix = this.fix().name("Replace 'packageName' with 'applicationId'", true).replace().text("packageName").with("applicationId").autoFix().build();
                GradleDetector.report$default(this, context2, propertyCookie, DEPRECATED, message5, fix, false, 32, null);
            }
            if (Intrinsics.areEqual((Object)property, (Object)"versionCode") && context2.isEnabled(HIGH_APP_VERSION_CODE) && GradleContext.Companion.isNonNegativeInteger(value) && (version = GradleContext.Companion.getIntLiteralValue(value, -1)) >= 2000000000) {
                String message6 = "The 'versionCode' is very high and close to the max allowed value";
                GradleDetector.report$default(this, context2, statementCookie, HIGH_APP_VERSION_CODE, message6, null, false, 48, null);
            }
        } else if ((Intrinsics.areEqual((Object)property, (Object)"compileSdkVersion") || Intrinsics.areEqual((Object)property, (Object)"compileSdk")) && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            int version = -1;
            if (GradleContext.Companion.isStringLiteral(value)) {
                String hash = GradleContext.Companion.getStringLiteralValue(value);
                if (hash != null && !Lint.isNumberString(hash)) {
                    AndroidVersion platformVersion;
                    if (Intrinsics.areEqual((Object)property, (Object)"compileSdk")) {
                        String message7 = "`compileSdk` does not support strings; did you mean `compileSdkPreview` ?";
                        LintFix fix = this.fix().replace().text("compileSdk").with("compileSdkPreview").build();
                        GradleDetector.report$default(this, context2, statementCookie, STRING_INTEGER, message7, fix, false, 32, null);
                    }
                    if ((platformVersion = AndroidTargetHash.getPlatformVersion((String)hash)) != null) {
                        version = platformVersion.getFeatureLevel();
                    }
                }
            } else {
                version = GradleContext.Companion.getIntLiteralValue(value, -1);
            }
            if (version > 0) {
                this.compileSdkVersion = version;
                this.compileSdkVersionCookie = statementCookie;
                this.checkTargetCompatibility(context2);
            } else {
                this.checkIntegerAsString(context2, value, statementCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"buildToolsVersion") && Intrinsics.areEqual((Object)parent, (Object)OLD_APP_PLUGIN_ID)) {
            GradleVersion version;
            String versionString = GradleContext.Companion.getStringLiteralValue(value);
            if (versionString != null && (version = GradleVersion.tryParse((String)versionString)) != null) {
                String message8;
                GradleVersion recommended = GradleDetector.Companion.getLatestBuildTools(context2.getClient(), version.getMajor());
                if (recommended != null && version.compareTo(recommended) < 0) {
                    message8 = "Old buildToolsVersion " + version + "; recommended version is " + recommended + " or later";
                    String string = version.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"version.toString()");
                    String string2 = string;
                    string = recommended.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"recommended.toString()");
                    LintFix fix = GradleDetector.getUpdateDependencyFix$default(this, string2, string, false, null, 12, null);
                    GradleDetector.report$default(this, context2, statementCookie, DEPENDENCY, message8, fix, false, 32, null);
                }
                if (version.getMajor() == 23 && version.getMinor() == 0 && version.getMicro() == 0 && context2.isEnabled(COMPATIBILITY)) {
                    if (recommended == null || recommended.getMajor() < 23) {
                        recommended = new GradleVersion(23, 0, 3);
                    }
                    message8 = "Build Tools `23.0.0` should not be used; it has some known serious bugs. Use version `" + recommended + "` instead.";
                    this.reportFatalCompatibilityIssue((Context)context2, statementCookie, message8);
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"plugins")) {
            if (Intrinsics.areEqual((Object)property, (Object)"id")) {
                String plugin = GradleContext.Companion.getStringLiteralValue(value);
                boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
                if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                    String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                    String message9 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                    LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                    GradleDetector.report$default(this, context2, valueCookie, DEPRECATED, message9, fix, false, 32, null);
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                    this.mAppliedKotlinAndroidPlugin = true;
                }
                if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                    this.mAppliedKotlinKaptPlugin = true;
                }
                if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                    this.mAppliedJavaPlugin = true;
                    this.mJavaPluginInfo = new JavaPluginInfo(statementCookie);
                }
            }
        } else if (Intrinsics.areEqual((Object)parent, (Object)"dependencies")) {
            if (StringsKt.startsWith$default((String)value, (String)"files('", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"')", (boolean)false, (int)2, null)) {
                String isOldAppPlugin = value;
                int replaceWith = "files('".length();
                int message9 = value.length() - 2;
                boolean fix = false;
                String string = isOldAppPlugin.substring(replaceWith, message9);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                String path2 = string;
                if (StringsKt.contains$default((CharSequence)path2, (CharSequence)"\\\\", (boolean)false, (int)2, null)) {
                    LintFix fix2 = this.fix().replace().text(path2).with(StringsKt.replace$default((String)path2, (String)"\\\\", (String)"/", (boolean)false, (int)4, null)).build();
                    String message10 = "Do not use Windows file separators in .gradle files; use / instead";
                    GradleDetector.report$default(this, context2, valueCookie, PATH, message10, fix2, false, 32, null);
                } else if (StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null) || new File(StringsKt.replace$default((String)path2, (char)'/', (char)File.separatorChar, (boolean)false, (int)4, null)).isAbsolute()) {
                    String message11 = "Avoid using absolute paths in .gradle files";
                    GradleDetector.report$default(this, context2, valueCookie, PATH, message11, null, false, 48, null);
                }
            } else {
                String dependency = GradleContext.Companion.getStringLiteralValue(value);
                if (dependency == null) {
                    dependency = Companion.getNamedDependency(value);
                }
                if (dependency != null) {
                    LintFix fix;
                    Object object;
                    Object message12;
                    Ref.ObjectRef gc2 = new Ref.ObjectRef();
                    gc2.element = GradleCoordinate.parseCoordinateString((String)dependency);
                    Ref.BooleanRef isResolved = new Ref.BooleanRef();
                    if (gc2.element != null && StringsKt.contains$default((CharSequence)dependency, (CharSequence)"$", (boolean)false, (int)2, null)) {
                        if (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && context2.isEnabled(NOT_INTERPOLATED)) {
                            message12 = "It looks like you are trying to substitute a version variable, but using single quotes ('). For Groovy string interpolation you must use double quotes (\").";
                            LintFix.ReplaceStringBuilder replaceStringBuilder = this.fix().name("Replace single quotes with double quotes").replace().text(value);
                            StringBuilder stringBuilder = new StringBuilder().append('\"');
                            object = value;
                            int n10 = 1;
                            int n11 = value.length() - 1;
                            boolean bl3 = false;
                            String string = ((String)object).substring(n10, n11);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            fix = replaceStringBuilder.with(stringBuilder.append(string).append('\"').toString()).build();
                            GradleDetector.report$default(this, context2, statementCookie, NOT_INTERPOLATED, (String)message12, fix, false, 32, null);
                        }
                        message12 = gc2.element;
                        Intrinsics.checkExpressionValueIsNotNull((Object)message12, (String)"gc");
                        gc2.element = this.resolveCoordinate(context2, property, (GradleCoordinate)message12);
                        isResolved.element = true;
                    }
                    if (gc2.element != null) {
                        if (((GradleCoordinate)gc2.element).acceptsGreaterRevisions()) {
                            message12 = "Avoid using + in version numbers; can lead to unpredictable and unrepeatable builds (" + dependency + ')';
                            LintFix.Builder builder = this.fix();
                            object = new Object[2];
                            object[0] = KEY_COORDINATE;
                            String string = ((GradleCoordinate)gc2.element).toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gc.toString()");
                            object[1] = string;
                            fix = builder.data((Object[])object);
                            GradleDetector.report$default(this, context2, valueCookie, PLUS, (String)message12, fix, false, 32, null);
                        }
                        context2.getDriver().runLaterOutsideReadAction(new Runnable(this, context2, (Ref.ObjectRef<GradleCoordinate>)gc2, isResolved, valueCookie, statementCookie){
                            final /* synthetic */ GradleDetector this$0;
                            final /* synthetic */ GradleContext $context;
                            final /* synthetic */ Ref.ObjectRef<GradleCoordinate> $gc;
                            final /* synthetic */ Ref.BooleanRef $isResolved;
                            final /* synthetic */ Object $valueCookie;
                            final /* synthetic */ Object $statementCookie;
                            {
                                this.this$0 = $receiver;
                                this.$context = $context;
                                this.$gc = $gc;
                                this.$isResolved = $isResolved;
                                this.$valueCookie = $valueCookie;
                                this.$statementCookie = $statementCookie;
                            }

                            public final void run() {
                                Object object = this.$gc.element;
                                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"gc");
                                GradleDetector.access$checkDependency(this.this$0, this.$context, (GradleCoordinate)object, this.$isResolved.element, this.$valueCookie, this.$statementCookie);
                            }
                        });
                    }
                    if (GradleDetector.Companion.hasLifecycleAnnotationProcessor(dependency) && GradleDetector.Companion.targetJava8Plus(context2.getProject())) {
                        GradleDetector.report$default(this, context2, valueCookie, LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8, "Use the Lifecycle Java 8 API provided by the `lifecycle-common-java8` library instead of Lifecycle annotations for faster incremental build.", null, false, 32, null);
                    }
                    this.checkAnnotationProcessorOnCompilePath(property, dependency, context2, propertyCookie);
                }
                this.checkDeprecatedConfigurations(property, context2, propertyCookie);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"packageNameSuffix")) {
            String message13 = "Deprecated: Replace 'packageNameSuffix' with 'applicationIdSuffix'";
            LintFix fix = this.fix().name("Replace 'packageNameSuffix' with 'applicationIdSuffix'", true).replace().text("packageNameSuffix").with("applicationIdSuffix").autoFix().build();
            GradleDetector.report$default(this, context2, propertyCookie, DEPRECATED, message13, fix, false, 32, null);
        } else if (Intrinsics.areEqual((Object)property, (Object)"applicationIdSuffix")) {
            String suffix = GradleContext.Companion.getStringLiteralValue(value);
            if (suffix != null && !StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null)) {
                String message14 = "Application ID suffix should probably start with a \".\"";
                GradleDetector.report$default(this, context2, statementCookie, PATH, message14, null, false, 48, null);
            }
        } else if (Intrinsics.areEqual((Object)property, (Object)"minSdkVersion") && Intrinsics.areEqual((Object)parent, (Object)"dev") && Intrinsics.areEqual((Object)"21", (Object)value) && !Intrinsics.areEqual((Object)"gradle", (Object)LintClient.Companion.getClientName())) {
            GradleDetector.report$default(this, context2, statementCookie, DEV_MODE_OBSOLETE, "You no longer need a `dev` mode to enable multi-dexing during development, and this can break API version checks", null, false, 48, null);
        } else if (Intrinsics.areEqual((Object)parent, (Object)"dataBinding") && (Intrinsics.areEqual((Object)property, (Object)"enabled") || Intrinsics.areEqual((Object)property, (Object)"isEnabled")) || Intrinsics.areEqual((Object)parent, (Object)"buildFeatures") && Intrinsics.areEqual((Object)property, (Object)"dataBinding")) {
            if (Intrinsics.areEqual((Object)value, (Object)"true") && this.mAppliedKotlinAndroidPlugin && !this.mAppliedKotlinKaptPlugin) {
                String message15 = "If you plan to use data binding in a Kotlin project, you should apply the kotlin-kapt plugin.";
                GradleDetector.report$default(this, context2, statementCookie, DATA_BINDING_WITHOUT_KAPT, message15, null, false, 32, null);
            }
        } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"sourceCompatibility")) {
            this.mDeclaredSourceCompatibility = true;
        } else if ((Intrinsics.areEqual((Object)parent, (Object)"") || Intrinsics.areEqual((Object)parent, (Object)"java")) && Intrinsics.areEqual((Object)property, (Object)"targetCompatibility")) {
            this.mDeclaredTargetCompatibility = true;
        }
    }

    private final void checkDeprecatedConfigurations(String configuration, GradleContext context2, Object propertyCookie) {
        DeprecatedConfiguration[] deprecatedConfigurationArray = context2.getProject().getGradleModelVersion();
        if (deprecatedConfigurationArray == null ? false : !deprecatedConfigurationArray.isAtLeastIncludingPreviews(3, 0, 0)) {
            return;
        }
        deprecatedConfigurationArray = DeprecatedConfiguration.values();
        int n10 = 0;
        int n11 = deprecatedConfigurationArray.length;
        while (n10 < n11) {
            DeprecatedConfiguration deprecatedConfiguration = deprecatedConfigurationArray[n10];
            ++n10;
            if (!deprecatedConfiguration.matches(configuration)) continue;
            if (deprecatedConfiguration == DeprecatedConfiguration.COMPILE && GradleDetector.Companion.suggestApiConfigurationUse(context2.getProject(), configuration)) {
                String implementation = null;
                String api = null;
                if (Intrinsics.areEqual((Object)configuration, (Object)"compile")) {
                    implementation = "implementation";
                    api = "api";
                } else {
                    String prefix = StringsKt.removeSuffix((String)configuration, (CharSequence)"Compile");
                    implementation = Intrinsics.stringPlus((String)prefix, (Object)"Implementation");
                    api = Intrinsics.stringPlus((String)prefix, (Object)"Api");
                }
                String message2 = '`' + configuration + "` is deprecated; replace with either `" + api + "` to maintain current behavior, or `" + implementation + "` to improve build performance by not sharing this dependency transitively.";
                LintFix apiFix = this.fix().name("Replace '" + configuration + "' with '" + api + '\'').family("Replace compile with api").replace().text(configuration).with(api).autoFix().build();
                LintFix implementationFix = this.fix().name("Replace '" + configuration + "' with '" + implementation + '\'').family("Replace compile with implementation").replace().text(configuration).with(implementation).autoFix().build();
                LintFix fixes = this.fix().alternatives().name("Replace '" + configuration + "' with '" + api + "' or '" + implementation + '\'').add(apiFix).add(implementationFix).build();
                GradleDetector.report$default(this, context2, propertyCookie, DEPRECATED_CONFIGURATION, message2, fixes, false, 32, null);
                continue;
            }
            String replacement = deprecatedConfiguration.replacement(configuration);
            String message3 = '`' + configuration + "` is deprecated; replace with `" + replacement + '`';
            LintFix fix = this.fix().name("Replace '" + configuration + "' with '" + replacement + '\'').family("Replace deprecated configurations").replace().text(configuration).with(replacement).autoFix().build();
            GradleDetector.report$default(this, context2, propertyCookie, DEPRECATED_CONFIGURATION, message3, fix, false, 32, null);
        }
    }

    private final void checkAnnotationProcessorOnCompilePath(String configuration, String dependency, GradleContext context2, Object propertyCookie) {
        for (Companion.CompileConfiguration compileConfiguration : Companion.CompileConfiguration.values()) {
            if (!compileConfiguration.matches(configuration) || !GradleDetector.Companion.isCommonAnnotationProcessor(dependency)) continue;
            String replacement = compileConfiguration.replacement(configuration);
            LintFix fix = this.fix().name("Replace " + configuration + " with " + replacement).family("Replace compile classpath with annotationProcessor").replace().text(configuration).with(replacement).autoFix().build();
            String message2 = "Add annotation processor to processor path using `" + replacement + "` instead of `" + configuration + '`';
            GradleDetector.report$default(this, context2, propertyCookie, ANNOTATION_PROCESSOR_ON_COMPILE_PATH, message2, fix, false, 32, null);
        }
    }

    private final void checkMinSdkVersion(GradleContext context2, int version, Object valueCookie) {
        boolean bl2 = 1 <= version ? version < 16 : false;
        if (bl2) {
            String message2 = "The value of minSdkVersion is too low. It can be incremented without noticeably reducing the number of supported devices.";
            String label = "Update minSdkVersion to 16";
            LintFix fix = this.fix().name(label).replace().text(String.valueOf(version)).with("16").build();
            GradleDetector.report$default(this, context2, valueCookie, MIN_SDK_TOO_LOW, message2, fix, false, 32, null);
        }
    }

    private final void checkIntegerAsString(GradleContext context2, String value, Object cookie) {
        String string = GradleContext.Companion.getStringLiteralValue(value);
        if (Lint.isNumberString(string)) {
            String message2 = "Use an integer rather than a string here (replace " + value + " with just " + string + ')';
            LintFix fix = this.fix().name("Replace with integer", true).replace().text(value).with(string).build();
            GradleDetector.report$default(this, context2, cookie, STRING_INTEGER, message2, fix, false, 32, null);
        }
    }

    @Override
    public void checkMethodCall(@NotNull GradleContext context2, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)statement, (String)"statement");
        Intrinsics.checkParameterIsNotNull(namedArguments, (String)"namedArguments");
        Intrinsics.checkParameterIsNotNull(unnamedArguments, (String)"unnamedArguments");
        Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
        String plugin = namedArguments.get("plugin");
        if (Intrinsics.areEqual((Object)statement, (Object)"apply") && parent == null) {
            boolean isOldAppPlugin = Intrinsics.areEqual((Object)OLD_APP_PLUGIN_ID, (Object)plugin);
            if (isOldAppPlugin || Intrinsics.areEqual((Object)OLD_LIB_PLUGIN_ID, (Object)plugin)) {
                String replaceWith = isOldAppPlugin ? APP_PLUGIN_ID : LIB_PLUGIN_ID;
                String message2 = '\'' + plugin + "' is deprecated; use '" + replaceWith + "' instead";
                LintFix fix = this.fix().sharedName("Replace plugin").replace().text(plugin).with(replaceWith).autoFix().build();
                GradleDetector.report$default(this, context2, cookie, DEPRECATED, message2, fix, false, 32, null);
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-android")) {
                this.mAppliedKotlinAndroidPlugin = true;
            }
            if (Intrinsics.areEqual((Object)plugin, (Object)"kotlin-kapt")) {
                this.mAppliedKotlinKaptPlugin = true;
            }
            if (CollectionsKt.contains((Iterable)JAVA_PLUGIN_IDS, (Object)plugin)) {
                this.mAppliedJavaPlugin = true;
                this.mJavaPluginInfo = new JavaPluginInfo(cookie);
            }
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"google") && Intrinsics.areEqual((Object)parent, (Object)"repositories") && Intrinsics.areEqual((Object)parentParent, (Object)"buildscript")) {
            this.mDeclaredGoogleMavenRepository = true;
            this.maybeReportAgpVersionIssue(context2);
        }
        if (Intrinsics.areEqual((Object)statement, (Object)"jcenter") && Intrinsics.areEqual((Object)parent, (Object)"repositories")) {
            String message3 = "JCenter Maven repository is no longer receiving updates: newer library versions may be available elsewhere";
            LintFix replaceFix = this.fix().name("Replace with mavenCentral").replace().text("jcenter").with("mavenCentral").build();
            LintFix deleteFix = this.fix().name("Delete this repository declaration").replace().all().with("").build();
            LintFix[] lintFixArray = new LintFix[]{replaceFix, deleteFix};
            GradleDetector.report$default(this, context2, cookie, JCENTER_REPOSITORY_OBSOLETE, message3, this.fix().alternatives(lintFixArray), false, 32, null);
        }
    }

    private final void checkTargetCompatibility(GradleContext context2) {
        if (this.compileSdkVersion > 0 && this.targetSdkVersion > 0 && this.targetSdkVersion > this.compileSdkVersion) {
            String message2 = "The compileSdkVersion (" + this.compileSdkVersion + ") should not be lower than the targetSdkVersion (" + this.targetSdkVersion + ')';
            LintFix fix = this.fix().name(Intrinsics.stringPlus((String)"Set compileSdkVersion to ", (Object)this.targetSdkVersion)).replace().text(String.valueOf(this.compileSdkVersion)).with(String.valueOf(this.targetSdkVersion)).build();
            Context context3 = context2;
            Object object = this.compileSdkVersionCookie;
            if (object == null) {
                Intrinsics.throwNpe();
            }
            this.reportNonFatalCompatibilityIssue(context3, object, message2, fix);
        }
    }

    private final void checkDependency(GradleContext context2, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        GradleVersion latest;
        LintFix fix;
        DeprecatedSdkRegistry sdkRegistry;
        DeprecatedSdkRegistry.DeprecatedLibrary deprecated;
        List<LintModelDependency> path2;
        GradleVersion version = dependency.getVersion();
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        String revision = dependency.getRevision();
        GradleVersion safeReplacement = null;
        if (version == null) {
            return;
        }
        Ref.ObjectRef newerVersion = new Ref.ObjectRef();
        Intrinsics.checkExpressionValueIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkExpressionValueIsNotNull((Object)revision, (String)"revision");
        Predicate<GradleVersion> filter = this.getUpgradeVersionFilter(context2, groupId, artifactId, revision);
        switch (groupId) {
            case "com.google.android.gms": 
            case "com.google.android.wearable": 
            case "com.google.firebase": 
            case "com.google.android.support": {
                this.checkPlayServices(context2, dependency, version, revision, cookie, statementCookie);
                break;
            }
            case "com.android.tools.build": {
                GradleVersion.VersionSegment versionSegment;
                if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) break;
                if (this.checkGradlePluginDependency(context2, dependency, statementCookie)) {
                    return;
                }
                newerVersion.element = GradleVersion.max((GradleVersion)version, (GradleVersion)this.getGoogleMavenRepoVersion(context2, dependency, filter));
                newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
                newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context2.getClient().getHighestKnownVersion(dependency, filter));
                if (!(newerVersion.element == null || version.isPreview() || Intrinsics.areEqual((Object)newerVersion.element, (Object)version) || !((versionSegment = version.getMinorSegment()) == null ? false : !versionSegment.acceptsGreaterValue()) || version.getMajor() == ((GradleVersion)newerVersion.element).getMajor() && version.getMinor() == ((GradleVersion)newerVersion.element).getMinor())) {
                    safeReplacement = this.getGoogleMavenRepoVersion(context2, dependency, new Predicate(version, (Ref.ObjectRef<GradleVersion>)newerVersion){
                        final /* synthetic */ GradleVersion $version;
                        final /* synthetic */ Ref.ObjectRef<GradleVersion> $newerVersion;
                        {
                            this.$version = $version;
                            this.$newerVersion = $newerVersion;
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final boolean test(@NotNull GradleVersion filterVersion) {
                            Intrinsics.checkParameterIsNotNull((Object)filterVersion, (String)"filterVersion");
                            if (filterVersion.getMajor() != this.$version.getMajor()) return false;
                            if (filterVersion.getMinor() != this.$version.getMinor()) return false;
                            if (filterVersion.getMicro() <= this.$version.getMicro()) return false;
                            if (filterVersion.isPreview()) return false;
                            Object object = this.$newerVersion.element;
                            if (object == null) {
                                Intrinsics.throwNpe();
                            }
                            if (filterVersion.compareTo((GradleVersion)object) >= 0) return false;
                            if (filterVersion.isSnapshot()) return false;
                            return true;
                        }
                    });
                }
                if (newerVersion.element != null && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
                    this.agpVersionCheckInfo = new AgpVersionCheckInfo((GradleVersion)newerVersion.element, ((GradleVersion)newerVersion.element).getMajor() == version.getMajor() && ((GradleVersion)newerVersion.element).getMinor() == version.getMinor(), safeReplacement, dependency, isResolved, statementCookie);
                    this.maybeReportAgpVersionIssue(context2);
                }
                return;
            }
            case "com.google.guava": {
                if (!Intrinsics.areEqual((Object)"guava", (Object)artifactId)) break;
                newerVersion.element = this.getNewerVersion(version, 21, 0);
                break;
            }
            case "com.google.code.gson": {
                if (!Intrinsics.areEqual((Object)"gson", (Object)artifactId)) break;
                newerVersion.element = this.getNewerVersion(version, 2, 8, 2);
                break;
            }
            case "org.apache.httpcomponents": {
                if (!Intrinsics.areEqual((Object)"httpclient", (Object)artifactId)) break;
                newerVersion.element = this.getNewerVersion(version, 4, 5, 5);
                break;
            }
            case "com.squareup.okhttp3": {
                if (!Intrinsics.areEqual((Object)"okhttp", (Object)artifactId)) break;
                newerVersion.element = this.getNewerVersion(version, 3, 10, 0);
                break;
            }
            case "com.github.bumptech.glide": {
                if (!Intrinsics.areEqual((Object)"glide", (Object)artifactId)) break;
                newerVersion.element = this.getNewerVersion(version, 3, 7, 0);
                break;
            }
            case "io.fabric.tools": {
                Object fix2;
                if (!Intrinsics.areEqual((Object)"gradle", (Object)artifactId)) break;
                GradleVersion parsed = GradleVersion.tryParse((String)revision);
                if (parsed != null && parsed.compareTo("1.21.6") < 0) {
                    fix2 = GradleDetector.getUpdateDependencyFix$default(this, revision, "1.22.1", false, null, 12, null);
                    GradleDetector.report$default(this, context2, statementCookie, DEPENDENCY, "Use Fabric Gradle plugin version 1.21.6 or later to improve Instant Run performance (was " + revision + ')', (LintFix)fix2, false, 32, null);
                    break;
                }
                newerVersion.element = this.getNewerVersion(version, new GradleVersion(1, 25, 1));
                break;
            }
            case "com.bugsnag": {
                Object fix3;
                if (!Intrinsics.areEqual((Object)"bugsnag-android-gradle-plugin", (Object)artifactId)) break;
                if (!version.isAtLeast(2, 1, 2)) {
                    fix3 = GradleDetector.getUpdateDependencyFix$default(this, revision, "2.4.1", false, null, 12, null);
                    GradleDetector.report$default(this, context2, statementCookie, DEPENDENCY, "Use BugSnag Gradle plugin version 2.1.2 or later to improve Instant Run performance (was " + revision + ')', (LintFix)fix3, false, 32, null);
                    break;
                }
                newerVersion.element = this.getNewerVersion(version, 3, 2, 5);
                break;
            }
            case "org.robolectric": {
                if (!Intrinsics.areEqual((Object)"robolectric", (Object)artifactId)) break;
                Object fix3 = System.getProperty("os.name");
                Intrinsics.checkExpressionValueIsNotNull((Object)fix3, (String)"getProperty(\"os.name\")");
                Object fix2 = Locale.US;
                Intrinsics.checkExpressionValueIsNotNull((Object)fix2, (String)"US");
                boolean bl2 = false;
                Object object = fix3;
                boolean bl3 = false;
                String string = ((String)object).toLowerCase((Locale)fix2);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
                if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"windows", (boolean)false, (int)2, null) || version.isAtLeast(4, 2, 1)) break;
                fix3 = GradleDetector.getUpdateDependencyFix$default(this, revision, "4.2.1", false, null, 12, null);
                GradleDetector.report$default(this, context2, cookie, DEPENDENCY, "Use robolectric version 4.2.1 or later to fix issues with parsing of Windows paths", (LintFix)fix3, false, 32, null);
                break;
            }
            case "org.jetbrains.kotlin": {
                if (!Intrinsics.areEqual((Object)artifactId, (Object)"kotlin-gradle-plugin")) break;
                return;
            }
        }
        this.checkForKtxExtension(context2, groupId, artifactId, version, cookie);
        BlockedDependencies blockedDependencies = this.blockedDependencies.get(context2.getProject());
        if (blockedDependencies != null && (path2 = blockedDependencies.checkDependency(groupId, artifactId, true)) != null) {
            String message2 = this.getBlockedDependencyMessage(path2);
            LintFix fix4 = this.fix().name("Delete dependency").replace().all().build();
            this.report(context2, statementCookie, DUPLICATE_CLASSES, message2, fix4, true);
        }
        if ((deprecated = (sdkRegistry = this.getDeprecatedLibraryLookup(context2.getClient())).getVersionInfo(dependency)) != null) {
            String prefix = null;
            Issue issue = null;
            if (Intrinsics.areEqual((Object)deprecated.getStatus(), (Object)"insecure")) {
                prefix = "This version is known to be insecure.";
                issue = RISKY_LIBRARY;
            } else {
                prefix = "This version is " + deprecated.getStatus() + '.';
                issue = DEPRECATED_LIBRARY;
            }
            String suffix = null;
            fix = null;
            String recommended = deprecated.getRecommended();
            if (recommended != null) {
                suffix = " Consider switching to recommended version " + recommended + '.';
                String string = dependency.getRevision();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"dependency.revision");
                fix = GradleDetector.getUpdateDependencyFix$default(this, string, recommended, false, null, 12, null);
            } else {
                suffix = "";
                fix = null;
            }
            CharSequence charSequence = deprecated.getMessage();
            boolean bl4 = false;
            String separatorDot = charSequence.length() > 0 && !StringsKt.endsWith$default((String)deprecated.getMessage(), (String)".", (boolean)false, (int)2, null) ? "." : "";
            String message3 = prefix + " Details: " + deprecated.getMessage() + separatorDot + suffix;
            GradleDetector.report$default(this, context2, cookie, issue, message3, fix, false, 32, null);
        } else {
            GradleVersion recommended = sdkRegistry.getRecommendedVersion(dependency);
            if (recommended != null && (newerVersion.element == null || recommended.compareTo((GradleVersion)newerVersion.element) > 0)) {
                newerVersion.element = recommended;
            }
        }
        Issue issue = DEPENDENCY;
        if (context2.getScope().size() > 1 && context2.isEnabled(REMOTE_VERSION) && !StringsKt.startsWith$default((String)groupId, (String)"androidx.", (boolean)false, (int)2, null) && (latest = Companion.getLatestVersionFromRemoteRepo(context2.getClient(), dependency, filter, dependency.isPreview())) != null && version.compareTo(latest) < 0) {
            newerVersion.element = latest;
            issue = REMOTE_VERSION;
        }
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.findCachedNewerVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)context2.getClient().getHighestKnownVersion(dependency, filter));
        newerVersion.element = GradleVersion.max((GradleVersion)((GradleVersion)newerVersion.element), (GradleVersion)this.getGoogleMavenRepoVersion(context2, dependency, filter));
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.support") || Intrinsics.areEqual((Object)groupId, (Object)"com.android.support.test")) {
            this.checkSupportLibraries(context2, dependency, version, (GradleVersion)newerVersion.element, cookie);
        }
        if (newerVersion.element != null && version.compareTo(new GradleVersion(0, 0, 0)) > 0 && ((GradleVersion)newerVersion.element).compareTo(version) > 0) {
            String suffix = ((GradleVersion)newerVersion.element).toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)suffix, (String)"newerVersion.toString()");
            String versionString = suffix;
            String message4 = this.getNewerVersionAvailableMessage(dependency, versionString, null);
            fix = !isResolved ? GradleDetector.getUpdateDependencyFix$default(this, revision, versionString, false, null, 12, null) : null;
            GradleDetector.report$default(this, context2, cookie, issue, message4, fix, false, 32, null);
        }
    }

    private final Predicate<GradleVersion> getUpgradeVersionFilter(GradleContext context2, String groupId, String artifactId, String revision) {
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId)) {
            if (this.compileSdkVersion >= 18) {
                return new Predicate(this){
                    final /* synthetic */ GradleDetector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                        return version.getMajor() == GradleDetector.access$getCompileSdkVersion$p(this.this$0);
                    }
                };
            }
            if (this.targetSdkVersion > 0) {
                return new Predicate(this){
                    final /* synthetic */ GradleDetector this$0;
                    {
                        this.this$0 = $receiver;
                    }

                    public final boolean test(@NotNull GradleVersion version) {
                        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
                        return version.getMajor() >= GradleDetector.access$getTargetSdkVersion$p(this.this$0);
                    }
                };
            }
        }
        if (Intrinsics.areEqual((Object)groupId, (Object)"com.android.tools.build") && LintClient.Companion.isStudio()) {
            String string = context2.getClient().getClientRevision();
            if (string == null) {
                return null;
            }
            String clientRevision = string;
            GradleVersion ideVersion = GradleVersion.parse((String)clientRevision);
            GradleVersion version = GradleVersion.parse((String)revision);
            return new Predicate(ideVersion, version){
                final /* synthetic */ GradleVersion $ideVersion;
                final /* synthetic */ GradleVersion $version;
                {
                    this.$ideVersion = $ideVersion;
                    this.$version = $version;
                }

                public final boolean test(@NotNull GradleVersion v10) {
                    Intrinsics.checkParameterIsNotNull((Object)v10, (String)"v");
                    return v10.getMajor() == this.$ideVersion.getMajor() && v10.getMinor() == this.$ideVersion.getMinor() || v10.getMajor() == this.$version.getMajor() && v10.getMinor() == this.$version.getMinor();
                }
            };
        }
        return null;
    }

    @NotNull
    protected final File getArtifactCacheHome() {
        File file;
        File file2 = this.artifactCacheHome;
        if (file2 == null) {
            File home;
            GradleDetector gradleDetector = this;
            boolean bl2 = false;
            boolean bl3 = false;
            GradleDetector $this$getArtifactCacheHome_u24lambda_u2d0 = gradleDetector;
            boolean bl4 = false;
            $this$getArtifactCacheHome_u24lambda_u2d0.artifactCacheHome = home = new File($this$getArtifactCacheHome_u24lambda_u2d0.getGradleUserHome(), "caches" + File.separator + "modules-2" + File.separator + "files-2.1");
            file = home;
        } else {
            file = file2;
        }
        return file;
    }

    private final GradleVersion findCachedNewerVersion(GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        Path versionDir = this.getArtifactCacheHome().toPath().resolve(dependency.getGroupId() + File.separator + dependency.getArtifactId());
        return CancellableFileIo.exists((Path)versionDir, (LinkOption[])new LinkOption[0]) ? MavenRepositories.getHighestVersion((Path)versionDir, filter, (boolean)MavenRepositories.isPreview((GradleCoordinate)dependency)) : null;
    }

    private final void ensureTargetCompatibleWithO(GradleContext context2, GradleVersion version, Object cookie, int major, int minor, int micro) {
        if (version != null && !version.isAtLeast(major, minor, micro)) {
            GradleVersion revision = new GradleVersion(major, minor, micro);
            GradleVersion newest = this.getNewerVersion(version, revision);
            if (newest != null) {
                revision = newest;
            }
            String message2 = "Version must be at least " + revision + " when targeting O";
            this.reportFatalCompatibilityIssue((Context)context2, cookie, message2);
        }
    }

    private final boolean checkGradlePluginDependency(GradleContext context2, GradleCoordinate dependency, Object cookie) {
        GradleCoordinate minimum = GradleCoordinate.parseCoordinateString((String)"com.android.tools.build:gradle:1.0.0");
        if (minimum != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, minimum) < 0) {
            GradleVersion recommended = GradleVersion.max((GradleVersion)this.getGoogleMavenRepoVersion(context2, minimum, null), (GradleVersion)GradleVersion.tryParse((String)"3.3.2"));
            String message2 = Intrinsics.stringPlus((String)"You must use a newer version of the Android Gradle plugin. The minimum supported version is 1.0.0 and the recommended version is ", (Object)recommended);
            GradleDetector.report$default(this, context2, cookie, GRADLE_PLUGIN_COMPATIBILITY, message2, null, false, 48, null);
            return true;
        }
        return false;
    }

    private final void checkSupportLibraries(GradleContext context2, GradleCoordinate dependency, GradleVersion version, GradleVersion newerVersion, Object cookie) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        Intrinsics.checkExpressionValueIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkExpressionValueIsNotNull((Object)artifactId, (String)"artifactId");
        if (this.isSupportLibraryDependentOnCompileSdk(groupId, artifactId) && this.compileSdkVersion >= 18 && dependency.getMajorVersion() != this.compileSdkVersion && dependency.getMajorVersion() != -1 && context2.isEnabled(COMPATIBILITY)) {
            if (this.compileSdkVersion >= 29 && dependency.getMajorVersion() < 29) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "Version 28 (intended for Android Pie and below) is the last version of the legacy support library, so we recommend that you migrate to AndroidX libraries when using Android Q and moving forward. The IDE can help with this: Refactor > Migrate to AndroidX...", null, 8, null);
                return;
            }
            LintFix fix = null;
            if (newerVersion != null) {
                fix = this.fix().name(Intrinsics.stringPlus((String)"Replace with ", (Object)newerVersion)).replace().text(version.toString()).with(newerVersion.toString()).build();
            }
            String message2 = "This support library should not use a different version (" + dependency.getMajorVersion() + ") than the `compileSdkVersion` (" + this.compileSdkVersion + ')';
            this.reportNonFatalCompatibilityIssue(context2, cookie, message2, fix);
        }
        if (!(this.mCheckedSupportLibs || StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations"))) {
            this.mCheckedSupportLibs = true;
            if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES) && context2.isGlobalAnalysis()) {
                this.checkConsistentSupportLibraries(context2, cookie);
            }
        }
        if (Intrinsics.areEqual((Object)"appcompat-v7", (Object)artifactId)) {
            IAndroidTarget buildTarget;
            boolean compile26Beta;
            boolean supportLib26Beta = version.isAtLeast(26, 0, 0, "beta", 1, true);
            boolean bl2 = compile26Beta = this.compileSdkVersion >= 26;
            if (this.compileSdkVersion == 26 && (buildTarget = context2.getProject().getBuildTarget()) != null && buildTarget.getVersion().isPreview()) {
                boolean bl3 = compile26Beta = buildTarget.getRevision() != 1;
            }
            if (supportLib26Beta && !compile26Beta && this.compileSdkVersion == version.getMajor()) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "When using a `compileSdkVersion` older than android-O revision 2, the support library version must be 26.0.0-alpha1 or lower (was " + version + ')', null, 8, null);
            } else if (!supportLib26Beta && compile26Beta) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, "When using a `compileSdkVersion` android-O revision 2 or higher, the support library version should be 26.0.0-beta1 or higher (was " + version + ')', null, 8, null);
            }
        }
    }

    private final void checkPlayServices(GradleContext context2, GradleCoordinate dependency, GradleVersion version, String revision, Object cookie, Object statementCookie) {
        String message2;
        LintFix fix;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        if (Intrinsics.areEqual((Object)"5.2.08", (Object)revision) && context2.isEnabled(COMPATIBILITY)) {
            GradleVersion maxVersion = GradleVersion.max((GradleVersion)GradleVersion.parse((String)"10.2.1"), (GradleVersion)this.getGoogleMavenRepoVersion(context2, dependency, null));
            String string = maxVersion.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"maxVersion.toString()");
            fix = GradleDetector.getUpdateDependencyFix$default(this, revision, string, false, null, 12, null);
            String message3 = "Version `5.2.08` should not be used; the app can not be published with this version. Use version `" + maxVersion + "` instead.";
            this.reportFatalCompatibilityIssue(context2, cookie, message3, fix);
        }
        if (context2.isEnabled(BUNDLED_GMS) && PLAY_SERVICES_V650.isSameArtifact(dependency) && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, PLAY_SERVICES_V650) >= 0) {
            message2 = "Avoid using bundled version of Google Play services SDK.";
            GradleDetector.report$default(this, context2, cookie, BUNDLED_GMS, message2, null, false, 48, null);
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-appindexing", (Object)artifactId)) {
            message2 = "Deprecated: Replace 'com.google.android.gms:play-services-appindexing:" + revision + "' with 'com.google.firebase:firebase-appindexing:10.0.0' or above. More info: http://firebase.google.com/docs/app-indexing/android/migrate";
            fix = this.fix().name("Replace with Firebase").replace().text(Intrinsics.stringPlus((String)"com.google.android.gms:play-services-appindexing:", (Object)revision)).with("com.google.firebase:firebase-appindexing:10.2.1").build();
            GradleDetector.report$default(this, context2, cookie, DEPRECATED, message2, fix, false, 32, null);
        }
        if (this.targetSdkVersion >= 26) {
            if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"play-services-gcm", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId) && Intrinsics.areEqual((Object)"firebase-messaging", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 10, 2, 1);
            } else if (Intrinsics.areEqual((Object)"firebase-jobdispatcher", (Object)artifactId) || Intrinsics.areEqual((Object)"firebase-jobdispatcher-with-gcm-dep", (Object)artifactId)) {
                this.ensureTargetCompatibleWithO(context2, version, cookie, 0, 6, 0);
            }
        }
        if (Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) || Intrinsics.areEqual((Object)FIREBASE_GROUP_ID, (Object)groupId)) {
            if (!this.mCheckedGms) {
                this.mCheckedGms = true;
                if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES) && context2.isGlobalAnalysis()) {
                    this.checkConsistentPlayServices(context2, cookie);
                }
            }
        } else if (!this.mCheckedWearableLibs) {
            this.mCheckedWearableLibs = true;
            if (!context2.getScope().contains((Object)Scope.ALL_RESOURCE_FILES) && context2.isGlobalAnalysis()) {
                this.checkConsistentWearableLibraries(context2, cookie, statementCookie);
            }
        }
    }

    private final boolean isSupportLibArtifact(LintModelMavenName $this$isSupportLibArtifact) {
        return this.isSupportLibraryDependentOnCompileSdk($this$isSupportLibArtifact.getGroupId(), $this$isSupportLibArtifact.getArtifactId());
    }

    private final boolean isAndroidxArtifact(LintModelMavenName $this$isAndroidxArtifact) {
        return StringsKt.startsWith$default((String)$this$isAndroidxArtifact.getGroupId(), (String)"androidx.", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)$this$isAndroidxArtifact.getGroupId(), (Object)"androidx.navigation");
    }

    private final void checkConsistentSupportLibraries(Context context2, Object cookie) {
        Iterator $this$filterIsInstanceTo$iv$iv;
        this.checkConsistentLibraries(context2, cookie, "com.android.support", null);
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(context2.getProject());
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        Iterator iterator = $this$filterIsInstanceTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv$iv = iterator.next();
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List androidLibraries = (List)destination$iv$iv;
        LintModelMavenName usesOldSupportLib = null;
        LintModelMavenName usesAndroidX = null;
        for (LintModelExternalLibrary library2 : androidLibraries) {
            LintModelMavenName coordinates = library2.getResolvedCoordinates();
            if (usesOldSupportLib == null && this.isSupportLibArtifact(coordinates)) {
                usesOldSupportLib = coordinates;
            }
            if (usesAndroidX == null && this.isAndroidxArtifact(coordinates)) {
                usesAndroidX = coordinates;
            }
            if (usesOldSupportLib == null || usesAndroidX == null) continue;
        }
        if (usesOldSupportLib != null && usesAndroidX != null) {
            String message2 = "Dependencies using groupId `com.android.support` and `androidx.*` can not be combined but found `" + usesOldSupportLib + "` and `" + usesAndroidX + "` incompatible dependencies";
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, message2, null, 8, null);
            } else {
                Location location = Companion.getDependencyLocation(context2, usesOldSupportLib, usesAndroidX);
                this.reportNonFatalCompatibilityIssue(context2, location, message2);
            }
        }
    }

    private final void checkConsistentPlayServices(Context context2, Object cookie) {
        this.checkConsistentLibraries(context2, cookie, GMS_GROUP_ID, FIREBASE_GROUP_ID);
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentWearableLibraries(Context context2, Object cookie, Object statementCookie) {
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context2.getMainProject();
        if (!project.isGradleProject()) {
            return;
        }
        HashSet<String> supportVersions = new HashSet<String>();
        HashSet<String> wearableVersions = new HashSet<String>();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        for (LintModelExternalLibrary library2 : (List)destination$iv$iv) {
            LintModelMavenName coordinates = library2.getResolvedCoordinates();
            if (Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) && Intrinsics.areEqual((Object)GOOGLE_SUPPORT_GROUP_ID, (Object)coordinates.getGroupId())) {
                supportVersions.add(coordinates.getVersion());
            }
            if (!Intrinsics.areEqual((Object)WEARABLE_ARTIFACT_ID, (Object)coordinates.getArtifactId()) || !Intrinsics.areEqual((Object)ANDROID_WEAR_GROUP_ID, (Object)coordinates.getGroupId())) continue;
            if (!library2.getProvided()) {
                String message2 = "This dependency should be marked as `compileOnly`, not `compile`";
                if (statementCookie != null) {
                    this.reportFatalCompatibilityIssue(context2, statementCookie, message2);
                } else {
                    Location location = Companion.getDependencyLocation(context2, coordinates);
                    if (location.getStart() == null) {
                        message2 = "The com.google.android.wearable:wearable dependency should be marked as `compileOnly`, not `compile`";
                    }
                    this.reportFatalCompatibilityIssue(context2, location, message2);
                }
            }
            wearableVersions.add(coordinates.getVersion());
        }
        Collection collection = supportVersions;
        boolean library2 = false;
        if (!collection.isEmpty()) {
            Object location;
            if (wearableVersions.isEmpty()) {
                ArrayList list2 = new ArrayList(supportVersions);
                String first = (String)Collections.min(list2);
                String message3 = "Project depends on com.google.android.support:wearable:" + first + ", so it must also depend (as a provided dependency) on com.google.android.wearable:wearable:" + first;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context2, cookie, message3);
                } else {
                    Intrinsics.checkExpressionValueIsNotNull((Object)first, (String)"first");
                    location = Companion.getDependencyLocation(context2, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, first);
                    this.reportFatalCompatibilityIssue(context2, (Location)location, message3);
                }
            } else if (!Intrinsics.areEqual(supportVersions, wearableVersions)) {
                ArrayList sortedSupportVersions = new ArrayList(supportVersions);
                CollectionsKt.sort((List)sortedSupportVersions);
                ArrayList supportedWearableVersions = new ArrayList(wearableVersions);
                CollectionsKt.sort((List)supportedWearableVersions);
                location = StringCompanionObject.INSTANCE;
                String string = "The wearable libraries for %1$s and %2$s must use **exactly** the same versions; found %3$s and %4$s";
                Object[] objectArray = new Object[]{GOOGLE_SUPPORT_GROUP_ID, ANDROID_WEAR_GROUP_ID, sortedSupportVersions.size() == 1 ? (String)sortedSupportVersions.get(0) : sortedSupportVersions.toString(), supportedWearableVersions.size() == 1 ? (String)supportedWearableVersions.get(0) : supportedWearableVersions.toString()};
                boolean bl2 = false;
                String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"java.lang.String.format(format, *args)");
                String message4 = string2;
                if (cookie != null) {
                    this.reportFatalCompatibilityIssue(context2, cookie, message4);
                } else {
                    string = sortedSupportVersions.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sortedSupportVersions[0]");
                    string = supportedWearableVersions.get(0);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"supportedWearableVersions[0]");
                    location = com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(Companion, context2, GOOGLE_SUPPORT_GROUP_ID, WEARABLE_ARTIFACT_ID, string, ANDROID_WEAR_GROUP_ID, WEARABLE_ARTIFACT_ID, string, null, 128, null);
                    this.reportFatalCompatibilityIssue(context2, (Location)location, message4);
                }
            }
        }
    }

    private final List<LintModelLibrary> getAllLibraries(Project project) {
        LintModelDependencies lintModelDependencies;
        LintModelAndroidArtifact lintModelAndroidArtifact;
        LintModelVariant lintModelVariant = project.getBuildVariant();
        List<LintModelLibrary> list2 = lintModelVariant == null ? null : ((lintModelAndroidArtifact = lintModelVariant.getMainArtifact()) == null ? null : ((lintModelDependencies = lintModelAndroidArtifact.getDependencies()) == null ? null : lintModelDependencies.getAll()));
        return list2 == null ? CollectionsKt.emptyList() : list2;
    }

    /*
     * WARNING - void declaration
     */
    private final void checkConsistentLibraries(Context context2, Object cookie, String groupId, String groupId2) {
        Object coordinates;
        void $this$filterIsInstanceTo$iv$iv;
        Project project = context2.getMainProject();
        ArrayListMultimap versionToCoordinate = ArrayListMultimap.create();
        Iterable $this$filterIsInstance$iv = this.getAllLibraries(project);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo2 = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof LintModelExternalLibrary)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List allLibraries = (List)destination$iv$iv;
        for (LintModelExternalLibrary library2 : allLibraries) {
            coordinates = library2.getResolvedCoordinates();
            if (!Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId) && !Intrinsics.areEqual((Object)coordinates.getGroupId(), (Object)groupId2) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"multidex", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"renderscript", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)coordinates.getArtifactId(), (String)"firebase-jobdispatcher", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)coordinates.getArtifactId(), (Object)"support-annotations")) continue;
            versionToCoordinate.put((Object)coordinates.getVersion(), coordinates);
        }
        Set versions = versionToCoordinate.keySet();
        if (versions.size() > 1) {
            Object object;
            LintModelDependencies lintModelDependencies;
            Object object2;
            GradleVersion version;
            ArrayList sortedVersions = new ArrayList(versions);
            List list2 = sortedVersions;
            coordinates = Collections.reverseOrder();
            Intrinsics.checkExpressionValueIsNotNull((Object)coordinates, (String)"reverseOrder()");
            CollectionsKt.sortWith((List)list2, (Comparator)coordinates);
            destination$iv$iv = versionToCoordinate.get(sortedVersions.get(0));
            Intrinsics.checkExpressionValueIsNotNull((Object)destination$iv$iv, (String)"versionToCoordinate.get(sortedVersions[0])");
            LintModelMavenName c12 = this.findFirst(destination$iv$iv);
            List $i$f$filterIsInstanceTo2 = versionToCoordinate.get(sortedVersions.get(1));
            Intrinsics.checkExpressionValueIsNotNull((Object)$i$f$filterIsInstanceTo2, (String)"versionToCoordinate.get(sortedVersions[1])");
            LintModelMavenName c22 = this.findFirst($i$f$filterIsInstanceTo2);
            if ((Intrinsics.areEqual((Object)groupId, (Object)GMS_GROUP_ID) || Intrinsics.areEqual((Object)groupId, (Object)FIREBASE_GROUP_ID)) && (version = GradleVersion.tryParse((String)c22.getVersion())) != null && (version.getMajor() >= 14 || version.getMajor() == 0)) {
                return;
            }
            String example1 = c12.getGroupId() + ':' + c12.getArtifactId() + ':' + c12.getVersion();
            String example2 = c22.getGroupId() + ':' + c22.getArtifactId() + ':' + c22.getVersion();
            String groupDesc = Intrinsics.areEqual((Object)GMS_GROUP_ID, (Object)groupId) ? "gms/firebase" : groupId;
            String message2 = "All " + groupDesc + " libraries must use the exact same version specification (mixing versions can lead to runtime crashes). Found versions " + Joiner.on((String)", ").join((Iterable)sortedVersions) + ". Examples include `" + example1 + "` and `" + example2 + '`';
            LintModelVariant lintModelVariant = project.getBuildVariant();
            Iterator iterator = lintModelVariant == null ? null : ((object2 = lintModelVariant.getMainArtifact()) == null ? null : ((lintModelDependencies = object2.getDependencies()) == null ? null : ((object = lintModelDependencies.getCompileDependencies()) == null ? null : object.getAllGraphItems())));
            List allItems = iterator == null ? CollectionsKt.emptyList() : iterator;
            for (LintModelDependency library3 : allItems) {
                if (!Intrinsics.areEqual((Object)library3.getArtifactName(), (Object)"com.android.databinding:library")) continue;
                for (LintModelDependency dep : library3.getDependencies()) {
                    if (!Intrinsics.areEqual((Object)dep.getArtifactName(), (Object)"com.android.support:support-v4")) continue;
                    Comparable<LintModelLibrary> comparable = dep.findLibrary();
                    Object object3 = object = comparable instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)comparable : null;
                    if (Intrinsics.areEqual(sortedVersions.get(0), object == null ? null : ((comparable = object.getResolvedCoordinates()) == null ? null : comparable.getVersion()))) continue;
                    comparable = library3.findLibrary();
                    Object object4 = object = comparable instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)comparable : null;
                    StringBuilder stringBuilder = new StringBuilder().append(message2).append(". Note that this project is using data binding (com.android.databinding:library:").append((Object)(object == null ? null : ((comparable = object.getResolvedCoordinates()) == null ? null : comparable.getVersion()))).append(") which pulls in com.android.support:support-v4:");
                    comparable = dep.findLibrary();
                    Object object5 = object = comparable instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)comparable : null;
                    message2 = stringBuilder.append((Object)(object == null ? null : ((comparable = object.getResolvedCoordinates()) == null ? null : comparable.getVersion()))).append(". You can try to work around this by adding an explicit dependency on com.android.support:support-v4:").append(sortedVersions.get(0)).toString();
                    break;
                }
                break;
            }
            if (cookie != null) {
                GradleDetector.reportNonFatalCompatibilityIssue$default(this, context2, cookie, message2, null, 8, null);
            } else {
                Location location = Companion.getDependencyLocation(context2, c12, c22);
                this.reportNonFatalCompatibilityIssue(context2, location, message2);
            }
        }
    }

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Project project = context2.getProject();
        Map map = this.blockedDependencies;
        BlockedDependencies blockedDependencies = new BlockedDependencies(project);
        boolean bl2 = false;
        map.put(project, blockedDependencies);
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Project project = context2.getProject();
        this.checkBlockedDependencies(context2, project);
    }

    private final void checkLibraryConsistency(Context context2) {
        this.checkConsistentPlayServices(context2, null);
        this.checkConsistentSupportLibraries(context2, null);
        this.checkConsistentWearableLibraries(context2, null, null);
    }

    @Override
    public void afterCheckFile(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (!(!this.mAppliedJavaPlugin || this.mDeclaredSourceCompatibility && this.mDeclaredTargetCompatibility)) {
            File file = context2.file;
            String contents = ((Object)context2.getClient().readFile(file)).toString();
            String message2 = this.mDeclaredTargetCompatibility ? "no Java sourceCompatibility directive" : (this.mDeclaredSourceCompatibility ? "no Java targetCompatibility directive" : "no Java language level directives");
            String fixDisplayName = this.mDeclaredTargetCompatibility ? "Insert sourceCompatibility directive for JDK8" : (this.mDeclaredSourceCompatibility ? "Insert targetCompatibility directive for JDK8" : "Insert JDK8 language level directives");
            String insertion = this.mDeclaredTargetCompatibility ? "\njava.sourceCompatibility = JavaVersion.VERSION_1_8" : (this.mDeclaredSourceCompatibility ? "\njava.targetCompatibility = JavaVersion.VERSION_1_8" : "\njava {\n    sourceCompatibility = JavaVersion.VERSION_1_8\n    targetCompatibility = JavaVersion.VERSION_1_8\n}");
            LintFix fix = this.fix().replace().name(fixDisplayName).range(Location.Companion.create(context2.file, contents, 0, contents.length())).end().with(insertion).build();
            JavaPluginInfo javaPluginInfo = this.mJavaPluginInfo;
            if (javaPluginInfo == null) {
                Intrinsics.throwNpe();
            }
            GradleDetector.report$default(this, context2, javaPluginInfo.getCookie(), JAVA_PLUGIN_LANGUAGE_LEVEL, message2, fix, false, 32, null);
        }
    }

    private final void maybeReportAgpVersionIssue(Context context2) {
        AgpVersionCheckInfo agpVersionCheckInfo;
        if (this.mDeclaredGoogleMavenRepository && (agpVersionCheckInfo = this.agpVersionCheckInfo) != null) {
            LintFix lintFix;
            AgpVersionCheckInfo agpVersionCheckInfo2 = agpVersionCheckInfo;
            boolean bl2 = false;
            boolean bl3 = false;
            AgpVersionCheckInfo it2 = agpVersionCheckInfo2;
            boolean bl4 = false;
            String string = it2.getNewerVersion().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.newerVersion.toString()");
            String versionString = string;
            String message2 = this.getNewerVersionAvailableMessage(it2.getDependency(), versionString, it2.getSafeReplacement());
            if (it2.isResolved()) {
                lintFix = null;
            } else {
                String string2 = it2.getDependency().getRevision();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"it.dependency.revision");
                lintFix = this.getUpdateDependencyFix(string2, versionString, it2.getNewerVersionIsSafe(), it2.getSafeReplacement());
            }
            LintFix fix = lintFix;
            GradleDetector.report$default(this, context2, it2.getCookie(), AGP_DEPENDENCY, message2, fix, false, 32, null);
        }
    }

    private final void checkForKtxExtension(Context context2, String groupId, String artifactId, GradleVersion version, Object cookie) {
        if (!this.mAppliedKotlinAndroidPlugin) {
            return;
        }
        if (StringsKt.endsWith$default((String)artifactId, (String)"-ktx", (boolean)false, (int)2, null)) {
            return;
        }
        String mavenName = groupId + ':' + artifactId;
        if (!GradleDetector.Companion.libraryHasKtxExtension(mavenName)) {
            return;
        }
        Object object = context2.getProject().getBuildVariant();
        if (object == null) {
            return;
        }
        Object variant = object;
        if ((object = variant.getMainArtifact().findCompileDependency("org.jetbrains.kotlin:kotlin-stdlib")) == null) {
            return;
        }
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context2.getClient());
        GradleVersion gradleVersion = repository2.findVersion(groupId, Intrinsics.stringPlus((String)artifactId, (Object)"-ktx"), (Function1)new Function1<GradleVersion, Boolean>(version){
            final /* synthetic */ GradleVersion $version;
            {
                this.$version = $version;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull GradleVersion it2) {
                Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                return Intrinsics.areEqual((Object)it2, (Object)this.$version);
            }
        }, true);
        if (gradleVersion == null) {
            return;
        }
        String msg = "Add suffix `-ktx` to enable the Kotlin extensions for this library";
        LintFix fix = this.fix().name("Replace with KTX dependency").replace().text(mavenName).with(Intrinsics.stringPlus((String)mavenName, (Object)"-ktx")).build();
        GradleDetector.report$default(this, context2, cookie, KTX_EXTENSION_AVAILABLE, msg, fix, false, 32, null);
    }

    private final void checkBlockedDependencies(Context context2, Project project) {
        BlockedDependencies blockedDependencies;
        Object object = this.blockedDependencies.get(project);
        if (object == null) {
            return;
        }
        BlockedDependencies blockedDependencies2 = blockedDependencies = object;
        List<List<LintModelDependency>> dependencies = blockedDependencies2.getForbiddenDependencies();
        object = dependencies;
        boolean bl2 = false;
        if (!object.isEmpty()) {
            for (List<LintModelDependency> path2 : dependencies) {
                Location location;
                String string = this.getBlockedDependencyMessage(path2);
                if (string == null) continue;
                String message2 = string;
                File projectDir = context2.getProject().getDir();
                LintModelMavenName gc2 = LintModelMavenName.Companion.parse(path2.get(0).getArtifactAddress());
                if (gc2 != null) {
                    location = Companion.getDependencyLocation(context2, gc2.getGroupId(), gc2.getArtifactId(), gc2.getVersion());
                } else {
                    String mavenName = path2.get(0).getArtifactName();
                    LintClient lintClient = context2.getClient();
                    Intrinsics.checkExpressionValueIsNotNull((Object)projectDir, (String)"projectDir");
                    location = Lint.guessGradleLocation(lintClient, projectDir, mavenName);
                }
                Location location2 = location;
                context2.report(new Incident(DUPLICATE_CLASSES, location2, message2), this.map());
            }
        }
        this.blockedDependencies.remove(project);
    }

    private final void report(Context context2, Object cookie, Issue issue, String message2, LintFix fix, boolean partial) {
        context2.getClient().runReadAction(new Runnable(context2, issue, cookie, message2, fix, partial, this){
            final /* synthetic */ Context $context;
            final /* synthetic */ Issue $issue;
            final /* synthetic */ Object $cookie;
            final /* synthetic */ String $message;
            final /* synthetic */ LintFix $fix;
            final /* synthetic */ boolean $partial;
            final /* synthetic */ GradleDetector this$0;
            {
                this.$context = $context;
                this.$issue = $issue;
                this.$cookie = $cookie;
                this.$message = $message;
                this.$fix = $fix;
                this.$partial = $partial;
                this.this$0 = $receiver;
            }

            public final void run() {
                if (this.$context.isEnabled(this.$issue) && this.$context instanceof GradleContext) {
                    boolean checkComments = this.$context.containsCommentSuppress();
                    if (checkComments && ((GradleContext)this.$context).isSuppressedWithComment(this.$cookie, this.$issue)) {
                        return;
                    }
                    Location location = ((GradleContext)this.$context).getLocation(this.$cookie);
                    Incident incident = new Incident(this.$issue, location, this.$message, this.$fix);
                    if (this.$partial) {
                        this.$context.report(incident, GradleDetector.access$map(this.this$0));
                    } else {
                        this.$context.report(incident);
                    }
                }
            }
        });
    }

    static /* synthetic */ void report$default(GradleDetector gradleDetector, Context context2, Object object, Issue issue, String string, LintFix lintFix, boolean bl2, int n10, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: report");
        }
        if ((n10 & 0x10) != 0) {
            lintFix = null;
        }
        if ((n10 & 0x20) != 0) {
            bl2 = false;
        }
        gradleDetector.report(context2, object, issue, string, lintFix, bl2);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Object cookie, String message2) {
        GradleDetector.report$default(this, context2, cookie, COMPATIBILITY, message2, null, false, 48, null);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Object cookie, String message2, LintFix fix) {
        GradleDetector.report$default(this, context2, cookie, COMPATIBILITY, message2, fix, false, 32, null);
    }

    private final void reportNonFatalCompatibilityIssue(Context context2, Object cookie, String message2, LintFix lintFix) {
        if (context2.getDriver().getFatalOnlyMode()) {
            return;
        }
        GradleDetector.report$default(this, context2, cookie, COMPATIBILITY, message2, lintFix, false, 32, null);
    }

    static /* synthetic */ void reportNonFatalCompatibilityIssue$default(GradleDetector gradleDetector, Context context2, Object object, String string, LintFix lintFix, int n10, Object object2) {
        if (object2 != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: reportNonFatalCompatibilityIssue");
        }
        if ((n10 & 8) != 0) {
            lintFix = null;
        }
        gradleDetector.reportNonFatalCompatibilityIssue(context2, object, string, lintFix);
    }

    private final void reportFatalCompatibilityIssue(Context context2, Location location, String message2) {
        context2.getClient().runReadAction(new Runnable(context2, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default(this.$context, GradleDetector.COMPATIBILITY, this.$location, this.$message, null, 8, null);
            }
        });
    }

    private final void reportNonFatalCompatibilityIssue(Context context2, Location location, String message2) {
        if (context2.getDriver().getFatalOnlyMode()) {
            return;
        }
        context2.getClient().runReadAction(new Runnable(context2, location, message2){
            final /* synthetic */ Context $context;
            final /* synthetic */ Location $location;
            final /* synthetic */ String $message;
            {
                this.$context = $context;
                this.$location = $location;
                this.$message = $message;
            }

            public final void run() {
                Context.report$default(this.$context, GradleDetector.COMPATIBILITY, this.$location, this.$message, null, 8, null);
            }
        });
    }

    private final int getSdkVersion(String value) {
        int version = 0;
        if (GradleContext.Companion.isStringLiteral(value)) {
            String codeName = GradleContext.Companion.getStringLiteralValue(value);
            if (codeName != null) {
                if (Lint.isNumberString(codeName)) {
                    return -1;
                }
                AndroidVersion androidVersion = SdkVersionInfo.getVersion((String)codeName, null);
                if (androidVersion != null) {
                    version = androidVersion.getFeatureLevel();
                }
            }
        } else {
            version = GradleContext.Companion.getIntLiteralValue(value, -1);
        }
        return version;
    }

    private final GradleCoordinate resolveCoordinate(GradleContext context2, String property, GradleCoordinate gc2) {
        String string = gc2.getRevision();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"gc.revision");
        boolean bl2 = StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null);
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl2) {
            boolean $i$a$-assert-GradleDetector$resolveCoordinate$22 = false;
            String string2 = gc2.getRevision();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"gc.revision");
            String $i$a$-assert-GradleDetector$resolveCoordinate$22 = string2;
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-GradleDetector$resolveCoordinate$22));
        }
        Project project = context2.getProject();
        LintModelVariant variant = project.getBuildVariant();
        if (variant != null) {
            Object object;
            Object object2 = StringsKt.startsWith$default((String)property, (String)"androidTest", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getAndroidTestArtifact() : (object = StringsKt.startsWith$default((String)property, (String)"test", (boolean)false, (int)2, null) ? (LintModelArtifact)variant.getTestArtifact() : (LintModelArtifact)variant.getMainArtifact());
            if (object == null) {
                return null;
            }
            LintModelArtifact artifact = object;
            for (LintModelLibrary library2 : artifact.getDependencies().getAll()) {
                LintModelMavenName mc2;
                if (!(library2 instanceof LintModelExternalLibrary) || !Intrinsics.areEqual((Object)(mc2 = ((LintModelExternalLibrary)library2).getResolvedCoordinates()).getGroupId(), (Object)gc2.getGroupId()) || !Intrinsics.areEqual((Object)mc2.getArtifactId(), (Object)gc2.getArtifactId())) continue;
                List revisions = GradleCoordinate.parseRevisionNumber((String)mc2.getVersion());
                Intrinsics.checkExpressionValueIsNotNull((Object)revisions, (String)"revisions");
                Collection collection = revisions;
                boolean bl4 = false;
                if (!(!collection.isEmpty())) break;
                return new GradleCoordinate(mc2.getGroupId(), mc2.getArtifactId(), revisions, null);
            }
        }
        return null;
    }

    private final boolean usesLegacyHttpLibrary(Project project) {
        LintModelModule lintModelModule = project.getBuildModule();
        if (lintModelModule == null) {
            return false;
        }
        LintModelModule model = lintModelModule;
        for (File path2 : model.getBootClassPath()) {
            if (!FilesKt.endsWith((File)path2, (String)"org.apache.http.legacy.jar")) continue;
            return true;
        }
        return false;
    }

    private final LintFix getUpdateDependencyFix(String currentVersion, String suggestedVersion, boolean suggestedVersionIsSafe, GradleVersion safeReplacement) {
        LintFix lintFix;
        LintFix fix = this.fix().name(Intrinsics.stringPlus((String)"Change to ", (Object)suggestedVersion)).sharedName("Update versions").replace().text(currentVersion).with(suggestedVersion).autoFix(suggestedVersionIsSafe, suggestedVersionIsSafe).build();
        if (safeReplacement != null) {
            String string = safeReplacement.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"safeReplacement.toString()");
            String stableVersion = string;
            LintFix stableFix = this.fix().name(Intrinsics.stringPlus((String)"Change to ", (Object)stableVersion)).sharedName("Update versions").replace().text(currentVersion).with(stableVersion).autoFix().build();
            LintFix[] lintFixArray = new LintFix[]{fix, stableFix};
            lintFix = this.fix().alternatives(lintFixArray);
        } else {
            lintFix = fix;
        }
        return lintFix;
    }

    static /* synthetic */ LintFix getUpdateDependencyFix$default(GradleDetector gradleDetector, String string, String string2, boolean bl2, GradleVersion gradleVersion, int n10, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getUpdateDependencyFix");
        }
        if ((n10 & 4) != 0) {
            bl2 = false;
        }
        if ((n10 & 8) != 0) {
            gradleVersion = null;
        }
        return gradleDetector.getUpdateDependencyFix(string, string2, bl2, gradleVersion);
    }

    private final String getNewerVersionAvailableMessage(GradleCoordinate dependency, String version, GradleVersion stable) {
        StringBuilder message2 = new StringBuilder();
        boolean bl2 = false;
        boolean bl3 = false;
        StringBuilder $this$getNewerVersionAvailableMessage_u24lambda_u2d3 = message2;
        boolean bl4 = false;
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append("A newer version of ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(dependency.getGroupId());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(":");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(dependency.getArtifactId());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(" than ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(dependency.getRevision());
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(" is available: ");
        $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(version);
        if (stable != null) {
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(". (There is also a newer version of ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(String.valueOf(stable.getMajor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(".");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(String.valueOf(stable.getMinor()));
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(".\ud835\udc65 available, if upgrading to ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(version);
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(" is difficult: ");
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(stable.toString());
            $this$getNewerVersionAvailableMessage_u24lambda_u2d3.append(")");
        }
        String string = message2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"message.toString()");
        return string;
    }

    private final boolean isSupportLibraryDependentOnCompileSdk(String groupId, String artifactId) {
        return Intrinsics.areEqual((Object)"com.android.support", (Object)groupId) && !StringsKt.startsWith$default((String)artifactId, (String)"multidex", (boolean)false, (int)2, null) && !StringsKt.startsWith$default((String)artifactId, (String)"renderscript", (boolean)false, (int)2, null) && !Intrinsics.areEqual((Object)artifactId, (Object)"support-annotations");
    }

    private final LintModelMavenName findFirst(Collection<? extends LintModelMavenName> coordinates) {
        LintModelMavenName lintModelMavenName = Collections.min(coordinates, findFirst.1.INSTANCE);
        Intrinsics.checkExpressionValueIsNotNull((Object)lintModelMavenName, (String)"min(coordinates) { o1, o\u2026ompareTo(o2.toString()) }");
        return lintModelMavenName;
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)incident, (String)"incident");
        Intrinsics.checkParameterIsNotNull((Object)map, (String)"map");
        Issue issue = incident.getIssue();
        if (issue == DUPLICATE_CLASSES) {
            return context2.getMainProject().getMinSdk() < 23 || this.usesLegacyHttpLibrary(context2.getMainProject());
        }
        if (Intrinsics.areEqual((Object)issue, (Object)EXPIRING_TARGET_SDK_VERSION) || Intrinsics.areEqual((Object)issue, (Object)EXPIRED_TARGET_SDK_VERSION)) {
            return !this.isWearApp(context2);
        }
        String string = issue.getId();
        boolean bl2 = false;
        throw (Throwable)new IllegalStateException(string.toString());
    }

    private final boolean isWearApp(Context context2) {
        Object object;
        Document document = context2.getMainProject().getMergedManifest();
        Object object2 = object = document == null ? null : document.getDocumentElement();
        if (object == null) {
            return false;
        }
        Element manifest = object;
        object = DomExtensions.iterator((Element)manifest);
        while (object.hasNext()) {
            Element element = (Element)object.next();
            if (!Intrinsics.areEqual((Object)element.getTagName(), (Object)"uses-feature") || !Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)"android.hardware.type.watch")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        if (context2.isGlobalAnalysis() && context2.getDriver().isIsolated()) {
            return;
        }
        this.checkLibraryConsistency(context2);
    }

    private final String getBlockedDependencyMessage(List<? extends LintModelDependency> path2) {
        boolean direct = path2.size() == 1;
        String message2 = null;
        String resolution = "Solutions include finding newer versions or alternative libraries that don't have the same problem (for example, for `httpclient` use `HttpUrlConnection` or `okhttp` instead), or repackaging the library using something like `jarjar`.";
        if (direct) {
            message2 = '`' + path2.get(0).getArtifactId() + "` defines classes that conflict with classes now provided by Android. " + resolution;
        } else {
            StringBuilder sb2 = new StringBuilder();
            boolean first = true;
            for (LintModelDependency string : path2) {
                if (first) {
                    first = false;
                } else {
                    sb2.append(" \u2192 ");
                }
                String coordinates = string.getArtifactName();
                sb2.append(coordinates);
            }
            sb2.append(") ");
            String string = sb2.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
            String chain = string;
            message2 = '`' + path2.get(0).getArtifactId() + "` depends on a library (" + path2.get(path2.size() - 1).getArtifactName() + ") which defines classes that conflict with classes now provided by Android. " + resolution + " Dependency chain: " + chain;
        }
        return message2;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor, int micro) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && !version1.isAtLeast(major, minor, micro) ? new GradleVersion(major, minor, micro) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, int major, int minor) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && !version1.isAtLeast(major, minor, 0) ? new GradleVersion(major, minor) : null;
    }

    private final GradleVersion getNewerVersion(GradleVersion version1, GradleVersion version2) {
        return version1.compareTo(new GradleVersion(0, 0, 0)) > 0 && version1.compareTo(version2) < 0 ? version2 : null;
    }

    private final GradleVersion getGoogleMavenRepoVersion(GradleContext context2, GradleCoordinate dependency, Predicate<GradleVersion> filter) {
        GoogleMavenRepository repository2 = this.getGoogleMavenRepository(context2.getClient());
        return repository2.findVersion(dependency, filter, dependency.isPreview());
    }

    private final GoogleMavenRepository getGoogleMavenRepository(LintClient client) {
        GoogleMavenRepository googleMavenRepository;
        GoogleMavenRepository googleMavenRepository2 = this.googleMavenRepository;
        if (googleMavenRepository2 == null) {
            GradleDetector gradleDetector = this;
            boolean bl2 = false;
            boolean bl3 = false;
            GradleDetector $this$getGoogleMavenRepository_u24lambda_u2d4 = gradleDetector;
            boolean bl4 = false;
            File cacheDir = client.getCacheDir("maven.google", true);
            File file = cacheDir;
            Path path2 = file == null ? null : file.toPath();
            GoogleMavenRepository repository2 = new GoogleMavenRepository(client, path2){
                final /* synthetic */ LintClient $client;
                {
                    this.$client = $client;
                    super($super_call_param$1, 0, 0, false, 14, null);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    return Lint.readUrlData(this.$client, url, timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    this.$client.log(throwable, message2, new Object[0]);
                }
            };
            $this$getGoogleMavenRepository_u24lambda_u2d4.googleMavenRepository = repository2;
            googleMavenRepository = repository2;
        } else {
            googleMavenRepository = googleMavenRepository2;
        }
        return googleMavenRepository;
    }

    private final DeprecatedSdkRegistry getDeprecatedLibraryLookup(LintClient client) {
        DeprecatedSdkRegistry deprecatedSdkRegistry;
        DeprecatedSdkRegistry deprecatedSdkRegistry2 = this.deprecatedSdkRegistry;
        if (deprecatedSdkRegistry2 == null) {
            GradleDetector gradleDetector = this;
            boolean bl2 = false;
            boolean bl3 = false;
            GradleDetector $this$getDeprecatedLibraryLookup_u24lambda_u2d5 = gradleDetector;
            boolean bl4 = false;
            File cacheDir = client.getCacheDir("sdk-registry.xml", true);
            File file = cacheDir;
            Path path2 = file == null ? null : file.toPath();
            DeprecatedSdkRegistry repository2 = new DeprecatedSdkRegistry(client, path2){
                final /* synthetic */ LintClient $client;
                {
                    this.$client = $client;
                    super($super_call_param$1);
                }

                @Nullable
                public byte[] readUrlData(@NotNull String url, int timeout) {
                    Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                    return Lint.readUrlData(this.$client, url, timeout);
                }

                public void error(@NotNull Throwable throwable, @Nullable String message2) {
                    Intrinsics.checkParameterIsNotNull((Object)throwable, (String)"throwable");
                    this.$client.log(throwable, message2, new Object[0]);
                }
            };
            $this$getDeprecatedLibraryLookup_u24lambda_u2d5.deprecatedSdkRegistry = repository2;
            deprecatedSdkRegistry = repository2;
        } else {
            deprecatedSdkRegistry = deprecatedSdkRegistry2;
        }
        return deprecatedSdkRegistry;
    }

    @JvmStatic
    @Nullable
    public static final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
        return Companion.getLatestVersionFromRemoteRepo(client, dependency, filter, allowPreview);
    }

    @JvmStatic
    @Nullable
    public static final String getNamedDependency(@NotNull String expression) {
        return Companion.getNamedDependency(expression);
    }

    public static final /* synthetic */ void access$checkDependency(GradleDetector $this, GradleContext context2, GradleCoordinate dependency, boolean isResolved, Object cookie, Object statementCookie) {
        $this.checkDependency(context2, dependency, isResolved, cookie, statementCookie);
    }

    public static final /* synthetic */ int access$getCompileSdkVersion$p(GradleDetector $this) {
        return $this.compileSdkVersion;
    }

    public static final /* synthetic */ int access$getTargetSdkVersion$p(GradleDetector $this) {
        return $this.targetSdkVersion;
    }

    public static final /* synthetic */ LintMap access$map(GradleDetector $this) {
        return $this.map();
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$flatMapTo$iv$iv;
        Companion = new Companion(null);
        IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
        DEPENDENCY = Issue.Companion.create("GradleDependency", "Obsolete Gradle Dependency", "\n                This detector looks for usages of libraries where the version you are using \\\n                is not the current stable release. Using older versions is fine, and there \\\n                are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is \\\n                available, and that is what this lint check helps find.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        Object[] objectArray = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Object object = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        AGP_DEPENDENCY = Issue.Companion.create$default((Issue.Companion)objectArray, "AndroidGradlePluginVersion", "Obsolete Android Gradle Plugin Version", "\n                This detector looks for usage of the Android Gradle Plugin where the version \\\n                you are using is not the current stable release. Using older versions is fine, \\\n                and there are cases where you deliberately want to stick with an older version. \\\n                However, you may simply not be aware that a more recent version is available, \\\n                and that is what this lint check helps find.", implementation, null, category, 4, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED = Issue.Companion.create$default((Issue.Companion)objectArray, "GradleDeprecated", "Deprecated Gradle Construct", "\n                This detector looks for deprecated Gradle constructs which currently work \\\n                but will likely stop working in a future update.", implementation, null, category, 6, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEPRECATED_CONFIGURATION = Issue.Companion.create$default((Issue.Companion)objectArray, "GradleDeprecatedConfiguration", "Deprecated Gradle Configuration", "\n                Some Gradle configurations have been deprecated since Android Gradle Plugin 3.0.0 \\\n                and will be removed in a future version of the Android Gradle Plugin.\n             ", implementation, "https://d.android.com/r/tools/update-dependency-configurations", category, 6, object, false, null, null, null, 3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_PLUGIN_COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, "GradlePluginVersion", "Incompatible Android Gradle Plugin", "\n                Not all versions of the Android Gradle plugin are compatible with all \\\n                versions of the SDK. If you update your tools, or if you are trying to \\\n                open a project that was built with an old version of the tools, you may \\\n                need to update your plugin version number.", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        PATH = Issue.Companion.create("GradlePath", "Gradle Path Issues", "\n                Gradle build scripts are meant to be cross platform, so file paths use \\\n                Unix-style path separators (a forward slash) rather than Windows path \\\n                separators (a backslash). Similarly, to keep projects portable and \\\n                repeatable, avoid using absolute paths on the system; keep files within \\\n                the project instead. To share code between projects, consider creating \\\n                an android-library and an AAR dependency", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        IDE_SUPPORT = Issue.Companion.create("GradleIdeError", "Gradle IDE Support Issues", "\n                Gradle is highly flexible, and there are things you can do in Gradle \\\n                files which can make it hard or impossible for IDEs to properly handle \\\n                the project. This lint check looks for constructs that potentially \\\n                break IDE support.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
        PLUS = Issue.Companion.create("GradleDynamicVersion", "Gradle Dynamic Version", "\n                Using `+` in dependencies lets you automatically pick up the latest \\\n                available version rather than a specific, named version. However, \\\n                this is not recommended; your builds are not repeatable; you may have \\\n                tested with a slightly different version than what the build server \\\n                used. (Using a dynamic version as the major version number is more \\\n                problematic than using it in the minor version position.)", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        GRADLE_GETTER = Issue.Companion.create$default((Issue.Companion)objectArray, "GradleGetter", "Gradle Implicit Getter Call", "\n                Gradle will let you replace specific constants in your build scripts \\\n                with method calls, so you can for example dynamically compute a version \\\n                string based on your current version control revision number, rather \\\n                than hardcoding a number.\n\n                When computing a version name, it's tempting to for example call the \\\n                method to do that `getVersionName`. However, when you put that method \\\n                call inside the `defaultConfig` block, you will actually be calling the \\\n                Groovy getter for the `versionName` property instead. Therefore, you \\\n                need to name your method something which does not conflict with the \\\n                existing implicit getters. Consider using `compute` as a prefix instead \\\n                of `get`.", implementation, null, category, 6, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        COMPATIBILITY = Issue.Companion.create$default((Issue.Companion)objectArray, "GradleCompatible", "Incompatible Gradle Versions", "\n                There are some combinations of libraries, or tools and libraries, that \\\n                are incompatible, or can lead to bugs. One such incompatibility is \\\n                compiling with a version of the Android support libraries that is not \\\n                the latest version (or in particular, a version lower than your \\\n                `targetSdkVersion`).", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        STRING_INTEGER = Issue.Companion.create$default((Issue.Companion)objectArray, "StringShouldBeInt", "String should be int", "\n                The properties `compileSdkVersion`, `minSdkVersion` and `targetSdkVersion` \\\n                are usually numbers, but can be strings when you are using an add-on (in \\\n                the case of `compileSdkVersion`) or a preview platform (for the other two \\\n                properties).\n\n                However, you can not use a number as a string (e.g. \"19\" instead of 19); \\\n                that will result in a platform not found error message at build/sync \\\n                time.", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        NOT_INTERPOLATED = Issue.Companion.create$default((Issue.Companion)objectArray, "NotInterpolated", "Incorrect Interpolation", "\n                To insert the value of a variable, you can use `${variable}` inside a \\\n                string literal, but **only** if you are using double quotes!", implementation, "https://www.groovy-lang.org/syntax.html#_string_interpolation", category, 8, object, false, null, null, null, 3840, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        REMOTE_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, "NewerVersionAvailable", "Newer Library Versions Available", "\n                This detector checks with a central repository to see if there are newer \\\n                versions available for the dependencies used by this project. This is \\\n                similar to the `GradleDependency` check, which checks for newer versions \\\n                available in the Android SDK tools and libraries, but this works with any \\\n                MavenCentral dependency, and connects to the library every time, which \\\n                makes it more flexible but also **much** slower.", implementation, null, category, 4, object, false, null, null, null, 3600, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        MIN_SDK_TOO_LOW = Issue.Companion.create$default((Issue.Companion)objectArray, "MinSdkTooLow", "API Version Too Low", "\n                The value of the `minSdkVersion` property is too low and can be \\\n                incremented without noticeably reducing the number of supported \\\n                devices.", implementation, null, category, 4, object, false, true, null, null, 3088, null);
        ACCIDENTAL_OCTAL = Issue.Companion.create("AccidentalOctal", "Accidental Octal", "\n                In Groovy, an integer literal that starts with a leading 0 will be \\\n                interpreted as an octal number. That is usually (always?) an accident \\\n                and can lead to subtle bugs, for example when used in the `versionCode` \\\n                of an app.", Category.CORRECTNESS, 2, Severity.ERROR, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        BUNDLED_GMS = Issue.Companion.create$default((Issue.Companion)objectArray, "UseOfBundledGooglePlayServices", "Use of bundled version of Google Play services", "\n                Google Play services SDK's can be selectively included, which enables a \\\n                smaller APK size. Consider declaring dependencies on individual Google \\\n                Play services SDK's. If you are using Firebase API's \\\n                (https://firebase.google.com/docs/android/setup), Android Studio's \\\n                Tools \u2192 Firebase assistant window can automatically add just the \\\n                dependencies needed for each feature.", implementation, "https://developers.google.com/android/guides/setup#split", category, 4, object, false, true, null, null, 3328, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        HIGH_APP_VERSION_CODE = Issue.Companion.create$default((Issue.Companion)objectArray, "HighAppVersionCode", "VersionCode too high", "\n                The declared `versionCode` is an Integer. Ensure that the version number is \\\n                not close to the limit. It is recommended to monotonically increase this \\\n                number each minor or major release of the app. Note that updating an app \\\n                with a versionCode over `Integer.MAX_VALUE` is not possible.", implementation, "https://developer.android.com/studio/publish/versioning.html", category, 8, object, false, true, null, null, 3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DEV_MODE_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, "DevModeObsolete", "Dev Mode Obsolete", "\n                In the past, our documentation recommended creating a `dev` product flavor \\\n                with has a minSdkVersion of 21, in order to enable multidexing to speed up \\\n                builds significantly during development.\n\n                That workaround is no longer necessary, and it has some serious downsides, \\\n                such as breaking API access checking (since the true `minSdkVersion` is no \\\n                longer known).\n\n                In recent versions of the IDE and the Gradle plugin, the IDE automatically \\\n                passes the API level of the connected device used for deployment, and if \\\n                that device is at least API 21, then multidexing is automatically turned \\\n                on, meaning that you get the same speed benefits as the `dev` product \\\n                flavor but without the downsides.", implementation, null, category, 2, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        DUPLICATE_CLASSES = Issue.Companion.create$default((Issue.Companion)objectArray, "DuplicatePlatformClasses", "Duplicate Platform Classes", "\n                There are a number of libraries that duplicate not just functionality \\\n                of the Android platform but using the exact same class names as the ones \\\n                provided in Android -- for example the apache http classes. This can \\\n                lead to unexpected crashes.\n\n                To solve this, you need to either find a newer version of the library \\\n                which no longer has this problem, or to repackage the library (and all \\\n                of its dependencies) using something like the `jarjar` tool, or finally, \\\n                rewriting the code to use different APIs (for example, for http code, \\\n                consider using `HttpUrlConnection` or a library like `okhttp`).", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        EXPIRING_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, "ExpiringTargetSdkVersion", "TargetSdkVersion Soon Expiring", "\n                In the second half of 2018, Google Play will require that new apps and app \\\n                updates target API level 26 or higher. This will be required for new apps in \\\n                August 2018, and for updates to existing apps in November 2018.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                This lint check starts warning you some months **before** these changes go \\\n                into effect if your `targetSdkVersion` is 25 or lower. This is intended to \\\n                give you a heads up to update your app, since depending on your current \\\n                `targetSdkVersion` the work can be nontrivial.\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", implementation, null, category, 8, object, false, true, null, null, 3344, null).addMoreInfo("https://support.google.com/googleplay/android-developer/answer/113469#targetsdk").addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.FATAL;
        implementation = IMPLEMENTATION;
        EXPIRED_TARGET_SDK_VERSION = Issue.Companion.create$default((Issue.Companion)objectArray, "ExpiredTargetSdkVersion", "TargetSdkVersion No Longer Supported", "\n                As of the second half of 2018, Google Play requires that new apps and app \\\n                updates target API level 26 or higher.\n\n                Configuring your app to target a recent API level ensures that users benefit \\\n                from significant security and performance improvements, while still allowing \\\n                your app to run on older Android versions (down to the `minSdkVersion`).\n\n                To update your `targetSdkVersion`, follow the steps from \\\n                \"Meeting Google Play requirements for target API level\",\n                https://developer.android.com/distribute/best-practices/develop/target-sdk.html\n                ", implementation, "https://support.google.com/googleplay/android-developer/answer/113469#targetsdk", category, 8, object, false, true, null, null, 3328, null).addMoreInfo("https://developer.android.com/distribute/best-practices/develop/target-sdk.html");
        objectArray = Issue.Companion;
        category = Category.COMPLIANCE;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        DEPRECATED_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, "OutdatedLibrary", "Outdated Library", "\n                Your app is using an outdated version of a library. This may cause violations \\\n                of Google Play policies (see https://play.google.com/about/monetization-ads/ads/) \\\n                and/or may affect your app\u2019s visibility on the Play Store.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n                ", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        DATA_BINDING_WITHOUT_KAPT = Issue.Companion.create$default((Issue.Companion)objectArray, "DataBindingWithoutKapt", "Data Binding without Annotation Processing", "\n                Apps that use Kotlin and data binding should also apply the kotlin-kapt plugin.\n                ", implementation, "https://kotlinlang.org/docs/reference/kapt.html", category, 1, object, false, true, null, null, 3328, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8 = Issue.Companion.create$default((Issue.Companion)objectArray, "LifecycleAnnotationProcessorWithJava8", "Lifecycle Annotation Processor with Java 8 Compile Option", "\n                For faster incremental build, switch to the Lifecycle Java 8 API with these steps:\n\n                First replace\n                ```gradle\n                annotationProcessor \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                kapt \"androidx.lifecycle:lifecycle-compiler:*version*\"\n                ```\n                with\n                ```gradle\n                implementation \"androidx.lifecycle:lifecycle-common-java8:*version*\"\n                ```\n                Then remove any `OnLifecycleEvent` annotations from `Observer` classes \\\n                and make them implement the `DefaultLifecycleObserver` interface.\n                ", implementation, "https://d.android.com/r/studio-ui/lifecycle-release-notes", category, 6, object, false, true, null, null, 3328, null);
        objectArray = Issue.Companion;
        category = Category.SECURITY;
        object = Severity.ERROR;
        implementation = IMPLEMENTATION;
        RISKY_LIBRARY = Issue.Companion.create$default((Issue.Companion)objectArray, "RiskyLibrary", "Libraries with Privacy or Security Risks", "\n                Your app is using a version of a library that has been identified by \\\n                the library developer as a potential source of privacy and/or security risks. \\\n                This may be a violation of Google Play policies (see \\\n                https://play.google.com/about/monetization-ads/ads/) and/or affect your app\u2019s \\\n                visibility on the Play Store.\n\n                When available, the individual error messages from lint will include details \\\n                about the reasons for this advisory.\n\n                Please try updating your app with an updated version of this library, or remove \\\n                it from your app.\n            ", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.PERFORMANCE;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        ANNOTATION_PROCESSOR_ON_COMPILE_PATH = Issue.Companion.create$default((Issue.Companion)objectArray, "AnnotationProcessorOnCompilePath", "Annotation Processor on Compile Classpath", "\n               This dependency is identified as an annotation processor. Consider adding it to the \\\n               processor path using `annotationProcessor` instead of including it to the\n               compile path.\n            ", implementation, null, category, 8, object, false, true, null, null, 3344, null);
        objectArray = Issue.Companion;
        category = Category.PRODUCTIVITY;
        object = Severity.INFORMATIONAL;
        implementation = IMPLEMENTATION;
        KTX_EXTENSION_AVAILABLE = Issue.Companion.create$default((Issue.Companion)objectArray, "KtxExtensionAvailable", "KTX Extension Available", "\n                Android KTX extensions augment some libraries with support for modern Kotlin \\\n                language features like extension functions, extension properties, lambdas, named \\\n                parameters, coroutines, and more.\n\n                In Kotlin projects, use the KTX version of a library by replacing the \\\n                dependency in your `build.gradle` file. For example, you can replace \\\n                `androidx.fragment:fragment` with `androidx.fragment:fragment-ktx`.\n            ", implementation, "https://developer.android.com/kotlin/ktx", category, 4, object, false, true, null, null, 3328, null);
        JAVA_PLUGIN_LANGUAGE_LEVEL = Issue.Companion.create("JavaPluginLanguageLevel", "No Explicit Java Language Level Given", "\n                In modules using plugins deriving from the Gradle `java` plugin (e.g. \\\n                `java-library` or `application`), the java source and target compatibility \\\n                default to the version of the JDK being used to run Gradle, which may cause \\\n                compatibility problems with Android (or other) modules.\n\n                You can specify an explicit sourceCompatibility and targetCompatibility in this \\\n                module to maintain compatibility no matter which JDK is used to run Gradle.\n            ", Category.INTEROPERABILITY, 6, Severity.WARNING, IMPLEMENTATION);
        objectArray = Issue.Companion;
        category = Category.CORRECTNESS;
        object = Severity.WARNING;
        implementation = IMPLEMENTATION;
        JCENTER_REPOSITORY_OBSOLETE = Issue.Companion.create$default((Issue.Companion)objectArray, "JcenterRepositoryObsolete", "JCenter Maven repository is read-only", "\n                The JCenter Maven repository is no longer accepting submissions of Maven \\\n                artifacts since 31st March 2021.  Ensure that the project is configured \\\n                to search in repositories with the latest versions of its dependencies.\n            ", implementation, "https://developer.android.com/r/tools/jcenter-end-of-service", category, 8, object, false, null, null, null, 3840, null);
        objectArray = new String[]{"java", "java-library", "application"};
        Iterable $this$flatMap$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$flatMap = false;
        object = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it2 = (String)element$iv$iv;
            boolean bl2 = false;
            Object[] objectArray2 = new String[]{it2, Intrinsics.stringPlus((String)"org.gradle.", (Object)it2)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        JAVA_PLUGIN_IDS = (List)((Object)implementation);
        GradleCoordinate gradleCoordinate = GradleCoordinate.parseCoordinateString((String)"com.google.android.gms:play-services:6.5.0");
        if (gradleCoordinate == null) {
            Intrinsics.throwNpe();
        }
        PLAY_SERVICES_V650 = gradleCoordinate;
        objectArray = new String[]{"com.jakewharton:butterknife-compiler", "com.github.bumptech.glide:compiler", "androidx.databinding:databinding-compiler", "com.google.dagger:dagger-compiler", "com.google.auto.service:auto-service", "android.arch.persistence.room:compiler", "android.arch.lifecycle:compiler", "io.realm:realm-annotations-processor", "com.google.dagger:dagger-android-processor", "androidx.room:room-compiler", "com.android.databinding:compiler", "androidx.lifecycle:lifecycle-compiler", "org.projectlombok:lombok", "com.google.auto.value:auto-value", "org.parceler:parceler", "com.github.hotchemi:permissionsdispatcher-processor", "com.alibaba:arouter-compiler", "org.androidannotations:androidannotations", "com.github.Raizlabs.DBFlow:dbflow-processor", "frankiesardo:icepick-processor", "org.greenrobot:eventbus-annotation-processor", "com.ryanharter.auto.value:auto-value-gson", "io.objectbox:objectbox-processor", "com.arello-mobile:moxy-compiler", "com.squareup.dagger:dagger-compiler", "io.realm:realm-android", "com.bluelinelabs:logansquare-compiler", "com.tencent.tinker:tinker-android-anno", "com.raizlabs.android:DBFlow-Compiler", "com.google.auto.factory:auto-factory", "com.airbnb:deeplinkdispatch-processor", "com.alipay.android.tools:androidannotations", "org.permissionsdispatcher:permissionsdispatcher-processor", "com.airbnb.android:epoxy-processor", "org.immutables:value", "com.github.stephanenicolas.toothpick:toothpick-compiler", "com.mindorks.android:placeholderview-compiler", "com.github.frankiesardo:auto-parcel-processor", "com.hannesdorfmann.fragmentargs:processor", "com.evernote:android-state-processor", "org.mapstruct:mapstruct-processor", "com.iqiyi.component.router:qyrouter-compiler", "com.iqiyi.component.mm:mm-compiler", "dk.ilios:realmfieldnameshelper", "com.lianjia.common.android.router2:compiler", "com.smile.gifshow.annotation:invoker_processor", "com.f2prateek.dart:dart-processor", "com.sankuai.waimai.router:compiler", "org.qiyi.card:card-action-compiler", "com.iqiyi.video:eventbus-annotation-processor", "ly.img.android.pesdk:build-processor", "org.apache.logging.log4j:log4j-core", "com.github.jokermonn:permissions4m", "com.arialyy.aria:aria-compiler", "com.smile.gifshow.annotation:provide_processor", "com.smile.gifshow.annotation:preference_processor", "com.smile.gifshow.annotation:plugin_processor", "org.inferred:freebuilder", "com.smile.gifshow.annotation:router_processor"};
        commonAnnotationProcessors = SetsKt.setOf((Object[])objectArray);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\t\u0010\u0006\u001a\u00020\u0001H\u00c6\u0003J\u0013\u0010\u0007\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000b\u001a\u00020\fH\u00d6\u0001J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$JavaPluginInfo;", "", "cookie", "(Ljava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class JavaPluginInfo {
        @NotNull
        private final Object cookie;

        public JavaPluginInfo(@NotNull Object cookie) {
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            this.cookie = cookie;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final Object component1() {
            return this.cookie;
        }

        @NotNull
        public final JavaPluginInfo copy(@NotNull Object cookie) {
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            return new JavaPluginInfo(cookie);
        }

        public static /* synthetic */ JavaPluginInfo copy$default(JavaPluginInfo javaPluginInfo, Object object, int n10, Object object2) {
            if ((n10 & 1) != 0) {
                object = javaPluginInfo.cookie;
            }
            return javaPluginInfo.copy(object);
        }

        @NotNull
        public String toString() {
            return "JavaPluginInfo(cookie=" + this.cookie + ')';
        }

        public int hashCode() {
            return this.cookie.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof JavaPluginInfo)) {
                return false;
            }
            JavaPluginInfo javaPluginInfo = (JavaPluginInfo)other;
            return Intrinsics.areEqual((Object)this.cookie, (Object)javaPluginInfo.cookie);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u000bJ\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0001H\u00c6\u0003JG\u0010\u001b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00052\b\b\u0002\u0010\n\u001a\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001c\u001a\u00020\u00052\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J\t\u0010 \u001a\u00020!H\u00d6\u0001R\u0011\u0010\n\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0012\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/GradleDetector$AgpVersionCheckInfo;", "", "newerVersion", "Lcom/android/ide/common/repository/GradleVersion;", "newerVersionIsSafe", "", "safeReplacement", "dependency", "Lcom/android/ide/common/repository/GradleCoordinate;", "isResolved", "cookie", "(Lcom/android/ide/common/repository/GradleVersion;ZLcom/android/ide/common/repository/GradleVersion;Lcom/android/ide/common/repository/GradleCoordinate;ZLjava/lang/Object;)V", "getCookie", "()Ljava/lang/Object;", "getDependency", "()Lcom/android/ide/common/repository/GradleCoordinate;", "()Z", "getNewerVersion", "()Lcom/android/ide/common/repository/GradleVersion;", "getNewerVersionIsSafe", "getSafeReplacement", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class AgpVersionCheckInfo {
        @NotNull
        private final GradleVersion newerVersion;
        private final boolean newerVersionIsSafe;
        @Nullable
        private final GradleVersion safeReplacement;
        @NotNull
        private final GradleCoordinate dependency;
        private final boolean isResolved;
        @NotNull
        private final Object cookie;

        public AgpVersionCheckInfo(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkParameterIsNotNull((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            this.newerVersion = newerVersion;
            this.newerVersionIsSafe = newerVersionIsSafe;
            this.safeReplacement = safeReplacement;
            this.dependency = dependency;
            this.isResolved = isResolved;
            this.cookie = cookie;
        }

        @NotNull
        public final GradleVersion getNewerVersion() {
            return this.newerVersion;
        }

        public final boolean getNewerVersionIsSafe() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion getSafeReplacement() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate getDependency() {
            return this.dependency;
        }

        public final boolean isResolved() {
            return this.isResolved;
        }

        @NotNull
        public final Object getCookie() {
            return this.cookie;
        }

        @NotNull
        public final GradleVersion component1() {
            return this.newerVersion;
        }

        public final boolean component2() {
            return this.newerVersionIsSafe;
        }

        @Nullable
        public final GradleVersion component3() {
            return this.safeReplacement;
        }

        @NotNull
        public final GradleCoordinate component4() {
            return this.dependency;
        }

        public final boolean component5() {
            return this.isResolved;
        }

        @NotNull
        public final Object component6() {
            return this.cookie;
        }

        @NotNull
        public final AgpVersionCheckInfo copy(@NotNull GradleVersion newerVersion, boolean newerVersionIsSafe, @Nullable GradleVersion safeReplacement, @NotNull GradleCoordinate dependency, boolean isResolved, @NotNull Object cookie) {
            Intrinsics.checkParameterIsNotNull((Object)newerVersion, (String)"newerVersion");
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            Intrinsics.checkParameterIsNotNull((Object)cookie, (String)"cookie");
            return new AgpVersionCheckInfo(newerVersion, newerVersionIsSafe, safeReplacement, dependency, isResolved, cookie);
        }

        public static /* synthetic */ AgpVersionCheckInfo copy$default(AgpVersionCheckInfo agpVersionCheckInfo, GradleVersion gradleVersion, boolean bl2, GradleVersion gradleVersion2, GradleCoordinate gradleCoordinate, boolean bl3, Object object, int n10, Object object2) {
            if ((n10 & 1) != 0) {
                gradleVersion = agpVersionCheckInfo.newerVersion;
            }
            if ((n10 & 2) != 0) {
                bl2 = agpVersionCheckInfo.newerVersionIsSafe;
            }
            if ((n10 & 4) != 0) {
                gradleVersion2 = agpVersionCheckInfo.safeReplacement;
            }
            if ((n10 & 8) != 0) {
                gradleCoordinate = agpVersionCheckInfo.dependency;
            }
            if ((n10 & 0x10) != 0) {
                bl3 = agpVersionCheckInfo.isResolved;
            }
            if ((n10 & 0x20) != 0) {
                object = agpVersionCheckInfo.cookie;
            }
            return agpVersionCheckInfo.copy(gradleVersion, bl2, gradleVersion2, gradleCoordinate, bl3, object);
        }

        @NotNull
        public String toString() {
            return "AgpVersionCheckInfo(newerVersion=" + this.newerVersion + ", newerVersionIsSafe=" + this.newerVersionIsSafe + ", safeReplacement=" + this.safeReplacement + ", dependency=" + this.dependency + ", isResolved=" + this.isResolved + ", cookie=" + this.cookie + ')';
        }

        public int hashCode() {
            int result2 = this.newerVersion.hashCode();
            int n10 = this.newerVersionIsSafe ? 1 : 0;
            if (n10 != 0) {
                n10 = 1;
            }
            result2 = result2 * 31 + n10;
            result2 = result2 * 31 + (this.safeReplacement == null ? 0 : this.safeReplacement.hashCode());
            result2 = result2 * 31 + this.dependency.hashCode();
            int n11 = this.isResolved ? 1 : 0;
            if (n11 != 0) {
                n11 = 1;
            }
            result2 = result2 * 31 + n11;
            result2 = result2 * 31 + this.cookie.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AgpVersionCheckInfo)) {
                return false;
            }
            AgpVersionCheckInfo agpVersionCheckInfo = (AgpVersionCheckInfo)other;
            if (!Intrinsics.areEqual((Object)this.newerVersion, (Object)agpVersionCheckInfo.newerVersion)) {
                return false;
            }
            if (this.newerVersionIsSafe != agpVersionCheckInfo.newerVersionIsSafe) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.safeReplacement, (Object)agpVersionCheckInfo.safeReplacement)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.dependency, (Object)agpVersionCheckInfo.dependency)) {
                return false;
            }
            if (this.isResolved != agpVersionCheckInfo.isResolved) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cookie, (Object)agpVersionCheckInfo.cookie);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u000b\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$DeprecatedConfiguration;", "", "deprecatedName", "", "replacementName", "(Ljava/lang/String;ILjava/lang/String;Ljava/lang/String;)V", "deprecatedSuffix", "replacementSuffix", "matches", "", "configurationName", "replacement", "COMPILE", "PROVIDED", "APK", "android.sdktools.lint-checks"})
    private static final class DeprecatedConfiguration
    extends Enum<DeprecatedConfiguration> {
        @NotNull
        private final String deprecatedName;
        @NotNull
        private final String replacementName;
        @NotNull
        private final String deprecatedSuffix;
        @NotNull
        private final String replacementSuffix;
        public static final /* enum */ DeprecatedConfiguration COMPILE = new DeprecatedConfiguration("compile", "implementation");
        public static final /* enum */ DeprecatedConfiguration PROVIDED = new DeprecatedConfiguration("provided", "compileOnly");
        public static final /* enum */ DeprecatedConfiguration APK = new DeprecatedConfiguration("apk", "runtimeOnly");
        private static final /* synthetic */ DeprecatedConfiguration[] $VALUES;

        private DeprecatedConfiguration(String deprecatedName, String replacementName) {
            this.deprecatedName = deprecatedName;
            this.replacementName = replacementName;
            this.deprecatedSuffix = StringHelper.usLocaleCapitalize((String)this.deprecatedName);
            this.replacementSuffix = StringHelper.usLocaleCapitalize((String)this.replacementName);
        }

        public final boolean matches(@NotNull String configurationName) {
            Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) || StringsKt.endsWith$default((String)configurationName, (String)this.deprecatedSuffix, (boolean)false, (int)2, null);
        }

        @NotNull
        public final String replacement(@NotNull String configurationName) {
            Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
            return Intrinsics.areEqual((Object)configurationName, (Object)this.deprecatedName) ? this.replacementName : Intrinsics.stringPlus((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.deprecatedSuffix), (Object)this.replacementSuffix);
        }

        public static DeprecatedConfiguration[] values() {
            return (DeprecatedConfiguration[])$VALUES.clone();
        }

        public static DeprecatedConfiguration valueOf(String value) {
            return Enum.valueOf(DeprecatedConfiguration.class, value);
        }

        static {
            $VALUES = deprecatedConfigurationArray = new DeprecatedConfiguration[]{DeprecatedConfiguration.COMPILE, DeprecatedConfiguration.PROVIDED, DeprecatedConfiguration.APK};
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001hB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010E\u001a\u00020FJ\u001e\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010G\u001a\u00020F2\u0006\u0010H\u001a\u00020FJ&\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020\u0007JJ\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020D2\u0006\u0010L\u001a\u00020\u00072\u0006\u0010M\u001a\u00020\u00072\u0006\u0010N\u001a\u00020\u00072\u0006\u0010O\u001a\u00020\u00072\u0006\u0010P\u001a\u00020\u00072\u0006\u0010Q\u001a\u00020\u00072\n\b\u0002\u0010R\u001a\u0004\u0018\u00010\u0007J\u001a\u0010S\u001a\u0004\u0018\u00010?2\u0006\u0010T\u001a\u00020U2\u0006\u0010V\u001a\u000204H\u0002J2\u0010W\u001a\u0004\u0018\u00010?2\u0006\u0010T\u001a\u00020U2\u0006\u0010X\u001a\u00020.2\u000e\u0010Y\u001a\n\u0012\u0004\u0012\u00020?\u0018\u00010Z2\u0006\u0010[\u001a\u00020\\H\u0007J\u0012\u0010]\u001a\u0004\u0018\u00010\u00072\u0006\u0010^\u001a\u00020\u0007H\u0007J\u0010\u0010_\u001a\u00020\\2\u0006\u0010X\u001a\u00020\u0007H\u0002J\u0010\u0010`\u001a\u00020\\2\u0006\u0010X\u001a\u00020\u0007H\u0002J\u0010\u0010a\u001a\u00020\\2\u0006\u0010b\u001a\u00020\u0007H\u0002J\u0018\u0010c\u001a\u00020\\2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020\u0007H\u0002J\u0010\u0010g\u001a\u00020\\2\u0006\u0010d\u001a\u00020eH\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00070\u001f\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0010\u0010\"\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010(\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010,\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020.X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010/\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00100\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00101\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u00102\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00103\u001a\u000204X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u00105\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u001c\u00106\u001a\u0004\u0018\u000107X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0014\u0010<\u001a\b\u0012\u0004\u0012\u00020\u00070=X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010>\u001a\u0004\u0018\u00010?X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010@\u001a\u000204X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006i"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion;", "", "()V", "ACCIDENTAL_OCTAL", "Lcom/android/tools/lint/detector/api/Issue;", "AGP_DEPENDENCY", "ANDROID_WEAR_GROUP_ID", "", "ANNOTATION_PROCESSOR_ON_COMPILE_PATH", "APP_PLUGIN_ID", "BUNDLED_GMS", "COMPATIBILITY", "DATA_BINDING_WITHOUT_KAPT", "DEPENDENCY", "DEPRECATED", "DEPRECATED_CONFIGURATION", "DEPRECATED_LIBRARY", "DEV_MODE_OBSOLETE", "DUPLICATE_CLASSES", "EXPIRED_TARGET_SDK_VERSION", "EXPIRING_TARGET_SDK_VERSION", "FIREBASE_GROUP_ID", "GMS_GROUP_ID", "GOOGLE_SUPPORT_GROUP_ID", "GRADLE_GETTER", "GRADLE_PLUGIN_COMPATIBILITY", "HIGH_APP_VERSION_CODE", "IDE_SUPPORT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "JAVA_PLUGIN_IDS", "", "getJAVA_PLUGIN_IDS", "()Ljava/util/List;", "JAVA_PLUGIN_LANGUAGE_LEVEL", "JCENTER_REPOSITORY_OBSOLETE", "KEY_COORDINATE", "KTX_EXTENSION_AVAILABLE", "LIB_PLUGIN_ID", "LIFECYCLE_ANNOTATION_PROCESSOR_WITH_JAVA8", "MIN_SDK_TOO_LOW", "NOT_INTERPOLATED", "OLD_APP_PLUGIN_ID", "OLD_LIB_PLUGIN_ID", "PATH", "PLAY_SERVICES_V650", "Lcom/android/ide/common/repository/GradleCoordinate;", "PLUS", "REMOTE_VERSION", "RISKY_LIBRARY", "STRING_INTEGER", "VERSION_CODE_HIGH_THRESHOLD", "", "WEARABLE_ARTIFACT_ID", "calendar", "Ljava/util/Calendar;", "getCalendar", "()Ljava/util/Calendar;", "setCalendar", "(Ljava/util/Calendar;)V", "commonAnnotationProcessors", "", "latestBuildTools", "Lcom/android/ide/common/repository/GradleVersion;", "majorBuildTools", "getDependencyLocation", "Lcom/android/tools/lint/detector/api/Location;", "context", "Lcom/android/tools/lint/detector/api/Context;", "c", "Lcom/android/tools/lint/model/LintModelMavenName;", "address1", "address2", "groupId", "artifactId", "version", "groupId1", "artifactId1", "version1", "groupId2", "artifactId2", "version2", "message", "getLatestBuildTools", "client", "Lcom/android/tools/lint/client/api/LintClient;", "major", "getLatestVersionFromRemoteRepo", "dependency", "filter", "Ljava/util/function/Predicate;", "allowPreview", "", "getNamedDependency", "expression", "hasLifecycleAnnotationProcessor", "isCommonAnnotationProcessor", "libraryHasKtxExtension", "mavenName", "suggestApiConfigurationUse", "project", "Lcom/android/tools/lint/detector/api/Project;", "configuration", "targetJava8Plus", "CompileConfiguration", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final Calendar getCalendar() {
            return calendar;
        }

        public final void setCalendar(@Nullable Calendar calendar) {
            GradleDetector.calendar = calendar;
        }

        @NotNull
        public final List<String> getJAVA_PLUGIN_IDS() {
            return JAVA_PLUGIN_IDS;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context2, @NotNull LintModelMavenName c10) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)c10, (String)"c");
            return this.getDependencyLocation(context2, c10.getGroupId(), c10.getArtifactId(), c10.getVersion());
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context2, @NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
            Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            LintClient client = context2.getClient();
            File projectDir = context2.getProject().getDir();
            String withoutQuotes = groupId + ':' + artifactId + ':' + version;
            Intrinsics.checkExpressionValueIsNotNull((Object)projectDir, (String)"projectDir");
            Location location = Lint.guessGradleLocation(client, projectDir, withoutQuotes);
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation(client, projectDir, groupId + ':' + artifactId + ':');
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation(client, projectDir, artifactId);
            if (location.getStart() != null) {
                return location;
            }
            location = Lint.guessGradleLocation(client, projectDir, groupId);
            return location;
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context2, @NotNull LintModelMavenName address1, @NotNull LintModelMavenName address2) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)address1, (String)"address1");
            Intrinsics.checkParameterIsNotNull((Object)address2, (String)"address2");
            return com.android.tools.lint.checks.GradleDetector$Companion.getDependencyLocation$default(this, context2, address1.getGroupId(), address1.getArtifactId(), address1.getVersion(), address2.getGroupId(), address2.getArtifactId(), address2.getVersion(), null, 128, null);
        }

        @NotNull
        public final Location getDependencyLocation(@NotNull Context context2, @NotNull String groupId1, @NotNull String artifactId1, @NotNull String version1, @NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @Nullable String message2) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            Intrinsics.checkParameterIsNotNull((Object)groupId1, (String)"groupId1");
            Intrinsics.checkParameterIsNotNull((Object)artifactId1, (String)"artifactId1");
            Intrinsics.checkParameterIsNotNull((Object)version1, (String)"version1");
            Intrinsics.checkParameterIsNotNull((Object)groupId2, (String)"groupId2");
            Intrinsics.checkParameterIsNotNull((Object)artifactId2, (String)"artifactId2");
            Intrinsics.checkParameterIsNotNull((Object)version2, (String)"version2");
            Location location1 = this.getDependencyLocation(context2, groupId1, artifactId1, version1);
            Location location2 = this.getDependencyLocation(context2, groupId2, artifactId2, version2);
            if (location2.getStart() != null || !Intrinsics.areEqual((Object)location1.getFile(), (Object)location2.getFile())) {
                location1.setSecondary(location2);
                String string = message2;
                if (string != null) {
                    String string2 = string;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    String it2 = string2;
                    boolean bl4 = false;
                    location2.setMessage(it2);
                }
            }
            return location1;
        }

        public static /* synthetic */ Location getDependencyLocation$default(Companion companion, Context context2, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n10, Object object) {
            if ((n10 & 0x80) != 0) {
                string7 = null;
            }
            return companion.getDependencyLocation(context2, string, string2, string3, string4, string5, string6, string7);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @Nullable
        public final GradleVersion getLatestVersionFromRemoteRepo(@NotNull LintClient client, @NotNull GradleCoordinate dependency, @Nullable Predicate<GradleVersion> filter, boolean allowPreview) {
            GradleVersion it2;
            Iterable $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            void $this$filter$iv2;
            GradleVersion version22;
            Object jre2;
            String substring;
            Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
            Intrinsics.checkParameterIsNotNull((Object)dependency, (String)"dependency");
            String groupId = dependency.getGroupId();
            String artifactId = dependency.getArtifactId();
            StringBuilder query = new StringBuilder();
            String encoding = Charsets.UTF_8.name();
            try {
                query.append("http://search.maven.org/solrsearch/select?q=g:%22");
                query.append(URLEncoder.encode(groupId, encoding));
                query.append("%22+AND+a:%22");
                query.append(URLEncoder.encode(artifactId, encoding));
            }
            catch (UnsupportedEncodingException e10) {
                return null;
            }
            query.append("%22&core=gav");
            if (!Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava") && !Intrinsics.areEqual((Object)artifactId, (Object)"kotlinx-coroutines-core") && filter == null && allowPreview) {
                query.append("&rows=1");
            }
            query.append("&wt=json");
            String response = null;
            try {
                String string = query.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"query.toString()");
                response = Lint.readUrlDataAsString(client, string, 20000);
                if (response == null) {
                    return null;
                }
            }
            catch (IOException e11) {
                Object[] objectArray = new Object[]{dependency};
                client.log(null, "Could not connect to maven central to look up the latest available version for %1$s", objectArray);
                return null;
            }
            int index = StringsKt.indexOf$default((CharSequence)response, (String)"\"response\"", (int)0, (boolean)false, (int)6, null);
            boolean bl2 = false;
            List versions = new ArrayList();
            while (index != -1) {
                if ((index = StringsKt.indexOf$default((CharSequence)response, (String)"\"v\":", (int)index, (boolean)false, (int)4, null)) == -1) continue;
                int start = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(index += 4), (boolean)false, (int)4, null) + 1;
                int end = StringsKt.indexOf$default((CharSequence)response, (char)'\"', (int)(start + 1), (boolean)false, (int)4, null);
                boolean bl3 = 0 <= start ? start < end : false;
                if (!bl3) continue;
                String string = response;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)string.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                GradleVersion revision = GradleVersion.tryParse((String)substring);
                if (revision == null) continue;
                versions.add(revision);
            }
            if (Intrinsics.areEqual((Object)groupId, (Object)"com.google.guava")) {
                GradleVersion version = dependency.getVersion();
                if (version != null) {
                    void $this$filterTo$iv$iv2;
                    void $this$filter$iv3;
                    substring = version.toString();
                    Intrinsics.checkExpressionValueIsNotNull((Object)substring, (String)"version.toString()");
                    String suffix = substring;
                    jre2 = getLatestVersionFromRemoteRepo.jre.1.INSTANCE;
                    Function1 android2 = getLatestVersionFromRemoteRepo.android.1.INSTANCE;
                    Iterable iterable = versions;
                    Object predicate$iv2 = StringsKt.endsWith$default((String)suffix, (String)"-jre", (boolean)false, (int)2, null) ? jre2 : android2;
                    boolean $i$f$filter = false;
                    void var19_33 = $this$filter$iv3;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                        if (!((Boolean)predicate$iv2.invoke(element$iv$iv)).booleanValue()) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    return (GradleVersion)CollectionsKt.max((Iterable)((List)destination$iv$iv));
                }
            } else if (Intrinsics.areEqual((Object)artifactId, (Object)"kotlinx-coroutines-core") && (version22 = dependency.getVersion()) != null) {
                void $this$filterTo$iv$iv3;
                jre2 = version22.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)jre2, (String)"version.toString()");
                String suffix = jre2;
                jre2 = versions;
                Function1 predicate$iv = StringsKt.indexOf$default((CharSequence)suffix, (char)'-', (int)0, (boolean)false, (int)6, null) == -1 ? (Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GradleVersion it2) {
                        boolean bl2;
                        Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                        if (this.$allowPreview || !it2.isPreview()) {
                            String string = it2.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"-native-mt", (boolean)false, (int)2, null)) {
                                bl2 = true;
                                return bl2;
                            }
                        }
                        bl2 = false;
                        return bl2;
                    }
                } : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt-2", (boolean)false, (int)2, null) ? (Function1)getLatestVersionFromRemoteRepo.2.INSTANCE : (StringsKt.contains$default((CharSequence)suffix, (CharSequence)"-native-mt", (boolean)false, (int)2, null) ? (Function1)getLatestVersionFromRemoteRepo.3.INSTANCE : (Function1)new Function1<GradleVersion, Boolean>(allowPreview){
                    final /* synthetic */ boolean $allowPreview;
                    {
                        this.$allowPreview = $allowPreview;
                        super(1);
                    }

                    /*
                     * Enabled aggressive block sorting
                     */
                    @NotNull
                    public final Boolean invoke(@NotNull GradleVersion it2) {
                        boolean bl2;
                        Intrinsics.checkParameterIsNotNull((Object)it2, (String)"it");
                        if (this.$allowPreview || !it2.isPreview()) {
                            String string = it2.toString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"it.toString()");
                            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"-native-mt", (boolean)false, (int)2, null)) {
                                bl2 = true;
                                return bl2;
                            }
                        }
                        bl2 = false;
                        return bl2;
                    }
                }));
                boolean $i$f$filter = false;
                void predicate$iv2 = $this$filter$iv2;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv3) {
                    if (!((Boolean)predicate$iv.invoke(element$iv$iv)).booleanValue()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                return (GradleVersion)CollectionsKt.max((Iterable)((List)destination$iv$iv));
            }
            Iterable version22 = versions;
            boolean $i$f$filter = false;
            $this$filter$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (GradleVersion)element$iv$iv;
                boolean bl5 = false;
                if (!(filter == null || filter.test(it2))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            $i$f$filter = false;
            $this$filterTo$iv$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList();
            $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it2 = (GradleVersion)element$iv$iv;
                boolean bl6 = false;
                if (!(allowPreview || !it2.isPreview())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (GradleVersion)CollectionsKt.max((Iterable)((List)destination$iv$iv));
        }

        @JvmStatic
        @Nullable
        public final String getNamedDependency(@NotNull String expression) {
            Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
            if (StringsKt.indexOf$default((CharSequence)expression, (char)',', (int)0, (boolean)false, (int)6, null) != -1 && StringsKt.contains$default((CharSequence)expression, (CharSequence)"version:", (boolean)false, (int)2, null)) {
                String artifact = null;
                String group = null;
                String version = null;
                Splitter splitter = Splitter.on((char)',').omitEmptyStrings().trimResults();
                for (String property : splitter.split((CharSequence)expression)) {
                    String value;
                    Intrinsics.checkExpressionValueIsNotNull((Object)property, (String)"property");
                    int colon = StringsKt.indexOf$default((CharSequence)property, (char)':', (int)0, (boolean)false, (int)6, null);
                    if (colon == -1) {
                        return null;
                    }
                    char quote = '\'';
                    int valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    if (valueStart == -1) {
                        quote = '\"';
                        valueStart = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(colon + 1), (boolean)false, (int)4, null);
                    }
                    if (valueStart == -1) continue;
                    int n10 = valueStart;
                    int valueEnd = StringsKt.indexOf$default((CharSequence)property, (char)quote, (int)(valueStart = n10 + 1), (boolean)false, (int)4, null);
                    if (valueEnd == -1) {
                        return null;
                    }
                    String string = property;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)string.substring(valueStart, valueEnd), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    if (StringsKt.startsWith$default((String)property, (String)"group:", (boolean)false, (int)2, null)) {
                        group = value;
                        continue;
                    }
                    if (StringsKt.startsWith$default((String)property, (String)"name:", (boolean)false, (int)2, null)) {
                        artifact = value;
                        continue;
                    }
                    if (!StringsKt.startsWith$default((String)property, (String)"version:", (boolean)false, (int)2, null)) continue;
                    version = value;
                }
                if (artifact != null && group != null && version != null) {
                    return group + ':' + artifact + ':' + version;
                }
            }
            return null;
        }

        private final GradleVersion getLatestBuildTools(LintClient client, int major) {
            if (major != majorBuildTools) {
                File[] dirs;
                majorBuildTools = major;
                ArrayList<GradleVersion> revisions = new ArrayList<GradleVersion>();
                int n10 = major;
                switch (n10) {
                    case 267: {
                        revisions.add(new GradleVersion(27, 0, 3));
                        break;
                    }
                    case 26: {
                        revisions.add(new GradleVersion(26, 0, 3));
                        break;
                    }
                    case 25: {
                        revisions.add(new GradleVersion(25, 0, 3));
                        break;
                    }
                    case 24: {
                        revisions.add(new GradleVersion(24, 0, 3));
                        break;
                    }
                    case 23: {
                        revisions.add(new GradleVersion(23, 0, 3));
                        break;
                    }
                    case 22: {
                        revisions.add(new GradleVersion(22, 0, 1));
                        break;
                    }
                    case 21: {
                        revisions.add(new GradleVersion(21, 1, 2));
                        break;
                    }
                    case 20: {
                        revisions.add(new GradleVersion(20, 0));
                        break;
                    }
                    case 19: {
                        revisions.add(new GradleVersion(19, 1));
                        break;
                    }
                    case 18: {
                        revisions.add(new GradleVersion(18, 1, 1));
                    }
                }
                File sdkHome = client.getSdkHome();
                if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                    for (File dir : dirs) {
                        GradleVersion v10;
                        String name = dir.getName();
                        if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v10 = GradleVersion.tryParse((String)name)) == null || v10.getMajor() != major) continue;
                        revisions.add(v10);
                    }
                }
                Collection collection = revisions;
                boolean bl2 = false;
                if (!collection.isEmpty()) {
                    latestBuildTools = (GradleVersion)Collections.max((Collection)revisions);
                }
            }
            return latestBuildTools;
        }

        private final boolean suggestApiConfigurationUse(Project project, String configuration) {
            boolean bl2;
            if (StringsKt.startsWith$default((String)configuration, (String)"test", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)configuration, (String)"androidTest", (boolean)false, (int)2, null)) {
                bl2 = false;
            } else {
                LintModelModuleType lintModelModuleType = project.getType();
                int n10 = lintModelModuleType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lintModelModuleType.ordinal()];
                switch (n10) {
                    case 1: {
                        bl2 = project.hasDynamicFeatures();
                        break;
                    }
                    case 2: {
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        bl2 = true;
                        break;
                    }
                    case 4: 
                    case 5: {
                        bl2 = true;
                        break;
                    }
                    case 6: {
                        bl2 = false;
                        break;
                    }
                    case 7: {
                        bl2 = false;
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return bl2;
        }

        private final boolean targetJava8Plus(Project project) {
            return Lint.getLanguageLevel(project, LanguageLevel.JDK_1_7).isAtLeast(LanguageLevel.JDK_1_8);
        }

        private final boolean hasLifecycleAnnotationProcessor(String dependency) {
            return StringsKt.contains$default((CharSequence)dependency, (CharSequence)"android.arch.lifecycle:compiler", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)dependency, (CharSequence)"androidx.lifecycle:lifecycle-compiler", (boolean)false, (int)2, null);
        }

        private final boolean isCommonAnnotationProcessor(String dependency) {
            boolean bl2;
            int index = StringsKt.lastIndexOf$default((CharSequence)dependency, (String)":", (int)0, (boolean)false, (int)6, null);
            if (index == -1) {
                bl2 = false;
            } else {
                Set set = commonAnnotationProcessors;
                String string = dependency;
                int n10 = 0;
                boolean bl3 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n10, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                bl2 = set.contains(string3);
            }
            return bl2;
        }

        private final boolean libraryHasKtxExtension(String mavenName) {
            boolean bl2;
            switch (mavenName) {
                case "androidx.palette:palette": 
                case "androidx.paging:paging-runtime": 
                case "androidx.lifecycle:lifecycle-viewmodel": 
                case "androidx.dynamicanimation:dynamicanimation": 
                case "androidx.lifecycle:lifecycle-livedata": 
                case "androidx.lifecycle:lifecycle-reactivestreams": 
                case "androidx.navigation:navigation-ui": 
                case "com.google.android.play:core": 
                case "androidx.lifecycle:lifecycle-livedata-core": 
                case "androidx.activity:activity": 
                case "androidx.core:core": 
                case "androidx.lifecycle:lifecycle-runtime": 
                case "androidx.navigation:navigation-runtime": 
                case "androidx.paging:paging-common": 
                case "androidx.fragment:fragment": 
                case "androidx.paging:paging-rxjava2": 
                case "androidx.sqlite:sqlite": 
                case "androidx.slice:slice-builders": 
                case "androidx.navigation:navigation-fragment": 
                case "androidx.collection:collection": 
                case "androidx.preference:preference": {
                    bl2 = true;
                    break;
                }
                default: {
                    bl2 = false;
                }
            }
            return bl2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\n\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u000bj\u0002\b\fj\u0002\b\rj\u0002\b\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/GradleDetector$Companion$CompileConfiguration;", "", "compileConfigName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "annotationProcessor", "compileConfigSuffix", "matches", "", "configurationName", "replacement", "API", "COMPILE", "IMPLEMENTATION", "COMPILE_ONLY", "android.sdktools.lint-checks"})
        private static final class CompileConfiguration
        extends Enum<CompileConfiguration> {
            @NotNull
            private final String compileConfigName;
            @NotNull
            private final String annotationProcessor;
            @NotNull
            private final String compileConfigSuffix;
            public static final /* enum */ CompileConfiguration API = new CompileConfiguration("api");
            public static final /* enum */ CompileConfiguration COMPILE = new CompileConfiguration("compile");
            public static final /* enum */ CompileConfiguration IMPLEMENTATION = new CompileConfiguration("implementation");
            public static final /* enum */ CompileConfiguration COMPILE_ONLY = new CompileConfiguration("compileOnly");
            private static final /* synthetic */ CompileConfiguration[] $VALUES;

            private CompileConfiguration(String compileConfigName) {
                this.compileConfigName = compileConfigName;
                this.annotationProcessor = "annotationProcessor";
                this.compileConfigSuffix = StringHelper.usLocaleCapitalize((String)this.compileConfigName);
            }

            public final boolean matches(@NotNull String configurationName) {
                Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) || StringsKt.endsWith$default((String)configurationName, (String)this.compileConfigSuffix, (boolean)false, (int)2, null);
            }

            @NotNull
            public final String replacement(@NotNull String configurationName) {
                Intrinsics.checkParameterIsNotNull((Object)configurationName, (String)"configurationName");
                return Intrinsics.areEqual((Object)configurationName, (Object)this.compileConfigName) ? this.annotationProcessor : StringHelper.appendCapitalized((String)StringsKt.removeSuffix((String)configurationName, (CharSequence)this.compileConfigSuffix), (String)this.annotationProcessor);
            }

            public static CompileConfiguration[] values() {
                return (CompileConfiguration[])$VALUES.clone();
            }

            public static CompileConfiguration valueOf(String value) {
                return Enum.valueOf(CompileConfiguration.class, value);
            }

            static {
                $VALUES = compileConfigurationArray = new CompileConfiguration[]{CompileConfiguration.API, CompileConfiguration.COMPILE, CompileConfiguration.IMPLEMENTATION, CompileConfiguration.COMPILE_ONLY};
            }
        }

        @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LintModelModuleType.values().length];
                nArray[LintModelModuleType.APP.ordinal()] = 1;
                nArray[LintModelModuleType.LIBRARY.ordinal()] = 2;
                nArray[LintModelModuleType.JAVA_LIBRARY.ordinal()] = 3;
                nArray[LintModelModuleType.FEATURE.ordinal()] = 4;
                nArray[LintModelModuleType.DYNAMIC_FEATURE.ordinal()] = 5;
                nArray[LintModelModuleType.TEST.ordinal()] = 6;
                nArray[LintModelModuleType.INSTANT_APP.ordinal()] = 7;
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

