/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.TypoLookup;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.TextFormat;
import com.android.utils.StringHelper;
import com.intellij.lang.jvm.JvmParameter;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiRecursiveElementVisitor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastLiteralUtils;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.JavaUField;
import org.jetbrains.uast.kotlin.KotlinStringTemplateUPolyadicExpression;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u00012\u00020\u0002:\u0002 !B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0011\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\u001a\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\u000eH\u0016J \u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "()V", "visitedTestClasses", "", "", "applicableSuperClasses", "", "checkDocumentationExamples", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "testClass", "Lorg/jetbrains/uast/UClass;", "checkIssueRegistry", "declaration", "checkKotlin", "checkTestFile", "testFile", "Lorg/jetbrains/uast/UExpression;", "visitor", "Lcom/android/tools/lint/checks/LintDetectorDetector$LintDetectorVisitor;", "getApplicableMethodNames", "getCopyrightYear", "", "visitClass", "visitMethodCall", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "LintDetectorVisitor", "android.sdktools.lint-checks"})
public final class LintDetectorDetector
extends Detector
implements Detector.UastScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Set<String> visitedTestClasses;
    @NotNull
    private static final String CLASS_LINT_CLIENT = "com.android.tools.lint.client.api.LintClient";
    @NotNull
    private static final String CLASS_DETECTOR = "com.android.tools.lint.detector.api.Detector";
    @NotNull
    private static final String CLASS_ISSUE_REGISTRY = "com.android.tools.lint.client.api.IssueRegistry";
    @NotNull
    private static final String CLASS_CONTEXT = "com.android.tools.lint.detector.api.Context";
    @NotNull
    private static final String CLASS_ISSUE = "com.android.tools.lint.detector.api.Issue";
    @NotNull
    private static final String CLASS_ISSUE_COMPANION = "com.android.tools.lint.detector.api.Issue.Companion";
    @NotNull
    private static final String CLASS_TEST_LINT_TASK = "com.android.tools.lint.checks.infrastructure.TestLintTask";
    @NotNull
    private static final String CLASS_TEST_LINT_RESULT = "com.android.tools.lint.checks.infrastructure..TestLintResult";
    @NotNull
    private static final String CLASS_PSI_METHOD = "com.intellij.psi.PsiMethod";
    @NotNull
    private static final String CLASS_PSI_ELEMENT = "com.intellij.psi.PsiElement";
    @NotNull
    private static final String CLASS_PSI_VARIABLE = "com.intellij.psi.PsiVariable";
    @NotNull
    private static final String CLASS_PSI_TREE_UTIL = "com.intellij.psi.util.PsiTreeUtil";
    @NotNull
    private static final String CLASS_PSI_JVM_MEMBER = "com.intellij.psi.PsiJvmMember";
    @NotNull
    private static final String CLASS_U_ELEMENT = "org.jetbrains.uast.UElement";
    @NotNull
    private static final String DOLLAR_STRING = "${\"$\"}";
    @NotNull
    private static final String DOLLAR_CHAR = "${'$'}";
    @NotNull
    private static final Regex CAMELCASE_PATTERN = new Regex("[a-zA-Z]+[a-z]+[A-Z][a-z]+");
    @NotNull
    private static final Regex CALL_PATTERN = new Regex("[a-zA-Z().=]+\\(.*\\)");
    @NotNull
    private static final Regex XML_PATTERN = new Regex("<.+>");
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(LintDetectorDetector.class, Scope.JAVA_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue ID;
    @JvmField
    @NotNull
    public static final Issue CHECK_URL;
    @JvmField
    @NotNull
    public static final Issue UNEXPECTED_DOMAIN;
    @JvmField
    @NotNull
    public static final Issue TEXT_FORMAT;
    @JvmField
    @NotNull
    public static final Issue EXISTING_LINT_CONSTANTS;
    @JvmField
    @NotNull
    public static final Issue USE_UAST;
    @JvmField
    @NotNull
    public static final Issue PSI_COMPARE;
    @JvmField
    @NotNull
    public static final Issue USE_KOTLIN;
    @JvmField
    @NotNull
    public static final Issue MISSING_VENDOR;
    @JvmField
    @NotNull
    public static final Issue TRIM_INDENT;
    @JvmField
    @NotNull
    public static final Issue DOLLAR_STRINGS;
    @JvmField
    @NotNull
    public static final Issue MISSING_DOC_EXAMPLE;

    public LintDetectorDetector() {
        boolean bl2 = false;
        this.visitedTestClasses = new LinkedHashSet();
    }

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        Object[] objectArray = new String[]{CLASS_DETECTOR, CLASS_ISSUE_REGISTRY};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"expect", "expectFixDiffs", "files", "projects", "lint"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        String methodName;
        String string;
        String string2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)method, (String)"method");
        String string3 = node.getMethodName();
        if (string3 == null) {
            object = node.getMethodIdentifier();
            String string4 = string2 = object == null ? null : object.getName();
            if (string2 == null) {
                return;
            }
            string = string2;
        } else {
            string = string3;
        }
        switch (methodName = string) {
            case "expect": 
            case "expectFixDiffs": {
                string2 = method.getReturnType();
                if (!Intrinsics.areEqual((Object)(string2 == null ? null : string2.getCanonicalText()), (Object)CLASS_TEST_LINT_RESULT)) {
                    return;
                }
                string2 = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                if (string2 == null) break;
                object = string2;
                boolean bl2 = false;
                boolean bl3 = false;
                Object it2 = object;
                boolean bl4 = false;
                new LintDetectorVisitor(context2).checkTrimIndent((UExpression)it2, false);
                break;
            }
            case "projects": 
            case "files": {
                string2 = method.getReturnType();
                if (!Intrinsics.areEqual((Object)(string2 == null ? null : string2.getCanonicalText()), (Object)CLASS_TEST_LINT_TASK)) {
                    return;
                }
                Object visitor2 = new LintDetectorVisitor(context2);
                for (UExpression testFile : node.getValueArguments()) {
                    this.checkTestFile(testFile, (LintDetectorVisitor)((Object)visitor2));
                }
                break;
            }
            case "lint": {
                String qualifiedName;
                Object visitor2 = method.getReturnType();
                if (!Intrinsics.areEqual((Object)(visitor2 == null ? null : visitor2.getCanonicalText()), (Object)CLASS_TEST_LINT_TASK)) {
                    return;
                }
                UClass testClass = (UClass)UastUtils.getParentOfType$default((UElement)((UElement)node), UClass.class, (boolean)false, (int)2, null);
                UClass uClass = testClass;
                String string5 = qualifiedName = uClass == null ? null : uClass.getQualifiedName();
                if (testClass == null || qualifiedName == null || !this.visitedTestClasses.add(qualifiedName)) break;
                this.checkDocumentationExamples(context2, testClass);
            }
        }
    }

    private final void checkTestFile(UExpression testFile, LintDetectorVisitor visitor2) {
        if (testFile instanceof UCallExpression) {
            visitor2.checkTestFile((UCallExpression)testFile);
        } else if (testFile instanceof UReferenceExpression) {
            PsiElement resolved = ((UReferenceExpression)testFile).resolve();
            if (resolved != null) {
                if (resolved instanceof UVariable) {
                    UExpression initializer = ((UVariable)resolved).getUastInitializer();
                    if (initializer instanceof UCallExpression) {
                        visitor2.checkTestFile((UCallExpression)initializer);
                    }
                } else if (resolved instanceof PsiVariable) {
                    UElement initializer = UastContextKt.toUElement((PsiElement)((PsiElement)((PsiVariable)resolved).getInitializer()));
                    if (initializer instanceof UCallExpression) {
                        visitor2.checkTestFile((UCallExpression)initializer);
                    }
                } else if (resolved instanceof PsiMethod) {
                    String string = ((PsiMethod)resolved).getName();
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolved.name");
                    String method = string;
                    if (Intrinsics.areEqual((Object)method, (Object)"indented") && testFile instanceof UQualifiedReferenceExpression) {
                        this.checkTestFile(((UQualifiedReferenceExpression)testFile).getReceiver(), visitor2);
                    }
                }
            }
        } else if (testFile instanceof UParenthesizedExpression) {
            this.checkTestFile(((UParenthesizedExpression)testFile).getExpression(), visitor2);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkDocumentationExamples(JavaContext context2, UClass testClass) {
        void $this$filterTo$iv$iv;
        Iterator $this$filter$iv;
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv;
        if (this.getCopyrightYear(context2) < 2021) {
            return;
        }
        Iterable iterable = testClass.getUastDeclarations();
        boolean $i$f$filterIsInstance = false;
        void var6_6 = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof UMethod)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterIsInstanceTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            UMethod it2 = (UMethod)element$iv$iv;
            boolean bl2 = false;
            if (!StringsKt.startsWith$default((String)it2.getName(), (String)"test", (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List tests = (List)destination$iv$iv;
        if (tests.isEmpty()) {
            return;
        }
        for (UMethod name : tests) {
            if (!StringsKt.startsWith$default((String)name.getName(), (String)"testDocumentationExample", (boolean)false, (int)2, null)) continue;
            return;
        }
        UMethod element = (UMethod)CollectionsKt.first((List)tests);
        context2.report(MISSING_DOC_EXAMPLE, element, context2.getLocation(element), "Expected to also find a documentation example test (`testDocumentationExample`) which shows a simple, typical scenario which triggers the test, and which will be extracted into lint's per-issue documentation pages");
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)declaration, (String)"declaration");
        this.checkKotlin(context2, declaration);
        declaration.accept((UastVisitor)new LintDetectorVisitor(context2));
        if (JavaEvaluator.inheritsFrom$default(context2.getEvaluator(), (PsiClass)declaration, CLASS_ISSUE_REGISTRY, false, 4, null)) {
            this.checkIssueRegistry(context2, declaration);
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void checkIssueRegistry(JavaContext context, UClass declaration) {
        methods = declaration.getJavaPsi().getAllMethods();
        Intrinsics.checkExpressionValueIsNotNull((Object)methods, (String)"methods");
        $this$count$iv = methods;
        $i$f$count = false;
        count$iv = 0;
        var8_7 = $this$count$iv;
        var9_8 = var8_7.length;
        for (var10_9 = 0; var10_9 < var9_8; ++var10_9) {
            it = element$iv = var8_7[var10_9];
            $i$a$-count-LintDetectorDetector$checkIssueRegistry$count$1 = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"getVendor")) ** GOTO lbl-1000
            var14_13 /* !! */  = it.getParameters();
            Intrinsics.checkExpressionValueIsNotNull((Object)var14_13 /* !! */ , (String)"it.parameters");
            var14_13 /* !! */  = var14_13 /* !! */ ;
            var15_14 = false;
            if (var14_13 /* !! */ .length == 0) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!v0) continue;
            ++count$iv;
        }
        count = count$iv;
        if (count <= 1) {
            name = declaration.getQualifiedName();
            if (name != null && StringsKt.startsWith$default((String)name, (String)"com.android.tools.lint.client.api.", (boolean)false, (int)2, null)) {
                return;
            }
            context.report(LintDetectorDetector.MISSING_VENDOR, declaration, context.getNameLocation(declaration), "An `IssueRegistry` should override the `vendor` property");
        }
    }

    private final int getCopyrightYear(JavaContext context2) {
        block4: {
            String yearString;
            int n10;
            block6: {
                block5: {
                    String source = String.valueOf(context2.getContents());
                    int yearIndex = StringsKt.indexOf$default((CharSequence)source, (String)" 20", (int)0, (boolean)false, (int)6, null);
                    if (yearIndex == -1) break block4;
                    String string = source;
                    n10 = yearIndex + 1;
                    int n11 = yearIndex + 5;
                    boolean bl2 = false;
                    String string2 = string;
                    if (string2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string3 = string2.substring(n10, n11);
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    yearString = string3;
                    char c10 = yearString.charAt(2);
                    n10 = 0;
                    if (!Character.isDigit(c10)) break block5;
                    c10 = yearString.charAt(3);
                    n10 = 0;
                    if (Character.isDigit(c10)) break block6;
                }
                return -1;
            }
            String string = yearString;
            n10 = 0;
            return Integer.parseInt(string);
        }
        return -1;
    }

    private final void checkKotlin(JavaContext context2, UClass declaration) {
        if (!Lint.isKotlin(declaration.getSourcePsi()) && this.getCopyrightYear(context2) >= 2020) {
            context2.report(USE_KOTLIN, declaration, context2.getNameLocation(declaration), "New lint checks should be implemented in Kotlin to take advantage of a lot of Kotlin-specific mechanisms in the Lint API");
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CUSTOM_LINT_CHECKS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        EnumSet<Platform> enumSet = Platform.JDK_SET;
        ID = Issue.Companion.create$default(companion, "LintImplIdFormat", "Lint ID Format", "\n                    This check looks at lint issue id registrations and makes sure the id \\\n                    follows the expected conventions: capitalized, camel case, no spaces, \\\n                    and not too long.\n\n                    Note: You shouldn't change id's for lint checks that are already widely \\\n                    used, since the id can already appear in `@SuppressLint` annotations, \\\n                    `tools:ignore=` attributes, lint baselines, Gradle `lintOptions` blocks, \\\n                    `lint.xml` files, and so on. In these cases, just explicitly suppress this \\\n                    warning instead using something like\n\n                    ```kotlin\n                    @JvmField\n                    val ISSUE = Issue.create(\n                        // ID string is too long, but we can't change this now since\n                        // this id is already used in user suppress configurations\n                        //noinspection LintImplIdFormat\n                        id = \"IncompatibleMediaBrowserServiceCompatVersion\",\n                        ...\n                    ```\n                ", implementation, null, category, 6, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        CHECK_URL = Issue.Companion.create$default(companion, "LintImplBadUrl", "Bad More Info Link", "\n                   More Info URLs let a link check point to additional resources about \\\n                   the problem and solution it's checking for.\n\n                   This check validates the URLs in various ways, such as making sure that \\\n                   issue tracker links look correct. It may also at some point touch the network \\\n                   to make sure that the URLs are actually still reachable.\n                ", implementation, null, category, 6, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        UNEXPECTED_DOMAIN = Issue.Companion.create$default(companion, "LintImplUnexpectedDomain", "Unexpected URL Domain", "\n                    This checks flags URLs to domains that have not been explicitly \\\n                    allowed for use as a documentation source.\n                ", implementation, null, category, 6, severity, false, null, enumSet, null, 2576, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        TEXT_FORMAT = Issue.Companion.create$default(companion, "LintImplTextFormat", "Lint Text Format", "\n                    Lint supports various markdown like formatting directives in all of its \\\n                    strings (issue explanations, reported error messages, etc).\n\n                    This lint check looks for strings that look like they may benefit from \\\n                    additional formatting. For example, if a snippet looks like code it should \\\n                    be surrounded with backticks.\n\n                    Note: Be careful changing **existing** strings; this may stop baseline file \\\n                    matching from working, so consider suppressing existing violations of this \\\n                    check if this is an error many users may be filtering in baselines. (This \\\n                    is only an issue for strings used in `report` calls; for issue registration \\\n                    strings like summaries and explanations there's no risk changing the text \\\n                    contents.)\n                ", implementation, null, category, 6, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        EXISTING_LINT_CONSTANTS = Issue.Companion.create$default(companion, "LintImplUseExistingConstants", "Use Existing Lint Constants", "\n                    This check looks for opportunities to reuse predefined lint constants.\n                ", implementation, null, category, 6, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        USE_UAST = Issue.Companion.create$default(companion, "LintImplUseUast", "Using Wrong UAST Method", "\n                    UAST is a library that sits on top of PSI, and in many cases PSI is \\\n                    part of the UAST API; for example, UResolvable#resolve returns a \\\n                    PsiElement.\n\n                    Also, for convenience, a UClass is a PsiClass, a UMethod is a PsiMethod, \\\n                    and so on.\n\n                    However, there are some parts of the PSI API that does not work correctly \\\n                    when used in this way. For example, if you call `PsiMethod#getBody` or \\\n                    `PsiVariable#getInitializer`, this will only work in Java, not for \\\n                    Kotlin (or potentially other languages).\n\n                    There are UAST specific methods you need to call instead and lint will \\\n                    flag these.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        PSI_COMPARE = Issue.Companion.create$default(companion, "LintImplPsiEquals", "Comparing PsiElements with Equals", "\n                    You should never compare two PSI elements for equality with `equals`;\n                    use `isEquivalentTo(PsiElement)` instead.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2576, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        USE_KOTLIN = Issue.Companion.create$default(companion, "LintImplUseKotlin", "Non-Kotlin Lint Detectors", "\n                    New lint checks should be written in Kotlin; the Lint API is written in \\\n                    Kotlin and uses a number of language features that makes it beneficial \\\n                    to also write the lint checks in Kotlin. Examples include many extension \\\n                    functions (as well as in UAST), default and named parameters (for the \\\n                    Issue registration methods for example where there are methods with 12+ \\\n                    parameters with only a couple of required ones), and so on.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        MISSING_VENDOR = Issue.Companion.create$default(companion, "MissingVendor", "IssueRegistry not providing a vendor", "\n                    Recent versions of lint includes a `vendor` property (or from Java, \\\n                    `getVendor` and `setVendor` methods) on `IssueRegistry`.\n\n                    You should override this property and point to a suitable vendor \\\n                    instance where you list the author (or organization or vendor) \\\n                    providing the lint check, a feedback URL, etc. (See the Vendor \\\n                    documentation.)\n\n                    The vendor info is included in a few places (such as HTML reports) \\\n                    and partially in a few other places (such as the identifier showing \\\n                    up at the end of each error line in the text output). This makes it \\\n                    easier for users to figure out where checks are coming from, since \\\n                    lint will pull in lint checks from a number of sources, and makes \\\n                    it clear where to go to provide feedback or file bug reports or \\\n                    requests.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        TRIM_INDENT = Issue.Companion.create$default(companion, "LintImplTrimIndent", "Calling `.trimIndent` on Lint Strings", "\n                    Lint implicitly calls `.trimIndent()` (lazily, at the last minute) in \\\n                    a number of places:\n                    * Issue explanations\n                    * Error messages\n                    * Lint test file descriptions\n                    * etc\n\n                    That means you don't need to put `.trimIndent()` in your source code \\\n                    to handle this.\n\n                    There are advantages to **not** putting `.trimIndent()` in the code. \\\n                    For test files, if you call for example `kotlin(\"\"\\\"source code\"\\\"\"\\\")` \\\n                    then IntelliJ/Android Studio will syntax highlight the source code as \\\n                    Kotlin. The second you add in a .trimIndent() on the string, the syntax \\\n                    highlighting goes away. For test files you can instead call \".indented()\" \\\n                    on the test file builder to get it to indent the string.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        DOLLAR_STRINGS = Issue.Companion.create$default(companion, "LintImplDollarEscapes", "Using Dollar Escapes", "\n                    Instead of putting `${\"$\"}` in your Kotlin raw string literals \\\n                    you can simply use \uff04. This looks like the dollar sign but is instead \\\n                    the full width dollar sign, U+FF04. And this character does not need \\\n                    to be escaped in Kotlin raw strings, since it does not start a \\\n                    string template.\n\n                    Lint will automatically convert references to \uff04 in unit test files into \\\n                    a real dollar sign, and when pulling results and error messages out of \\\n                    lint, the dollar sign back into the full width dollar sign.\n\n                    That means you can use \uff04 everywhere instead of `${\"$\"}`, which makes \\\n                    the test strings more readable -- especially `$`-heavy code such as \\\n                    references to inner classes.\n                    ", implementation, null, category, 4, severity, false, null, enumSet, null, 2832, null);
        companion = Issue.Companion;
        category = Category.CUSTOM_LINT_CHECKS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        enumSet = Platform.JDK_SET;
        MISSING_DOC_EXAMPLE = Issue.Companion.create$default(companion, "LintDocExample", "Missing Documentation Example", "\n                    Lint's tool for generating documentation for each issue has special \\\n                    support for including a code example which shows how to trigger \\\n                    the report. It will pick the first unit test it can find and pick out \\\n                    the source file referenced from the error message, but you can instead \\\n                    designate a unit test to be the documentation example, and in that case, \\\n                    all the files are included.\n\n                    To designate a unit test as the documentation example for an issue, \\\n                    name the test `testDocumentationExample`, or if your detector reports \\\n                    multiple issues, `testDocumentationExample`<Id>, such as\n                    `testDocumentationExampleMyId`.\n                    ", implementation, null, category, 6, severity, false, null, enumSet, null, 2576, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J*\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00072\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\rH\u0002J.\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00182\b\u0010\u001c\u001a\u0004\u0018\u00010\u0018H\u0002J(\u0010\u001d\u001a\u00020\u00112\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020\u0007H\u0002J\u0010\u0010#\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u0018H\u0002J\u0018\u0010$\u001a\u00020\u000b2\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0007H\u0002J\u0010\u0010'\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010(\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010*\u001a\u00020\u00142\u0006\u0010+\u001a\u00020\u0007H\u0002J\u0010\u0010,\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010-\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0007H\u0002J\u000e\u0010/\u001a\u00020\u000b2\u0006\u00100\u001a\u00020\rJ\u0018\u00101\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\b\b\u0002\u00102\u001a\u00020\u0011J\u0018\u00103\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u00104\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0018\u00105\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0018\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u00072\u0006\u00109\u001a\u00020:H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u0014H\u0002J\"\u0010<\u001a\u00020:2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00072\b\b\u0002\u00109\u001a\u00020:H\u0002J\u0018\u0010=\u001a\u00020\u00112\u0006\u00109\u001a\u00020:2\u0006\u0010 \u001a\u00020\u0007H\u0002J.\u0010>\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u00142\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020A2\f\u0010B\u001a\b\u0012\u0004\u0012\u00020\u00070CH\u0002J\u0010\u0010D\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020\rH\u0016J\u0010\u0010G\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020HH\u0016J\u0010\u0010I\u001a\u00020\u00112\u0006\u0010\u0016\u001a\u00020JH\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector$LintDetectorVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "(Lcom/android/tools/lint/detector/api/JavaContext;)V", "checkedUrls", "", "", "typoLookup", "Lcom/android/tools/lint/checks/TypoLookup;", "checkCall", "", "call", "Lorg/jetbrains/uast/UCallExpression;", "expectedContainer", "message", "requireUastReceiver", "", "checkDollarSubstitutions", "source", "Lorg/jetbrains/uast/UExpression;", "checkEnumSet", "node", "checkEquals", "Lorg/jetbrains/uast/UElement;", "type", "Lcom/intellij/psi/PsiType;", "arg1", "arg2", "checkForCodeFragments", "pattern", "Lkotlin/text/Regex;", "string", "argument", "typeString", "checkGetIssues", "checkId", "idArgument", "id", "checkIssueRegistration", "checkLintString", "checkMoreInfoUrl", "urlArgument", "url", "checkReport", "checkSummary", "title", "checkTestFile", "testFile", "checkTrimIndent", "isUnitTestFile", "checkTypos", "checkUrl", "checkUrls", "createSurroundFix", "Lcom/android/tools/lint/detector/api/LintFix;", "s", "location", "Lcom/android/tools/lint/detector/api/Location;", "getString", "getStringLocation", "locationContains", "reportTypo", "text", "begin", "", "replacements", "", "visitBinaryExpression", "Lorg/jetbrains/uast/UBinaryExpression;", "visitCallExpression", "visitField", "Lorg/jetbrains/uast/UField;", "visitMethod", "Lorg/jetbrains/uast/UMethod;", "android.sdktools.lint-checks"})
    public static final class LintDetectorVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final JavaContext context;
        @Nullable
        private final TypoLookup typoLookup;
        @NotNull
        private final Set<String> checkedUrls;

        public LintDetectorVisitor(@NotNull JavaContext context2) {
            Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
            this.context = context2;
            this.typoLookup = TypoLookup.Companion.get(this.context.getClient(), "en", null);
            boolean bl2 = false;
            this.checkedUrls = new LinkedHashSet();
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            block34: {
                Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                String string = node.getMethodName();
                if (string == null) break block34;
                int n10 = -1;
                switch (string.hashCode()) {
                    case 700591008: {
                        if (string.equals("getParent")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case -75652584: {
                        if (string.equals("getBody")) {
                            n10 = 2;
                        }
                        break;
                    }
                    case -1295482945: {
                        if (string.equals("equals")) {
                            n10 = 3;
                        }
                        break;
                    }
                    case 3543: {
                        if (string.equals("of")) {
                            n10 = 4;
                        }
                        break;
                    }
                    case -1193538204: {
                        if (string.equals("addMoreInfo")) {
                            n10 = 5;
                        }
                        break;
                    }
                    case -934521548: {
                        if (string.equals("report")) {
                            n10 = 6;
                        }
                        break;
                    }
                    case -1352294148: {
                        if (string.equals("create")) {
                            n10 = 7;
                        }
                        break;
                    }
                    case -397434540: {
                        if (string.equals("getContainingClass")) {
                            n10 = 8;
                        }
                        break;
                    }
                    case -1733350031: {
                        if (string.equals("getParentOfType")) {
                            n10 = 9;
                        }
                        break;
                    }
                    case 593751468: {
                        if (string.equals("getInitializer")) {
                            n10 = 10;
                        }
                        break;
                    }
                }
                switch (n10) {
                    case 2: {
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_METHOD, "Don't call PsiMethod#getBody(); you must use UAST instead. If you don't have a UMethod call UastFacade.getMethodBody(method)", false, 8, null);
                        break;
                    }
                    case 1: {
                        this.checkCall(node, LintDetectorDetector.CLASS_PSI_ELEMENT, "Don't call `PsiElement#getParent()`; you should use UAST instead and call `getUastParent()`", true);
                        break;
                    }
                    case 8: {
                        this.checkCall(node, LintDetectorDetector.CLASS_PSI_JVM_MEMBER, "Don't call `PsiMember#getContainingClass()`; you should use UAST instead and call `getContainingUClass()`", true);
                        break;
                    }
                    case 9: {
                        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)node.getValueArguments());
                        PsiType receiverType = uExpression == null ? null : uExpression.getExpressionType();
                        JavaEvaluator evaluator = this.context.getEvaluator();
                        PsiClass typeClass = evaluator.getTypeClass(receiverType);
                        if (typeClass == null || !evaluator.inheritsFrom(typeClass, LintDetectorDetector.CLASS_U_ELEMENT, false)) break;
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_TREE_UTIL, "Don't call `PsiTreeUtil#getParentOfType()`; you should use UAST instead and call `UElement.parentOfType`", false, 8, null);
                        break;
                    }
                    case 10: {
                        LintDetectorVisitor.checkCall$default(this, node, LintDetectorDetector.CLASS_PSI_VARIABLE, "Don't call PsiField#getInitializer(); you must use UAST instead. If you don't have a UField call UastFacade.getInitializerBody(field)", false, 8, null);
                        break;
                    }
                    case 3: {
                        this.checkEquals((UElement)node, node.getReceiverType(), (UElement)node.getReceiver(), (UElement)CollectionsKt.firstOrNull((List)node.getValueArguments()));
                        break;
                    }
                    case 7: {
                        this.checkIssueRegistration(node);
                        break;
                    }
                    case 5: {
                        if (node.getValueArgumentCount() != 1) break;
                        UExpression argument = (UExpression)node.getValueArguments().get(0);
                        String string2 = this.getString(argument);
                        CharSequence charSequence = string2;
                        boolean bl2 = false;
                        if (!(charSequence.length() > 0)) break;
                        this.checkMoreInfoUrl(argument, string2);
                        break;
                    }
                    case 6: {
                        this.checkReport(node);
                        break;
                    }
                    case 4: {
                        this.checkEnumSet(node);
                    }
                }
            }
            return super.visitCallExpression(node);
        }

        public final void checkTestFile(@NotNull UCallExpression testFile) {
            block23: {
                Intrinsics.checkParameterIsNotNull((Object)testFile, (String)"testFile");
                String name = testFile.getMethodName();
                if (name == null) break block23;
                int n10 = -1;
                switch (name.hashCode()) {
                    case -1237894073: {
                        if (name.equals("gradle")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case 3254818: {
                        if (name.equals("java")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case 130625071: {
                        if (name.equals("manifest")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case 118807: {
                        if (name.equals("xml")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case -1125574399: {
                        if (name.equals("kotlin")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case 3433: {
                        if (name.equals("kt")) {
                            n10 = 1;
                        }
                        break;
                    }
                    case 106538: {
                        if (name.equals("kts")) {
                            n10 = 1;
                        }
                        break;
                    }
                }
                switch (n10) {
                    case 1: {
                        UExpression uExpression;
                        List args = testFile.getValueArguments();
                        if (args.size() > 1) {
                            uExpression = (UExpression)args.get(1);
                        } else if (args.size() == 1) {
                            uExpression = (UExpression)args.get(0);
                        } else {
                            return;
                        }
                        UExpression source = uExpression;
                        String string = this.getString(source);
                        this.checkTrimIndent(source, true);
                        if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"$", (boolean)false, (int)2, null) || !Lint.isKotlin(testFile.getSourcePsi())) break;
                        this.checkDollarSubstitutions(source);
                    }
                }
            }
        }

        private final void checkDollarSubstitutions(UExpression source) {
            PsiElement psiElement = source.getSourcePsi();
            if (psiElement != null) {
                psiElement.accept((PsiElementVisitor)new PsiRecursiveElementVisitor(this, source){
                    final /* synthetic */ LintDetectorVisitor this$0;
                    final /* synthetic */ UExpression $source;
                    {
                        this.this$0 = $receiver;
                        this.$source = $source;
                    }

                    public void visitElement(@NotNull PsiElement element) {
                        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                        String text = element.getText();
                        boolean string = true;
                        Intrinsics.checkExpressionValueIsNotNull((Object)text, (String)"text");
                        int index = StringsKt.indexOf$default((CharSequence)text, (String)"${\"$\"}", (int)0, (boolean)false, (int)6, null);
                        if (index == -1) {
                            string = false;
                            index = StringsKt.indexOf$default((CharSequence)text, (String)"${'$'}", (int)0, (boolean)false, (int)6, null);
                        }
                        if (index != -1) {
                            LintFix fix = LintFix.Companion.create().replace().text(string ? "${\"$\"}" : "${'$'}").with("\uff04").build();
                            Location location = LintDetectorVisitor.access$getContext$p(this.this$0).getRangeLocation(element, index, 6);
                            LintDetectorVisitor.access$getContext$p(this.this$0).report(LintDetectorDetector.DOLLAR_STRINGS, (UElement)this.$source, location, "In unit tests, use the fullwidth dollar sign, `\uff04`, instead of `$`, to avoid having to use cumbersome escapes. Lint will treat a `\uff04` as a `$`.", fix);
                            return;
                        }
                        super.visitElement(element);
                    }
                });
            }
        }

        private final void checkEnumSet(UCallExpression node) {
            UExpression receiver = node.getReceiver();
            if (receiver instanceof USimpleNameReferenceExpression && Intrinsics.areEqual((Object)((USimpleNameReferenceExpression)receiver).getIdentifier(), (Object)"EnumSet")) {
                EnumSet<Scope> scopes = EnumSet.noneOf(Scope.class);
                for (UExpression argument : node.getValueArguments()) {
                    String name;
                    PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)argument));
                    PsiField psiField = psiElement instanceof PsiField ? (PsiField)psiElement : null;
                    String string = name = psiField == null ? null : psiField.getName();
                    if (name == null) {
                        String string2;
                        if (argument instanceof UQualifiedReferenceExpression && ((UQualifiedReferenceExpression)argument).getSelector() instanceof USimpleNameReferenceExpression) {
                            string2 = ((USimpleNameReferenceExpression)((UQualifiedReferenceExpression)argument).getSelector()).getIdentifier();
                        } else if (argument instanceof USimpleNameReferenceExpression) {
                            string2 = ((USimpleNameReferenceExpression)argument).getIdentifier();
                        } else {
                            return;
                        }
                        name = string2;
                    }
                    try {
                        Scope scope = Scope.valueOf(name);
                        scopes.add(scope);
                    }
                    catch (Throwable e10) {
                        return;
                    }
                }
                if (!scopes.isEmpty()) {
                    Field[] fieldArray = Scope.class.getDeclaredFields();
                    Intrinsics.checkExpressionValueIsNotNull((Object)fieldArray, (String)"Scope::class.java.declaredFields");
                    for (Field field : fieldArray) {
                        if ((field.getModifiers() & 8) == 0 || field.isEnumConstant()) continue;
                        field.setAccessible(true);
                        Object constant = field.get(0);
                        if (!Intrinsics.areEqual(scopes, (Object)constant)) continue;
                        PsiElement psiElement = node.getSourcePsi();
                        String string = psiElement == null ? null : psiElement.getText();
                        LintFix fix = LintFix.Companion.create().name(Intrinsics.stringPlus((String)"Replace with Scope.", (Object)field.getName())).replace().text(string == null ? node.asSourceString() : string).with(Intrinsics.stringPlus((String)"com.android.tools.lint.detector.api.Scope.", (Object)field.getName())).shortenNames().autoFix().build();
                        this.context.report(EXISTING_LINT_CONSTANTS, (UElement)node, this.context.getLocation((UElement)node), "Use `Scope." + field.getName() + "` instead", fix);
                    }
                }
            }
        }

        private final void checkReport(UCallExpression call) {
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod create = psiMethod;
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (!evaluator.isMemberInSubClassOf((PsiMember)create, LintDetectorDetector.CLASS_CONTEXT, false) && !evaluator.isMemberInSubClassOf((PsiMember)create, LintDetectorDetector.CLASS_LINT_CLIENT, false)) {
                return;
            }
            int n10 = 2;
            List arguments = call.getValueArguments();
            int n11 = arguments.size();
            if (n10 < n11) {
                do {
                    PsiType type;
                    int index;
                    UExpression argument;
                    PsiType psiType;
                    if ((psiType = (argument = (UExpression)arguments.get(index = n10++)).getExpressionType()) == null || !Intrinsics.areEqual((Object)(type = psiType).getCanonicalText(), (Object)"java.lang.String")) continue;
                    String string = this.getString(argument);
                    this.checkLintString(argument, string);
                    if (!StringsKt.endsWith$default((String)string, (String)".", (boolean)false, (int)2, null) || StringsKt.lastIndexOf$default((CharSequence)string, (char)'.', (int)(string.length() - 2), (boolean)false, (int)4, null) != -1 || StringsKt.endsWith$default((String)string, (String)" etc.", (boolean)false, (int)2, null)) continue;
                    Location fallback = this.context.getLocation((UElement)argument);
                    Location location = this.getStringLocation(argument, string, fallback);
                    boolean canFix = location != fallback || this.locationContains(location, string);
                    LintFix fix = canFix ? LintFix.Companion.create().name("Remove period").replace().text(".").with("").autoFix().build() : null;
                    this.context.report(TEXT_FORMAT, (UElement)argument, location, "Single sentence error messages should not end with a period", fix);
                } while (n10 < n11);
            }
        }

        private final boolean locationContains(Location location, String string) {
            int n10;
            int n11;
            int n12;
            Position position = location.getStart();
            int start = position == null ? -1 : (n12 = position.getOffset());
            Position position2 = location.getEnd();
            int end = position2 == null ? -1 : (n11 = position2.getOffset());
            CharSequence charSequence = this.context.getContents();
            int i10 = charSequence == null ? -1 : (n10 = StringsKt.indexOf$default((CharSequence)charSequence, (String)string, (int)start, (boolean)false, (int)4, null));
            return i10 < end && i10 != -1;
        }

        public boolean visitField(@NotNull UField node) {
            UExpression initializer;
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getName(), (Object)"issues") && (initializer = node.getUastInitializer()) != null) {
                this.checkGetIssues((UElement)initializer);
            }
            return super.visitField(node);
        }

        public boolean visitMethod(@NotNull UMethod node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            if (Intrinsics.areEqual((Object)node.getName(), (Object)"getIssues")) {
                this.checkGetIssues((UElement)node);
            }
            return super.visitMethod(node);
        }

        private final void checkGetIssues(UElement node) {
            node.accept((UastVisitor)new AbstractUastVisitor(this){
                final /* synthetic */ LintDetectorVisitor this$0;
                {
                    this.this$0 = $receiver;
                }

                public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                    Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
                    JavaEvaluator evaluator = LintDetectorVisitor.access$getContext$p(this.this$0).getEvaluator();
                    PsiClass type = LintDetectorVisitor.access$getContext$p(this.this$0).getEvaluator().getTypeClass(node.getExpressionType());
                    if (type != null && JavaEvaluator.inheritsFrom$default(evaluator, type, "com.android.tools.lint.detector.api.Issue", false, 4, null)) {
                        PsiElement resolved = node.resolve();
                        if (resolved instanceof PsiField) {
                            PsiElement $this$toUElementOfType$iv = resolved;
                            boolean $i$f$toUElementOfType22 = false;
                            UField issue = (UField)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UField.class);
                            if (!(issue instanceof JavaUField) || !JavaEvaluator.inheritsFrom$default(evaluator, (PsiClass)UastUtils.getContainingUClass((UElement)((UElement)issue)), "com.android.tools.lint.detector.api.Detector", false, 4, null)) {
                                UExpression $i$f$toUElementOfType22;
                                boolean bl2;
                                $this$toUElementOfType$iv = issue;
                                if ($this$toUElementOfType$iv == null) {
                                    bl2 = false;
                                } else {
                                    List $i$f$toUElementOfType22 = $this$toUElementOfType$iv.getUAnnotations();
                                    if ($i$f$toUElementOfType22 == null) {
                                        bl2 = false;
                                    } else {
                                        boolean bl3;
                                        block14: {
                                            Iterable $this$any$iv = $i$f$toUElementOfType22;
                                            boolean $i$f$any = false;
                                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                                bl3 = false;
                                            } else {
                                                for (T element$iv : $this$any$iv) {
                                                    UAnnotation it2 = (UAnnotation)element$iv;
                                                    boolean bl4 = false;
                                                    if (!Intrinsics.areEqual((Object)it2.getQualifiedName(), (Object)"kotlin.jvm.JvmField")) continue;
                                                    bl3 = true;
                                                    break block14;
                                                }
                                                bl3 = false;
                                            }
                                        }
                                        bl2 = bl3;
                                    }
                                }
                                if (!bl2 && ($this$toUElementOfType$iv = issue) != null && ($i$f$toUElementOfType22 = $this$toUElementOfType$iv.getUastInitializer()) != null) {
                                    $i$f$toUElementOfType22.accept((UastVisitor)this.this$0);
                                }
                            }
                        } else if (resolved instanceof PsiMethod) {
                            PsiElement $this$toUElementOfType$iv = resolved;
                            boolean $i$f$toUElementOfType = false;
                            UMethod create = (UMethod)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UMethod.class);
                            UMethod uMethod = create;
                            if (uMethod != null) {
                                uMethod.accept((UastVisitor)this.this$0);
                            }
                        }
                    }
                    return super.visitSimpleNameReferenceExpression(node);
                }
            });
        }

        private final void checkIssueRegistration(UCallExpression call) {
            CharSequence charSequence;
            String string;
            Map it2;
            boolean bl2;
            PsiMethod psiMethod = call.resolve();
            if (psiMethod == null) {
                return;
            }
            PsiMethod create = psiMethod;
            JavaEvaluator evaluator = this.context.getEvaluator();
            if (!evaluator.isMemberInClass((PsiMember)create, LintDetectorDetector.CLASS_ISSUE_COMPANION) && !evaluator.isMemberInClass((PsiMember)create, LintDetectorDetector.CLASS_ISSUE)) {
                return;
            }
            JvmParameter[] parameters = create.getParameters();
            Map<UExpression, PsiParameter> mapping = evaluator.computeArgumentMapping(call, create);
            boolean bl3 = false;
            Map map = new LinkedHashMap();
            boolean bl4 = false;
            boolean bl5 = false;
            Map it3 = map;
            boolean bl6 = false;
            Map<UExpression, PsiParameter> $this$forEach$iv = mapping;
            boolean $i$f$forEach = false;
            Map<UExpression, PsiParameter> map2 = $this$forEach$iv;
            boolean bl7 = false;
            Iterator<Map.Entry<UExpression, PsiParameter>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<UExpression, PsiParameter> element$iv;
                Map.Entry<UExpression, PsiParameter> $dstr$argument$parameter = element$iv = iterator.next();
                boolean bl8 = false;
                Map.Entry<UExpression, PsiParameter> entry = $dstr$argument$parameter;
                boolean bl9 = false;
                UExpression argument = entry.getKey();
                Object object = $dstr$argument$parameter;
                boolean bl10 = false;
                PsiParameter parameter = object.getValue();
                object = it3;
                bl10 = false;
                object.put(parameter, argument);
            }
            Map reversed = MapsKt.toMap((Map)map);
            JvmParameter idParameter = parameters[0];
            JvmParameter summaryParameter = parameters[1];
            JvmParameter explanationParameter = parameters[2];
            Map map3 = reversed;
            boolean bl11 = false;
            UExpression uExpression = (UExpression)map3.get(idParameter);
            if (uExpression != null) {
                map3 = uExpression;
                bl11 = false;
                bl2 = false;
                it2 = map3;
                boolean bl12 = false;
                string = this.getString((UExpression)it2);
                this.checkId((UExpression)it2, string);
            }
            map3 = reversed;
            bl11 = false;
            uExpression = (UExpression)map3.get(summaryParameter);
            if (uExpression != null) {
                map3 = uExpression;
                bl11 = false;
                bl2 = false;
                it2 = map3;
                boolean bl13 = false;
                string = this.getString((UExpression)it2);
                charSequence = string;
                boolean bl14 = false;
                if (charSequence.length() > 0) {
                    this.checkSummary((UExpression)it2, string);
                }
            }
            map3 = reversed;
            bl11 = false;
            uExpression = (UExpression)map3.get(explanationParameter);
            if (uExpression != null) {
                map3 = uExpression;
                bl11 = false;
                bl2 = false;
                it2 = map3;
                boolean bl15 = false;
                string = this.getString((UExpression)it2);
                charSequence = string;
                boolean bl16 = false;
                if (charSequence.length() > 0) {
                    this.checkLintString((UExpression)it2, string);
                    LintDetectorVisitor.checkTrimIndent$default(this, (UExpression)it2, false, 2, null);
                }
            }
            if (parameters.length == 12) {
                map3 = reversed;
                JvmParameter jvmParameter = parameters[4];
                bl2 = false;
                uExpression = (UExpression)map3.get(jvmParameter);
                if (uExpression != null) {
                    map3 = uExpression;
                    boolean bl17 = false;
                    bl2 = false;
                    it2 = map3;
                    boolean bl18 = false;
                    string = this.getString((UExpression)it2);
                    charSequence = string;
                    boolean bl19 = false;
                    if (charSequence.length() > 0) {
                        this.checkMoreInfoUrl((UExpression)it2, string);
                    }
                }
            }
        }

        private final void checkSummary(UExpression argument, String title) {
            if (title.length() > 60) {
                JavaContext.report$default(this.context, TEXT_FORMAT, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, title, null, 4, null), "The issue summary should be shorter; typically just a 3-6 words; it's used as a topic header in HTML reports and in the IDE inspections window", null, 16, null);
            } else {
                char c10 = title.charAt(0);
                boolean bl2 = false;
                if (Character.isLowerCase(c10)) {
                    JavaContext.report$default(this.context, TEXT_FORMAT, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, title, null, 4, null), "The issue summary should be capitalized", null, 16, null);
                }
                if (StringsKt.endsWith$default((String)title, (String)".", (boolean)false, (int)2, null)) {
                    JavaContext.report$default(this.context, TEXT_FORMAT, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, title, null, 4, null), "The issue summary should *not* end with a period (think of it as a headline)", null, 16, null);
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private final void checkId(UExpression idArgument, String id2) {
            String leaf;
            block20: {
                block19: {
                    boolean bl2;
                    block18: {
                        String string;
                        boolean bl3;
                        CharSequence charSequence;
                        int n10 = -1;
                        switch (id2.hashCode()) {
                            case 225294590: {
                                if (!id2.equals("IncompatibleMediaBrowserServiceCompatVersion")) break;
                                n10 = 1;
                                break;
                            }
                            case 1091140979: {
                                if (!id2.equals("PermissionImpliesUnsupportedChromeOsHardware")) break;
                                n10 = 1;
                                break;
                            }
                            case -1862783803: {
                                if (!id2.equals("PrivateMemberAccessBetweenOuterAndInnerClass")) break;
                                n10 = 1;
                                break;
                            }
                        }
                        switch (n10) {
                            case 1: {
                                return;
                            }
                        }
                        int leafIndex = StringsKt.lastIndexOf$default((CharSequence)id2, (char)'.', (int)0, (boolean)false, (int)6, null) + 1;
                        if (leafIndex > 0 && leafIndex < id2.length() - 1) {
                            charSequence = id2;
                            bl3 = false;
                            CharSequence charSequence2 = charSequence;
                            if (charSequence2 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            String string2 = ((String)charSequence2).substring(leafIndex);
                            string = string2;
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                        } else {
                            string = id2;
                        }
                        leaf = string;
                        charSequence = leaf;
                        bl3 = false;
                        if (charSequence.length() == 0) {
                            return;
                        }
                        boolean bl4 = false;
                        if (bl4) {
                            return;
                        }
                        char c10 = leaf.charAt(0);
                        bl3 = false;
                        if (!Character.isUpperCase(c10)) break block19;
                        CharSequence $this$none$iv = leaf;
                        boolean $i$f$none = false;
                        CharSequence charSequence3 = $this$none$iv;
                        for (int i10 = 0; i10 < charSequence3.length(); ++i10) {
                            char element$iv;
                            char it2 = element$iv = charSequence3.charAt(i10);
                            boolean bl5 = false;
                            char c11 = it2;
                            boolean bl6 = false;
                            if (!Character.isLowerCase(c11)) continue;
                            bl2 = false;
                            break block18;
                        }
                        bl2 = true;
                    }
                    if (!bl2) break block20;
                }
                JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should use capitalized camel case, such as `MyIssueId`", null, 16, null);
                return;
            }
            if (StringsKt.contains$default((CharSequence)id2, (CharSequence)" ", (boolean)false, (int)2, null)) {
                JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should not contain spaces, such as `MyIssueId`", null, 16, null);
                return;
            }
            if (leaf.length() < 40) return;
            JavaContext.report$default(this.context, ID, (UElement)idArgument, this.context.getLocation((UElement)idArgument), "Lint issue IDs should be reasonably short (< 40 chars); they're used in suppress annotations etc", null, 16, null);
        }

        private final void checkMoreInfoUrl(UExpression urlArgument, String url) {
            this.checkUrl(url, urlArgument);
        }

        private final void checkUrls(UExpression argument, String string) {
            int index;
            int start = 0;
            while ((index = StringsKt.indexOf$default((CharSequence)string, (String)"http://", (int)start, (boolean)false, (int)4, null)) != -1 || (index = StringsKt.indexOf$default((CharSequence)string, (String)"https://", (int)start, (boolean)false, (int)4, null)) != -1) {
                String url;
                start = index;
                int end = TextFormat.Companion.findUrlEnd(string, start);
                String string2 = string;
                boolean bl2 = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                Intrinsics.checkNotNullExpressionValue((Object)string3.substring(start, end), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                this.checkUrl(url, argument);
                start = end;
            }
        }

        private final Location getStringLocation(UExpression argument, String string, Location location) {
            Location location2;
            Integer n10;
            Integer n11;
            Position position = location.getStart();
            Integer n12 = n11 = position == null ? null : Integer.valueOf(position.getOffset());
            if (n11 == null) {
                return location;
            }
            int start = n11;
            Position position2 = location.getEnd();
            Position position3 = position = position2 == null ? null : Integer.valueOf(position2.getOffset());
            if (position == null) {
                return location;
            }
            int end = (Integer)((Object)position);
            CharSequence contents = this.context.getContents();
            CharSequence charSequence = contents;
            Integer n13 = n10 = charSequence == null ? null : Integer.valueOf(StringsKt.indexOf((CharSequence)charSequence, (String)string, (int)start, (boolean)false));
            if (n10 == null) {
                return location;
            }
            int index = n10;
            if (index != -1) {
                int alt;
                if (index > end && (alt = StringsKt.lastIndexOf((CharSequence)contents, (String)string, (int)start, (boolean)false)) != -1) {
                    index = alt;
                }
                location2 = argument instanceof KotlinStringTemplateUPolyadicExpression && ((KotlinStringTemplateUPolyadicExpression)argument).getOperands().size() == 1 && location.getSource() == ((KotlinStringTemplateUPolyadicExpression)argument).getOperands().get(0) ? this.context.getRangeLocation((UElement)((KotlinStringTemplateUPolyadicExpression)argument).getOperands().get(0), index - start, string.length()) : this.context.getRangeLocation((UElement)argument, index - start, string.length());
            } else {
                location2 = location;
            }
            return location2;
        }

        static /* synthetic */ Location getStringLocation$default(LintDetectorVisitor lintDetectorVisitor, UExpression uExpression, String string, Location location, int n10, Object object) {
            if ((n10 & 4) != 0) {
                location = lintDetectorVisitor.context.getLocation((UElement)uExpression);
            }
            return lintDetectorVisitor.getStringLocation(uExpression, string, location);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private final void checkUrl(String url, UExpression argument) {
            int n10 = -1;
            switch (url.hashCode()) {
                case -1168752206: {
                    if (!url.equals("http://schemas.android.com/apk/res/android")) break;
                    n10 = 1;
                    break;
                }
                case -1988678336: {
                    if (!url.equals("http://schemas.android.com/tools")) break;
                    n10 = 1;
                    break;
                }
                case -621665718: {
                    if (!url.equals("http://schemas.android.com/apk/res-auto")) break;
                    n10 = 1;
                    break;
                }
            }
            switch (n10) {
                case 1: {
                    return;
                }
            }
            if (!this.checkedUrls.add(url)) {
                return;
            }
            if (StringsKt.contains$default((CharSequence)url, (CharSequence)"b.android.com", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)url, (CharSequence)"code.google.com/p/android/issues/", (boolean)false, (int)2, null)) {
                JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Don't point to old `http://b.android.com` links; should be using `https://issuetracker.google.com` instead", null, 16, null);
                return;
            }
            if (StringsKt.startsWith$default((String)url, (String)"https://issuetracker.google.com/", (boolean)false, (int)2, null)) {
                int expectedLength;
                int issueLength = url.length() - (StringsKt.lastIndexOf$default((CharSequence)url, (char)'/', (int)0, (boolean)false, (int)6, null) + 1);
                if (issueLength >= (expectedLength = 9)) return;
                JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Suspicious issue tracker length; expected a " + expectedLength + " digit issue id, but was " + issueLength, null, 16, null);
                return;
            }
            try {
                String protocol;
                block22: {
                    String host;
                    block23: {
                        String string;
                        String string2;
                        URL parsed = new URL(url);
                        String string3 = parsed.getProtocol();
                        if (string3 == null) {
                            string2 = null;
                        } else {
                            string = string3;
                            Locale locale = Locale.US;
                            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"US");
                            boolean bl2 = false;
                            String string4 = string;
                            boolean bl3 = false;
                            String string5 = string4.toLowerCase(locale);
                            string2 = string5;
                            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
                        }
                        protocol = string2;
                        if (Intrinsics.areEqual(protocol, (Object)"mailto")) {
                            return;
                        }
                        if (protocol != null && !Intrinsics.areEqual(protocol, (Object)"http") && !Intrinsics.areEqual(protocol, (Object)"https")) {
                            JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Unexpected protocol `" + protocol + "` in `" + url + '`', null, 16, null);
                            return;
                        }
                        host = parsed.getHost();
                        if (host != null && (StringsKt.contains$default((CharSequence)host, (CharSequence)"corp.google.com", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)host, (CharSequence)"googleplex.com", (boolean)false, (int)2, null))) {
                            JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Don't use internal Google links (`" + url + "`)", null, 16, null);
                            return;
                        }
                        if (host == null || StringsKt.endsWith$default((String)host, (String)".google.com", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)host, (String)".android.com", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)host, (Object)"goo.gle") || Intrinsics.areEqual((Object)host, (Object)"android.com") || Intrinsics.areEqual((Object)host, (Object)"android-developers.googleblog.com") || Intrinsics.areEqual((Object)host, (Object)"android-developers.blogspot.com") || Intrinsics.areEqual((Object)host, (Object)"g.co") || Intrinsics.areEqual((Object)host, (Object)"material.io") || Intrinsics.areEqual((Object)host, (Object)"android.github.io")) break block22;
                        if (!Intrinsics.areEqual((Object)host, (Object)"medium.com")) break block23;
                        string = parsed.getPath();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"parsed.path");
                        if (StringsKt.startsWith$default((String)string, (String)"/androiddevelopers/", (boolean)false, (int)2, null)) break block22;
                    }
                    if (!(StringsKt.endsWith$default((String)host, (String)".wikipedia.org", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)host, (String)".groovy-lang.org", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)host, (String)".sqlite.org", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)host, (Object)"stackoverflow.com") || Intrinsics.areEqual((Object)host, (Object)"tools.ietf.org") || Intrinsics.areEqual((Object)host, (Object)"kotlinlang.org") || Intrinsics.areEqual((Object)host, (Object)"bugs.eclipse.org"))) {
                        JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Unexpected URL host `" + host + "`; for the builtin Android Lint checks make sure to use an authoritative link (`" + url + "`)", null, 16, null);
                        return;
                    }
                }
                if (!Intrinsics.areEqual(protocol, (Object)"http")) return;
                JavaContext.report$default(this.context, UNEXPECTED_DOMAIN, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "Use https, not http, for more info links (`" + url + "`)", null, 16, null);
                return;
            }
            catch (MalformedURLException e10) {
                JavaContext.report$default(this.context, CHECK_URL, (UElement)argument, LintDetectorVisitor.getStringLocation$default(this, argument, url, null, 4, null), "The URL `" + url + "` cannot be parsed: " + e10, null, 16, null);
            }
        }

        public final void checkTrimIndent(@NotNull UExpression argument, boolean isUnitTestFile) {
            String methodName;
            UExpression selector;
            Intrinsics.checkParameterIsNotNull((Object)argument, (String)"argument");
            if (argument instanceof UQualifiedReferenceExpression && (selector = ((UQualifiedReferenceExpression)argument).getSelector()) instanceof UCallExpression && (Intrinsics.areEqual((Object)(methodName = ((UCallExpression)selector).getMethodName()), (Object)"trimIndent") || Intrinsics.areEqual((Object)methodName, (Object)"trimMargin"))) {
                String string;
                Location location = this.context.getCallLocation((UCallExpression)selector, false, true);
                LintFix fix = !isUnitTestFile ? LintFix.Companion.create().replace().all().with("").build() : (LintFix)null;
                UElement uElement = (UElement)selector;
                StringBuilder stringBuilder = new StringBuilder().append("No need to call `.").append((Object)methodName).append("()` in issue registration strings; they are already trimmed by indent by lint when displaying to users");
                if (isUnitTestFile) {
                    UElement uElement2 = argument.getUastParent();
                    UCallExpression uCallExpression = uElement2 instanceof UCallExpression ? (UCallExpression)uElement2 : null;
                    string = ". Instead, call `.indented()` on the surrounding `" + (uCallExpression == null ? null : uCallExpression.getMethodName()) + "()` test file construction";
                } else {
                    string = "";
                }
                this.context.report(TRIM_INDENT, uElement, location, stringBuilder.append(string).toString(), fix);
            }
        }

        public static /* synthetic */ void checkTrimIndent$default(LintDetectorVisitor lintDetectorVisitor, UExpression uExpression, boolean bl2, int n10, Object object) {
            if ((n10 & 2) != 0) {
                bl2 = false;
            }
            lintDetectorVisitor.checkTrimIndent(uExpression, bl2);
        }

        private final String getString(UExpression argument) {
            String constant;
            if (argument instanceof UPolyadicExpression) {
                StringBuilder sb2 = new StringBuilder();
                for (UExpression part : ((UPolyadicExpression)argument).getOperands()) {
                    sb2.append(this.getString(part));
                }
                String string = sb2.toString();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
                return string;
            }
            if (argument instanceof ULiteralExpression) {
                String string;
                Object sb2 = ((ULiteralExpression)argument).getValue();
                return sb2 == null ? "" : ((string = sb2.toString()) == null ? "" : string);
            }
            if (argument instanceof UCallExpression) {
                String string;
                UExpression receiver = ((UCallExpression)argument).getReceiver();
                if (receiver != null && ((string = ((UCallExpression)argument).getMethodName()) == null ? false : StringsKt.startsWith$default((String)string, (String)"trim", (boolean)false, (int)2, null))) {
                    return this.getString(receiver);
                }
            } else if (argument instanceof UQualifiedReferenceExpression) {
                UExpression selector = ((UQualifiedReferenceExpression)argument).getSelector();
                if (selector instanceof UCallExpression) {
                    String methodName = ((UCallExpression)selector).getMethodName();
                    String part = methodName;
                    if (part == null ? false : StringsKt.startsWith$default((String)part, (String)"trim", (boolean)false, (int)2, null)) {
                        return this.getString(((UQualifiedReferenceExpression)argument).getReceiver());
                    }
                    if (Intrinsics.areEqual((Object)methodName, (Object)"format")) {
                        List args = ((UCallExpression)selector).getValueArguments();
                        for (UExpression arg : args) {
                            PsiType psiType = arg.getExpressionType();
                            if (!Intrinsics.areEqual((Object)(psiType == null ? null : psiType.getCanonicalText()), (Object)"java.lang.String")) continue;
                            return this.getString(arg);
                        }
                    }
                }
            } else if (!(argument.getUastParent() instanceof KotlinStringTemplateUPolyadicExpression) && (constant = ConstantEvaluator.evaluateString(null, (UElement)argument, true)) != null) {
                return constant;
            }
            return "";
        }

        private final void checkTypos(UExpression argument, String string) {
            int start = 0;
            int length = string.length();
            int index = start;
            while (true) {
                boolean bl2;
                int n10;
                if (index < length) {
                    n10 = string.charAt(index);
                    bl2 = false;
                    if (!Character.isLetter((char)n10)) {
                        n10 = index;
                        index = n10 + '\u0001';
                        continue;
                    }
                }
                start = index;
                while (index < length) {
                    n10 = string.charAt(index);
                    bl2 = false;
                    if (!Character.isLetter((char)n10)) break;
                    n10 = index;
                    index = n10 + 1;
                }
                if (index <= start) break;
                TypoLookup typoLookup = this.typoLookup;
                List<String> replacements = typoLookup == null ? null : typoLookup.getTypos(string, start, index);
                if (replacements == null) continue;
                this.reportTypo(argument, string, start, replacements);
            }
        }

        private final void checkLintString(UExpression argument, String string) {
            this.checkUrls(argument, string);
            this.checkTypos(argument, string);
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"`", (boolean)false, (int)2, null)) {
                return;
            }
            if (!this.checkForCodeFragments(XML_PATTERN, string, argument, "an XML reference") && !this.checkForCodeFragments(CALL_PATTERN, string, argument, "a call")) {
                this.checkForCodeFragments(CAMELCASE_PATTERN, string, argument, "a code reference");
            }
        }

        private final boolean checkForCodeFragments(Regex pattern, String string, UExpression argument, String typeString) {
            boolean bl2;
            MatchResult xml = Regex.find$default((Regex)pattern, (CharSequence)string, (int)0, (int)2, null);
            if (xml != null) {
                Location fallback;
                String s10 = (String)xml.getGroupValues().get(0);
                Location location = this.getStringLocation(argument, s10, fallback = this.context.getLocation((UElement)argument));
                boolean canFix = location != fallback || this.locationContains(location, string);
                LintFix fix = canFix ? this.createSurroundFix(s10, location) : null;
                this.context.report(TEXT_FORMAT, (UElement)argument, location, '\"' + s10 + "\" looks like " + typeString + "; surround with backtics in string to display as symbol, e.g. \\`" + s10 + "\\`", fix);
                bl2 = true;
            } else {
                bl2 = false;
            }
            return bl2;
        }

        private final LintFix createSurroundFix(String s10, Location location) {
            return LintFix.Companion.create().name("Surround with backtics").replace().text(s10).with('`' + s10 + '`').range(location).autoFix().build();
        }

        private final void reportTypo(UExpression argument, String text, int begin, List<String> replacements) {
            String string;
            boolean canFix;
            if (replacements.size() < 2) {
                return;
            }
            String typo = replacements.get(0);
            String string2 = text;
            int n10 = begin + typo.length();
            boolean bl2 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(begin, n10);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String word = string4;
            String first = null;
            String message2 = null;
            LintFix.GroupBuilder fixBuilder = LintFix.Companion.create().alternatives();
            boolean isCapitalized = Character.isUpperCase(word.charAt(0));
            StringBuilder sb2 = new StringBuilder(40);
            int i10 = 1;
            int n11 = replacements.size();
            while (i10 < n11) {
                String replacement = replacements.get(i10);
                if (first == null) {
                    first = replacement;
                }
                CharSequence charSequence = sb2;
                boolean bl3 = false;
                if (charSequence.length() > 0) {
                    sb2.append(" or ");
                }
                sb2.append('\"');
                if (isCapitalized) {
                    replacement = StringHelper.usLocaleCapitalize((String)replacement);
                }
                sb2.append(replacement);
                fixBuilder.add(LintFix.Companion.create().name("Replace with \"" + replacement + '\"').replace().text(word).with(replacement).build());
                sb2.append('\"');
                int n12 = i10;
                i10 = n12 + 1;
            }
            LintFix fix = fixBuilder.build();
            Location fallback = this.context.getLocation((UElement)argument);
            Location location = this.getStringLocation(argument, word, fallback);
            boolean bl4 = canFix = location != fallback || this.locationContains(location, word);
            if (first != null && StringsKt.equals((String)first, (String)word, (boolean)true)) {
                if (Intrinsics.areEqual((Object)first, (Object)word)) {
                    return;
                }
                string = '\"' + word + "\" is usually capitalized as \"" + first + '\"';
            } else {
                string = '\"' + word + "\" is a common misspelling; did you mean " + sb2 + " ?";
            }
            message2 = string;
            this.context.report(TEXT_FORMAT, (UElement)argument, location, message2, canFix ? fix : null);
        }

        public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
            Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
            UastBinaryOperator operator = node.getOperator();
            if (Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.EQUALS) || Intrinsics.areEqual((Object)operator, (Object)UastBinaryOperator.NOT_EQUALS)) {
                this.checkEquals((UElement)node, node.getLeftOperand().getExpressionType(), (UElement)node.getLeftOperand(), (UElement)node.getRightOperand());
            }
            return super.visitBinaryExpression(node);
        }

        private final void checkCall(UCallExpression call, String expectedContainer, String message2, boolean requireUastReceiver) {
            PsiType receiverType;
            UExpression uExpression;
            if (requireUastReceiver && (uExpression = (receiverType = (uExpression = call.getReceiver()) == null ? null : uExpression.getExpressionType())) != null) {
                UExpression uExpression2 = uExpression;
                boolean bl2 = false;
                boolean bl3 = false;
                UExpression it2 = uExpression2;
                boolean bl4 = false;
                JavaEvaluator evaluator = this.context.getEvaluator();
                PsiClass typeClass = evaluator.getTypeClass((PsiType)it2);
                if (typeClass != null && !evaluator.inheritsFrom(typeClass, LintDetectorDetector.CLASS_U_ELEMENT, false)) {
                    return;
                }
            }
            if ((uExpression = call.resolve()) == null) {
                return;
            }
            UExpression method = uExpression;
            if (this.context.getEvaluator().isMemberInClass((PsiMember)method, expectedContainer)) {
                JavaContext.report$default(this.context, USE_UAST, (UElement)call, this.context.getLocation((UElement)call), message2, null, 16, null);
            }
        }

        static /* synthetic */ void checkCall$default(LintDetectorVisitor lintDetectorVisitor, UCallExpression uCallExpression, String string, String string2, boolean bl2, int n10, Object object) {
            if ((n10 & 8) != 0) {
                bl2 = false;
            }
            lintDetectorVisitor.checkCall(uCallExpression, string, string2, bl2);
        }

        private final void checkEquals(UElement node, PsiType type, UElement arg1, UElement arg2) {
            PsiClass psiClass;
            if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && this.context.getEvaluator().inheritsFrom(psiClass, LintDetectorDetector.CLASS_PSI_ELEMENT, false)) {
                UElement uElement = arg1;
                if (uElement == null ? false : UastLiteralUtils.isNullLiteral((UElement)uElement)) {
                    return;
                }
                uElement = arg2;
                if (uElement == null ? false : UastLiteralUtils.isNullLiteral((UElement)uElement)) {
                    return;
                }
                String message2 = "Don't compare PsiElements with `equals`, use `isEquivalentTo(PsiElement)` instead";
                JavaContext.report$default(this.context, PSI_COMPARE, node, this.context.getLocation(node), message2, null, 16, null);
            }
        }

        public static final /* synthetic */ JavaContext access$getContext$p(LintDetectorVisitor $this) {
            return $this.context;
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010 \u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010#\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010$\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010%\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/LintDetectorDetector$Companion;", "", "()V", "CALL_PATTERN", "Lkotlin/text/Regex;", "CAMELCASE_PATTERN", "CHECK_URL", "Lcom/android/tools/lint/detector/api/Issue;", "CLASS_CONTEXT", "", "CLASS_DETECTOR", "CLASS_ISSUE", "CLASS_ISSUE_COMPANION", "CLASS_ISSUE_REGISTRY", "CLASS_LINT_CLIENT", "CLASS_PSI_ELEMENT", "CLASS_PSI_JVM_MEMBER", "CLASS_PSI_METHOD", "CLASS_PSI_TREE_UTIL", "CLASS_PSI_VARIABLE", "CLASS_TEST_LINT_RESULT", "CLASS_TEST_LINT_TASK", "CLASS_U_ELEMENT", "DOLLAR_CHAR", "DOLLAR_STRING", "DOLLAR_STRINGS", "EXISTING_LINT_CONSTANTS", "ID", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING_DOC_EXAMPLE", "MISSING_VENDOR", "PSI_COMPARE", "TEXT_FORMAT", "TRIM_INDENT", "UNEXPECTED_DOMAIN", "USE_KOTLIN", "USE_UAST", "XML_PATTERN", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

