/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.ResourceVisibilityLookup;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.resources.FolderTypeRelationship;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.SdkUtils;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiPackage;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UReferenceExpression;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PrivateResourceDetector
extends ResourceXmlDetector
implements SourceCodeScanner {
    private static final String ATTR_OVERRIDE = "override";
    private static final String KEY_URL = "url";
    private static final Implementation IMPLEMENTATION = new Implementation(PrivateResourceDetector.class, Scope.JAVA_AND_RESOURCE_FILES, Scope.JAVA_FILE_SCOPE, Scope.RESOURCE_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("PrivateResource", "Using private resources", "Private resources should not be referenced; the may not be present everywhere, and even where they are they may disappear without notice.\n\nTo fix this, copy the resource into your own project instead.", Category.CORRECTNESS, 3, Severity.WARNING, IMPLEMENTATION);
    private List<String> overriding;

    @Override
    public boolean appliesToResourceRefs() {
        return true;
    }

    @Override
    public void visitResourceReference(JavaContext context2, UElement node, ResourceType resourceType, String name, boolean isFramework) {
        if (!isFramework && PrivateResourceDetector.isPrivate(context2, resourceType, name)) {
            String pkgName;
            PsiPackage pkg;
            PsiElement resolved;
            boolean foreignPackage = false;
            boolean globalAnalysis = context2.isGlobalAnalysis();
            if (!(!(node instanceof UReferenceExpression) || !((resolved = ((UReferenceExpression)node).resolve()) instanceof PsiField) || (pkg = context2.getEvaluator().getPackage(resolved)) == null || (pkgName = pkg.getQualifiedName()).equals(context2.getProject().getPackage()) || globalAnalysis && pkgName.equals(context2.getMainProject().getPackage()))) {
                foreignPackage = true;
            }
            if (!foreignPackage) {
                if (globalAnalysis && PrivateResourceDetector.referencedInMain(context2, resourceType, name)) {
                    return;
                }
                if (this.overriding != null && this.overriding.contains(resourceType + ":" + name)) {
                    return;
                }
            }
            String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, resourceType, name);
            Incident incident = new Incident(ISSUE, node, context2.getLocation(node), message2);
            if (globalAnalysis) {
                context2.report(incident);
            } else {
                context2.report(incident, this.map().put(KEY_URL, "@" + resourceType + "/" + name));
            }
        }
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        String urlString = map.getString(KEY_URL, null);
        if (urlString != null) {
            ResourceUrl url = ResourceUrl.parse((String)urlString);
            return url != null && !PrivateResourceDetector.referencedInMain(context2, url.type, url.name);
        }
        return false;
    }

    private static boolean referencedInMain(Context context2, ResourceType resourceType, String name) {
        LintClient client = context2.getClient();
        Project mainProject = context2.getMainProject();
        ResourceRepository repository2 = client.getResources(mainProject, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        return repository2.hasResources(ResourceNamespace.TODO(), resourceType, name);
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return ALL;
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        String value = attribute.getNodeValue();
        ResourceUrl url = ResourceUrl.parse((String)value);
        if (PrivateResourceDetector.isPrivate(context2, url)) {
            String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, url.type, url.name);
            context2.report(ISSUE, attribute, context2.getValueLocation(attribute), message2);
        }
    }

    @Override
    public Collection<String> getApplicableElements() {
        return Arrays.asList("style", "resources", "array", "string-array", "integer-array", "plurals");
    }

    @Override
    public void visitElement(XmlContext context2, Element element) {
        if ("resources".equals(element.getTagName())) {
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                Attr nameAttribute = item.getAttributeNode("name");
                if (nameAttribute == null) continue;
                String name = ResourcesUtil.resourceNameToFieldName((String)nameAttribute.getValue());
                ResourceType resourceType = ResourceType.fromXmlTag((Node)item);
                if (resourceType == null || !PrivateResourceDetector.isPrivate(context2, resourceType, name)) continue;
                if (this.overriding == null) {
                    this.overriding = Lists.newArrayList();
                }
                this.overriding.add(resourceType.getName() + ":" + name);
                if ("true".equals(item.getAttributeNS("http://schemas.android.com/tools", ATTR_OVERRIDE))) continue;
                String message2 = PrivateResourceDetector.createOverrideErrorMessage(context2, resourceType, name);
                Location location = context2.getValueLocation(nameAttribute);
                context2.report(ISSUE, nameAttribute, location, message2);
            }
        } else {
            assert ("style".equals(element.getTagName()) || "array".equals(element.getTagName()) || "plurals".equals(element.getTagName()) || "integer-array".equals(element.getTagName()) || "string-array".equals(element.getTagName()));
            for (Element item : XmlUtils.getSubTags((Node)element)) {
                PrivateResourceDetector.checkChildRefs(context2, item);
            }
        }
    }

    private static boolean isPrivate(Context context2, ResourceType type, String name) {
        if (type == ResourceType.ID) {
            return false;
        }
        ResourceVisibilityLookup lookup2 = context2.getProject().getResourceVisibility();
        return lookup2.isPrivate(type, name);
    }

    private static boolean isPrivate(Context context2, ResourceUrl url) {
        return url != null && !url.isFramework() && PrivateResourceDetector.isPrivate(context2, url.type, url.name);
    }

    private static void checkChildRefs(XmlContext context2, Element item) {
        NodeList childNodes = item.getChildNodes();
        int n10 = childNodes.getLength();
        block0: for (int i10 = 0; i10 < n10; ++i10) {
            Node child = childNodes.item(i10);
            if (child.getNodeType() != 3) continue;
            String text = child.getNodeValue();
            int index = text.indexOf("?attr/");
            if (index != -1) {
                String name = text.substring(index + "?attr/".length()).trim();
                if (!PrivateResourceDetector.isPrivate(context2, ResourceType.ATTR, name)) continue;
                String message2 = PrivateResourceDetector.createUsageErrorMessage(context2, ResourceType.ATTR, name);
                context2.report(ISSUE, item, context2.getLocation(child), message2);
                continue;
            }
            int m10 = text.length();
            for (int j10 = 0; j10 < m10; ++j10) {
                char c10 = text.charAt(j10);
                if (c10 == '@') {
                    ResourceUrl url = ResourceUrl.parse((String)text.trim());
                    if (!PrivateResourceDetector.isPrivate(context2, url)) continue block0;
                    String message3 = PrivateResourceDetector.createUsageErrorMessage(context2, url.type, url.name);
                    context2.report(ISSUE, item, context2.getLocation(child), message3);
                    continue block0;
                }
                if (!Character.isWhitespace(c10)) continue block0;
            }
        }
    }

    @Override
    public void beforeCheckFile(Context context2) {
        String resourceName;
        File file = context2.file;
        if (!Lint.isXmlFile(file) && !SdkUtils.isBitmapFile((File)file)) {
            return;
        }
        String parentName = file.getParentFile().getName();
        int dash = parentName.indexOf(45);
        if (dash != -1 || "values".equals(parentName)) {
            return;
        }
        ResourceFolderType folderType = ResourceFolderType.getFolderType((String)parentName);
        if (folderType == null) {
            return;
        }
        List types = FolderTypeRelationship.getRelatedResourceTypes((ResourceFolderType)folderType);
        if (types.isEmpty()) {
            return;
        }
        ResourceType type = (ResourceType)types.get(0);
        if (PrivateResourceDetector.isPrivate(context2, type, resourceName = ResourcesUtil.resourceNameToFieldName((String)Lint.getBaseName(file.getName())))) {
            String message2 = PrivateResourceDetector.createOverrideErrorMessage(context2, type, resourceName);
            Location location = Location.create(file);
            context2.report(ISSUE, location, message2);
        }
    }

    private static String createOverrideErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context2, type, name);
        return String.format("Overriding `@%1$s/%2$s` which is marked as private in %3$s. If deliberate, use tools:override=\"true\", otherwise pick a different name.", type, name, libraryName);
    }

    private static String createUsageErrorMessage(Context context2, ResourceType type, String name) {
        String libraryName = PrivateResourceDetector.getLibraryName(context2, type, name);
        return String.format("The resource `@%1$s/%2$s` is marked as private in %3$s", type, name, libraryName);
    }

    private static String getLibraryName(Context context2, ResourceType type, String name) {
        ResourceVisibilityLookup lookup2 = context2.getProject().getResourceVisibility();
        String library2 = lookup2.getPrivateIn(type, name);
        if (library2 != null) {
            return library2;
        }
        return "the library";
    }
}

