/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.android.tools.lint.model.LintModelMavenName;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttribute;
import com.intellij.lang.jvm.annotation.JvmAnnotationAttributeValue;
import com.intellij.lang.jvm.annotation.JvmAnnotationConstantValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.compiled.ClsAnnotationImpl;
import com.intellij.psi.util.PsiTypesUtil;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UastEmptyExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.java.UnknownJavaExpression;
import org.jetbrains.uast.util.UastExpressionUtils;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 42\u00020\u00012\u00020\u0002:\u00014B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016JP\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JX\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002JD\u0010\u0018\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J\u0016\u0010\u0019\u001a\u00020\u00142\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0002J*\u0010\u001b\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u000f\u001a\u00020\u0006H\u0016J\"\u0010\u001f\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\fH\u0002J\u0018\u0010%\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020\fH\u0002J<\u0010&\u001a\u00020\b2\b\u0010'\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u0015\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010(\u001a\u00020\u0014H\u0002J \u0010)\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010*\u001a\u00020\u0006H\u0002J|\u0010+\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010,\u001a\u00020\f2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010-\u001a\u00020\u00062\b\u0010\r\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u0001002\f\u00101\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u00052\f\u00103\u001a\b\u0012\u0004\u0012\u00020\u00100\u0005H\u0016\u00a8\u00065"}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "applicableAnnotations", "", "", "checkRestrictTo", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UElement;", "method", "Lcom/intellij/psi/PsiMember;", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "allMethodAnnotations", "allClassAnnotations", "applyClassAnnotationsToMembers", "", "member", "scope", "", "checkVisibleForTesting", "containsRestrictionAnnotation", "list", "flagHide", "containingClass", "Lcom/intellij/psi/PsiClass;", "inheritAnnotation", "isAllowedFirstParty", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "isGmsContext", "element", "isTestContext", "reportRestriction", "where", "isClassAnnotation", "reportVisibilityError", "desc", "visitAnnotationUsage", "usage", "qualifiedName", "Lcom/intellij/psi/PsiMethod;", "referenced", "Lcom/intellij/psi/PsiElement;", "annotations", "allMemberAnnotations", "allPackageAnnotations", "Companion", "android.sdktools.lint-checks"})
public final class RestrictToDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(RestrictToDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String ATTR_OTHERWISE = "otherwise";
    @NotNull
    private static final String ATTR_PRODUCTION_VISIBILITY = "productionVisibility";
    private static final int VISIBILITY_PRIVATE = 2;
    private static final int VISIBILITY_PACKAGE_PRIVATE = 3;
    private static final int VISIBILITY_PROTECTED = 4;
    private static final int VISIBILITY_NONE = 5;
    private static final int RESTRICT_TO_LIBRARY_GROUP = 1;
    private static final int RESTRICT_TO_LIBRARY = 2;
    private static final int RESTRICT_TO_LIBRARY_GROUP_PREFIX = 4;
    private static final int RESTRICT_TO_TESTS = 8;
    private static final int RESTRICT_TO_SUBCLASSES = 16;
    private static final int RESTRICT_TO_ALL = 32;
    @JvmField
    @NotNull
    public static final Issue RESTRICTED = Issue.Companion.create("RestrictedApi", "Restricted API", "\n                This API has been flagged with a restriction that has not been met.\n\n                Examples of API restrictions:\n                * Method can only be invoked by a subclass\n                * Method can only be accessed from within the same library (defined by the Gradle library group id)\n                * Method can only be accessed from tests.\n\n                You can add your own API restrictions with the `@RestrictTo` annotation.", Category.CORRECTNESS, 4, Severity.ERROR, IMPLEMENTATION);
    @JvmField
    @NotNull
    public static final Issue TEST_VISIBILITY = Issue.Companion.create("VisibleForTests", "Visible Only For Tests", "\n                With the `@VisibleForTesting` annotation you can specify an `otherwise=` \\\n                attribute which specifies the intended visibility if the method had not \\\n                been made more widely visible for the tests.\n\n                This check looks for accesses from production code (e.g. not tests) where \\\n                the access would not have been allowed with the intended production \\\n                visibility.", Category.CORRECTNESS, 4, Severity.WARNING, IMPLEMENTATION);

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[6];
        String string = AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.oldName()");
        objectArray[0] = string;
        string = AnnotationDetector.RESTRICT_TO_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.newName()");
        objectArray[1] = string;
        objectArray[2] = "com.google.android.gms.common.internal.Hide";
        string = AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VISIBLE_FOR_TESTING_ANNOTATION.oldName()");
        objectArray[3] = string;
        string = AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"VISIBLE_FOR_TESTING_ANNOTATION.newName()");
        objectArray[4] = string;
        objectArray[5] = "com.google.common.annotations.VisibleForTesting";
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        return false;
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        return type != AnnotationUsageType.ASSIGNMENT_LHS && type != AnnotationUsageType.ASSIGNMENT_RHS && super.isApplicableAnnotationUsage(type);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement usage, @NotNull AnnotationUsageType type, @NotNull UAnnotation annotation, @NotNull String qualifiedName, @Nullable PsiMethod method, @Nullable PsiElement referenced, @NotNull List<? extends UAnnotation> annotations, @NotNull List<? extends UAnnotation> allMemberAnnotations, @NotNull List<? extends UAnnotation> allClassAnnotations, @NotNull List<? extends UAnnotation> allPackageAnnotations) {
        PsiElement psiElement;
        Object object;
        PsiElement sourcePsi;
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)usage, (String)"usage");
        Intrinsics.checkParameterIsNotNull((Object)((Object)type), (String)"type");
        Intrinsics.checkParameterIsNotNull((Object)annotation, (String)"annotation");
        Intrinsics.checkParameterIsNotNull((Object)qualifiedName, (String)"qualifiedName");
        Intrinsics.checkParameterIsNotNull(annotations, (String)"annotations");
        Intrinsics.checkParameterIsNotNull(allMemberAnnotations, (String)"allMemberAnnotations");
        Intrinsics.checkParameterIsNotNull(allClassAnnotations, (String)"allClassAnnotations");
        Intrinsics.checkParameterIsNotNull(allPackageAnnotations, (String)"allPackageAnnotations");
        if (type == AnnotationUsageType.EXTENDS && usage instanceof UTypeReferenceExpression && Lint.isKotlin(sourcePsi = usage.getSourcePsi()) && Intrinsics.areEqual((object = sourcePsi) == null ? null : ((psiElement = object.getParent()) == null ? null : psiElement.toString()), (Object)"CONSTRUCTOR_CALLEE")) {
            return;
        }
        object = method;
        PsiMember member = object == null ? (referenced instanceof PsiMember ? (PsiMember)referenced : null) : (PsiMember)object;
        object = qualifiedName;
        if (Intrinsics.areEqual((Object)object, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)object, (Object)AnnotationDetector.RESTRICT_TO_ANNOTATION.newName())) {
            this.checkRestrictTo(context2, usage, member, annotation, allMemberAnnotations, allClassAnnotations, true);
        } else if (Intrinsics.areEqual((Object)object, (Object)"com.google.android.gms.common.internal.Hide")) {
            boolean isConstructor = method == null || method.isConstructor();
            boolean isStatic = method == null ? false : context2.getEvaluator().isStatic((PsiModifierListOwner)method);
            this.checkRestrictTo(context2, usage, (PsiMember)method, annotation, allMemberAnnotations, allClassAnnotations, isConstructor || isStatic);
        } else if (((Intrinsics.areEqual((Object)object, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.oldName()) ? true : Intrinsics.areEqual((Object)object, (Object)AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.newName())) ? true : Intrinsics.areEqual((Object)object, (Object)"com.google.common.annotations.VisibleForTesting")) && member != null) {
            this.checkVisibleForTesting(context2, usage, member, annotation, allMemberAnnotations, allClassAnnotations);
        }
    }

    private final boolean flagHide(JavaContext context2, PsiClass containingClass, PsiMember member, UElement node) {
        if (this.isGmsContext(context2, node)) {
            return false;
        }
        return !this.isAllowedFirstParty(context2, containingClass, member);
    }

    private final boolean isAllowedFirstParty(JavaContext context2, PsiClass containingClass, PsiMember member) {
        PsiMember psiMember;
        String string = System.getProperty("com.android.tools.lint.bindir");
        if (string == null) {
            return false;
        }
        String binDir = string;
        if (!StringsKt.contains$default((CharSequence)binDir, (CharSequence)"third_party/java/android/", (boolean)false, (int)2, null)) {
            return false;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (member != containingClass && ((psiMember = member) == null ? false : RestrictToDetector.isAllowedFirstParty$isFirstParty((PsiModifierListOwner)psiMember, evaluator))) {
            return true;
        }
        return RestrictToDetector.isAllowedFirstParty$isFirstParty((PsiModifierListOwner)containingClass, evaluator);
    }

    private final boolean isGmsContext(JavaContext context2, UElement element) {
        JavaEvaluator evaluator = context2.getEvaluator();
        PsiPackage psiPackage = evaluator.getPackage(element);
        if (psiPackage == null) {
            return false;
        }
        PsiPackage pkg = psiPackage;
        String string = pkg.getQualifiedName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pkg.qualifiedName");
        String qualifiedName = string;
        if (!StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.", (boolean)false, (int)2, null)) {
            return false;
        }
        return StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.firebase", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.android.gms", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.ads", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)qualifiedName, (String)"com.google.mlkit", (boolean)false, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isTestContext(JavaContext context2, UElement element) {
        UElement current = element;
        if (context2.isTestSource()) {
            return true;
        }
        while (true) {
            void $this$getParentOfType$iv;
            UElement uElement = current;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UAnnotated uAnnotated = (UAnnotated)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UAnnotated.class, (boolean)strict$iv);
            if (uAnnotated == null) break;
            UAnnotated owner = uAnnotated;
            for (UAnnotation annotation : owner.getUAnnotations()) {
                int restrictionScope;
                String name = annotation.getQualifiedName();
                if (!(AnnotationDetector.RESTRICT_TO_ANNOTATION.isEquals(name) ? ((restrictionScope = RestrictToDetector.Companion.getRestrictionScope(annotation)) & 8) != 0 : AnnotationDetector.VISIBLE_FOR_TESTING_ANNOTATION.isEquals(name) || Intrinsics.areEqual((Object)"com.google.common.annotations.VisibleForTesting", (Object)name))) continue;
                return true;
            }
            current = (UElement)owner;
        }
        return false;
    }

    private final void checkVisibleForTesting(JavaContext context2, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations) {
        int visibility = RestrictToDetector.Companion.getVisibilityForTesting(annotation);
        if (visibility == 5) {
            RestrictToDetector.checkRestrictTo$default(this, context2, node, method, annotation, allMethodAnnotations, allClassAnnotations, 8, false, 128, null);
        } else {
            PsiFile containingFile2;
            UFile uFile = UastUtils.getContainingUFile((UElement)node);
            PsiFile containingFile1 = UastLintUtils.Companion.getPsiFile(uFile);
            if (Intrinsics.areEqual((Object)containingFile1, (Object)(containingFile2 = UastLintUtils.Companion.getContainingFile((PsiElement)method))) || containingFile2 == null) {
                return;
            }
            PsiFile psiFile = containingFile1;
            if (Intrinsics.areEqual((Object)(psiFile == null ? null : psiFile.getVirtualFile()), (Object)containingFile2.getVirtualFile())) {
                return;
            }
            if (visibility == 2) {
                if (!this.isTestContext(context2, node)) {
                    this.reportVisibilityError(context2, node, "private");
                }
                return;
            }
            JavaEvaluator evaluator = context2.getEvaluator();
            PsiPackage pkg = evaluator.getPackage(node);
            PsiPackage methodPackage = evaluator.getPackage((PsiElement)method);
            PsiPackage psiPackage = pkg;
            String string = psiPackage == null ? null : psiPackage.getQualifiedName();
            psiPackage = methodPackage;
            if (Intrinsics.areEqual((Object)string, (Object)(psiPackage == null ? null : psiPackage.getQualifiedName()))) {
                return;
            }
            if (visibility == 3) {
                if (!this.isTestContext(context2, node)) {
                    this.reportVisibilityError(context2, node, "package private");
                }
                return;
            }
            boolean bl2 = visibility == 4;
            boolean bl3 = false;
            boolean bl4 = false;
            if (_Assertions.ENABLED && !bl2) {
                boolean bl5 = false;
                String string2 = "Assertion failed";
                throw (Throwable)((Object)new AssertionError((Object)string2));
            }
            PsiClass methodClass = method.getContainingClass();
            UClass thisClass = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)true);
            if (thisClass == null || methodClass == null) {
                return;
            }
            String qualifiedName = methodClass.getQualifiedName();
            if (qualifiedName == null || evaluator.inheritsFrom((PsiClass)thisClass, qualifiedName, false)) {
                return;
            }
            if (!this.isTestContext(context2, node)) {
                this.reportVisibilityError(context2, node, "protected");
            }
        }
    }

    private final void reportVisibilityError(JavaContext context2, UElement node, String desc) {
        String message2 = "This method should only be accessed from tests or within " + desc + " scope";
        Location location = node instanceof UCallExpression ? context2.getCallLocation((UCallExpression)node, false, false) : context2.getLocation(node);
        this.report(context2, TEST_VISIBILITY, node, location, message2);
    }

    private final void checkRestrictTo(JavaContext context2, UElement node, PsiMember method, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, boolean applyClassAnnotationsToMembers) {
        int scope = RestrictToDetector.Companion.getRestrictionScope(annotation);
        if (scope != 0) {
            this.checkRestrictTo(context2, node, method, annotation, allMethodAnnotations, allClassAnnotations, scope, applyClassAnnotationsToMembers);
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list2, List list3, boolean bl2, int n10, Object object) {
        if ((n10 & 0x40) != 0) {
            bl2 = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list2, list3, bl2);
    }

    private final void checkRestrictTo(JavaContext context2, UElement node, PsiMember member, UAnnotation annotation, List<? extends UAnnotation> allMethodAnnotations, List<? extends UAnnotation> allClassAnnotations, int scope, boolean applyClassAnnotationsToMembers) {
        String qualifiedName;
        String fqn;
        Object expectedPrefix;
        Object where2;
        Object methodGroup;
        Object thisGroup;
        LintModelMavenName methodCoordinates;
        LintModelMavenName thisCoordinates;
        JavaEvaluator evaluator;
        PsiClass containingClass;
        PsiClass psiClass;
        Object object;
        if (node instanceof UTypeReferenceExpression) {
            object = PsiTypesUtil.getPsiClass((PsiType)((UTypeReferenceExpression)node).getType());
        } else if (member != null) {
            object = member.getContainingClass();
        } else if (node instanceof UCallExpression) {
            UReferenceExpression uReferenceExpression = ((UCallExpression)node).getClassReference();
            PsiElement psiElement = psiClass = uReferenceExpression == null ? null : uReferenceExpression.resolve();
            object = psiClass instanceof PsiClass ? psiClass : null;
        } else {
            object = node instanceof PsiClass ? (PsiClass)node : null;
        }
        psiClass = containingClass = object;
        if (psiClass == null) {
            return;
        }
        boolean isClassAnnotation = false;
        if (UastLintUtils.Companion.containsAnnotation(allMethodAnnotations, annotation)) {
            if (member != null && context2.getEvaluator().isInherited(annotation, (PsiModifierListOwner)member)) {
                return;
            }
        } else if (applyClassAnnotationsToMembers) {
            if (this.containsRestrictionAnnotation(allMethodAnnotations)) {
                return;
            }
            isClassAnnotation = UastLintUtils.Companion.containsAnnotation(allClassAnnotations, annotation);
            if (isClassAnnotation ? context2.getEvaluator().isInherited(annotation, (PsiModifierListOwner)containingClass) : this.containsRestrictionAnnotation(allClassAnnotations)) {
                return;
            }
        } else {
            return;
        }
        if ((scope & 1) != 0 && member != null) {
            Object object2;
            Object object3;
            evaluator = context2.getEvaluator();
            LintModelMavenName lintModelMavenName = evaluator.getLibrary(node);
            thisCoordinates = lintModelMavenName == null ? context2.getProject().getMavenCoordinate() : lintModelMavenName;
            LintModelMavenName lintModelMavenName2 = evaluator.getLibrary((PsiElement)member);
            if (lintModelMavenName2 == null) {
                Project project;
                object3 = this;
                boolean bl2 = false;
                boolean bl3 = false;
                RestrictToDetector $this$checkRestrictTo_u24lambda_u2d0 = (RestrictToDetector)object3;
                boolean bl4 = false;
                object2 = thisCoordinates != null && !(member instanceof PsiCompiledElement) ? ((project = context2.getEvaluator().getProject((PsiElement)member)) == null ? null : project.getMavenCoordinate()) : (LintModelMavenName)null;
            } else {
                object2 = lintModelMavenName2;
            }
            methodCoordinates = object2;
            object3 = thisCoordinates;
            thisGroup = object3 == null ? null : object3.getGroupId();
            LintModelMavenName lintModelMavenName3 = methodCoordinates;
            Object object4 = methodGroup = lintModelMavenName3 == null ? null : lintModelMavenName3.getGroupId();
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                where2 = "from within the same library group (groupId=" + methodGroup + ')';
                this.reportRestriction((String)where2, containingClass, member, context2, node, isClassAnnotation);
            }
        } else if ((scope & 4) != 0 && member != null) {
            Object object5;
            boolean bl5;
            int n10;
            evaluator = context2.getEvaluator();
            methodCoordinates = evaluator.getLibrary(node);
            thisCoordinates = methodCoordinates == null ? context2.getProject().getMavenCoordinate() : methodCoordinates;
            thisGroup = evaluator.getLibrary((PsiElement)member);
            if (thisGroup == null) {
                Project project;
                methodGroup = this;
                boolean where2 = false;
                n10 = 0;
                RestrictToDetector $this$checkRestrictTo_u24lambda_u2d1 = (RestrictToDetector)methodGroup;
                bl5 = false;
                object5 = thisCoordinates != null && !(member instanceof PsiCompiledElement) ? ((project = context2.getEvaluator().getProject((PsiElement)member)) == null ? null : project.getMavenCoordinate()) : (LintModelMavenName)null;
            } else {
                object5 = thisGroup;
            }
            methodCoordinates = object5;
            methodGroup = thisCoordinates;
            thisGroup = methodGroup == null ? null : methodGroup.getGroupId();
            where2 = methodCoordinates;
            Object object6 = methodGroup = where2 == null ? null : where2.getGroupId();
            if (!(methodGroup == null || thisGroup != null && Companion.sameLibraryGroupPrefix((String)thisGroup, (String)methodGroup))) {
                String string;
                n10 = StringsKt.lastIndexOf$default((CharSequence)((CharSequence)methodGroup), (char)'.', (int)0, (boolean)false, (int)6, null);
                boolean $this$checkRestrictTo_u24lambda_u2d1 = false;
                bl5 = false;
                int it2 = n10;
                boolean bl6 = false;
                if (it2 < 0) {
                    string = "\"\"";
                } else {
                    Object object7 = methodGroup;
                    int n11 = 0;
                    boolean bl7 = false;
                    String string2 = ((String)object7).substring(n11, it2);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                expectedPrefix = string;
                String where3 = "from within the same library group prefix (referenced groupId=`" + methodGroup + "` with prefix " + (String)expectedPrefix + (thisGroup != null ? " from groupId=`" + thisGroup + '`' : "") + ')';
                this.reportRestriction(where3, containingClass, member, context2, node, isClassAnnotation);
            }
        } else if ((scope & 2) != 0 && member != null) {
            Project project;
            evaluator = context2.getEvaluator();
            methodCoordinates = evaluator.getLibrary(node);
            thisCoordinates = methodCoordinates == null ? context2.getProject().getMavenCoordinate() : methodCoordinates;
            methodCoordinates = evaluator.getLibrary((PsiElement)member);
            methodGroup = thisCoordinates;
            thisGroup = methodGroup == null ? null : methodGroup.getGroupId();
            expectedPrefix = methodCoordinates;
            Object object8 = methodGroup = expectedPrefix == null ? null : expectedPrefix.getGroupId();
            if (!Intrinsics.areEqual((Object)thisGroup, (Object)methodGroup) && methodGroup != null) {
                String methodArtifact;
                LintModelMavenName where3 = thisCoordinates;
                String thisArtifact = where3 == null ? null : where3.getArtifactId();
                if (!Intrinsics.areEqual((Object)thisArtifact, (Object)(methodArtifact = methodCoordinates.getArtifactId()))) {
                    String where4 = "from within the same library (" + methodGroup + ':' + methodArtifact + ')';
                    this.reportRestriction(where4, containingClass, member, context2, node, isClassAnnotation);
                }
            } else if (!(member instanceof PsiCompiledElement) && (project = context2.getEvaluator().getProject((PsiElement)member)) != null && !Intrinsics.areEqual((Object)project, (Object)context2.getProject())) {
                LintModelMavenName coordinates = project.getMavenCoordinate();
                String name = coordinates != null ? coordinates.getGroupId() + ':' + coordinates.getArtifactId() : project.getName();
                String where5 = "from within the same library (" + name + ')';
                this.reportRestriction(where5, containingClass, member, context2, node, isClassAnnotation);
            }
        }
        if ((scope & 8) != 0 && !this.isTestContext(context2, node)) {
            this.reportRestriction("from tests", containingClass, member, context2, node, isClassAnnotation);
        }
        if ((scope & 0x20) != 0 && (!Intrinsics.areEqual((Object)(fqn = annotation.getQualifiedName()), (Object)"com.google.android.gms.common.internal.Hide") || this.flagHide(context2, containingClass, member, node))) {
            this.reportRestriction(null, containingClass, member, context2, node, isClassAnnotation);
        }
        if ((scope & 0x10) != 0 && (qualifiedName = containingClass.getQualifiedName()) != null) {
            JavaEvaluator evaluator2 = context2.getEvaluator();
            UClass outer = null;
            boolean isSubClass = false;
            UElement prev = node;
            while ((outer = (UClass)UastUtils.getParentOfType((UElement)prev, UClass.class, (boolean)true)) != null) {
                if (evaluator2.inheritsFrom((PsiClass)outer, qualifiedName, false)) {
                    isSubClass = true;
                    break;
                }
                if (evaluator2.isStatic((PsiModifierListOwner)outer)) break;
                prev = (UElement)outer;
            }
            if (!isSubClass) {
                this.reportRestriction("from subclasses", containingClass, member, context2, node, isClassAnnotation);
            }
        }
    }

    static /* synthetic */ void checkRestrictTo$default(RestrictToDetector restrictToDetector, JavaContext javaContext, UElement uElement, PsiMember psiMember, UAnnotation uAnnotation, List list2, List list3, int n10, boolean bl2, int n11, Object object) {
        if ((n11 & 0x80) != 0) {
            bl2 = true;
        }
        restrictToDetector.checkRestrictTo(javaContext, uElement, psiMember, uAnnotation, list2, list3, n10, bl2);
    }

    private final void reportRestriction(String where, PsiClass containingClass, PsiMember member, JavaContext context2, UElement node, boolean isClassAnnotation) {
        String string;
        String string2;
        String string3;
        String api = null;
        if (member == null || member instanceof PsiMethod && ((PsiMethod)member).isConstructor()) {
            PsiMember psiMember = member;
            string3 = psiMember == null ? null : psiMember.getName();
            string2 = string3 == null ? Intrinsics.stringPlus((String)containingClass.getName(), (Object)" constructor") : string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"{\n            member?.na\u2026 \" constructor\"\n        }");
            string = string2;
        } else {
            string = Intrinsics.areEqual((Object)containingClass, (Object)member) ? (string2 = (string3 = member.getName()) == null ? "class" : string3) : containingClass.getName() + '.' + member.getName();
        }
        api = string;
        UElement locationNode = node;
        if (node instanceof UCallExpression) {
            UIdentifier nameElement = ((UCallExpression)node).getMethodIdentifier();
            if (nameElement != null) {
                locationNode = (UElement)nameElement;
            }
            if (isClassAnnotation) {
                UExpression qualifier = ((UCallExpression)node).getReceiver();
                String className = containingClass.getName();
                if (qualifier != null && className != null && Intrinsics.areEqual((Object)qualifier.asSourceString(), (Object)className)) {
                    locationNode = (UElement)qualifier;
                    api = className;
                }
            }
        }
        String message2 = null;
        if (where == null) {
            message2 = Intrinsics.stringPlus((String)api, (Object)" is marked as internal and should not be accessed from apps");
        } else {
            String refType = member instanceof PsiMethod ? "called" : "accessed";
            message2 = api + " can only be " + refType + ' ' + where;
            if (Intrinsics.areEqual((Object)where, (Object)"from within the same library (groupId=com.android.support)")) {
                message2 = "This API is marked as internal to the support library and should not be accessed from apps";
            }
        }
        Location location = null;
        location = locationNode instanceof UCallExpression ? context2.getCallLocation((UCallExpression)locationNode, false, false) : context2.getLocation(locationNode);
        this.report(context2, RESTRICTED, node, location, message2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean containsRestrictionAnnotation(List<? extends UAnnotation> list2) {
        String string = AnnotationDetector.RESTRICT_TO_ANNOTATION.oldName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.oldName()");
        if (UastLintUtils.Companion.containsAnnotation(list2, string)) return true;
        string = AnnotationDetector.RESTRICT_TO_ANNOTATION.newName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"RESTRICT_TO_ANNOTATION.newName()");
        if (!UastLintUtils.Companion.containsAnnotation(list2, string)) return false;
        return true;
    }

    private static final boolean isAllowedFirstParty$isFirstParty(PsiModifierListOwner $this$isAllowedFirstParty_u24isFirstParty, JavaEvaluator evaluator) {
        String[] stringArray = new String[]{"com.google.android.gms.common.internal.ShowFirstParty"};
        PsiAnnotation psiAnnotation = evaluator.findAnnotationInHierarchy($this$isAllowedFirstParty_u24isFirstParty, stringArray);
        return psiAnnotation != null;
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u001f\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u000bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lcom/android/tools/lint/checks/RestrictToDetector$Companion;", "", "()V", "ATTR_OTHERWISE", "", "ATTR_PRODUCTION_VISIBILITY", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "RESTRICTED", "Lcom/android/tools/lint/detector/api/Issue;", "RESTRICT_TO_ALL", "", "RESTRICT_TO_LIBRARY", "RESTRICT_TO_LIBRARY_GROUP", "RESTRICT_TO_LIBRARY_GROUP_PREFIX", "RESTRICT_TO_SUBCLASSES", "RESTRICT_TO_TESTS", "TEST_VISIBILITY", "VISIBILITY_NONE", "VISIBILITY_PACKAGE_PRIVATE", "VISIBILITY_PRIVATE", "VISIBILITY_PROTECTED", "getRestrictionScope", "annotation", "Lorg/jetbrains/uast/UAnnotation;", "expression", "Lorg/jetbrains/uast/UExpression;", "getVisibilityForTesting", "sameLibraryGroupPrefix", "", "group1", "group2", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final int getVisibilityForTesting(UAnnotation annotation) {
            block23: {
                PsiElement psi;
                UExpression value;
                block24: {
                    Object v10;
                    block22: {
                        UExpression uExpression = annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_OTHERWISE);
                        UExpression uExpression2 = value = uExpression == null ? annotation.findDeclaredAttributeValue(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY) : uExpression;
                        if (!(value instanceof ULiteralExpression)) break block22;
                        v10 = ((ULiteralExpression)value).getValue();
                        if (v10 instanceof Integer) {
                            return ((Number)v10).intValue();
                        }
                        break block23;
                    }
                    if (!(value instanceof UReferenceExpression)) break block24;
                    v10 = ((UReferenceExpression)value).getResolvedName();
                    if (v10 == null) break block23;
                    int n10 = -1;
                    switch (((String)v10).hashCode()) {
                        case 2402104: {
                            if (((String)v10).equals("NONE")) {
                                n10 = 1;
                            }
                            break;
                        }
                        case -2116912242: {
                            if (((String)v10).equals("PROTECTED")) {
                                n10 = 2;
                            }
                            break;
                        }
                        case 403485027: {
                            if (((String)v10).equals("PRIVATE")) {
                                n10 = 3;
                            }
                            break;
                        }
                        case 1152750154: {
                            if (((String)v10).equals("PACKAGE_PRIVATE")) {
                                n10 = 4;
                            }
                            break;
                        }
                    }
                    switch (n10) {
                        case 1: {
                            return 5;
                        }
                        case 3: {
                            return 2;
                        }
                        case 2: {
                            return 4;
                        }
                        case 4: {
                            return 3;
                        }
                    }
                    break block23;
                }
                if (value instanceof UnknownJavaExpression) {
                    Object v11;
                    PsiElement sourcePsi = ((UnknownJavaExpression)value).getSourcePsi();
                    if (sourcePsi instanceof PsiLiteralExpression && (v11 = ((PsiLiteralExpression)sourcePsi).getValue()) instanceof Integer) {
                        return ((Number)v11).intValue();
                    }
                } else if (value instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v12;
                    JvmAnnotationAttribute otherwise;
                    JvmAnnotationAttribute jvmAnnotationAttribute = ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_OTHERWISE);
                    JvmAnnotationAttribute jvmAnnotationAttribute2 = otherwise = jvmAnnotationAttribute == null ? ((ClsAnnotationImpl)psi).findAttribute(RestrictToDetector.ATTR_PRODUCTION_VISIBILITY) : jvmAnnotationAttribute;
                    JvmAnnotationAttributeValue jvmAnnotationAttributeValue = v12 = jvmAnnotationAttribute2 == null ? null : jvmAnnotationAttribute2.getAttributeValue();
                    if (v12 instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v12).getConstantValue()) instanceof Number) {
                        return ((Number)constant).intValue();
                    }
                }
            }
            return 2;
        }

        private final int getRestrictionScope(UAnnotation annotation) {
            UExpression value = annotation.findDeclaredAttributeValue("value");
            if (value != null) {
                return this.getRestrictionScope(value, annotation);
            }
            if (Intrinsics.areEqual((Object)"com.google.android.gms.common.internal.Hide", (Object)annotation.getQualifiedName())) {
                return 32;
            }
            return 0;
        }

        private final int getRestrictionScope(UExpression expression, UAnnotation annotation) {
            int scope = 0;
            if (expression != null) {
                PsiElement psi;
                if (UastExpressionUtils.isArrayInitializer((UElement)((UElement)expression))) {
                    UCallExpression initializerExpression = (UCallExpression)expression;
                    List initializers = initializerExpression.getValueArguments();
                    for (UExpression initializer : initializers) {
                        scope |= this.getRestrictionScope(initializer, annotation);
                    }
                } else if (expression instanceof UReferenceExpression) {
                    PsiElement resolved = ((UReferenceExpression)expression).resolve();
                    if (resolved instanceof PsiField) {
                        String string = ((PsiField)resolved).getName();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolved.name");
                        String name = string;
                        if (Intrinsics.areEqual((Object)"GROUP_ID", (Object)name) || Intrinsics.areEqual((Object)"LIBRARY_GROUP", (Object)name)) {
                            scope |= 1;
                        } else if (Intrinsics.areEqual((Object)"SUBCLASSES", (Object)name)) {
                            scope |= 0x10;
                        } else if (Intrinsics.areEqual((Object)"TESTS", (Object)name)) {
                            scope |= 8;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY", (Object)name)) {
                            scope |= 2;
                        } else if (Intrinsics.areEqual((Object)"LIBRARY_GROUP_PREFIX", (Object)name)) {
                            scope |= 4;
                        }
                    }
                } else if (expression instanceof UastEmptyExpression && (psi = annotation.getSourcePsi()) instanceof ClsAnnotationImpl) {
                    Object constant;
                    JvmAnnotationAttributeValue v10;
                    JvmAnnotationAttribute otherwise = ((ClsAnnotationImpl)psi).findAttribute("value");
                    JvmAnnotationAttribute initializer = otherwise;
                    JvmAnnotationAttributeValue jvmAnnotationAttributeValue = v10 = initializer == null ? null : initializer.getAttributeValue();
                    if (v10 instanceof JvmAnnotationConstantValue && (constant = ((JvmAnnotationConstantValue)v10).getConstantValue()) instanceof Number) {
                        scope |= ((Number)constant).intValue();
                    }
                }
            }
            return scope;
        }

        public final boolean sameLibraryGroupPrefix(@NotNull String group1, @NotNull String group2) {
            Intrinsics.checkParameterIsNotNull((Object)group1, (String)"group1");
            Intrinsics.checkParameterIsNotNull((Object)group2, (String)"group2");
            if (Intrinsics.areEqual((Object)group1, (Object)group2)) {
                return true;
            }
            int i12 = StringsKt.lastIndexOf$default((CharSequence)group1, (char)'.', (int)0, (boolean)false, (int)6, null);
            int i22 = StringsKt.lastIndexOf$default((CharSequence)group2, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (i22 != i12 || i12 == -1) {
                return false;
            }
            return StringsKt.regionMatches$default((String)group1, (int)0, (String)group2, (int)0, (int)i12, (boolean)false, (int)16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

