/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnnotationDetector;
import com.android.tools.lint.checks.RangeConstraint;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.google.common.annotations.VisibleForTesting;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UExpression;

class SizeConstraint
extends RangeConstraint {
    final long exact;
    final long min;
    final long max;
    final long multiple;

    public static SizeConstraint create(UAnnotation annotation) {
        assert (AnnotationDetector.SIZE_ANNOTATION.isEquals(annotation.getQualifiedName()));
        long exact = UastLintUtils.getAnnotationLongValue(annotation, "value", -1L);
        long min = UastLintUtils.getAnnotationLongValue(annotation, "min", Long.MIN_VALUE);
        long max = UastLintUtils.getAnnotationLongValue(annotation, "max", Long.MAX_VALUE);
        long multiple = UastLintUtils.getAnnotationLongValue(annotation, "multiple", 1L);
        return new SizeConstraint(exact, min, max, multiple);
    }

    @VisibleForTesting
    static SizeConstraint exactly(long value) {
        return new SizeConstraint(value, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
    }

    @VisibleForTesting
    static SizeConstraint atLeast(long value) {
        return new SizeConstraint(-1L, value, Long.MAX_VALUE, 1L);
    }

    @VisibleForTesting
    static SizeConstraint atMost(long value) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, value, 1L);
    }

    @VisibleForTesting
    static SizeConstraint range(long from, long to2) {
        return new SizeConstraint(-1L, from, to2, 1L);
    }

    @VisibleForTesting
    static SizeConstraint multiple(int multiple) {
        return new SizeConstraint(-1L, Long.MIN_VALUE, Long.MAX_VALUE, multiple);
    }

    @VisibleForTesting
    static SizeConstraint rangeWithMultiple(long from, long to2, int multiple) {
        return new SizeConstraint(-1L, from, to2, multiple);
    }

    @VisibleForTesting
    static SizeConstraint minWithMultiple(long from, int multiple) {
        return new SizeConstraint(-1L, from, Long.MAX_VALUE, multiple);
    }

    private SizeConstraint(long exact, long min, long max, long multiple) {
        this.exact = exact;
        this.min = min;
        this.max = max;
        this.multiple = multiple;
    }

    public String toString() {
        return this.describe(null, null, null);
    }

    public boolean isValid(long actual) {
        return !(this.exact != -1L ? this.exact != actual : actual < this.min || actual > this.max || actual % this.multiple != 0L);
    }

    public String describe() {
        return this.describe(null, null, null);
    }

    public String describe(long argument) {
        return this.describe(null, null, argument);
    }

    public String describe(UExpression argument, String unit, Long actualValue) {
        if (unit == null) {
            unit = argument != null && argument.getExpressionType() != null && argument.getExpressionType().getCanonicalText().equals("java.lang.String") ? "Length" : "Size";
        }
        if (actualValue != null && !this.isValid(actualValue)) {
            long actual = actualValue;
            if (this.exact != -1L) {
                if (this.exact != actual) {
                    return String.format("Expected %1$s %2$d (was %3$d)", unit, this.exact, actual);
                }
            } else {
                if (actual < this.min || actual > this.max) {
                    StringBuilder sb2 = new StringBuilder(20);
                    if (actual < this.min) {
                        sb2.append("Expected ").append(unit).append(" \u2265 ");
                        sb2.append(Long.toString(this.min));
                    } else {
                        assert (actual > this.max);
                        sb2.append("Expected ").append(unit).append(" \u2264 ");
                        sb2.append(Long.toString(this.max));
                    }
                    sb2.append(" (was ").append(actual).append(')');
                    return sb2.toString();
                }
                if (actual % this.multiple != 0L) {
                    return String.format("Expected %1$s to be a multiple of %2$d (was %3$d and should be either %4$d or %5$d)", unit, this.multiple, actual, actual / this.multiple * this.multiple, (actual / this.multiple + 1L) * this.multiple);
                }
            }
        }
        StringBuilder sb3 = new StringBuilder(20);
        sb3.append(unit);
        sb3.append(" must be");
        if (this.exact != -1L) {
            sb3.append(" exactly ");
            sb3.append(Long.toString(this.exact));
            return sb3.toString();
        }
        boolean continued = true;
        if (this.min != Long.MIN_VALUE && this.max != Long.MAX_VALUE) {
            sb3.append(" at least ");
            sb3.append(Long.toString(this.min));
            sb3.append(" and at most ");
            sb3.append(Long.toString(this.max));
        } else if (this.min != Long.MIN_VALUE) {
            sb3.append(" at least ");
            sb3.append(Long.toString(this.min));
        } else if (this.max != Long.MAX_VALUE) {
            sb3.append(" at most ");
            sb3.append(Long.toString(this.max));
        } else {
            continued = false;
        }
        if (this.multiple != 1L) {
            if (continued) {
                sb3.append(" and");
            }
            sb3.append(" a multiple of ");
            sb3.append(Long.toString(this.multiple));
        }
        if (actualValue != null) {
            sb3.append(" (was ").append(actualValue).append(')');
        }
        return sb3.toString();
    }

    @Override
    public Boolean contains(RangeConstraint other) {
        if (other instanceof SizeConstraint) {
            SizeConstraint otherRange = (SizeConstraint)other;
            if (this.exact != -1L && otherRange.exact != -1L) {
                return this.exact == otherRange.exact;
            }
            if (this.multiple != 1L && (otherRange.exact != -1L ? otherRange.exact % this.multiple != 0L : otherRange.multiple % this.multiple != 0L)) {
                return false;
            }
            if (otherRange.exact != -1L) {
                return otherRange.exact >= this.min && otherRange.exact <= this.max;
            }
            return otherRange.min >= this.min && otherRange.max <= this.max;
        }
        return null;
    }
}

