/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.repository.GradleVersion;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelVariant;
import java.util.ArrayDeque;
import java.util.Locale;
import java.util.function.Predicate;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class VectorDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("VectorRaster", "Vector Image Generation", "Vector icons require API 21 or API 24 depending on used features, but when `minSdkVersion` is less than 21 or 24 and Android Gradle plugin 1.4 or higher is used, a vector drawable placed in the `drawable` folder is automatically moved to `drawable-anydpi-v21` or `drawable-anydpi-v24` and bitmap images are generated for different screen resolutions for backwards compatibility.\n\nHowever, there are some limitations to this raster image generation, and this lint check flags elements and attributes that are not fully supported. You should manually check whether the generated output is acceptable for those older devices.", Category.CORRECTNESS, 5, Severity.WARNING, new Implementation(VectorDetector.class, Scope.RESOURCE_FILE_SCOPE));
    private static final String KEY_CONTAINS_GRADIENT = "containsGradient";
    private static final String KEY_CONTAINS_FILL_TYPE = "containsFillType";
    private static final String KEY_FOLDER_VERSION = "folderVersion";
    private static final String KEY_MESSAGE = "message";

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        return folderType == ResourceFolderType.DRAWABLE;
    }

    public static boolean isVectorGenerationSupported(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(1, 4, 0);
    }

    public static boolean isVectorGenerationSupportedForGradient(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(3, 1, 0);
    }

    public static boolean isVectorGenerationSupportedForFillType(Project project) {
        GradleVersion modelVersion = project.getGradleModelVersion();
        return modelVersion != null && modelVersion.isAtLeastIncludingPreviews(3, 2, 0);
    }

    @Override
    public void visitDocument(XmlContext context2, Document document) {
        VectorDetector.checkSize(context2, document);
        Element root = document.getDocumentElement();
        if (root == null || !root.getTagName().equals("vector")) {
            return;
        }
        int apiThreshold = 24;
        if (context2.getFolderVersion() >= apiThreshold) {
            return;
        }
        this.checkSupported(context2, root);
    }

    private void reportConditional(XmlContext context2, Node node, Location location, String formatString) {
        Incident incident = new Incident(ISSUE, node, location, "");
        Document document = context2.document;
        boolean containsGradient = VectorDetector.containsGradient(document);
        LintMap map = this.map().put(KEY_MESSAGE, formatString).put(KEY_CONTAINS_GRADIENT, containsGradient).put(KEY_CONTAINS_FILL_TYPE, !containsGradient && VectorDetector.containsFillType(document)).put(KEY_FOLDER_VERSION, context2.getFolderVersion());
        context2.report(incident, map);
    }

    @Override
    public boolean filterIncident(Context context2, Incident incident, LintMap map) {
        boolean generationDueToGradient;
        int apiThreshold = 24;
        Project project = context2.getMainProject();
        if (project.getMinSdkVersion().getFeatureLevel() >= apiThreshold) {
            return false;
        }
        if (!project.isGradleProject()) {
            return false;
        }
        if (!VectorDetector.isVectorGenerationSupported(project)) {
            return false;
        }
        if (VectorDetector.usingSupportLibVectors(project)) {
            return false;
        }
        boolean bl2 = generationDueToGradient = map.getBoolean(KEY_CONTAINS_GRADIENT, false) != false && VectorDetector.isVectorGenerationSupportedForGradient(project);
        if (!generationDueToGradient) {
            boolean generationDueToFillType;
            boolean bl3 = generationDueToFillType = map.getBoolean(KEY_CONTAINS_FILL_TYPE, false) != false && VectorDetector.isVectorGenerationSupportedForFillType(project);
            if (!generationDueToFillType) {
                apiThreshold = 21;
                if (project.getMinSdkVersion().getFeatureLevel() >= apiThreshold) {
                    return false;
                }
                if (map.getInt(KEY_FOLDER_VERSION, -1) >= apiThreshold) {
                    return false;
                }
            }
        }
        String format = map.getString(KEY_MESSAGE, "");
        String message2 = String.format(Locale.US, format, apiThreshold);
        incident.setMessage(message2);
        return true;
    }

    private static void checkSize(XmlContext context2, Document document) {
        Element root = document.getDocumentElement();
        if (root == null) {
            return;
        }
        Attr widthAttribute = root.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "width");
        Attr heightAttribute = root.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "height");
        if (widthAttribute == null || heightAttribute == null) {
            return;
        }
        try {
            Attr wrong;
            int width = VectorDetector.getDipSize(widthAttribute);
            int height = VectorDetector.getDipSize(heightAttribute);
            if (width > 200) {
                wrong = widthAttribute;
            } else if (height > 200) {
                wrong = heightAttribute;
            } else {
                return;
            }
            context2.report(ISSUE, wrong, context2.getValueLocation(wrong), "Limit vector icons sizes to 200\u00d7200 to keep icon drawing fast; see https://developer.android.com/studio/write/vector-asset-studio#when for more");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static int getDipSize(Attr attribute) {
        String s10 = attribute.getValue();
        if (s10.isEmpty() || !Character.isDigit(s10.charAt(0))) {
            return -1;
        }
        if (s10.endsWith("dp")) {
            s10 = s10.substring(0, s10.length() - "dp".length());
        } else if (s10.endsWith("dip")) {
            s10 = s10.substring(0, s10.length() - "dip".length());
        } else {
            return -1;
        }
        try {
            return Integer.parseInt(s10);
        }
        catch (NumberFormatException ignore) {
            return -1;
        }
    }

    private static boolean containsGradient(Document document) {
        return VectorDetector.findElement(document, element -> "gradient".equals(element.getTagName())) != null;
    }

    private static boolean containsFillType(Document document) {
        return VectorDetector.findElement(document, element -> element.hasAttributeNS("http://schemas.android.com/apk/res/android", "fillType")) != null;
    }

    private static Element findElement(Document document, Predicate<Element> predicate) {
        Element element;
        ArrayDeque<Element> elements = new ArrayDeque<Element>();
        elements.add(document.getDocumentElement());
        while ((element = (Element)elements.poll()) != null) {
            if (predicate.test(element)) {
                return element;
            }
            NodeList children = element.getChildNodes();
            int n10 = children.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                Node child = children.item(i10);
                if (child.getNodeType() != 1) continue;
                elements.add((Element)child);
            }
        }
        return null;
    }

    static boolean usingSupportLibVectors(Project project) {
        GradleVersion version = project.getGradleModelVersion();
        if (version == null || version.getMajor() < 2) {
            return false;
        }
        LintModelVariant variant = project.getBuildVariant();
        return variant != null && variant.getUseSupportLibraryVectorDrawables();
    }

    private void checkSupported(XmlContext context2, Element element) {
        String tag = element.getTagName();
        if ("clip-path".equals(tag)) {
            String message2 = "This tag is not supported in images generated from this vector icon for API < %1$d; check generated icon to make sure it looks acceptable";
            this.reportConditional(context2, element, context2.getLocation(element), message2);
        }
        NamedNodeMap attributes = element.getAttributes();
        int n10 = attributes.getLength();
        for (int i10 = 0; i10 < n10; ++i10) {
            String value;
            Attr attr = (Attr)attributes.item(i10);
            String name = attr.getLocalName();
            if (("autoMirrored".equals(name) || "trimPathStart".equals(name) || "trimPathEnd".equals(name) || "trimPathOffset".equals(name)) && "http://schemas.android.com/apk/res/android".equals(attr.getNamespaceURI())) {
                String message3 = "This attribute is not supported in images generated from this vector icon for API < %1$d; check generated icon to make sure it looks acceptable";
                this.reportConditional(context2, attr, context2.getNameLocation(attr), message3);
            }
            if (ResourceUrl.parse((String)(value = attr.getValue())) == null) continue;
            String message4 = "Resource references will not work correctly in images generated for this vector icon for API < %1$d; check generated icon to make sure it looks acceptable";
            this.reportConditional(context2, attr, context2.getValueLocation(attr), message4);
        }
        NodeList children = element.getChildNodes();
        int n11 = children.getLength();
        for (int i11 = 0; i11 < n11; ++i11) {
            Node child = children.item(i11);
            if (child.getNodeType() != 1) continue;
            this.checkSupported(context2, (Element)child);
        }
    }
}

