/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import org.w3c.dom.Attr;

public class VectorDrawableCompatDetector
extends ResourceXmlDetector {
    public static final Issue ISSUE = Issue.create("VectorDrawableCompat", "Using VectorDrawableCompat", "To use VectorDrawableCompat, you need to make two modifications to your project. First, set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in your `build.gradle` file, and second, use `app:srcCompat` instead of `android:src` to refer to vector drawables.", Category.CORRECTNESS, 5, Severity.ERROR, new Implementation(VectorDrawableCompatDetector.class, Scope.ALL_RESOURCES_SCOPE, Scope.RESOURCE_FILE_SCOPE)).addMoreInfo("https://developer.android.com/guide/topics/graphics/vector-drawable-resources").addMoreInfo("https://medium.com/androiddevelopers/using-vector-assets-in-android-apps-4318fd662eb9").setEnabledByDefault(false);
    private boolean mSkipChecks;
    private boolean mUseSupportLibrary;

    @Override
    public void beforeCheckRootProject(Context context2) {
        LintModelVariant variant = context2.getProject().getBuildVariant();
        if (variant == null) {
            this.mSkipChecks = true;
            return;
        }
        if (context2.getProject().getMinSdk() >= 21) {
            this.mSkipChecks = true;
            return;
        }
        GradleVersion version = context2.getProject().getGradleModelVersion();
        if (version == null || version.getMajor() < 2) {
            this.mSkipChecks = true;
            return;
        }
        this.mUseSupportLibrary = variant.getUseSupportLibraryVectorDrawables();
    }

    @Override
    public boolean appliesTo(ResourceFolderType folderType) {
        if (this.mSkipChecks) {
            return false;
        }
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.LAYOUT;
    }

    @Override
    public Collection<String> getApplicableAttributes() {
        return this.mSkipChecks ? null : ImmutableList.of((Object)"src", (Object)"srcCompat");
    }

    @Override
    public void visitAttribute(XmlContext context2, Attr attribute) {
        Location location;
        if (this.mSkipChecks) {
            return;
        }
        LintClient client = context2.getClient();
        boolean full = context2.isGlobalAnalysis();
        Project project = full ? context2.getMainProject() : context2.getProject();
        ResourceRepository resources = client.getResources(project, ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        Predicate<String> isVector = name -> VectorDrawableCompatDetector.checkResourceRepository(resources, name);
        String name2 = attribute.getLocalName();
        String namespace = attribute.getNamespaceURI();
        if ("src".equals(name2) && !"http://schemas.android.com/apk/res/android".equals(namespace) || "srcCompat".equals(name2) && !"http://schemas.android.com/apk/res-auto".equals(namespace)) {
            return;
        }
        ResourceUrl resourceUrl = ResourceUrl.parse((String)attribute.getValue());
        if (resourceUrl == null) {
            return;
        }
        if (this.mUseSupportLibrary && "src".equals(name2) && isVector.test(resourceUrl.name)) {
            location = context2.getNameLocation(attribute);
            String message2 = "When using VectorDrawableCompat, you need to use `app:srcCompat`";
            context2.report(ISSUE, attribute, location, message2);
        }
        if (!this.mUseSupportLibrary && "srcCompat".equals(name2) && isVector.test(resourceUrl.name)) {
            location = context2.getNameLocation(attribute);
            String path2 = "build.gradle";
            LintModelModule model = context2.getProject().getBuildModule();
            if (model != null) {
                path2 = model.getModulePath() + File.separator + path2;
            }
            String message3 = "To use VectorDrawableCompat, you need to set `android.defaultConfig.vectorDrawables.useSupportLibrary = true` in `" + path2 + "`";
            context2.report(ISSUE, attribute, location, message3);
        }
    }

    private static boolean checkResourceRepository(ResourceRepository resources, String name) {
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.DRAWABLE, name);
        for (ResourceItem item : items) {
            PathString source = item.getSource();
            if (source == null) {
                return false;
            }
            File file = source.toFile();
            if (file == null) {
                return false;
            }
            if (!source.getFileName().endsWith(".xml")) continue;
            String rootTagName = XmlUtils.getRootTagName((File)file);
            return "vector".equals(rootTagName) || "animated-vector".equals(rootTagName);
        }
        return false;
    }
}

