/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.Vendor;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\r\b'\u0018\u0000 :2\u00020\u0001:\u0001:B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J\b\u0010\"\u001a\u00020\u0012H\u0014J\u000e\u0010#\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J[\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\b2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020,0\u001c2\u001a\u0010-\u001a\u0016\u0012\u0004\u0012\u00020\u001d\u0012\n\u0012\b\u0012\u0004\u0012\u00020%0.\u0018\u00010\u001bH\u0000\u00a2\u0006\u0002\b/J\u0014\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\f\u00101\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0014\u00102\u001a\b\u0012\u0004\u0012\u00020\u000b0\b2\u0006\u00103\u001a\u00020\u000bJ\u0010\u00104\u001a\u0004\u0018\u00010\u00102\u0006\u00103\u001a\u00020\u000bJ\u0016\u00105\u001a\u00020\u00042\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u001c\u00106\u001a\b\u0012\u0004\u0012\u00020\u00100\b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cH\u0014J\u000e\u00107\u001a\u00020\u00122\u0006\u00108\u001a\u00020\u000bJ\u000e\u00109\u001a\u00020\u00122\u0006\u00103\u001a\u00020\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0013R\u0018\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00100\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\rR\u0014\u0010\u0016\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0014\u0010\u0018\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006R&\u0010\u001a\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\b0\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006;"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry;", "", "()V", "api", "", "getApi", "()I", "categories", "", "Lcom/android/tools/lint/detector/api/Category;", "deletedIssues", "", "getDeletedIssues", "()Ljava/util/List;", "idToIssue", "", "Lcom/android/tools/lint/detector/api/Issue;", "isUpToDate", "", "()Z", "issues", "getIssues", "maxApi", "getMaxApi", "minApi", "getMinApi", "scopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "vendor", "Lcom/android/tools/lint/client/api/Vendor;", "getVendor", "()Lcom/android/tools/lint/client/api/Vendor;", "cacheable", "createCategoryList", "createDetectors", "Lcom/android/tools/lint/detector/api/Detector;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "configuration", "Lcom/android/tools/lint/client/api/Configuration;", "scope", "platforms", "Lcom/android/tools/lint/detector/api/Platform;", "scopeToDetectors", "", "createDetectors$android_sdktools_lint_api", "createIdToIssueMap", "getCategories", "getIdSpellingSuggestions", "id", "getIssue", "getIssueCapacity", "getIssuesForScope", "isCategoryName", "name", "isIssueId", "Companion", "android.sdktools.lint-api"})
@Beta
public abstract class IssueRegistry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Vendor vendor;
    private final int api;
    @NotNull
    private final List<String> deletedIssues;
    private final boolean isUpToDate;
    @Nullable
    private volatile List<Category> categories;
    @Nullable
    private volatile Map<String, Issue> idToIssue;
    @NotNull
    private Map<EnumSet<Scope>, List<Issue>> scopeIssues;
    @Nullable
    private static volatile List<Category> cachedCategories;
    @Nullable
    private static volatile Map<String, Issue> cachedIdToIssue;
    @NotNull
    private static Map<EnumSet<Scope>, List<Issue>> cachedScopeIssues;
    @NotNull
    private static final Implementation EMPTY_IMPLEMENTATION;
    @NotNull
    private static Set<String> deletedIds;
    @NotNull
    private static Map<String, String> renamedIds;
    @JvmField
    @NotNull
    public static final Issue PARSER_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_ERROR;
    @JvmField
    @NotNull
    public static final Issue LINT_WARNING;
    @JvmField
    @NotNull
    public static final Issue UNKNOWN_ISSUE_ID;
    @JvmField
    @NotNull
    public static final Issue CANNOT_ENABLE_HIDDEN;
    @JvmField
    @NotNull
    public static final Issue BASELINE;
    @JvmField
    @NotNull
    public static final Issue OBSOLETE_LINT_CHECK;
    @NotNull
    private static final Vendor AOSP_VENDOR;

    protected IssueRegistry() {
        LintClient.Companion.ensureClientNameInitialized();
        this.api = -1;
        this.deletedIssues = CollectionsKt.emptyList();
        this.isUpToDate = true;
        if (this.cacheable()) {
            this.scopeIssues = cachedScopeIssues;
            this.idToIssue = cachedIdToIssue;
            this.categories = cachedCategories;
        } else {
            HashMap hashMap = Maps.newHashMap();
            Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"newHashMap()");
            this.scopeIssues = hashMap;
            this.idToIssue = null;
            this.categories = null;
        }
    }

    @Nullable
    public Vendor getVendor() {
        return this.vendor;
    }

    public int getApi() {
        return this.api;
    }

    public int getMinApi() {
        return this.getApi();
    }

    public int getMaxApi() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public abstract List<Issue> getIssues();

    @NotNull
    public List<String> getDeletedIssues() {
        return this.deletedIssues;
    }

    public boolean isUpToDate() {
        return this.isUpToDate;
    }

    protected int getIssueCapacity(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        return 20;
    }

    @NotNull
    protected List<Issue> getIssuesForScope(@NotNull EnumSet<Scope> scope) {
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        List list2 = this.scopeIssues.get(scope);
        if (list2 == null) {
            List<Issue> issues = this.getIssues();
            if (Intrinsics.areEqual(scope, Scope.ALL)) {
                list2 = issues;
            } else {
                list2 = new ArrayList(this.getIssueCapacity(scope));
                for (Issue issue : issues) {
                    if (!issue.getImplementation().isAdequate(scope)) continue;
                    ((ArrayList)list2).add(issue);
                }
            }
            Map<EnumSet<Scope>, List<Issue>> map = this.scopeIssues;
            boolean bl2 = false;
            map.put(scope, list2);
        }
        return list2;
    }

    @NotNull
    public final List<Detector> createDetectors$android_sdktools_lint_api(@NotNull LintClient client, @NotNull Configuration configuration, @NotNull EnumSet<Scope> scope, @NotNull EnumSet<Platform> platforms, @Nullable Map<Scope, List<Detector>> scopeToDetectors) {
        Object string;
        Iterator iterator;
        Object[] objectArray;
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        Intrinsics.checkParameterIsNotNull(scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull(platforms, (String)"platforms");
        List<Issue> issues = this.getIssuesForScope(scope);
        if (issues.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        HashSet<Object[]> detectorClasses = new HashSet<Object[]>();
        HashMap detectorToScope = new HashMap();
        for (Issue issue : issues) {
            boolean bl2;
            if (!issue.getPlatforms().isEmpty() && !issue.getPlatforms().containsAll((Collection)platforms)) continue;
            Implementation implementation = issue.getImplementation();
            objectArray = implementation.getDetectorClass();
            Intrinsics.checkExpressionValueIsNotNull(objectArray, (String)"implementation.detectorClass");
            Object[] detectorClass = objectArray;
            iterator = implementation.getScope();
            Intrinsics.checkExpressionValueIsNotNull(iterator, (String)"implementation.scope");
            EnumSet<Scope> issueScope = iterator;
            if (!detectorClasses.contains(detectorClass)) {
                if (!configuration.isEnabled(issue)) continue;
                boolean bl3 = implementation.isAdequate(scope);
                boolean bl4 = false;
                bl2 = false;
                if (_Assertions.ENABLED && !bl3) {
                    boolean bl5 = false;
                    String string2 = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string2));
                }
                detectorClasses.add(detectorClass);
            }
            if (scopeToDetectors == null) continue;
            EnumSet s10 = (EnumSet)detectorToScope.get(detectorClass);
            if (s10 == null) {
                Map map = detectorToScope;
                bl2 = false;
                map.put(detectorClass, issueScope);
                continue;
            }
            if (s10.containsAll((Collection)issueScope)) continue;
            EnumSet union = EnumSet.copyOf(s10);
            union.addAll(issueScope);
            Map map = detectorToScope;
            Intrinsics.checkExpressionValueIsNotNull(union, (String)"union");
            string = union;
            boolean bl6 = false;
            map.put(detectorClass, string);
        }
        ArrayList<Detector> detectors = new ArrayList<Detector>(detectorClasses.size());
        for (Class clazz : detectorClasses) {
            try {
                EnumSet union;
                Detector detector = (Detector)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                detectors.add(detector);
                if (scopeToDetectors == null || (union = (EnumSet)detectorToScope.get(clazz)) == null) continue;
                Iterator union2 = iterator = union;
                iterator = ((AbstractCollection)((Object)union2)).iterator();
                while (iterator.hasNext()) {
                    Scope s11 = (Scope)((Object)iterator.next());
                    List list2 = scopeToDetectors.get((Object)s11);
                    if (list2 == null) {
                        list2 = new ArrayList();
                        string = scopeToDetectors;
                        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)s11), (String)"s");
                        Scope scope2 = s11;
                        boolean bl7 = false;
                        string.put(scope2, list2);
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)detector, (String)"detector");
                    list2.add(detector);
                }
            }
            catch (Throwable t10) {
                objectArray = new Object[1];
                iterator = clazz.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)iterator, (String)"clz.name");
                objectArray[0] = iterator;
                client.log(t10, "Can't initialize detector %1$s", objectArray);
            }
        }
        return detectors;
    }

    public final boolean isIssueId(@NotNull String id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        return this.getIssue(id2) != null;
    }

    public final boolean isCategoryName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        return Category.Companion.getCategory(name) != null;
    }

    @NotNull
    public final List<Category> getCategories() {
        List<Category> categories = this.categories;
        if (categories == null) {
            this.categories = categories = Collections.unmodifiableList(this.createCategoryList());
            if (this.cacheable()) {
                cachedCategories = categories;
            }
        }
        List<Category> list2 = categories;
        if (list2 == null) {
            Intrinsics.throwNpe();
        }
        return list2;
    }

    private final List<Category> createCategoryList() {
        HashSet categorySet = Sets.newHashSetWithExpectedSize((int)20);
        for (Issue issue : this.getIssues()) {
            Category element = issue.getCategory();
            categorySet.add(element);
            for (Category parent = element.getParent(); parent != null; parent = parent.getParent()) {
                categorySet.add(parent);
            }
        }
        ArrayList sorted = new ArrayList(categorySet);
        CollectionsKt.sort((List)sorted);
        return sorted;
    }

    @Nullable
    public final Issue getIssue(@NotNull String id2) {
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        Map<String, Issue> map = this.idToIssue;
        if (map == null) {
            this.idToIssue = map = this.createIdToIssueMap();
            if (this.cacheable()) {
                cachedIdToIssue = map;
            }
        }
        return map.get(id2);
    }

    @NotNull
    public final List<String> getIdSpellingSuggestions(@NotNull String id2) {
        String matchWith;
        Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
        int maxDistance = id2.length() >= 4 ? 2 : 1;
        boolean bl2 = false;
        Set matches = new LinkedHashSet();
        for (Issue issue : this.getIssues()) {
            matchWith = issue.getId();
            int distance = Lint.editDistance(id2, matchWith, maxDistance);
            if (distance <= maxDistance) {
                matches.add(matchWith);
            }
            if (!StringsKt.equals((String)matchWith, (String)id2, (boolean)true)) continue;
            matches.add(matchWith);
        }
        if (matches.isEmpty()) {
            for (Issue issue : this.getIssues()) {
                matchWith = issue.getId();
                if (!StringsKt.contains$default((CharSequence)matchWith, (CharSequence)id2, (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)id2, (CharSequence)matchWith, (boolean)false, (int)2, null)) continue;
                matches.add(matchWith);
            }
        }
        if (matches.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        return SequencesKt.toList((Sequence)SequencesKt.sorted((Sequence)CollectionsKt.asSequence((Iterable)matches)));
    }

    private final Map<String, Issue> createIdToIssueMap() {
        Object object;
        List<Issue> issues = this.getIssues();
        HashMap map = Maps.newHashMapWithExpectedSize((int)(issues.size() + 20));
        for (Issue issue : issues) {
            Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"map");
            object = map;
            String string = issue.getId();
            boolean bl2 = false;
            object.put(string, issue);
            object = issue.getAliases();
            if (object == null) continue;
            Iterable $this$forEach$iv = (Iterable)object;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String alias = (String)element$iv;
                boolean bl3 = false;
                Map<String, String> map2 = map;
                boolean bl4 = false;
                map2.put(alias, (String)((Object)issue));
                map2 = renamedIds;
                String string2 = issue.getId();
                boolean bl5 = false;
                map2.put(alias, string2);
            }
        }
        for (String id2 : this.getDeletedIssues()) {
            deletedIds.add(id2);
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)map, (String)"map");
        Object object2 = map;
        String string = PARSER_ERROR.getId();
        object = PARSER_ERROR;
        boolean bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = LINT_ERROR.getId();
        object = LINT_ERROR;
        bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = LINT_WARNING.getId();
        object = LINT_WARNING;
        bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = BASELINE.getId();
        object = BASELINE;
        bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = UNKNOWN_ISSUE_ID.getId();
        object = UNKNOWN_ISSUE_ID;
        bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = CANNOT_ENABLE_HIDDEN.getId();
        object = CANNOT_ENABLE_HIDDEN;
        bl6 = false;
        object2.put(string, object);
        object2 = map;
        string = OBSOLETE_LINT_CHECK.getId();
        object = OBSOLETE_LINT_CHECK;
        bl6 = false;
        object2.put(string, object);
        return map;
    }

    protected boolean cacheable() {
        return false;
    }

    static {
        HashMap hashMap = Maps.newHashMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"newHashMap()");
        cachedScopeIssues = hashMap;
        EMPTY_IMPLEMENTATION = new Implementation(Detector.class, EnumSet.noneOf(Scope.class));
        boolean bl2 = false;
        deletedIds = new LinkedHashSet();
        bl2 = false;
        renamedIds = new LinkedHashMap();
        PARSER_ERROR = Issue.Companion.create("ParserError", "Parser Errors", "\n                Lint will ignore any files that contain fatal parsing errors. These may \\\n                contain other errors, or contain code which affects issues in other files.", Category.LINT, 10, Severity.ERROR, EMPTY_IMPLEMENTATION);
        LINT_ERROR = Issue.Companion.create("LintError", "Lint Failure", "\n                This issue type represents a problem running lint itself. Examples include \\\n                failure to find bytecode for source files (which means certain detectors \\\n                could not be run), parsing errors in lint configuration files, etc.\n\n                These errors are not errors in your own code, but they are shown to make it \\\n                clear that some checks were not completed.\n                ", Category.LINT, 10, Severity.ERROR, EMPTY_IMPLEMENTATION);
        LINT_WARNING = Issue.Companion.create("LintWarning", "Lint Failure", "\n                This issue type represents a problem running lint itself. Examples include \\\n                unsupported tags in configuration files, etc.\n\n                These errors are not errors in your own code, but they are shown to make it \\\n                clear that some checks were not completed.\n                ", Category.LINT, 5, Severity.WARNING, EMPTY_IMPLEMENTATION);
        UNKNOWN_ISSUE_ID = Issue.Companion.create("UnknownIssueId", "Unknown Lint Issue Id", "\n                Lint will report this issue if it is configured with an issue id it does \\\n                not recognize in for example Gradle files or `lint.xml` configuration files.\n                ", Category.LINT, 1, Severity.WARNING, EMPTY_IMPLEMENTATION);
        CANNOT_ENABLE_HIDDEN = Issue.Companion.create("CannotEnableHidden", "Issue Already Disabled", "\n                Any issues that are specifically disabled in a library cannot be re-enabled \\\n                in a dependent project. To fix this you need to also enable the issue in \\\n                the library project.\n\n                (This also applies for issues that are off by default; they cannot just be \\\n                enabled in a dependent project; they must also be enabled in all the \\\n                libraries the project depends on.)\n                ", Category.LINT, 1, Severity.WARNING, EMPTY_IMPLEMENTATION);
        BASELINE = Issue.Companion.create("LintBaseline", "Baseline Issues", "\n                Lint can be configured with a \"baseline\"; a set of current issues found \\\n                in a codebase, which future runs of lint will silently ignore. Only new \\\n                issues not found in the baseline are reported.\n\n                Note that while opening files in the IDE, baseline issues are not \\\n                filtered out; the purpose of baselines is to allow you to get started \\\n                using lint and break the build on all newly introduced errors, without \\\n                having to go back and fix the entire codebase up front. However, when \\\n                you open up existing files you still want to be aware of and fix issues \\\n                as you come across them.\n\n                This issue type is used to emit two types of informational messages in \\\n                reports: first, whether any issues were filtered out so you don't have \\\n                a false sense of security if you forgot that you've checked in a \\\n                baseline file, and second, whether any issues in the baseline file \\\n                appear to have been fixed such that you can stop filtering them out and \\\n                get warned if the issues are re-introduced.", Category.LINT, 10, Severity.INFORMATIONAL, EMPTY_IMPLEMENTATION);
        OBSOLETE_LINT_CHECK = Issue.Companion.create("ObsoleteLintCustomCheck", "Obsolete custom lint check", "\n                Lint can be extended with \"custom checks\": additional checks implemented \\\n                by developers and libraries to for example enforce specific API usages \\\n                required by a library or a company coding style guideline.\n\n                The Lint APIs are not yet stable, so these checks may either cause a \\\n                performance degradation, or stop working, or provide wrong results.\n\n                This warning flags custom lint checks that are found to be using obsolete \\\n                APIs and will need to be updated to run in the current lint environment.\n\n                It may also flag issues found to be using a **newer** version of the API, \\\n                meaning that you need to use a newer version of lint (or Android Studio \\\n                or Gradle plugin etc) to work with these checks.", Category.LINT, 10, Severity.WARNING, EMPTY_IMPLEMENTATION);
        AOSP_VENDOR = new Vendor("Android Open Source Project", null, "https://issuetracker.google.com/issues/new?component=192708", "https://groups.google.com/g/lint-dev", 2, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001f\u001a\u00020\u0016J\u000e\u0010 \u001a\u00020!2\u0006\u0010\u001f\u001a\u00020\u0016J\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010\u0017\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00120\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/android/tools/lint/client/api/IssueRegistry$Companion;", "", "()V", "AOSP_VENDOR", "Lcom/android/tools/lint/client/api/Vendor;", "getAOSP_VENDOR", "()Lcom/android/tools/lint/client/api/Vendor;", "BASELINE", "Lcom/android/tools/lint/detector/api/Issue;", "CANNOT_ENABLE_HIDDEN", "EMPTY_IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "LINT_ERROR", "LINT_WARNING", "OBSOLETE_LINT_CHECK", "PARSER_ERROR", "UNKNOWN_ISSUE_ID", "cachedCategories", "", "Lcom/android/tools/lint/detector/api/Category;", "cachedIdToIssue", "", "", "cachedScopeIssues", "", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Scope;", "deletedIds", "", "renamedIds", "getNewId", "id", "isDeletedIssueId", "", "reset", "", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isDeletedIssueId(@NotNull String id2) {
            Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
            return deletedIds.contains(id2);
        }

        @Nullable
        public final String getNewId(@NotNull String id2) {
            Intrinsics.checkParameterIsNotNull((Object)id2, (String)"id");
            return (String)renamedIds.get(id2);
        }

        @NotNull
        public final Vendor getAOSP_VENDOR() {
            return AOSP_VENDOR;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void reset() {
            Class<IssueRegistry> clazz = IssueRegistry.class;
            boolean bl2 = false;
            boolean bl3 = false;
            synchronized (clazz) {
                boolean bl4 = false;
                cachedIdToIssue = null;
                cachedCategories = null;
                HashMap hashMap = Maps.newHashMap();
                Intrinsics.checkExpressionValueIsNotNull((Object)hashMap, (String)"newHashMap()");
                cachedScopeIssues = hashMap;
                Unit unit = Unit.INSTANCE;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

