/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.client.api;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Beta
class ResourceVisitor {
    private final Map<String, List<XmlScanner>> elementToCheck = new HashMap<String, List<XmlScanner>>();
    private final Map<String, List<XmlScanner>> attributeToCheck = new HashMap<String, List<XmlScanner>>();
    private final List<XmlScanner> allElementDetectors = new ArrayList<XmlScanner>();
    private final List<XmlScanner> allAttributeDetectors = new ArrayList<XmlScanner>();
    private final List<XmlScanner> allDetectors;
    private final List<? extends Detector> binaryDetectors;
    private final LintClient client;

    ResourceVisitor(LintClient client, List<XmlScanner> allDetectors, List<Detector> binaryDetectors) {
        this.client = client;
        this.binaryDetectors = binaryDetectors;
        this.allDetectors = allDetectors;
        for (XmlScanner detector : allDetectors) {
            XmlScanner xmlDetector = detector;
            Collection<String> attributes = xmlDetector.getApplicableAttributes();
            if (attributes == XmlScanner.ALL) {
                this.allAttributeDetectors.add(xmlDetector);
            } else if (attributes != null) {
                for (String attribute : attributes) {
                    List<XmlScanner> list2 = this.attributeToCheck.get(attribute);
                    if (list2 == null) {
                        list2 = new ArrayList<XmlScanner>();
                        this.attributeToCheck.put(attribute, list2);
                    }
                    list2.add(xmlDetector);
                }
            }
            Collection<String> elements = xmlDetector.getApplicableElements();
            if (elements == XmlScanner.ALL) {
                this.allElementDetectors.add(xmlDetector);
                continue;
            }
            if (elements == null) continue;
            for (String element : elements) {
                List<XmlScanner> list3 = this.elementToCheck.get(element);
                if (list3 == null) {
                    list3 = new ArrayList<XmlScanner>();
                    this.elementToCheck.put(element, list3);
                }
                list3.add(xmlDetector);
            }
        }
    }

    void visitFile(XmlContext context2) {
        try {
            for (XmlScanner check : this.allDetectors) {
                check.beforeCheckFile(context2);
                check.visitDocument(context2, context2.document);
            }
            if (!(this.elementToCheck.isEmpty() && this.attributeToCheck.isEmpty() && this.allAttributeDetectors.isEmpty() && this.allElementDetectors.isEmpty())) {
                this.visitElement(context2, context2.document.getDocumentElement());
            }
            for (XmlScanner check : this.allDetectors) {
                check.afterCheckFile(context2);
            }
        }
        catch (RuntimeException e10) {
            LintDriver.handleDetectorError(context2, context2.getDriver(), e10);
        }
    }

    private void visitElement(XmlContext context2, Element element) {
        int n10;
        List<XmlScanner> elementChecks = this.elementToCheck.get(element.getLocalName());
        if (elementChecks != null) {
            assert (elementChecks instanceof RandomAccess);
            for (XmlScanner check : elementChecks) {
                check.visitElement(context2, element);
            }
        }
        if (!this.allElementDetectors.isEmpty()) {
            for (XmlScanner check : this.allElementDetectors) {
                check.visitElement(context2, element);
            }
        }
        if (!this.attributeToCheck.isEmpty() || !this.allAttributeDetectors.isEmpty()) {
            NamedNodeMap attributes = element.getAttributes();
            n10 = attributes.getLength();
            for (int i10 = 0; i10 < n10; ++i10) {
                List<XmlScanner> list2;
                Attr attribute = (Attr)attributes.item(i10);
                String name = attribute.getLocalName();
                if (name == null) {
                    name = attribute.getName();
                }
                if ((list2 = this.attributeToCheck.get(name)) != null) {
                    for (XmlScanner check : list2) {
                        check.visitAttribute(context2, attribute);
                    }
                }
                if (this.allAttributeDetectors.isEmpty()) continue;
                for (XmlScanner check : this.allAttributeDetectors) {
                    check.visitAttribute(context2, attribute);
                }
            }
        }
        NodeList childNodes = element.getChildNodes();
        n10 = childNodes.getLength();
        for (int i11 = 0; i11 < n10; ++i11) {
            Node child = childNodes.item(i11);
            if (child.getNodeType() != 1) continue;
            this.visitElement(context2, (Element)child);
        }
        if (elementChecks != null) {
            for (XmlScanner check : elementChecks) {
                check.visitElementAfter(context2, element);
            }
        }
        if (!this.allElementDetectors.isEmpty()) {
            for (XmlScanner check : this.allElementDetectors) {
                check.visitElementAfter(context2, element);
            }
        }
    }

    public void visitBinaryResource(ResourceContext context2) {
        if (this.binaryDetectors == null) {
            return;
        }
        for (Detector detector : this.binaryDetectors) {
            detector.beforeCheckFile(context2);
            detector.checkBinaryResource(context2);
            detector.afterCheckFile(context2);
        }
    }
}

