/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.detector.api.ApplicableVariants;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Position;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ComparisonChain;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.File;
import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.w3c.dom.Node;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\fB)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\rB'\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0010B1\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0011B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0012B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000f\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u0013J\u000e\u0010X\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u0011\u0010Y\u001a\u00020'2\u0006\u0010Z\u001a\u00020\u0000H\u0096\u0002J\u0013\u0010[\u001a\u00020S2\b\u0010Z\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0006\u0010\\\u001a\u00020\u0005J\b\u0010]\u001a\u00020'H\u0016J\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0006\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010^\u001a\u00020\u00002\u0006\u0010J\u001a\u00020KJ\u0010\u0010@\u001a\u00020\u00002\b\u0010@\u001a\u0004\u0018\u00010AJ\u0006\u0010_\u001a\u00020`J\u000e\u0010_\u001a\u00020`2\u0006\u0010 \u001a\u00020!J\u0010\u0010\u000e\u001a\u00020\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\b\u0010a\u001a\u00020\u0005H\u0016R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001c\u0010 \u001a\u0004\u0018\u00010!X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010)R\u0011\u0010*\u001a\u00020+8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010-R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u00103\"\u0004\b4\u00105R\u0011\u00106\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\b7\u0010)R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010=\"\u0004\b>\u0010?R\u001c\u0010@\u001a\u0004\u0018\u00010AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bF\u0010G\"\u0004\bH\u0010IR\u001a\u0010J\u001a\u00020KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u0011\u0010P\u001a\u00020'8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010)R\u001a\u0010R\u001a\u00020SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010W\u00a8\u0006b"}, d2={"Lcom/android/tools/lint/detector/api/Incident;", "", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "message", "", "location", "Lcom/android/tools/lint/detector/api/Location;", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;)V", "fix", "Lcom/android/tools/lint/detector/api/LintFix;", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;Lcom/android/tools/lint/detector/api/LintFix;)V", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "(Lcom/android/tools/lint/detector/api/Issue;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)V", "scope", "", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;Lcom/android/tools/lint/detector/api/LintFix;)V", "()V", "(Lcom/android/tools/lint/detector/api/Issue;Ljava/lang/String;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/Object;Lcom/android/tools/lint/detector/api/LintFix;)V", "applicableVariants", "Lcom/android/tools/lint/detector/api/ApplicableVariants;", "getApplicableVariants", "()Lcom/android/tools/lint/detector/api/ApplicableVariants;", "setApplicableVariants", "(Lcom/android/tools/lint/detector/api/ApplicableVariants;)V", "clientProperties", "Lcom/android/tools/lint/detector/api/LintMap;", "getClientProperties", "()Lcom/android/tools/lint/detector/api/LintMap;", "setClientProperties", "(Lcom/android/tools/lint/detector/api/LintMap;)V", "context", "Lcom/android/tools/lint/detector/api/Context;", "getContext$android_sdktools_lint_api", "()Lcom/android/tools/lint/detector/api/Context;", "setContext$android_sdktools_lint_api", "(Lcom/android/tools/lint/detector/api/Context;)V", "endOffset", "", "getEndOffset", "()I", "file", "Ljava/io/File;", "getFile", "()Ljava/io/File;", "getFix", "()Lcom/android/tools/lint/detector/api/LintFix;", "setFix", "(Lcom/android/tools/lint/detector/api/LintFix;)V", "getIssue", "()Lcom/android/tools/lint/detector/api/Issue;", "setIssue", "(Lcom/android/tools/lint/detector/api/Issue;)V", "line", "getLine", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "setLocation", "(Lcom/android/tools/lint/detector/api/Location;)V", "getMessage", "()Ljava/lang/String;", "setMessage", "(Ljava/lang/String;)V", "project", "Lcom/android/tools/lint/detector/api/Project;", "getProject", "()Lcom/android/tools/lint/detector/api/Project;", "setProject", "(Lcom/android/tools/lint/detector/api/Project;)V", "getScope", "()Ljava/lang/Object;", "setScope", "(Ljava/lang/Object;)V", "severity", "Lcom/android/tools/lint/detector/api/Severity;", "getSeverity", "()Lcom/android/tools/lint/detector/api/Severity;", "setSeverity", "(Lcom/android/tools/lint/detector/api/Severity;)V", "startOffset", "getStartOffset", "wasAutoFixed", "", "getWasAutoFixed", "()Z", "setWasAutoFixed", "(Z)V", "at", "compareTo", "other", "equals", "getDisplayPath", "hashCode", "overrideSeverity", "report", "", "toString", "android.sdktools.lint-api"})
public final class Incident
implements Comparable<Incident> {
    @NotNull
    private Issue issue;
    @NotNull
    private String message;
    @NotNull
    private Location location;
    @Nullable
    private Object scope;
    @Nullable
    private LintFix fix;
    @Nullable
    private Project project;
    @NotNull
    private Severity severity;
    private boolean wasAutoFixed;
    @Nullable
    private ApplicableVariants applicableVariants;
    @Nullable
    private LintMap clientProperties;
    @Nullable
    private transient Context context;

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location, @Nullable Object scope, @Nullable LintFix fix) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.issue = issue;
        this.message = message2;
        this.location = location;
        this.scope = scope;
        this.fix = fix;
        this.severity = this.issue.getDefaultSeverity();
    }

    public /* synthetic */ Incident(Issue issue, String string, Location location, Object object, LintFix lintFix, int n10, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n10 & 8) != 0) {
            object = location.getSource();
        }
        if ((n10 & 0x10) != 0) {
            lintFix = null;
        }
        this(issue, string, location, object, lintFix);
    }

    @NotNull
    public final Issue getIssue() {
        return this.issue;
    }

    public final void setIssue(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"<set-?>");
        this.issue = issue;
    }

    @NotNull
    public final String getMessage() {
        return this.message;
    }

    public final void setMessage(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.message = string;
    }

    @NotNull
    public final Location getLocation() {
        return this.location;
    }

    public final void setLocation(@NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"<set-?>");
        this.location = location;
    }

    @Nullable
    public final Object getScope() {
        return this.scope;
    }

    public final void setScope(@Nullable Object object) {
        this.scope = object;
    }

    @Nullable
    public final LintFix getFix() {
        return this.fix;
    }

    public final void setFix(@Nullable LintFix lintFix) {
        this.fix = lintFix;
    }

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this(issue, message2, location, (Object)null, null);
    }

    public Incident(@NotNull Issue issue, @NotNull String message2, @NotNull Location location, @Nullable LintFix fix) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this(issue, message2, location, (Object)null, fix);
    }

    public Incident(@NotNull Issue issue, @NotNull Location location, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this(issue, message2, location, (Object)null, null);
    }

    public Incident(@NotNull Issue issue, @NotNull Location location, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this(issue, message2, location, (Object)null, fix);
    }

    public Incident(@NotNull Issue issue, @NotNull Object scope, @NotNull Location location, @NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this(issue, message2, location, scope, null);
    }

    public Incident(@NotNull Issue issue, @NotNull Object scope, @NotNull Location location, @NotNull String message2, @Nullable LintFix fix) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this(issue, message2, location, scope, fix);
    }

    @Nullable
    public final Project getProject() {
        return this.project;
    }

    public final void setProject(@Nullable Project project) {
        this.project = project;
    }

    @NotNull
    public final String getDisplayPath() {
        Object object;
        String string;
        Object object2 = this.project;
        String string2 = string = object2 == null ? null : ((Project)object2).getDisplayPath(this.getFile());
        if (string == null) {
            object2 = this.getFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"file.path");
            object = object2;
        } else {
            object = string;
        }
        return object;
    }

    @NotNull
    public final File getFile() {
        return this.location.getFile();
    }

    public final int getLine() {
        int n10;
        Position position = this.location.getStart();
        return position == null ? -1 : (n10 = position.getLine());
    }

    public final int getStartOffset() {
        int n10;
        Position position = this.location.getStart();
        return position == null ? -1 : (n10 = position.getOffset());
    }

    public final int getEndOffset() {
        Position position = this.location.getEnd();
        Integer n10 = position == null ? null : Integer.valueOf(position.getOffset());
        return n10 == null ? this.getStartOffset() : n10.intValue();
    }

    @NotNull
    public final Severity getSeverity() {
        return this.severity;
    }

    public final void setSeverity(@NotNull Severity severity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"<set-?>");
        this.severity = severity;
    }

    public final boolean getWasAutoFixed() {
        return this.wasAutoFixed;
    }

    public final void setWasAutoFixed(boolean bl2) {
        this.wasAutoFixed = bl2;
    }

    @Nullable
    public final ApplicableVariants getApplicableVariants() {
        return this.applicableVariants;
    }

    public final void setApplicableVariants(@Nullable ApplicableVariants applicableVariants) {
        this.applicableVariants = applicableVariants;
    }

    @Nullable
    public final LintMap getClientProperties() {
        return this.clientProperties;
    }

    public final void setClientProperties(@Nullable LintMap lintMap) {
        this.clientProperties = lintMap;
    }

    @Nullable
    public final Context getContext$android_sdktools_lint_api() {
        return this.context;
    }

    public final void setContext$android_sdktools_lint_api(@Nullable Context context2) {
        this.context = context2;
    }

    public Incident() {
        this(IssueRegistry.LINT_ERROR, "<missing>", Location.NONE);
    }

    @NotNull
    public final Incident issue(@NotNull Issue issue) {
        Intrinsics.checkParameterIsNotNull((Object)issue, (String)"issue");
        if (Intrinsics.areEqual((Object)this.issue, (Object)IssueRegistry.LINT_ERROR)) {
            this.severity = issue.getDefaultSeverity();
        }
        this.issue = issue;
        return this;
    }

    @NotNull
    public final Incident message(@NotNull String message2) {
        Intrinsics.checkParameterIsNotNull((Object)message2, (String)"message");
        this.message = message2;
        return this;
    }

    @NotNull
    public final Incident location(@NotNull Location location) {
        Intrinsics.checkParameterIsNotNull((Object)location, (String)"location");
        this.location = location;
        return this;
    }

    @NotNull
    public final Incident overrideSeverity(@NotNull Severity severity) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)severity), (String)"severity");
        this.severity = severity;
        return this;
    }

    @NotNull
    public final Incident at(@NotNull Object scope) {
        Location location;
        Intrinsics.checkParameterIsNotNull((Object)scope, (String)"scope");
        Object object = this.context;
        if (object == null) {
            String string = "This method can only be used when the Incident(context) is used";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Context context2 = object;
        this.scope = scope;
        object = scope;
        if (object instanceof UElement) {
            JavaContext javaContext;
            JavaContext javaContext2 = javaContext = context2 instanceof JavaContext ? (JavaContext)context2 : null;
            if (javaContext == null) {
                String string = "Associated context must be a JavaContext";
                boolean bl3 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            JavaContext javaContext3 = javaContext;
            location = scope instanceof UClass || scope instanceof UMethod ? javaContext3.getNameLocation((UElement)scope) : javaContext3.getLocation((UElement)scope);
        } else if (object instanceof PsiElement) {
            JavaContext javaContext;
            JavaContext javaContext4 = javaContext = context2 instanceof JavaContext ? (JavaContext)context2 : null;
            if (javaContext == null) {
                String string = "Associated context must be a JavaContext";
                boolean bl4 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            JavaContext javaContext5 = javaContext;
            if (scope instanceof PsiClass || scope instanceof PsiMethod) {
                javaContext5.getNameLocation((PsiElement)scope);
            } else {
                javaContext5.getLocation((PsiElement)scope);
            }
            location = javaContext5.getLocation((PsiElement)scope);
        } else if (object instanceof Node) {
            XmlContext xmlContext;
            XmlContext xmlContext2 = xmlContext = context2 instanceof XmlContext ? (XmlContext)context2 : null;
            if (xmlContext == null) {
                String string = "Associated context must be a JavaContext";
                boolean bl5 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            XmlContext xmlContext3 = xmlContext;
            location = xmlContext3.getLocation((Node)scope);
        } else if (context2 instanceof GradleContext) {
            location = ((GradleContext)context2).getLocation(scope);
        } else {
            String string = "Could not compute a location for scope element " + scope + "; if necessary use one of the Context.getLocation methods";
            boolean bl6 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        this.location = location;
        return this;
    }

    @NotNull
    public final Incident scope(@Nullable Object scope) {
        this.scope = scope;
        return this;
    }

    @NotNull
    public final Incident project(@Nullable Project project) {
        this.project = project;
        return this;
    }

    @NotNull
    public final Incident fix(@Nullable LintFix fix) {
        this.fix = fix;
        return this;
    }

    public final void report(@NotNull Context context2) {
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        context2.report(this);
    }

    public final void report() {
        Context context2 = this.context;
        if (context2 == null) {
            String string = "This method can only be used when the Incident(context) is used";
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Context context3 = context2;
        context3.report(this);
    }

    @Override
    public int compareTo(@NotNull Incident other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        String fileName1 = this.getFile().getName();
        String fileName2 = other.getFile().getName();
        Position start1 = this.location.getStart();
        Position start2 = other.location.getStart();
        Position position = start1;
        Integer col1 = position == null ? null : Integer.valueOf(position.getColumn());
        Position position2 = start2;
        Integer col2 = position2 == null ? null : Integer.valueOf(position2.getColumn());
        Location secondary1 = this.location.getSecondary();
        Location secondary2 = other.location.getSecondary();
        Location location = secondary1;
        File secondFile1 = location == null ? null : location.getFile();
        Location location2 = secondary2;
        File secondFile2 = location2 == null ? null : location2.getFile();
        return ComparisonChain.start().compare((Comparable)this.issue.getCategory(), (Comparable)other.issue.getCategory()).compare((Object)this.issue.getPriority(), (Object)other.issue.getPriority(), Comparator.reverseOrder()).compare((Comparable)((Object)this.issue.getId()), (Comparable)((Object)other.issue.getId())).compare((Comparable)((Object)this.severity), (Comparable)((Object)other.severity)).compare((Object)fileName1, (Object)fileName2, Comparator.nullsLast(Comparator.naturalOrder())).compare(this.getLine(), other.getLine()).compare((Comparable)((Object)this.message), (Comparable)((Object)other.message)).compare((Object)this.getFile(), (Object)other.getFile(), Comparator.nullsLast(Comparator.naturalOrder())).compare((Object)col1, (Object)col2, Comparator.nullsLast(Comparator.naturalOrder())).compare((Object)secondFile1, (Object)secondFile2, Comparator.nullsLast(Comparator.naturalOrder())).result();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other == null || !Intrinsics.areEqual(this.getClass(), other.getClass()) ? false : this.compareTo((Incident)other) == 0;
    }

    public int hashCode() {
        int result2 = this.message.hashCode();
        result2 = 31 * result2 + this.getFile().hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        Project project = this.project;
        String string = project == null ? null : project.getDisplayPath(this.getFile());
        return "Incident(\n issue='" + this.issue + "',\n message='" + this.message + "',\n file=" + (string == null ? this.getFile() : string) + ",\n line=" + this.getLine() + "\n)";
    }
}

