/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.support.AndroidxNameUtils;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.LintModelModuleProject;
import com.android.tools.lint.detector.api.LintModelModuleProjectKt;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.model.LintModelAndroidArtifact;
import com.android.tools.lint.model.LintModelDependencies;
import com.android.tools.lint.model.LintModelDependency;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelModule;
import com.android.tools.lint.model.LintModelModuleLibrary;
import com.android.tools.lint.model.LintModelModuleType;
import com.android.tools.lint.model.LintModelSourceProvider;
import com.android.tools.lint.model.LintModelVariant;
import com.android.utils.XmlUtils;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\b\u0016\u0018\u0000 >2\u00020\u0001:\u0001>B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0001J\u0017\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u0010\u001f\u001a\u00020\fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010#\u001a\u00020\bH\u0016J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u0016\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00102\u0006\u0010(\u001a\u00020\u001aH\u0016J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\n\u0010/\u001a\u0004\u0018\u00010\u001cH\u0016J\u000e\u00100\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u00102\u001a\u00020.H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010H\u0016J\b\u00105\u001a\u00020\u001aH\u0016J\b\u00106\u001a\u00020\u0017H\u0014J\b\u00107\u001a\u00020\u001aH\u0016J\b\u00108\u001a\u00020\u001aH\u0016J\u0010\u00109\u001a\u00020\u00172\u0006\u0010:\u001a\u00020\u0005H\u0002J\u000e\u0010;\u001a\u00020\u00172\u0006\u0010<\u001a\u00020\u001aJ\b\u0010=\u001a\u00020\u001cH\u0016R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00110\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006?"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "Lcom/android/tools/lint/detector/api/Project;", "client", "Lcom/android/tools/lint/client/api/LintClient;", "dir", "Ljava/io/File;", "referenceDir", "variant", "Lcom/android/tools/lint/model/LintModelVariant;", "mergedManifest", "(Lcom/android/tools/lint/client/api/LintClient;Ljava/io/File;Ljava/io/File;Lcom/android/tools/lint/model/LintModelVariant;Ljava/io/File;)V", "model", "Lcom/android/tools/lint/model/LintModelModule;", "getModel", "()Lcom/android/tools/lint/model/LintModelModule;", "sourceProviders", "", "Lcom/android/tools/lint/model/LintModelSourceProvider;", "getSourceProviders", "()Ljava/util/List;", "testSourceProviders", "getTestSourceProviders", "addDirectLibrary", "", "project", "dependsOn", "", "artifact", "", "(Ljava/lang/String;)Ljava/lang/Boolean;", "getAssetFolders", "getBuildModule", "getBuildSdk", "", "getBuildTargetHash", "getBuildVariant", "getGeneratedResourceFolders", "getGeneratedSourceFolders", "getJavaClassFolders", "getJavaLibraries", "includeProvided", "getJavaSourceFolders", "getManifestFiles", "getMergedManifest", "Lorg/w3c/dom/Document;", "getMinSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "getPackage", "getProguardFiles", "getResourceFolders", "getTargetSdkVersion", "getTestLibraries", "getTestSourceFolders", "hasDynamicFeatures", "initialize", "isAndroidProject", "isLibrary", "readManifest", "manifest", "setExternalLibrary", "external", "toString", "Companion", "android.sdktools.lint-api"})
public class LintModelModuleProject
extends Project {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LintModelVariant variant;

    public LintModelModuleProject(@NotNull LintClient client, @NotNull File dir, @NotNull File referenceDir, @NotNull LintModelVariant variant, @Nullable File mergedManifest) {
        Intrinsics.checkParameterIsNotNull((Object)client, (String)"client");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        Intrinsics.checkParameterIsNotNull((Object)referenceDir, (String)"referenceDir");
        Intrinsics.checkParameterIsNotNull((Object)variant, (String)"variant");
        super(client, dir, referenceDir);
        this.variant = variant;
        this.gradleProject = true;
        this.mergeManifests = true;
        boolean bl2 = false;
        this.directLibraries = new ArrayList();
        File file = mergedManifest;
        if (file != null) {
            File file2 = file;
            boolean bl3 = false;
            boolean bl4 = false;
            File it2 = file2;
            boolean bl5 = false;
            this.readManifest(it2);
        }
        this.manifestMinSdk = this.variant.getMinSdkVersion();
        this.manifestTargetSdk = this.variant.getTargetSdkVersion();
    }

    private final LintModelModule getModel() {
        return this.variant.getModule();
    }

    @Override
    @NotNull
    public String toString() {
        String string = this.getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"getName()");
        return string;
    }

    public final void setExternalLibrary(boolean external) {
        this.externalLibrary = external;
    }

    public final void addDirectLibrary(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.directLibraries.add(project);
    }

    private final void readManifest(File manifest) {
        if (manifest.exists()) {
            try {
                Document document;
                String xml = FilesKt.readText$default((File)manifest, null, (int)1, null);
                Document document2 = document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
                if (document2 != null) {
                    Document document3 = document2;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    Document it2 = document3;
                    boolean bl4 = false;
                    this.readManifest(it2);
                }
            }
            catch (IOException e10) {
                Object[] objectArray = new Object[]{manifest};
                this.client.log(e10, "Could not read manifest %1$s", objectArray);
            }
        }
    }

    @Override
    protected void initialize() {
    }

    private final List<LintModelSourceProvider> getSourceProviders() {
        return this.variant.getSourceProviders();
    }

    private final List<LintModelSourceProvider> getTestSourceProviders() {
        return this.variant.getTestSourceProviders();
    }

    @Override
    @NotNull
    public LintModelModule getBuildModule() {
        return this.variant.getModule();
    }

    @Override
    @NotNull
    public LintModelVariant getBuildVariant() {
        return this.variant;
    }

    @Override
    public boolean isLibrary() {
        return this.getModel().getType() == LintModelModuleType.LIBRARY || this.getModel().getType() == LintModelModuleType.JAVA_LIBRARY;
    }

    @Override
    public boolean isAndroidProject() {
        return this.getType() != LintModelModuleType.JAVA_LIBRARY;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean hasDynamicFeatures() {
        if (this.getModel().getType() != LintModelModuleType.APP) return false;
        Collection<String> collection = this.getModel().getDynamicFeatures();
        boolean bl2 = false;
        if (collection.isEmpty()) return false;
        return true;
    }

    @Override
    @NotNull
    public List<File> getManifestFiles() {
        if (this.manifestFiles == null) {
            this.manifestFiles = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl2 = false;
                File manifestFile = provider.getManifestFile();
                if (!manifestFile.exists()) continue;
                this.manifestFiles.add(manifestFile);
            }
        }
        List list2 = this.manifestFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"manifestFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getProguardFiles() {
        if (this.proguardFiles == null) {
            this.proguardFiles = CollectionsKt.plus(this.variant.getProguardFiles(), (Iterable)this.variant.getConsumerProguardFiles());
        }
        List list2 = this.proguardFiles;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"proguardFiles");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getResourceFolders() {
        if (this.resourceFolders == null) {
            this.resourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl2 = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getResDirectories()), (Function1)getResourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl3 = false;
                    this.resourceFolders.add(it2);
                }
            }
        }
        List list2 = this.resourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"resourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedResourceFolders() {
        if (this.generatedResourceFolders == null) {
            this.generatedResourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.variant.getMainArtifact().getGeneratedResourceFolders()), (Function1)getGeneratedResourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedResourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"generatedResourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getAssetFolders() {
        if (this.assetFolders == null) {
            this.assetFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl2 = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getAssetsDirectories()), (Function1)getAssetFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl3 = false;
                    this.assetFolders.add(it2);
                }
            }
        }
        List list2 = this.assetFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"assetFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaSourceFolders() {
        if (this.javaSourceFolders == null) {
            this.javaSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl2 = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getJavaSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl3 = false;
                    this.javaSourceFolders.add(it2);
                }
            }
        }
        List list2 = this.javaSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"javaSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getGeneratedSourceFolders() {
        if (this.generatedSourceFolders == null) {
            LintModelAndroidArtifact artifact = this.variant.getMainArtifact();
            this.generatedSourceFolders = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)artifact.getGeneratedSourceFolders()), (Function1)getGeneratedSourceFolders.1.INSTANCE));
        }
        List list2 = this.generatedSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"generatedSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestSourceFolders() {
        if (this.testSourceFolders == null) {
            this.testSourceFolders = Lists.newArrayList();
            Iterable $this$forEach$iv = this.getTestSourceProviders();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LintModelSourceProvider provider = (LintModelSourceProvider)element$iv;
                boolean bl2 = false;
                Sequence $this$forEach$iv2 = SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)provider.getJavaDirectories()), (Function1)getTestSourceFolders.1.1.INSTANCE);
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    File it2 = (File)element$iv2;
                    boolean bl3 = false;
                    this.testSourceFolders.add(it2);
                }
            }
        }
        List list2 = this.testSourceFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testSourceFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaClassFolders() {
        if (this.javaClassFolders == null) {
            this.javaClassFolders = new ArrayList(3);
            LintModelAndroidArtifact mainArtifact = this.variant.getMainArtifact();
            for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                if (!outputClassFolder.exists()) continue;
                this.javaClassFolders.add(outputClassFolder);
            }
            if (this.javaClassFolders.isEmpty() && this.isLibrary()) {
                for (LintModelVariant variant : this.getModel().getVariants()) {
                    if (Intrinsics.areEqual((Object)variant, (Object)this.variant)) continue;
                    mainArtifact = variant.getMainArtifact();
                    boolean found = false;
                    for (File outputClassFolder : mainArtifact.getClassOutputs()) {
                        if (!outputClassFolder.exists()) continue;
                        this.javaClassFolders.add(outputClassFolder);
                        found = true;
                    }
                    if (!found) continue;
                }
            }
        }
        List list2 = this.javaClassFolders;
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"javaClassFolders");
        return list2;
    }

    @Override
    @NotNull
    public List<File> getJavaLibraries(boolean includeProvided) {
        List list2;
        if (includeProvided) {
            if (this.javaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List<LintModelDependency> direct = dependencies.getCompileDependencies().getRoots();
                this.javaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library2;
                    Object object = graphItem.findLibrary();
                    if (object == null || !((library2 = object) instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    object = this.javaLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"javaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, (List<File>)object, false);
                }
            }
            List list3 = this.javaLibraries;
            Intrinsics.checkExpressionValueIsNotNull((Object)list3, (String)"{\n            if (javaLi\u2026  javaLibraries\n        }");
            list2 = list3;
        } else {
            if (this.nonProvidedJavaLibraries == null) {
                LintModelDependencies dependencies = this.variant.getMainArtifact().getDependencies();
                List<LintModelDependency> direct = dependencies.getPackageDependencies().getRoots();
                this.nonProvidedJavaLibraries = Lists.newArrayListWithExpectedSize((int)direct.size());
                for (LintModelDependency graphItem : direct) {
                    LintModelLibrary library3;
                    Object object = graphItem.findLibrary();
                    if (object == null || !((library3 = object) instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library3;
                    object = this.nonProvidedJavaLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"nonProvidedJavaLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, (List<File>)object, true);
                }
            }
            List list4 = this.nonProvidedJavaLibraries;
            Intrinsics.checkExpressionValueIsNotNull((Object)list4, (String)"{\n            // Skip pr\u2026edJavaLibraries\n        }");
            list2 = list4;
        }
        return list2;
    }

    @Override
    @NotNull
    public List<File> getTestLibraries() {
        Object object;
        if (this.testLibraries == null) {
            List list2;
            Object artifact;
            boolean bl2;
            boolean bl3;
            Object object2;
            this.testLibraries = Lists.newArrayListWithExpectedSize((int)6);
            object = this.variant.getAndroidTestArtifact();
            if (object != null) {
                object2 = object;
                bl3 = false;
                bl2 = false;
                artifact = object2;
                boolean bl4 = false;
                for (LintModelLibrary library2 : artifact.getDependencies().getAll()) {
                    if (!(library2 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    list2 = this.testLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list2, false);
                }
            }
            object = this.variant.getTestArtifact();
            if (object != null) {
                object2 = object;
                bl3 = false;
                bl2 = false;
                artifact = object2;
                boolean bl5 = false;
                for (LintModelLibrary library2 : artifact.getDependencies().getAll()) {
                    if (!(library2 instanceof LintModelExternalLibrary)) continue;
                    LintModelExternalLibrary lintModelExternalLibrary = (LintModelExternalLibrary)library2;
                    list2 = this.testLibraries;
                    Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"testLibraries");
                    LintModelModuleProjectKt.addJars(lintModelExternalLibrary, list2, false);
                }
            }
        }
        object = this.testLibraries;
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"testLibraries");
        return object;
    }

    @Override
    @Nullable
    public String getPackage() {
        String packageName;
        if (this.pkg == null && (packageName = this.variant.getPackage()) != null) {
            return packageName;
        }
        return this.pkg;
    }

    @Override
    @NotNull
    public AndroidVersion getMinSdkVersion() {
        AndroidVersion androidVersion;
        AndroidVersion androidVersion2 = this.manifestMinSdk;
        if (androidVersion2 == null) {
            AndroidVersion minSdk;
            AndroidVersion androidVersion3;
            LintModelModuleProject lintModelModuleProject = this;
            boolean bl2 = false;
            boolean bl3 = false;
            LintModelModuleProject $this$getMinSdkVersion_u24lambda_u2d13 = lintModelModuleProject;
            boolean bl4 = false;
            AndroidVersion androidVersion4 = $this$getMinSdkVersion_u24lambda_u2d13.variant.getMinSdkVersion();
            if (androidVersion4 == null) {
                AndroidVersion androidVersion5 = super.getMinSdkVersion();
                Intrinsics.checkExpressionValueIsNotNull((Object)androidVersion5, (String)"super.getMinSdkVersion()");
                androidVersion3 = androidVersion5;
            } else {
                androidVersion3 = androidVersion4;
            }
            $this$getMinSdkVersion_u24lambda_u2d13.manifestMinSdk = minSdk = androidVersion3;
            androidVersion = minSdk;
        } else {
            androidVersion = androidVersion2;
        }
        return androidVersion;
    }

    @Override
    @NotNull
    public AndroidVersion getTargetSdkVersion() {
        AndroidVersion androidVersion;
        AndroidVersion androidVersion2 = this.manifestTargetSdk;
        if (androidVersion2 == null) {
            AndroidVersion targetSdk;
            LintModelModuleProject lintModelModuleProject = this;
            boolean bl2 = false;
            boolean bl3 = false;
            LintModelModuleProject $this$getTargetSdkVersion_u24lambda_u2d14 = lintModelModuleProject;
            boolean bl4 = false;
            AndroidVersion androidVersion3 = $this$getTargetSdkVersion_u24lambda_u2d14.variant.getTargetSdkVersion();
            $this$getTargetSdkVersion_u24lambda_u2d14.manifestTargetSdk = targetSdk = androidVersion3 == null ? $this$getTargetSdkVersion_u24lambda_u2d14.getMinSdkVersion() : androidVersion3;
            androidVersion = targetSdk;
        } else {
            androidVersion = androidVersion2;
        }
        return androidVersion;
    }

    @Override
    public int getBuildSdk() {
        if (this.buildSdk == -1) {
            String compileTarget = this.getModel().getCompileTarget();
            AndroidVersion version = AndroidTargetHash.getPlatformVersion((String)compileTarget);
            AndroidVersion androidVersion = version;
            Integer n10 = androidVersion == null ? null : Integer.valueOf(androidVersion.getFeatureLevel());
            this.buildSdk = n10 == null ? super.getBuildSdk() : n10.intValue();
        }
        return this.buildSdk;
    }

    @Override
    @Nullable
    public String getBuildTargetHash() {
        return this.getModel().getCompileTarget();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    @Nullable
    public Boolean dependsOn(@NotNull String artifact) {
        Boolean bl2;
        String id2;
        Intrinsics.checkParameterIsNotNull((Object)artifact, (String)"artifact");
        String string = id2 = AndroidxNameUtils.getCoordinateMapping((String)artifact);
        if (string != null) {
            int n10 = -1;
            switch (string.hashCode()) {
                case -724478284: {
                    if (!string.equals("androidx.legacy:legacy-support-v4")) break;
                    n10 = 1;
                    break;
                }
                case -1423327723: {
                    if (!string.equals("androidx.leanback:leanback")) break;
                    n10 = 2;
                    break;
                }
                case 1501090183: {
                    if (!string.equals("androidx.appcompat:appcompat")) break;
                    n10 = 3;
                    break;
                }
            }
            switch (n10) {
                case 1: {
                    if (this.supportLib == null) {
                        LintModelAndroidArtifact a10 = this.variant.getMainArtifact();
                        this.supportLib = a10.findCompileDependency("androidx.legacy:legacy-support-v4") != null || a10.findCompileDependency("com.android.support:support-v4") != null;
                    }
                    bl2 = this.supportLib;
                    return bl2;
                }
                case 3: {
                    if (this.appCompat == null) {
                        LintModelAndroidArtifact a11 = this.variant.getMainArtifact();
                        this.appCompat = a11.findCompileDependency("androidx.appcompat:appcompat") != null || a11.findCompileDependency("com.android.support:appcompat-v7") != null;
                    }
                    bl2 = this.appCompat;
                    return bl2;
                }
                case 2: {
                    if (this.leanback == null) {
                        LintModelAndroidArtifact a12 = this.variant.getMainArtifact();
                        this.leanback = a12.findCompileDependency("androidx.leanback:leanback") != null || a12.findCompileDependency("com.android.support:leanback-v17") != null;
                    }
                    bl2 = this.leanback;
                    return bl2;
                }
            }
        }
        bl2 = super.dependsOn(id2);
        return bl2;
    }

    @Override
    @Nullable
    public Document getMergedManifest() {
        Object object = this.variant.getMergedManifest();
        if (object == null) {
            return super.getMergedManifest();
        }
        File manifest = object;
        try {
            String string = Files.asCharSource((File)manifest, (Charset)Charsets.UTF_8).read();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"asCharSource(manifest, Charsets.UTF_8).read()");
            String xml = string;
            Document document = XmlUtils.parseDocumentSilently((String)xml, (boolean)true);
            if (document == null) {
                Object[] objectArray = new Object[]{manifest};
                this.client.log(null, "Could not read %1$s", objectArray);
                return null;
            }
            File manifestMergeReport = this.variant.getManifestMergeReport();
            File file = manifestMergeReport;
            if (file != null) {
                File file2 = file;
                boolean bl2 = false;
                boolean bl3 = false;
                File it2 = file2;
                boolean bl4 = false;
                this.client.resolveMergeManifestSources(document, it2);
            }
            object = document;
        }
        catch (IOException ioe) {
            Object[] objectArray = new Object[]{manifest};
            this.client.log(ioe, "Could not read %1$s", objectArray);
            object = null;
        }
        return object;
    }

    @JvmStatic
    @NotNull
    public static final List<LintModelModuleProject> resolveDependencies(@NotNull Collection<? extends LintModelModuleProject> projects, boolean reporting) {
        return Companion.resolveDependencies(projects, reporting);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/detector/api/LintModelModuleProject$Companion;", "", "()V", "resolveDependencies", "", "Lcom/android/tools/lint/detector/api/LintModelModuleProject;", "projects", "", "reporting", "", "android.sdktools.lint-api"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final List<LintModelModuleProject> resolveDependencies(@NotNull Collection<? extends LintModelModuleProject> projects, boolean reporting) {
            Intrinsics.checkParameterIsNotNull(projects, (String)"projects");
            Map projectMap = new HashMap();
            for (LintModelModuleProject lintModelModuleProject : projects) {
                LintModelModule lintModelModule = lintModelModuleProject.getModel();
                String modulePath = lintModelModule.getModulePath();
                boolean bl2 = projectMap.get(modulePath) == null;
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                Map map = projectMap;
                bl3 = false;
                map.put(modulePath, lintModelModuleProject);
            }
            for (LintModelModuleProject lintModelModuleProject : projects) {
                LintModelVariant lintModelVariant = lintModelModuleProject.getBuildVariant();
                List<LintModelDependency> roots2 = lintModelVariant.getMainArtifact().getDependencies().getCompileDependencies().getRoots();
                for (LintModelDependency dependency : roots2) {
                    LintModelLibrary library2 = dependency.findLibrary();
                    if (!(library2 instanceof LintModelModuleLibrary)) continue;
                    String projectPath = ((LintModelModuleLibrary)library2).getProjectPath();
                    LintModelModuleProject dependsOn = (LintModelModuleProject)projectMap.get(projectPath);
                    if (dependsOn == null) {
                        Iterable $this$filterIsInstanceTo$iv$iv;
                        Iterable $this$filterIsInstance$iv;
                        Object object;
                        LintModelModuleLibrary it2;
                        Collection collection;
                        void $this$mapTo$iv$iv;
                        Iterable $this$map$iv;
                        Object object2 = lintModelVariant.getMainArtifact().getDependencies().getPackageDependencies().getRoots();
                        boolean $i$f$map = false;
                        void var16_34 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            LintModelDependency lintModelDependency = (LintModelDependency)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl6 = false;
                            object = it2.findLibrary();
                            collection.add(object);
                        }
                        $this$map$iv = (List)destination$iv$iv;
                        boolean $i$f$filterIsInstance = false;
                        $this$mapTo$iv$iv = $this$filterIsInstance$iv;
                        destination$iv$iv = new ArrayList();
                        boolean $i$f$filterIsInstanceTo = false;
                        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                            if (!(element$iv$iv instanceof LintModelModuleLibrary)) continue;
                            destination$iv$iv.add(element$iv$iv);
                        }
                        $this$filterIsInstance$iv = (List)destination$iv$iv;
                        $i$f$map = false;
                        $this$filterIsInstanceTo$iv$iv = $this$map$iv;
                        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void it3;
                            it2 = (LintModelModuleLibrary)item$iv$iv;
                            collection = destination$iv$iv;
                            boolean bl7 = false;
                            object = it3.getProjectPath();
                            collection.add(object);
                        }
                        List packageDependencies = (List)destination$iv$iv;
                        if (!packageDependencies.contains(projectPath)) continue;
                        object2 = "Missing lint model for " + projectPath + ", which is a dependency of " + lintModelModuleProject.getName();
                        boolean bl6 = false;
                        throw (Throwable)new IllegalStateException(object2.toString());
                    }
                    if (reporting && lintModelModuleProject.getType() == LintModelModuleType.DYNAMIC_FEATURE && dependsOn.getType() != LintModelModuleType.DYNAMIC_FEATURE) {
                        dependsOn.addDirectLibrary(lintModelModuleProject);
                        continue;
                    }
                    lintModelModuleProject.addDirectLibrary(dependsOn);
                }
            }
            LinkedHashSet<LintModelModuleProject> roots3 = new LinkedHashSet<LintModelModuleProject>();
            Iterable iterable = projects;
            boolean bl7 = false;
            for (Object element$iv : iterable) {
                LintModelModuleProject it3 = (LintModelModuleProject)element$iv;
                boolean bl9 = false;
                roots3.add(it3);
            }
            for (LintModelModuleProject lintModelModuleProject : projects) {
                for (Project dependency : lintModelModuleProject.getDirectLibraries()) {
                    Collection collection = roots3;
                    boolean bl8 = false;
                    TypeIntrinsics.asMutableCollection((Object)collection).remove(dependency);
                }
            }
            return CollectionsKt.toList((Iterable)roots3);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

