/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.model;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\u0018\u0000 \u001a2\u00020\u0001:\u0002\u001a\u001bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0000J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007J\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0007J\u001a\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\fJ\u0006\u0010\u0014\u001a\u00020\u0007J\u0006\u0010\r\u001a\u00020\u0007J$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\f2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ$\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\n2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u0017\u001a\u00020\u000eJ\b\u0010\u0019\u001a\u00020\nH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/android/tools/lint/model/PathVariables;", "", "()V", "pathVariables", "", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "add", "", "other", "name", "", "dir", "Ljava/io/File;", "sort", "", "any", "clear", "fromPathString", "path", "relativeTo", "normalize", "toPathString", "file", "unix", "fullPath", "toString", "Companion", "PathVariable", "android.sdktools.lint-model"})
public final class PathVariables {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PathVariable> pathVariables;
    @NotNull
    private static final String CANONICALIZED = "_canonical";
    @NotNull
    private static final Comparator<PathVariable> PATH_COMPARATOR = new Comparator<PathVariable>(){

        public int compare(@NotNull PathVariable v12, @NotNull PathVariable v22) {
            int c22;
            Intrinsics.checkParameterIsNotNull((Object)v12, (String)"v1");
            Intrinsics.checkParameterIsNotNull((Object)v22, (String)"v2");
            String p12 = v12.getDir().getPath();
            String p22 = v22.getDir().getPath();
            int c12 = StringsKt.endsWith$default((String)v12.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            int n10 = c22 = StringsKt.endsWith$default((String)v22.getName(), (String)"_canonical", (boolean)false, (int)2, null) ? 1 : 0;
            if (c12 != c22) {
                return c12 - c22;
            }
            if (p22.length() != p12.length()) {
                return p22.length() - p12.length();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)p22, (String)"p2");
            int delta = p12.compareTo(p22);
            if (delta != 0) {
                return delta;
            }
            return v12.getName().compareTo(v22.getName());
        }
    };

    public PathVariables() {
        boolean bl2 = false;
        this.pathVariables = new ArrayList();
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir, boolean sort) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        PathVariable variable = new PathVariable(name, dir);
        this.pathVariables.add(variable);
        if (sort) {
            this.sort();
        }
    }

    public static /* synthetic */ void add$default(PathVariables pathVariables, String string, File file, boolean bl2, int n10, Object object) {
        if ((n10 & 4) != 0) {
            bl2 = true;
        }
        pathVariables.add(string, file, bl2);
    }

    public final void sort() {
        CollectionsKt.sortWith(this.pathVariables, PATH_COMPARATOR);
    }

    public final void clear() {
        this.pathVariables.clear();
    }

    @NotNull
    public final String toPathString(@NotNull File file, @Nullable File relativeTo, boolean unix) {
        Intrinsics.checkParameterIsNotNull((Object)file, (String)"file");
        Object object = file.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"file.path");
        String string = object;
        object = relativeTo;
        return this.toPathString(string, object == null ? null : ((File)object).getPath(), unix);
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, File file, File file2, boolean bl2, int n10, Object object) {
        if ((n10 & 2) != 0) {
            file2 = null;
        }
        if ((n10 & 4) != 0) {
            bl2 = false;
        }
        return pathVariables.toPathString(file, file2, bl2);
    }

    @NotNull
    public final String toPathString(@NotNull String fullPath, @Nullable String relativeTo, boolean unix) {
        Object it2;
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)fullPath, (String)"fullPath");
        for (PathVariable pathVariable : this.pathVariables) {
            String prefix = pathVariable.component1();
            File root = pathVariable.component2();
            String string = root.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"root.path");
            if (!StringsKt.startsWith$default((String)fullPath, (String)string, (boolean)false, (int)2, null)) continue;
            if (Intrinsics.areEqual((Object)fullPath, (Object)root.getPath())) {
                return Intrinsics.stringPlus((String)"$", (Object)StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED));
            }
            if (fullPath.length() <= root.getPath().length() || fullPath.charAt(root.getPath().length()) != File.separatorChar) continue;
            String string2 = fullPath;
            int n10 = root.getPath().length();
            boolean bl2 = false;
            String string3 = string2.substring(n10);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String relative = string3;
            string2 = '$' + StringsKt.removeSuffix((String)prefix, (CharSequence)CANONICALIZED) + relative;
            n10 = 0;
            bl2 = false;
            String it3 = string2;
            boolean bl3 = false;
            return unix ? StringsKt.replace$default((String)it3, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it3;
        }
        if (relativeTo != null && StringsKt.startsWith$default((String)fullPath, (String)relativeTo, (boolean)false, (int)2, null) && fullPath.length() > relativeTo.length() && fullPath.charAt(relativeTo.length()) == File.separatorChar) {
            object = fullPath;
            int n11 = relativeTo.length() + 1;
            boolean bl4 = false;
            String string = ((String)object).substring(n11);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
            object = string;
            n11 = 0;
            bl4 = false;
            it2 = object;
            boolean bl5 = false;
            return unix ? StringsKt.replace$default((String)it2, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it2;
        }
        object = fullPath;
        boolean bl6 = false;
        boolean bl7 = false;
        it2 = object;
        boolean bl8 = false;
        return unix ? StringsKt.replace$default((String)it2, (char)'\\', (char)'/', (boolean)false, (int)4, null) : it2;
    }

    public static /* synthetic */ String toPathString$default(PathVariables pathVariables, String string, String string2, boolean bl2, int n10, Object object) {
        if ((n10 & 2) != 0) {
            string2 = null;
        }
        if ((n10 & 4) != 0) {
            bl2 = false;
        }
        return pathVariables.toPathString(string, string2, bl2);
    }

    @NotNull
    public final File fromPathString(@NotNull String path2, @Nullable File relativeTo) {
        Intrinsics.checkParameterIsNotNull((Object)path2, (String)"path");
        if (StringsKt.startsWith$default((String)path2, (String)"$", (boolean)false, (int)2, null)) {
            Object v42;
            String name;
            Object object;
            block10: {
                char c10;
                int i10;
                int n10 = 1;
                int n11 = path2.length();
                if (n10 < n11) {
                    do {
                        boolean bl2;
                        Object v12;
                        Object $this$firstOrNull$iv;
                        String varName;
                        block9: {
                            i10 = n10++;
                            char c11 = c10 = path2.charAt(i10);
                            boolean bl3 = false;
                            if (Character.isJavaIdentifierPart(c11)) continue;
                            String string = path2;
                            int n12 = 1;
                            boolean bl4 = false;
                            String string2 = string.substring(n12, i10);
                            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                            varName = string2;
                            $this$firstOrNull$iv = this.pathVariables;
                            boolean $i$f$firstOrNull = false;
                            Iterator iterator = $this$firstOrNull$iv.iterator();
                            while (iterator.hasNext()) {
                                Object element$iv = iterator.next();
                                PathVariable it2 = (PathVariable)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)it2.getName(), (Object)varName)) continue;
                                v12 = element$iv;
                                break block9;
                            }
                            v12 = null;
                        }
                        PathVariable pathVariable = v12;
                        if (pathVariable == null) {
                            $this$firstOrNull$iv = "Path variable $" + varName + " referenced in " + path2 + " not provided to serialization";
                            bl2 = false;
                            throw (Throwable)new IllegalStateException($this$firstOrNull$iv.toString());
                        }
                        File dir = pathVariable.getDir();
                        int relativeStart = c10 == '/' || c10 == '\\' ? i10 + 1 : i10;
                        $this$firstOrNull$iv = path2;
                        bl2 = false;
                        String string = ((String)$this$firstOrNull$iv).substring(relativeStart);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                        return new File(dir, string);
                    } while (n10 < n11);
                }
                object = path2;
                i10 = 1;
                c10 = '\u0000';
                String string = ((String)object).substring(i10);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).substring(startIndex)");
                name = string;
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it3 = (PathVariable)element$iv;
                    boolean bl6 = false;
                    if (!Intrinsics.areEqual((Object)it3.getName(), (Object)name)) continue;
                    v42 = element$iv;
                    break block10;
                }
                v42 = null;
            }
            object = v42;
            if (object == null) {
                String string = "Path variable $" + name + " referenced in " + path2 + " not provided to serialization";
                boolean bl7 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return ((PathVariable)object).getDir();
        }
        File file = new File(path2);
        if (relativeTo != null && !file.isAbsolute()) {
            File parentFile;
            if ((StringsKt.startsWith$default((String)path2, (String)"../", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)path2, (String)"..\\", (boolean)false, (int)2, null)) && (parentFile = relativeTo.getParentFile()) != null) {
                String string = path2;
                int n13 = 3;
                boolean bl8 = false;
                String string3 = string.substring(n13);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
                return new File(parentFile, string3);
            }
            return new File(relativeTo, path2);
        }
        return file;
    }

    public static /* synthetic */ File fromPathString$default(PathVariables pathVariables, String string, File file, int n10, Object object) {
        if ((n10 & 2) != 0) {
            file = null;
        }
        return pathVariables.fromPathString(string, file);
    }

    public final void add(@NotNull PathVariables other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        for (PathVariable variable : other.pathVariables) {
            Object v02;
            block3: {
                String name = variable.getName();
                Iterable $this$firstOrNull$iv = this.pathVariables;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    PathVariable it2 = (PathVariable)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it2.getName(), (Object)name)) continue;
                    v02 = element$iv;
                    break block3;
                }
                v02 = null;
            }
            PathVariable pathVariable = v02;
            if (pathVariable != null) {
                PathVariable pathVariable2 = pathVariable;
                boolean bl3 = false;
                boolean bl4 = false;
                PathVariable it3 = pathVariable2;
                boolean bl5 = false;
                this.pathVariables.remove(it3);
            }
            this.pathVariables.add(variable);
        }
        this.sort();
    }

    public final void normalize() {
        if (this.pathVariables.isEmpty()) {
            return;
        }
        for (PathVariable variable : CollectionsKt.toList((Iterable)this.pathVariables)) {
            try {
                boolean bl2 = !StringsKt.endsWith$default((String)variable.getName(), (String)CANONICALIZED, (boolean)false, (int)2, null);
                boolean bl3 = false;
                boolean bl4 = false;
                if (_Assertions.ENABLED && !bl2) {
                    boolean bl5 = false;
                    String string = "Assertion failed";
                    throw (Throwable)((Object)new AssertionError((Object)string));
                }
                File canonical = variable.getDir().getCanonicalFile();
                if (Intrinsics.areEqual((Object)canonical.getPath(), (Object)variable.getDir().getPath())) continue;
                String string = Intrinsics.stringPlus((String)variable.getName(), (Object)CANONICALIZED);
                Intrinsics.checkExpressionValueIsNotNull((Object)canonical, (String)"canonical");
                this.add(string, canonical, false);
            }
            catch (IOException iOException) {}
        }
        this.sort();
    }

    public final boolean any() {
        Collection collection = this.pathVariables;
        boolean bl2 = false;
        return !collection.isEmpty();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.pathVariables, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
    }

    @JvmOverloads
    public final void add(@NotNull String name, @NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        PathVariables.add$default(this, name, dir, false, 4, null);
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\b\u0010\u0013\u001a\u00020\u0003H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/model/PathVariables$PathVariable;", "", "name", "", "dir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "getDir", "()Ljava/io/File;", "getName", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-model"})
    private static final class PathVariable {
        @NotNull
        private final String name;
        @NotNull
        private final File dir;

        public PathVariable(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            this.name = name;
            this.dir = dir;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final File getDir() {
            return this.dir;
        }

        @NotNull
        public String toString() {
            return this.name + '=' + this.dir;
        }

        @NotNull
        public final String component1() {
            return this.name;
        }

        @NotNull
        public final File component2() {
            return this.dir;
        }

        @NotNull
        public final PathVariable copy(@NotNull String name, @NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            return new PathVariable(name, dir);
        }

        public static /* synthetic */ PathVariable copy$default(PathVariable pathVariable, String string, File file, int n10, Object object) {
            if ((n10 & 1) != 0) {
                string = pathVariable.name;
            }
            if ((n10 & 2) != 0) {
                file = pathVariable.dir;
            }
            return pathVariable.copy(string, file);
        }

        public int hashCode() {
            int result2 = this.name.hashCode();
            result2 = result2 * 31 + this.dir.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PathVariable)) {
                return false;
            }
            PathVariable pathVariable = (PathVariable)other;
            if (!Intrinsics.areEqual((Object)this.name, (Object)pathVariable.name)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.dir, (Object)pathVariable.dir);
        }
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u00070\u0006j\b\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/model/PathVariables$Companion;", "", "()V", "CANONICALIZED", "", "PATH_COMPARATOR", "Ljava/util/Comparator;", "Lcom/android/tools/lint/model/PathVariables$PathVariable;", "Lkotlin/Comparator;", "parse", "Lcom/android/tools/lint/model/PathVariables;", "s", "android.sdktools.lint-model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final PathVariables parse(@NotNull String s10) {
            Intrinsics.checkParameterIsNotNull((Object)s10, (String)"s");
            PathVariables variables = new PathVariables();
            char[] cArray = new char[]{';'};
            for (String pair : StringsKt.split$default((CharSequence)s10, (char[])cArray, (boolean)false, (int)0, (int)6, null)) {
                if (StringsKt.isBlank((CharSequence)pair)) continue;
                int index = StringsKt.indexOf$default((CharSequence)pair, (char)'=', (int)0, (boolean)false, (int)6, null);
                if (index <= 0 || index == pair.length() - 1 || StringsKt.startsWith$default((String)pair, (String)"$$", (boolean)false, (int)2, null)) {
                    String string = "Invalid path descriptor " + pair + ", expected name=path-prefix";
                    boolean bl2 = false;
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                String string = pair;
                int n10 = 1;
                int n11 = 0;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.substring(n10, index);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                string = string3;
                n10 = 0;
                String string4 = string;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String name = ((Object)StringsKt.trim((CharSequence)string4)).toString();
                String string5 = pair;
                n11 = index + 1;
                boolean bl3 = false;
                String string6 = string5;
                if (string6 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n11);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
                string5 = string7;
                n11 = 0;
                String string8 = string5;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                File prefix = new File(((Object)StringsKt.trim((CharSequence)string8)).toString());
                variables.add(name, prefix, false);
            }
            variables.sort();
            return variables;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

