/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.heap.analysis;

import com.android.tools.perflib.heap.Instance;
import com.android.tools.perflib.heap.RootObj;
import com.android.tools.perflib.heap.Snapshot;
import com.android.tools.perflib.heap.analysis.ComputationProgress;
import com.android.tools.perflib.heap.analysis.DominatorsBase;
import gnu.trove.TIntArrayList;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;

public final class LinkEvalDominators
extends DominatorsBase {
    private volatile int mNodeCount;
    private volatile int mSemiDominatorProgress = 0;
    private volatile int mDominatorProgress = 0;
    private static final int INVALID_ANCESTOR = -1;

    public LinkEvalDominators(Snapshot snapshot) {
        super(snapshot);
    }

    @Override
    public ComputationProgress getComputationProgress() {
        double progress;
        String progressMessage;
        if (this.mSemiDominatorProgress < this.mNodeCount) {
            progressMessage = String.format("Calculating semi-dominators %d/%d", this.mSemiDominatorProgress, this.mNodeCount);
            progress = 0.5 * (double)this.mSemiDominatorProgress / (double)this.mNodeCount;
        } else {
            progressMessage = String.format("Calculating immediate dominators %d/%d", this.mDominatorProgress, this.mNodeCount);
            progress = 0.5 + 0.5 * (double)this.mDominatorProgress / (double)this.mNodeCount;
        }
        this.mCurrentProgress.setMessage(progressMessage);
        this.mCurrentProgress.setProgress(progress);
        return this.mCurrentProgress;
    }

    @Override
    public void computeDominators() {
        int currentNode;
        DFSResult result2 = this.computeIndicesAndParents();
        Instance[] instances = result2.instances;
        int[] parents = result2.parents;
        int[][] preds = result2.predecessors;
        int[] semis = LinkEvalDominators.makeIdentityIntArray(instances.length);
        TIntArrayList[] buckets = new TIntArrayList[instances.length];
        for (int i10 = 0; i10 < buckets.length; ++i10) {
            buckets[i10] = new TIntArrayList();
        }
        int[] doms = new int[instances.length];
        int[] ancestors = new int[instances.length];
        Arrays.fill(ancestors, -1);
        int[] labels = LinkEvalDominators.makeIdentityIntArray(instances.length);
        this.mNodeCount = instances.length;
        for (currentNode = instances.length - 1; currentNode > 0; --currentNode) {
            this.mSemiDominatorProgress = instances.length - currentNode;
            for (int predecessor : preds[currentNode]) {
                int evaledPredecessor = LinkEvalDominators.eval(ancestors, labels, semis, predecessor);
                if (semis[evaledPredecessor] >= semis[currentNode]) continue;
                semis[currentNode] = semis[evaledPredecessor];
            }
            buckets[semis[currentNode]].add(currentNode);
            ancestors[currentNode] = parents[currentNode];
            for (int i11 = 0; i11 < buckets[parents[currentNode]].size(); ++i11) {
                int node = buckets[parents[currentNode]].get(i11);
                int nodeEvaled = LinkEvalDominators.eval(ancestors, labels, semis, node);
                doms[node] = semis[nodeEvaled] < semis[node] ? nodeEvaled : parents[currentNode];
                instances[node].setImmediateDominator(instances[doms[node]]);
            }
            buckets[parents[currentNode]].clear();
        }
        currentNode = 1;
        while (currentNode < instances.length) {
            if (doms[currentNode] != semis[currentNode]) {
                doms[currentNode] = doms[doms[currentNode]];
                instances[currentNode].setImmediateDominator(instances[doms[currentNode]]);
            }
            this.mDominatorProgress = currentNode++;
        }
    }

    private DFSResult computeIndicesAndParents() {
        TObjectIntHashMap parents = new TObjectIntHashMap(TObjectHashingStrategy.IDENTITY);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        Stack<Instance> nodeStack = new Stack<Instance>();
        instances.add(Snapshot.SENTINEL_ROOT);
        Set<Instance> gcRoots = this.mSnapshot.getGCRoots().stream().map(RootObj::getReferredInstance).filter(Objects::nonNull).collect(Collectors.toSet());
        gcRoots.forEach(gcRoot -> {
            parents.put(gcRoot, 0);
            nodeStack.push((Instance)gcRoot);
        });
        LinkEvalDominators.dfs(nodeStack, instances, (TObjectIntHashMap<Instance>)parents);
        return DFSResult.of(instances, (TObjectIntHashMap<Instance>)parents, gcRoots);
    }

    private static void dfs(Stack<Instance> nodeStack, ArrayList<Instance> instances, TObjectIntHashMap<Instance> parents) {
        Set touched = Collections.newSetFromMap(new IdentityHashMap());
        while (!nodeStack.empty()) {
            Instance node = nodeStack.pop();
            if (!touched.contains(node)) {
                node.setTopologicalOrder(instances.size());
                touched.add(node);
                instances.add(node);
            }
            for (Instance succ : node.getHardForwardReferences()) {
                if (touched.contains(succ)) continue;
                parents.put((Object)succ, node.getTopologicalOrder());
                nodeStack.push(succ);
            }
        }
    }

    private static int eval(int[] ancestors, int[] labels, int[] semis, int node) {
        return ancestors[node] == -1 ? node : LinkEvalDominators.compress(ancestors, labels, semis, node);
    }

    private static int compress(int[] ancestors, int[] labels, int[] semis, int node) {
        TIntArrayList compressArray = new TIntArrayList();
        assert (ancestors[node] != -1);
        int n10 = node;
        while (ancestors[ancestors[n10]] != -1) {
            compressArray.add(n10);
            n10 = ancestors[n10];
        }
        for (int i10 = compressArray.size() - 1; i10 >= 0; --i10) {
            int toCompress = compressArray.get(i10);
            int ancestor = ancestors[toCompress];
            assert (ancestor != -1);
            if (semis[labels[ancestor]] < semis[labels[toCompress]]) {
                labels[toCompress] = labels[ancestor];
            }
            ancestors[toCompress] = ancestors[ancestor];
        }
        return labels[node];
    }

    private static int[] makeIdentityIntArray(int size) {
        int[] ints = new int[size];
        for (int i10 = 0; i10 < size; ++i10) {
            ints[i10] = i10;
        }
        return ints;
    }

    private static class DFSResult {
        final Instance[] instances;
        final int[] parents;
        final int[][] predecessors;

        DFSResult(Instance[] instances, int[] parents, int[][] predecessors) {
            this.instances = instances;
            this.parents = parents;
            this.predecessors = predecessors;
        }

        static DFSResult of(ArrayList<Instance> instances, TObjectIntHashMap<Instance> parents, Set<Instance> gcRoots) {
            int[] parentIndices = new int[instances.size()];
            int[][] predIndices = new int[instances.size()][];
            for (int i10 = 1; i10 < instances.size(); ++i10) {
                Instance instance = instances.get(i10);
                int order = instance.getTopologicalOrder();
                parentIndices[order] = parents.get((Object)instance);
                int[] backRefs = instance.getHardReverseReferences().stream().filter(Instance::isReachable).mapToInt(Instance::getTopologicalOrder).toArray();
                predIndices[order] = gcRoots.contains(instance) ? DFSResult.prepend(0, backRefs) : backRefs;
            }
            return new DFSResult(instances.toArray(new Instance[0]), parentIndices, predIndices);
        }

        private static int[] prepend(int n10, int[] ns2) {
            int[] ns1 = new int[ns2.length + 1];
            System.arraycopy(ns2, 0, ns1, 1, ns2.length);
            ns1[0] = n10;
            return ns1;
        }
    }
}

