/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace;

import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.VmTraceData;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.UnsignedInts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class Call {
    private final long mMethodId;
    private final int mEntryGlobalTime;
    private final int mExitGlobalTime;
    private final int mEntryThreadTime;
    private final int mExitThreadTime;
    private final long mInclusiveThreadTimeInCallees;
    private final long mInclusiveGlobalTimeInCallees;
    private final int mDepth;
    private final boolean mIsRecursive;
    private final List<Call> mCallees;
    private static final Formatter METHOD_ID_FORMATTER = new Formatter(){

        @Override
        public String format(Call c10) {
            return Long.toString(c10.getMethodId());
        }
    };

    private Call(Builder builder, Stack<Long> backStack) {
        this.mMethodId = builder.mMethodId;
        this.mEntryThreadTime = builder.mEntryThreadTime;
        this.mEntryGlobalTime = builder.mEntryGlobalTime;
        this.mExitThreadTime = builder.mExitThreadTime;
        this.mExitGlobalTime = builder.mExitGlobalTime;
        this.mDepth = backStack.size();
        this.mIsRecursive = backStack.contains(this.mMethodId);
        if (builder.mCallees == null) {
            this.mCallees = Collections.emptyList();
        } else {
            backStack.push(this.mMethodId);
            ArrayList<Call> callees = new ArrayList<Call>(builder.mCallees.size());
            for (Builder b10 : builder.mCallees) {
                callees.add(b10.build(backStack));
            }
            backStack.pop();
            this.mCallees = new ImmutableList.Builder().addAll(callees).build();
        }
        this.mInclusiveThreadTimeInCallees = this.sumInclusiveTimes(this.mCallees, ClockType.THREAD);
        this.mInclusiveGlobalTimeInCallees = this.sumInclusiveTimes(this.mCallees, ClockType.GLOBAL);
    }

    private long sumInclusiveTimes(List<Call> callees, ClockType clockType) {
        long sum = 0L;
        for (Call c10 : callees) {
            sum += c10.getInclusiveTime(clockType, TimeUnit.MICROSECONDS);
        }
        return sum;
    }

    public long getMethodId() {
        return this.mMethodId;
    }

    public List<Call> getCallees() {
        return this.mCallees;
    }

    public int getDepth() {
        return this.mDepth;
    }

    public boolean isRecursive() {
        return this.mIsRecursive;
    }

    public long getEntryTime(ClockType clockType, TimeUnit units) {
        long entryTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)this.mEntryThreadTime) : UnsignedInts.toLong((int)this.mEntryGlobalTime);
        return units.convert(entryTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getExitTime(ClockType clockType, TimeUnit units) {
        long exitTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)this.mExitThreadTime) : UnsignedInts.toLong((int)this.mExitGlobalTime);
        return units.convert(exitTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getInclusiveTime(ClockType clockType, TimeUnit units) {
        long inclusiveTime = clockType == ClockType.THREAD ? UnsignedInts.toLong((int)(this.mExitThreadTime - this.mEntryThreadTime)) : UnsignedInts.toLong((int)(this.mExitGlobalTime - this.mEntryGlobalTime));
        return units.convert(inclusiveTime, VmTraceData.getDefaultTimeUnits());
    }

    public long getExclusiveTime(ClockType clockType, TimeUnit units) {
        long inclusiveTimeInCallees = clockType == ClockType.THREAD ? this.mInclusiveThreadTimeInCallees : this.mInclusiveGlobalTimeInCallees;
        long exclusiveTime = this.getInclusiveTime(clockType, VmTraceData.getDefaultTimeUnits()) - inclusiveTimeInCallees;
        return units.convert(exclusiveTime, VmTraceData.getDefaultTimeUnits());
    }

    public String format(Formatter f10) {
        StringBuilder sb2 = new StringBuilder(100);
        this.printCallHierarchy(sb2, f10);
        return sb2.toString();
    }

    public String toString() {
        return this.format(METHOD_ID_FORMATTER);
    }

    private void printCallHierarchy(StringBuilder sb2, Formatter formatter) {
        sb2.append(" -> ");
        sb2.append(formatter.format(this));
        List<Call> callees = this.getCallees();
        int lineStart = sb2.lastIndexOf("\n");
        int depth = sb2.length() - (lineStart + 1);
        for (int i10 = 0; i10 < callees.size(); ++i10) {
            if (i10 != 0) {
                sb2.append("\n");
                sb2.append(Strings.repeat((String)" ", (int)depth));
            }
            Call callee = callees.get(i10);
            callee.printCallHierarchy(sb2, formatter);
        }
    }

    public Iterator<Call> getCallHierarchyIterator() {
        return new CallHierarchyIterator(this);
    }

    private static class CallHierarchyIterator
    implements Iterator<Call> {
        private final Stack<Call> mCallStack = new Stack();

        public CallHierarchyIterator(Call top) {
            this.mCallStack.push(top);
        }

        @Override
        public boolean hasNext() {
            return !this.mCallStack.isEmpty();
        }

        @Override
        public Call next() {
            if (this.mCallStack.isEmpty()) {
                return null;
            }
            Call top = this.mCallStack.pop();
            for (int i10 = top.getCallees().size() - 1; i10 >= 0; --i10) {
                this.mCallStack.push(top.getCallees().get(i10));
            }
            return top;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static interface Formatter {
        public String format(Call var1);
    }

    public static class Builder {
        private final long mMethodId;
        private int mEntryThreadTime;
        private int mEntryGlobalTime;
        private int mExitGlobalTime;
        private int mExitThreadTime;
        private List<Builder> mCallees = null;

        public Builder(long methodId) {
            this.mMethodId = methodId;
        }

        public long getMethodId() {
            return this.mMethodId;
        }

        public void setMethodEntryTime(int threadTime, int globalTime) {
            this.mEntryThreadTime = threadTime;
            this.mEntryGlobalTime = globalTime;
        }

        public void setMethodExitTime(int threadTime, int globalTime) {
            this.mExitThreadTime = threadTime;
            this.mExitGlobalTime = globalTime;
        }

        public void addCallee(Builder c10) {
            if (this.mCallees == null) {
                this.mCallees = new ArrayList<Builder>();
            }
            this.mCallees.add(c10);
        }

        public List<Builder> getCallees() {
            return this.mCallees;
        }

        public int getMethodEntryThreadTime() {
            return this.mEntryThreadTime;
        }

        public int getMethodEntryGlobalTime() {
            return this.mEntryGlobalTime;
        }

        public int getMethodExitThreadTime() {
            return this.mExitThreadTime;
        }

        public int getMethodExitGlobalTime() {
            return this.mExitGlobalTime;
        }

        public Call build(Stack<Long> backStack) {
            return new Call(this, backStack);
        }
    }
}

