/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import com.android.tools.perflib.vmtrace.Call;
import com.android.tools.perflib.vmtrace.ClockType;
import com.android.tools.perflib.vmtrace.MethodInfo;
import com.android.tools.perflib.vmtrace.ThreadInfo;
import com.android.tools.perflib.vmtrace.VmTraceData;
import java.awt.Color;
import java.util.Collections;
import java.util.Set;

public class RenderContext {
    private static final Color HIGHLIGHTED_METHOD_COLOR = new Color(4744096);
    private final VmTraceData mTraceData;
    private ClockType mRenderClock;
    private boolean mUseInclusiveTimeForColorAssignment;
    private Set<MethodInfo> mHighlightedMethods = Collections.emptySet();
    private static final Color[] QUANTIZED_COLORS = new Color[]{new Color(226, 230, 189), new Color(235, 228, 139), new Color(242, 221, 128), new Color(246, 210, 119), new Color(246, 197, 111), new Color(242, 180, 104), new Color(234, 161, 98), new Color(223, 139, 91), new Color(207, 115, 85), new Color(188, 88, 77), new Color(166, 57, 69), new Color(142, 6, 59)};
    private static final int BRIGHT_TO_DARK_CROSSOVER_INDEX = 9;

    public RenderContext(VmTraceData traceData, ClockType renderClock) {
        this.mTraceData = traceData;
        this.mRenderClock = renderClock;
    }

    public void setRenderClock(ClockType type) {
        this.mRenderClock = type;
    }

    public void setUseInclusiveTimeForColorAssignment(boolean en2) {
        this.mUseInclusiveTimeForColorAssignment = en2;
    }

    public ClockType getRenderClock() {
        return this.mRenderClock;
    }

    private int getColorIndex(double percent) {
        int i10 = (int)(percent * (double)QUANTIZED_COLORS.length / 100.0);
        return i10 >= QUANTIZED_COLORS.length ? QUANTIZED_COLORS.length - 1 : i10;
    }

    public Color getFillColor(Call c10, ThreadInfo thread) {
        if (this.isHighlightedMethod(c10)) {
            return HIGHLIGHTED_METHOD_COLOR;
        }
        double percent = this.mTraceData.getDurationPercentage(c10, thread, this.mRenderClock, this.mUseInclusiveTimeForColorAssignment);
        return QUANTIZED_COLORS[this.getColorIndex(percent)];
    }

    public void setHighlightedMethods(Set<MethodInfo> highlightedMethods) {
        this.mHighlightedMethods = highlightedMethods;
    }

    private boolean isHighlightedMethod(Call c10) {
        MethodInfo method = this.mTraceData.getMethod(c10.getMethodId());
        return this.mHighlightedMethods != null && this.mHighlightedMethods.contains(method);
    }

    public Color getFontColor(Call c10, ThreadInfo thread) {
        double percent = this.mTraceData.getDurationPercentage(c10, thread, this.mRenderClock, this.mUseInclusiveTimeForColorAssignment);
        return this.getColorIndex(percent) < 9 ? Color.BLACK : Color.WHITE;
    }
}

