/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.perflib.vmtrace.viz;

import com.android.tools.perflib.vmtrace.viz.TimeUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.concurrent.TimeUnit;

public class TimeScaleRenderer {
    private static final int TIMELINE_Y_OFFSET = 20;
    public static final int TIMELINE_UNIT_HORIZONTAL_PADDING = 5;
    public static final int TIMELINE_UNIT_VERTICAL_PADDING = 5;
    private final long mStartTime;
    private final TimeUnit mTimeUnits;
    private double[] mPoints = new double[8];
    private AffineTransform mViewTransform;
    private AffineTransform mViewTransformInverse;

    public TimeScaleRenderer(long startTime, TimeUnit unit) {
        this.mStartTime = startTime;
        this.mTimeUnits = unit;
    }

    public void paint(Graphics2D g2d, AffineTransform viewPortTransform, int screenWidth) {
        AffineTransform originalTransform = g2d.getTransform();
        this.drawTimeLine(g2d, viewPortTransform, screenWidth);
        g2d.setTransform(originalTransform);
    }

    private void drawTimeLine(Graphics2D g2d, AffineTransform viewPortTransform, int screenWidth) {
        this.createInverse(viewPortTransform);
        this.mPoints[0] = 0.0;
        this.mPoints[1] = 0.0;
        this.mPoints[2] = screenWidth;
        this.mPoints[3] = 0.0;
        this.mViewTransformInverse.transform(this.mPoints, 0, this.mPoints, 4, 2);
        long start = (long)this.mPoints[4] + this.mStartTime;
        long end = (long)this.mPoints[6] + this.mStartTime;
        g2d.setColor(Color.BLACK);
        g2d.drawLine(0, 20, screenWidth, 20);
        String time = TimeUtils.makeHumanReadable(start, end - start, this.mTimeUnits);
        g2d.drawString(time, 5, 15);
        time = TimeUtils.makeHumanReadable(end, end - start, this.mTimeUnits);
        g2d.drawString(time, screenWidth - g2d.getFontMetrics().stringWidth(time) - 5, 15);
    }

    public int getLayoutHeight() {
        return 30;
    }

    private void createInverse(AffineTransform viewPortTransform) {
        if (!viewPortTransform.equals(this.mViewTransform)) {
            this.mViewTransform = new AffineTransform(viewPortTransform);
            try {
                this.mViewTransformInverse = this.mViewTransform.createInverse();
            }
            catch (NoninvertibleTransformException e10) {
                this.mViewTransformInverse = new AffineTransform();
            }
        }
    }
}

