/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.explainer;

import com.google.archivepatcher.explainer.EntryExplanation;
import com.google.archivepatcher.generator.RecommendationReason;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class PatchExplanation {
    private final List<EntryExplanation> explainedAsNew;
    private final List<EntryExplanation> explainedAsChanged;
    private final List<EntryExplanation> explainedAsUnchangedOrFree;
    private final List<EntryExplanation> explainedAsResourceConstrained;
    private final long estimatedNewSize;
    private final long estimatedChangedSize;
    private final long estimatedResourceConstrainedSize;

    public PatchExplanation(List<EntryExplanation> entryExplanations) {
        ArrayList<EntryExplanation> tempExplainedAsNew = new ArrayList<EntryExplanation>();
        ArrayList<EntryExplanation> tempExplainedAsChanged = new ArrayList<EntryExplanation>();
        ArrayList<EntryExplanation> tempExplainedAsUnchangedOrFree = new ArrayList<EntryExplanation>();
        ArrayList<EntryExplanation> tempExplainedAsResourceConstrained = new ArrayList<EntryExplanation>();
        long tempEstimatedNewSize = 0L;
        long tempEstimatedChangedSize = 0L;
        long tempEstimatedResourceConstrainedSize = 0L;
        for (EntryExplanation explanation : entryExplanations) {
            if (explanation.isNew()) {
                tempEstimatedNewSize += explanation.getCompressedSizeInPatch();
                tempExplainedAsNew.add(explanation);
                continue;
            }
            if (explanation.getReasonIncludedIfNotNew() == RecommendationReason.RESOURCE_CONSTRAINED) {
                tempEstimatedResourceConstrainedSize += explanation.getCompressedSizeInPatch();
                tempExplainedAsResourceConstrained.add(explanation);
                continue;
            }
            if (explanation.getCompressedSizeInPatch() > 0L) {
                tempEstimatedChangedSize += explanation.getCompressedSizeInPatch();
                tempExplainedAsChanged.add(explanation);
                continue;
            }
            tempExplainedAsUnchangedOrFree.add(explanation);
        }
        EntryExplanationLexicalComparator comparator = new EntryExplanationLexicalComparator();
        Collections.sort(tempExplainedAsNew, comparator);
        Collections.sort(tempExplainedAsChanged, comparator);
        Collections.sort(tempExplainedAsUnchangedOrFree, comparator);
        Collections.sort(tempExplainedAsResourceConstrained, comparator);
        this.explainedAsNew = Collections.unmodifiableList(tempExplainedAsNew);
        this.explainedAsChanged = Collections.unmodifiableList(tempExplainedAsChanged);
        this.explainedAsUnchangedOrFree = Collections.unmodifiableList(tempExplainedAsUnchangedOrFree);
        this.explainedAsResourceConstrained = Collections.unmodifiableList(tempExplainedAsResourceConstrained);
        this.estimatedNewSize = tempEstimatedNewSize;
        this.estimatedChangedSize = tempEstimatedChangedSize;
        this.estimatedResourceConstrainedSize = tempEstimatedResourceConstrainedSize;
    }

    public List<EntryExplanation> getExplainedAsNew() {
        return this.explainedAsNew;
    }

    public List<EntryExplanation> getExplainedAsChanged() {
        return this.explainedAsChanged;
    }

    public List<EntryExplanation> getExplainedAsUnchangedOrFree() {
        return this.explainedAsUnchangedOrFree;
    }

    public List<EntryExplanation> getExplainedAsResourceConstrained() {
        return this.explainedAsResourceConstrained;
    }

    public long getEstimatedNewSize() {
        return this.estimatedNewSize;
    }

    public long getEstimatedChangedSize() {
        return this.estimatedChangedSize;
    }

    public long getEstimatedResourceConstrainedSize() {
        return this.estimatedResourceConstrainedSize;
    }

    public void writeJson(PrintWriter writer) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("{\n");
        buffer.append("  estimatedNewSize: ").append(this.getEstimatedNewSize()).append(",\n");
        buffer.append("  estimatedChangedSize: ").append(this.getEstimatedChangedSize()).append(",\n");
        buffer.append("  estimatedResourceConstrainedSize: ").append(this.getEstimatedResourceConstrainedSize()).append(",\n");
        this.dumpJson(this.getExplainedAsNew(), "explainedAsNew", buffer, "  ");
        buffer.append(",\n");
        this.dumpJson(this.getExplainedAsChanged(), "explainedAsChanged", buffer, "  ");
        buffer.append(",\n");
        this.dumpJson(this.getExplainedAsUnchangedOrFree(), "explainedAsUnchangedOrFree", buffer, "  ");
        buffer.append(",\n");
        this.dumpJson(this.getExplainedAsResourceConstrained(), "explainedAsResourceConstrained", buffer, "  ");
        buffer.append("\n");
        buffer.append("}");
        writer.write(buffer.toString());
        writer.flush();
    }

    private void dumpJson(List<EntryExplanation> explanations, String listName, StringBuilder buffer, String indent) {
        buffer.append(indent).append(listName).append(": [\n");
        Iterator<EntryExplanation> iterator = explanations.iterator();
        while (iterator.hasNext()) {
            EntryExplanation explanation = iterator.next();
            this.dumpJson(explanation, buffer, indent + "  ");
            if (iterator.hasNext()) {
                buffer.append(",");
            }
            buffer.append("\n");
        }
        buffer.append(indent).append("]");
    }

    private void dumpJson(EntryExplanation entryExplanation, StringBuilder buffer, String indent) {
        String reasonString = entryExplanation.isNew() ? "undefined" : "'" + entryExplanation.getReasonIncludedIfNotNew().toString() + "'";
        buffer.append(indent).append("{ ").append("path: '").append(PatchExplanation.path(entryExplanation)).append("', ").append("isNew: ").append(entryExplanation.isNew()).append(", ").append("reasonIncluded: ").append(reasonString).append(", ").append("compressedSizeInPatch: ").append(entryExplanation.getCompressedSizeInPatch()).append(" }");
    }

    private static String path(EntryExplanation explanation) {
        try {
            return new String(explanation.getPath().getData(), "UTF-8");
        }
        catch (UnsupportedEncodingException e10) {
            throw new RuntimeException("System doesn't support UTF-8", e10);
        }
    }

    private static class EntryExplanationLexicalComparator
    implements Comparator<EntryExplanation> {
        private EntryExplanationLexicalComparator() {
        }

        @Override
        public int compare(EntryExplanation o12, EntryExplanation o22) {
            return PatchExplanation.path(o12).compareTo(PatchExplanation.path(o22));
        }
    }
}

