/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator;

import com.google.archivepatcher.generator.MinimalCentralDirectoryMetadata;
import com.google.archivepatcher.generator.MinimalZipEntry;
import com.google.archivepatcher.generator.MinimalZipParser;
import com.google.archivepatcher.shared.RandomAccessFileInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.zip.ZipException;

public class MinimalZipArchive {
    private static final Comparator<MinimalZipEntry> LOCAL_ENTRY_OFFSET_COMAPRATOR = new Comparator<MinimalZipEntry>(){

        @Override
        public int compare(MinimalZipEntry o12, MinimalZipEntry o22) {
            return Long.compare(o12.getFileOffsetOfLocalEntry(), o22.getFileOffsetOfLocalEntry());
        }
    };

    public static List<MinimalZipEntry> listEntries(File file) throws IOException {
        try (RandomAccessFileInputStream in2 = new RandomAccessFileInputStream(file);){
            List<MinimalZipEntry> list2 = MinimalZipArchive.listEntriesInternal(in2);
            return list2;
        }
    }

    private static List<MinimalZipEntry> listEntriesInternal(RandomAccessFileInputStream in2) throws IOException {
        int x10;
        long offsetOfEocd = MinimalZipParser.locateStartOfEocd(in2, 32768);
        if (offsetOfEocd == -1L) {
            throw new ZipException("EOCD record not found in last 32k of archive, giving up");
        }
        in2.setRange(offsetOfEocd, in2.length() - offsetOfEocd);
        MinimalCentralDirectoryMetadata centralDirectoryMetadata = MinimalZipParser.parseEocd(in2);
        in2.setRange(centralDirectoryMetadata.getOffsetOfCentralDirectory(), centralDirectoryMetadata.getLengthOfCentralDirectory());
        ArrayList<MinimalZipEntry> minimalZipEntries = new ArrayList<MinimalZipEntry>(centralDirectoryMetadata.getNumEntriesInCentralDirectory());
        for (x10 = 0; x10 < centralDirectoryMetadata.getNumEntriesInCentralDirectory(); ++x10) {
            minimalZipEntries.add(MinimalZipParser.parseCentralDirectoryEntry(in2));
        }
        Collections.sort(minimalZipEntries, LOCAL_ENTRY_OFFSET_COMAPRATOR);
        for (x10 = 0; x10 < minimalZipEntries.size(); ++x10) {
            MinimalZipEntry entry = (MinimalZipEntry)minimalZipEntries.get(x10);
            long offsetOfNextEntry = x10 < minimalZipEntries.size() - 1 ? ((MinimalZipEntry)minimalZipEntries.get(x10 + 1)).getFileOffsetOfLocalEntry() : centralDirectoryMetadata.getOffsetOfCentralDirectory();
            long rangeLength = offsetOfNextEntry - entry.getFileOffsetOfLocalEntry();
            in2.setRange(entry.getFileOffsetOfLocalEntry(), rangeLength);
            long relativeDataOffset = MinimalZipParser.parseLocalEntryAndGetCompressedDataOffset(in2);
            entry.setFileOffsetOfCompressedData(entry.getFileOffsetOfLocalEntry() + relativeDataOffset);
        }
        return minimalZipEntries;
    }
}

