/*
 * Decompiled with CFR 0.152.
 */
package com.google.archivepatcher.generator.bsdiff;

import com.google.archivepatcher.generator.bsdiff.BsDiffMatcher;
import com.google.archivepatcher.generator.bsdiff.BsUtil;
import com.google.archivepatcher.generator.bsdiff.DivSuffixSorter;
import com.google.archivepatcher.generator.bsdiff.Matcher;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObject;
import com.google.archivepatcher.generator.bsdiff.RandomAccessObjectFactory;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;

public class BsDiffPatchWriter {
    static final int DEFAULT_MINIMUM_MATCH_LENGTH = 16;

    private static void writeEntry(RandomAccessObject newData, RandomAccessObject oldData, int newPosition, int oldPosition, int diffLength, int extraLength, int oldPositionOffsetForNextEntry, OutputStream outputStream) throws IOException {
        int i10;
        BsUtil.writeFormattedLong(diffLength, outputStream);
        BsUtil.writeFormattedLong(extraLength, outputStream);
        BsUtil.writeFormattedLong(oldPositionOffsetForNextEntry, outputStream);
        newData.seek(newPosition);
        oldData.seek(oldPosition);
        for (i10 = 0; i10 < diffLength; ++i10) {
            outputStream.write(newData.readUnsignedByte() - oldData.readUnsignedByte());
        }
        if (extraLength > 0) {
            newData.seek(newPosition + diffLength);
            for (i10 = 0; i10 < extraLength; ++i10) {
                outputStream.write(newData.readByte());
            }
        }
    }

    static void generatePatchWithMatcher(RandomAccessObject oldData, RandomAccessObject newData, Matcher matcher, OutputStream outputStream) throws IOException, InterruptedException {
        int lastNewPosition = 0;
        int lastOldPosition = 0;
        int newPosition = 0;
        int oldPosition = 0;
        while ((long)newPosition < newData.length()) {
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            Matcher.NextMatch nextMatch = matcher.next();
            if (nextMatch.didFindMatch) {
                newPosition = nextMatch.newPosition;
                oldPosition = nextMatch.oldPosition;
            } else {
                newPosition = (int)newData.length();
            }
            int backwardExtension = 0;
            if ((long)newPosition < newData.length()) {
                int score = 0;
                int bestScore = 0;
                for (int i10 = 1; newPosition - i10 >= lastNewPosition && oldPosition >= i10; ++i10) {
                    oldData.seek(oldPosition - i10);
                    newData.seek(newPosition - i10);
                    score = oldData.readByte() == newData.readByte() ? ++score : --score;
                    if (score <= bestScore) continue;
                    bestScore = score;
                    backwardExtension = i10;
                }
            }
            int forwardExtension = 0;
            int score = 0;
            int bestScore = 0;
            oldData.seek(lastOldPosition);
            newData.seek(lastNewPosition);
            int i11 = 0;
            while (lastNewPosition + i11 < newPosition && (long)(lastOldPosition + i11) < oldData.length()) {
                score = oldData.readByte() == newData.readByte() ? ++score : --score;
                if (score > bestScore) {
                    bestScore = score;
                    forwardExtension = i11 + 1;
                }
                ++i11;
            }
            int overlap = lastNewPosition + forwardExtension - (newPosition - backwardExtension);
            if (overlap > 0) {
                int score2 = 0;
                int bestScore2 = 0;
                int backwardExtensionDecrement = 0;
                for (int i12 = 0; i12 < overlap; ++i12) {
                    newData.seek(lastNewPosition + forwardExtension - overlap + i12);
                    oldData.seek(lastOldPosition + forwardExtension - overlap + i12);
                    if (newData.readByte() == oldData.readByte()) {
                        ++score2;
                    }
                    newData.seek(newPosition - backwardExtension + i12);
                    oldData.seek(oldPosition - backwardExtension + i12);
                    if (newData.readByte() == oldData.readByte()) {
                        --score2;
                    }
                    if (score2 <= bestScore2) continue;
                    bestScore2 = score2;
                    backwardExtensionDecrement = i12 + 1;
                }
                forwardExtension -= overlap - backwardExtensionDecrement;
                backwardExtension -= backwardExtensionDecrement;
            }
            int oldPositionOffset = 0;
            if ((long)newPosition < newData.length()) {
                oldPositionOffset = oldPosition - backwardExtension - (lastOldPosition + forwardExtension);
            }
            int newNoMatchLength = newPosition - backwardExtension - (lastNewPosition + forwardExtension);
            BsDiffPatchWriter.writeEntry(newData, oldData, lastNewPosition, lastOldPosition, forwardExtension, newNoMatchLength, oldPositionOffset, outputStream);
            lastNewPosition = newPosition - backwardExtension;
            lastOldPosition = oldPosition - backwardExtension;
        }
    }

    public static void generatePatch(RandomAccessObject oldData, RandomAccessObject newData, OutputStream outputStream, RandomAccessObjectFactory randomAccessObjectFactory) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, randomAccessObjectFactory, 16);
    }

    public static void generatePatch(byte[] oldData, byte[] newData, OutputStream outputStream) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, 16);
    }

    public static void generatePatch(byte[] oldData, byte[] newData, OutputStream outputStream, int minimumMatchLength) throws IOException, InterruptedException {
        try (RandomAccessObject.RandomAccessByteArrayObject oldDataRAO = new RandomAccessObject.RandomAccessByteArrayObject(oldData);
             RandomAccessObject.RandomAccessByteArrayObject newDataRAO = new RandomAccessObject.RandomAccessByteArrayObject(newData);){
            BsDiffPatchWriter.generatePatch(oldDataRAO, newDataRAO, outputStream, new RandomAccessObjectFactory.RandomAccessByteArrayObjectFactory(), minimumMatchLength);
        }
    }

    public static void generatePatch(File oldData, File newData, OutputStream outputStream) throws IOException, InterruptedException {
        BsDiffPatchWriter.generatePatch(oldData, newData, outputStream, 16);
    }

    public static void generatePatch(File oldData, File newData, OutputStream outputStream, int minimumMatchLength) throws IOException, InterruptedException {
        try (RandomAccessFile oldDataRAF = new RandomAccessFile(oldData, "r");
             RandomAccessFile newDataRAF = new RandomAccessFile(newData, "r");
             RandomAccessObject.RandomAccessMmapObject oldDataRAO = new RandomAccessObject.RandomAccessMmapObject(oldDataRAF, "r");
             RandomAccessObject.RandomAccessMmapObject newDataRAO = new RandomAccessObject.RandomAccessMmapObject(newDataRAF, "r");){
            BsDiffPatchWriter.generatePatch(oldDataRAO, newDataRAO, outputStream, new RandomAccessObjectFactory.RandomAccessMmapObjectFactory("rw"), minimumMatchLength);
        }
        System.gc();
        System.runFinalization();
    }

    public static void generatePatch(RandomAccessObject oldData, RandomAccessObject newData, OutputStream outputStream, RandomAccessObjectFactory randomAccessObjectFactory, int minimumMatchLength) throws IOException, InterruptedException {
        outputStream.write("ENDSLEY/BSDIFF43".getBytes(StandardCharsets.US_ASCII));
        BsUtil.writeFormattedLong(newData.length(), outputStream);
        try (RandomAccessObject groupArray = new DivSuffixSorter(randomAccessObjectFactory).suffixSort(oldData);){
            BsDiffMatcher matcher = new BsDiffMatcher(oldData, newData, groupArray, minimumMatchLength);
            BsDiffPatchWriter.generatePatchWithMatcher(oldData, newData, matcher, outputStream);
        }
    }
}

