/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.lite.support.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.tensorflow.lite.support.metadata.Preconditions;
import org.tensorflow.lite.support.metadata.SeekableByteChannelCompat;

final class BoundedInputStream
extends InputStream {
    private final ByteBuffer singleByteBuffer = ByteBuffer.allocate(1);
    private final long end;
    private long position;
    private final SeekableByteChannelCompat channel;

    BoundedInputStream(SeekableByteChannelCompat channel, long start, long remaining) {
        Preconditions.checkArgument(remaining >= 0L && start >= 0L, String.format("Invalid length of stream at offset=%d, length=%d", start, remaining));
        this.end = start + remaining;
        this.channel = channel;
        this.position = start;
    }

    @Override
    public int available() throws IOException {
        return (int)(Math.min(this.end, this.channel.size()) - this.position);
    }

    @Override
    public int read() throws IOException {
        if (this.position >= this.end) {
            return -1;
        }
        this.singleByteBuffer.rewind();
        int count = this.read(this.position, this.singleByteBuffer);
        if (count < 0) {
            return count;
        }
        ++this.position;
        return this.singleByteBuffer.get() & 0xFF;
    }

    @Override
    public int read(byte[] b10, int off, int len) throws IOException {
        ByteBuffer buf;
        int count;
        Preconditions.checkNotNull(b10);
        Preconditions.checkElementIndex(off, b10.length, "The start offset");
        Preconditions.checkElementIndex(len, b10.length - off + 1, "The maximumn number of bytes to read");
        if (len == 0) {
            return 0;
        }
        if ((long)len > this.end - this.position) {
            if (this.position >= this.end) {
                return -1;
            }
            len = (int)(this.end - this.position);
        }
        if ((count = this.read(this.position, buf = ByteBuffer.wrap(b10, off, len))) > 0) {
            this.position += (long)count;
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int read(long position, ByteBuffer buf) throws IOException {
        int count;
        SeekableByteChannelCompat seekableByteChannelCompat = this.channel;
        synchronized (seekableByteChannelCompat) {
            this.channel.position(position);
            count = this.channel.read(buf);
        }
        buf.flip();
        return count;
    }
}

